/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleMethod;
import com.applitools.utils.ArgumentGuard;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.imgscalr.Scalr;

public class ImageUtils {
    public static byte[] encodeAsPng(BufferedImage image) {
        byte[] encodedImage;
        ArgumentGuard.notNull(image, "image");
        ByteArrayOutputStream pngBytesStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", pngBytesStream);
            pngBytesStream.flush();
            encodedImage = pngBytesStream.toByteArray();
        }
        catch (IOException e) {
            throw new EyesException("Failed to encode image", e);
        }
        finally {
            try {
                pngBytesStream.close();
            }
            catch (IOException e) {
                throw new EyesException("Failed to close png byte stream", e);
            }
        }
        return encodedImage;
    }

    public static BufferedImage imageFromFile(String path) throws EyesException {
        BufferedImage result;
        try {
            result = ImageIO.read(new File(path));
        }
        catch (IOException e) {
            throw new EyesException("Failed to to load the image bytes from " + path, e);
        }
        return result;
    }

    public static BufferedImage imageFromResource(String resource) throws EyesException {
        BufferedImage result;
        try {
            result = ImageIO.read(ImageUtils.class.getClassLoader().getResourceAsStream(resource));
        }
        catch (IOException e) {
            throw new EyesException("Failed to to load the image from resource: " + resource, e);
        }
        return result;
    }

    public static BufferedImage imageFromBase64(String image64) throws EyesException {
        ArgumentGuard.notNullOrEmpty(image64, "image64");
        byte[] imageBytes = Base64.decodeBase64((byte[])image64.getBytes(Charset.forName("UTF-8")));
        return ImageUtils.imageFromBytes(imageBytes);
    }

    public static String base64FromImage(BufferedImage image) {
        ArgumentGuard.notNull(image, "image");
        byte[] imageBytes = ImageUtils.encodeAsPng(image);
        return Base64.encodeBase64String((byte[])imageBytes);
    }

    public static BufferedImage imageFromBytes(byte[] imageBytes) throws EyesException {
        BufferedImage image;
        try {
            ByteArrayInputStream screenshotStream = new ByteArrayInputStream(imageBytes);
            image = ImageIO.read(screenshotStream);
            screenshotStream.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to create buffered image!", e);
        }
        return image;
    }

    public static BufferedImage getImagePart(BufferedImage image, Region region) {
        ArgumentGuard.notNull(image, "image");
        BufferedImage imagePart = image.getSubimage(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
        byte[] imagePartBytes = ImageUtils.encodeAsPng(imagePart);
        return ImageUtils.imageFromBytes(imagePartBytes);
    }

    public static BufferedImage rotateImage(BufferedImage image, double deg) {
        ArgumentGuard.notNull(image, "image");
        double radians = Math.toRadians(deg);
        double angleSin = Math.abs(Math.sin(radians));
        double angleCos = Math.abs(Math.cos(radians));
        int originalWidth = image.getWidth();
        double originalHeight = image.getHeight();
        int rotatedWidth = (int)Math.floor((double)originalWidth * angleCos + originalHeight * angleSin);
        int rotatedHeight = (int)Math.floor(originalHeight * angleCos + (double)originalWidth * angleSin);
        BufferedImage rotatedImage = new BufferedImage(rotatedWidth, rotatedHeight, image.getType());
        Graphics2D g = rotatedImage.createGraphics();
        g.translate((double)((rotatedWidth - originalWidth) / 2), ((double)rotatedHeight - originalHeight) / 2.0);
        g.rotate(radians, originalWidth / 2, originalHeight / 2.0);
        g.drawRenderedImage(image, null);
        g.dispose();
        return rotatedImage;
    }

    public static BufferedImage copyImageWithType(BufferedImage src, int updatedType) {
        ArgumentGuard.notNull(src, "src");
        BufferedImage result = new BufferedImage(src.getWidth(), src.getHeight(), updatedType);
        Graphics2D g2 = result.createGraphics();
        g2.drawRenderedImage(src, null);
        g2.dispose();
        return result;
    }

    public static BufferedImage scaleImage(BufferedImage image, ScaleMethod scaleMethod, double scaleRatio) {
        ArgumentGuard.notNull(image, "image");
        ArgumentGuard.greaterThanZero(scaleRatio, "scaleRatio");
        if (scaleRatio == 1.0) {
            return image;
        }
        int scaledWidth = (int)Math.ceil((double)image.getWidth() * scaleRatio);
        int scaledHeight = (int)Math.ceil((double)image.getHeight() * scaleRatio);
        BufferedImage scaledImage = Scalr.resize((BufferedImage)image, (Scalr.Method)scaleMethod.getMethod(), (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)scaledWidth, (int)scaledHeight, (BufferedImageOp[])new BufferedImageOp[0]);
        if (image.getType() == scaledImage.getType()) {
            return scaledImage;
        }
        return ImageUtils.copyImageWithType(scaledImage, image.getType());
    }
}

