/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.utils.ArgumentGuard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingInstanceContainer<T> {
    private T underlying = null;
    private boolean isClosed = false;

    public synchronized void put(T underlying) {
        ArgumentGuard.isValidState(!this.isClosed, "Container is closed!");
        this.underlying = underlying;
        this.notifyAll();
    }

    public synchronized T take() {
        while (this.underlying == null && !this.isClosed) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        T result = this.underlying;
        this.underlying = null;
        return result;
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }
}

