/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.AgentCommandLineLoader;
import com.appland.appmap.AppmapPluginExtension;
import com.appland.appmap.AppmapTask;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.Test;
import org.gradle.process.JavaForkOptions;

public class LoadAppmapAgentAction
implements Action<Task> {
    private static final Logger LOGGER = Logging.getLogger(LoadAppmapAgentAction.class);
    private final Project project;
    private final AppmapPluginExtension extension;

    public LoadAppmapAgentAction(Project project, AppmapPluginExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public void execute(Task task) {
        this.project.getTasks().withType(Test.class).configureEach(this::applyTo);
    }

    private <T extends Task & JavaForkOptions> void applyTo(T task) {
        if (task instanceof AppmapTask) {
            return;
        }
        String taskName = task.getName();
        LOGGER.lifecycle("Attaching Appmap Agent to task: " + taskName);
        ((JavaForkOptions)task).getJvmArgumentProviders().add(new AgentCommandLineLoader(this.extension));
    }
}

