/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.video;

import androidx.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum TrackingEventType {
    CREATIVE_VIEW("creativeView"),
    MUTE("mute"),
    UNMUTE("unmute"),
    START("start"),
    PAUSE("pause"),
    SKIP("skip"),
    COMPLETE("complete"),
    REWIND("rewind"),
    RESUME("resume"),
    FULLSCREEN("fullscreen"),
    EXPAND("expand"),
    COLLAPSE("collapse"),
    ACCEPT_INVITATION("acceptInvitation"),
    CLOSE("close"),
    ENGAGED_VIEW("engagedView");

    private static final Map<String, TrackingEventType> ENUM_MAP;
    private final String name;

    private TrackingEventType(String name) {
        this.name = name;
    }

    @Nullable
    public static TrackingEventType getEventType(String name) {
        return ENUM_MAP.get(name.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    static {
        HashMap<String, TrackingEventType> map = new HashMap<String, TrackingEventType>();
        for (TrackingEventType instance : TrackingEventType.values()) {
            map.put(instance.getName().toLowerCase(), instance);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

