/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appier.ads.Appier;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.AppierNativeViewBinder;
import com.appier.ads.AppierPredictCache;
import com.appier.ads.common.AdUnitIdentifier;
import com.appier.ads.common.AdUrlGenerator;
import com.appier.ads.common.BrowserUtil;
import com.appier.ads.common.ImageLoader;
import com.appier.ads.network.AppierVolley;
import com.appier.volley.NetworkResponse;
import com.appier.volley.Response;
import com.appier.volley.VolleyError;
import com.appier.volley.toolbox.StringRequest;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierNativeAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private EventListener mEventListener;
    private AppierNativeViewBinder mAppierNativeViewBinder;
    private int mImpTrackResCode;
    private boolean mIsImpressionRecorded = false;
    private boolean mIsImpressionRecording = false;
    private ImageLoader mImageLoader;
    private BrowserUtil mBrowserUtil;

    public AppierNativeAd(Context context, @NonNull AdUnitIdentifier adUnitId, EventListener eventListener) {
        super(context, adUnitId);
        this.setBaseAdEventListener(this);
        this.mEventListener = eventListener;
        this.mBrowserUtil = new BrowserUtil(context);
    }

    @Override
    public void destroy() {
        this.mAppierNativeViewBinder = null;
        this.mImageLoader = null;
        this.mBrowserUtil = null;
        super.destroy();
    }

    public void loadAdWithExternalCache() {
        super.loadAd();
    }

    @Override
    public void loadAd() {
        if (this.mImageLoader == null) {
            this.mImageLoader = new ImageLoader(this.getContext());
        }
        super.loadAd();
    }

    @Override
    public String getAdUri() {
        String predictId = AppierPredictCache.getInstance().getActivatedPredictId(this.getAdUnitId());
        AdUrlGenerator adUrlGenerator = new AdUrlGenerator(this.getContext(), this.getNetworkHost(), this.getAdPath()).withZoneId(this.getZoneId()).withPredictId(predictId);
        return adUrlGenerator.generateUrlString();
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    public String getTitle() throws JSONException {
        return this.getAd().getJSONObject("native").getString("title");
    }

    public String getText() throws JSONException {
        return this.getAd().getJSONObject("native").getString("text");
    }

    public String getIconImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("iconImage").getString("url");
    }

    public String getMainImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("mainImage").getString("url");
    }

    public String getCallToActionText() throws JSONException {
        return this.getAd().getJSONObject("native").getString("ctaText");
    }

    public String getImpressionTrackerUrl() throws JSONException {
        return this.getAd().getJSONArray("impTracker").getString(0);
    }

    public String getClickDestinationUrl() throws JSONException {
        return this.getAd().getString("clk");
    }

    public String getPrivacyInformationIconImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("privacyInformationIcon").getString("url");
    }

    public String getPrivacyInformationIconClickThroughUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("privacyInformationLink").getString("url");
    }

    public List<String> getCacheableImageUrls() {
        ArrayList<String> imageUrls = new ArrayList<String>();
        try {
            imageUrls.add(this.getIconImageUrl());
        }
        catch (JSONException e) {
            Appier.log("[Appier SDK]", "getIconImageUrl() failed");
        }
        try {
            imageUrls.add(this.getMainImageUrl());
        }
        catch (JSONException e) {
            Appier.log("[Appier SDK]", "getMainImageUrl() failed");
        }
        try {
            imageUrls.add(this.getPrivacyInformationIconImageUrl());
        }
        catch (JSONException e) {
            Appier.log("[Appier SDK]", "getPrivacyInformationIconImageUrl() failed");
        }
        return imageUrls;
    }

    public boolean impressionIsRecordingOrRecorded() {
        return this.mIsImpressionRecording || this.mIsImpressionRecorded;
    }

    public void setViewBinder(AppierNativeViewBinder appierNativeViewBinder) {
        this.mAppierNativeViewBinder = appierNativeViewBinder;
    }

    public View createAdView(@Nullable ViewGroup parent) {
        return LayoutInflater.from((Context)this.getContext()).inflate(this.mAppierNativeViewBinder.layoutId, parent, false);
    }

    public void renderAdView(@NonNull View view) throws JSONException {
        TextView tvTitle = (TextView)view.findViewById(this.mAppierNativeViewBinder.titleId);
        TextView tvText = (TextView)view.findViewById(this.mAppierNativeViewBinder.textId);
        Button tvCallToAction = (Button)view.findViewById(this.mAppierNativeViewBinder.callToActionId);
        ImageView imgMain = (ImageView)view.findViewById(this.mAppierNativeViewBinder.mainImageId);
        ImageView imgIcon = (ImageView)view.findViewById(this.mAppierNativeViewBinder.iconImageId);
        ImageView imgPrivacyInfoIcon = (ImageView)view.findViewById(this.mAppierNativeViewBinder.privacyInformationIconImageId);
        View.OnClickListener onAdClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    if (Appier.getBrowserAgent() == Appier.BrowserAgent.NATIVE) {
                        AppierNativeAd.this.mBrowserUtil.disableInternalBrowser();
                    } else {
                        AppierNativeAd.this.mBrowserUtil.enableInternalBrowser();
                    }
                    boolean isOpened = AppierNativeAd.this.mBrowserUtil.tryToOpenUrl(AppierNativeAd.this.getClickDestinationUrl());
                    if (isOpened) {
                        AppierNativeAd.this.mEventListener.onAdClick(AppierNativeAd.this);
                    } else {
                        AppierNativeAd.this.mEventListener.onAdClickFail(AppierError.NO_AVAILABLE_ACTIVITY_FOR_INTENT, AppierNativeAd.this);
                    }
                }
                catch (JSONException e) {
                    AppierNativeAd.this.mEventListener.onAdClickFail(AppierError.INVALID_JSON, AppierNativeAd.this);
                }
            }
        };
        View.OnAttachStateChangeListener onAdAttachStateChangeListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                if (!AppierNativeAd.this.mIsImpressionRecording && !AppierNativeAd.this.mIsImpressionRecorded) {
                    AppierNativeAd.this.makeImpressionTrackingRequest();
                }
                AppierNativeAd.this.mEventListener.onAdShown(AppierNativeAd.this);
            }

            public void onViewDetachedFromWindow(View v) {
            }
        };
        View.OnClickListener onPrivacyInformationIconClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    boolean isOpened = AppierNativeAd.this.mBrowserUtil.tryToOpenUrl(AppierNativeAd.this.getPrivacyInformationIconClickThroughUrl());
                    if (!isOpened) {
                        Appier.log("[Appier SDK]", "Failed to open privacy information:", AppierError.NO_AVAILABLE_ACTIVITY_FOR_INTENT.toString());
                    }
                }
                catch (JSONException e) {
                    Appier.log("[Appier SDK]", "Failed to open privacy information:", AppierError.INVALID_JSON.toString());
                }
            }
        };
        view.setOnClickListener(onAdClickListener);
        view.addOnAttachStateChangeListener(onAdAttachStateChangeListener);
        if (tvTitle != null) {
            tvTitle.setText((CharSequence)this.getTitle());
        }
        if (tvText != null) {
            tvText.setText((CharSequence)this.getText());
        }
        if (tvCallToAction != null) {
            tvCallToAction.setText((CharSequence)this.getCallToActionText());
            tvCallToAction.setOnClickListener(onAdClickListener);
        }
        if (imgMain != null) {
            this.mImageLoader.loadImageView(imgMain, this.getMainImageUrl());
        }
        if (imgIcon != null) {
            this.mImageLoader.loadImageView(imgIcon, this.getIconImageUrl());
        }
        if (imgPrivacyInfoIcon != null) {
            this.mImageLoader.loadImageView(imgPrivacyInfoIcon, this.getPrivacyInformationIconImageUrl());
            imgPrivacyInfoIcon.setOnClickListener(onPrivacyInformationIconClickListener);
        }
    }

    public View getAdView() {
        View adView = this.createAdView(null);
        try {
            this.renderAdView(adView);
        }
        catch (JSONException e) {
            Appier.log("[Appier SDK]", "getAdView() failed");
        }
        return adView;
    }

    public void makeImpressionTrackingRequest() {
        String impTracker = null;
        try {
            impTracker = this.getImpressionTrackerUrl();
        }
        catch (JSONException e) {
            this.mEventListener.onImpressionRecordFail(AppierError.INVALID_JSON, this);
        }
        Appier.log("[Appier SDK]", "Requesting impression tracker:", impTracker);
        this.mIsImpressionRecording = true;
        StringRequest req = new StringRequest(impTracker, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                if (AppierNativeAd.this.mImpTrackResCode == 200) {
                    AppierNativeAd.this.mEventListener.onImpressionRecorded(AppierNativeAd.this);
                    AppierNativeAd.this.mIsImpressionRecorded = true;
                } else {
                    AppierNativeAd.this.mEventListener.onImpressionRecordFail(AppierError.UNKNOWN_ERROR, AppierNativeAd.this);
                }
                AppierNativeAd.this.mIsImpressionRecording = false;
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                AppierNativeAd.this.mIsImpressionRecording = false;
                AppierNativeAd.this.mEventListener.onImpressionRecordFail(AppierError.UNKNOWN_ERROR, AppierNativeAd.this);
            }
        }){

            protected Response<String> parseNetworkResponse(NetworkResponse response) {
                AppierNativeAd.this.mImpTrackResCode = response.statusCode;
                return super.parseNetworkResponse(response);
            }
        };
        AppierVolley.getInstance(this.getContext()).addToRequestQueue(req);
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        this.mIsImpressionRecorded = false;
        if (isNoBid) {
            this.mEventListener.onAdNoBid(this);
        } else if (this.mImageLoader == null) {
            this.mEventListener.onAdLoaded(this);
        } else {
            this.mImageLoader.batchLoadImages(this.getCacheableImageUrls(), new ImageLoader.OnBatchImageEventListener(){

                @Override
                public void onBatchImageLoadedAndCached() {
                    AppierNativeAd.this.mEventListener.onAdLoaded(AppierNativeAd.this);
                }

                @Override
                public void onBatchImageLoadFail() {
                    AppierNativeAd.this.mEventListener.onAdLoadFail(AppierError.NETWORK_ERROR, AppierNativeAd.this);
                }
            });
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        this.mEventListener.onAdLoadFail(appierError, this);
    }

    public static interface EventListener {
        public void onAdLoaded(AppierNativeAd var1);

        public void onAdNoBid(AppierNativeAd var1);

        public void onAdLoadFail(AppierError var1, AppierNativeAd var2);

        public void onAdShown(AppierNativeAd var1);

        public void onImpressionRecorded(AppierNativeAd var1);

        public void onImpressionRecordFail(AppierError var1, AppierNativeAd var2);

        public void onAdClick(AppierNativeAd var1);

        public void onAdClickFail(AppierError var1, AppierNativeAd var2);
    }
}

