/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.util.Pair;
import com.appier.ads.Appier;
import com.appier.ads.AppierError;
import com.appier.ads.AppierPredictCache;
import com.appier.ads.AppierPredictHandler;
import com.appier.ads.common.AdUnitIdentifier;
import com.appier.ads.common.Identifier;
import com.appier.ads.common.PredictUrlGenerator;
import com.appier.ads.network.AppierVolley;
import com.appier.volley.NetworkResponse;
import com.appier.volley.Response;
import com.appier.volley.VolleyError;
import com.appier.volley.toolbox.StringRequest;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierPredictor {
    private Context mContext;
    private EventListener mEventListener;
    private int mResCode = -1;

    public AppierPredictor(Context context) {
        this(context, new AppierPredictHandler(context));
    }

    public AppierPredictor(Context context, EventListener eventListener) {
        this.mContext = context;
        this.mEventListener = eventListener;
    }

    private String getNetworkHost() {
        return "https://ad3.apx.appier.net";
    }

    private String getPredictPath() {
        return "/v1/sdk/predict";
    }

    public void predictAd(final AdUnitIdentifier adUnitId) {
        Appier.log("[Appier SDK]", "[Predict Mode]", "start to predict Ad", adUnitId.build());
        final Identifier identifier = Appier.getIdentifier(this.mContext);
        AdvertisingIdClient.Info adInfo = identifier.getCachedAdInfo();
        if (adInfo != null) {
            this.internalPredictAd(adUnitId);
        } else {
            identifier.getAdInfo(new Identifier.EventListener(){

                @Override
                public void onAdInfoFetched(AdvertisingIdClient.Info adInfo) {
                    identifier.setCachedAdInfo(adInfo);
                    AppierPredictor.this.internalPredictAd(adUnitId);
                }
            });
        }
    }

    private Pair<List<String>, List<String>> getItemList(String response) {
        ArrayList<String> keys = null;
        ArrayList<String> imageList = null;
        try {
            JSONObject object = new JSONObject(response);
            JSONArray array = object.getJSONArray("line_items");
            keys = new ArrayList<String>();
            imageList = new ArrayList<String>();
            for (int i = 0; i < array.length(); ++i) {
                keys.add(array.getJSONObject(i).getString("id"));
                JSONArray imageArray = array.getJSONObject(i).getJSONArray("prefetch_images");
                for (int j = 0; j < imageArray.length(); ++j) {
                    imageList.add(imageArray.getString(j));
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new Pair(keys, imageList);
    }

    private void internalPredictAd(final AdUnitIdentifier adUnitId) {
        if (AppierPredictCache.getInstance().sizeExceedCapacity(adUnitId)) {
            Appier.log("[Appier SDK]", "[Predict Mode]", "prediction cancelled (Too many predict requests)");
            return;
        }
        final String predictId = this.generatePredictId();
        String predictUri = this.getPredictUri(adUnitId.build(), predictId);
        AppierPredictCache.getInstance().setPredictStatus(adUnitId, predictId, null);
        StringRequest req = new StringRequest(1, predictUri, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                if (AppierPredictor.this.mResCode == 200) {
                    Pair items = AppierPredictor.this.getItemList(response);
                    AppierPredictCache.getInstance().setPredictStatus(adUnitId, predictId, (List)items.first);
                    AppierPredictor.this.mEventListener.onPredictSuccess(adUnitId.build(), (List)items.second);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                if (volleyError.networkResponse != null) {
                    AppierPredictor.this.mResCode = volleyError.networkResponse.statusCode;
                }
                if (400 <= AppierPredictor.this.mResCode && AppierPredictor.this.mResCode <= 499) {
                    AppierPredictor.this.mEventListener.onPredictFailed(adUnitId.build(), AppierError.BAD_REQUEST);
                } else if (500 <= AppierPredictor.this.mResCode && AppierPredictor.this.mResCode <= 599) {
                    AppierPredictor.this.mEventListener.onPredictFailed(adUnitId.build(), AppierError.INTERNAL_SERVER_ERROR);
                } else {
                    AppierPredictor.this.mEventListener.onPredictFailed(adUnitId.build(), AppierError.NETWORK_ERROR);
                }
            }
        }){

            protected Response<String> parseNetworkResponse(NetworkResponse response) {
                AppierPredictor.this.mResCode = response.statusCode;
                return super.parseNetworkResponse(response);
            }
        };
        AppierVolley.getInstance(this.mContext).addToRequestQueue(req);
    }

    private String generatePredictId() {
        return UUID.randomUUID().toString();
    }

    private String getPredictUri(String adUnitId, String predictId) {
        PredictUrlGenerator predictUrlGenerator = new PredictUrlGenerator(this.mContext, this.getNetworkHost(), this.getPredictPath()).withAdUnitId(adUnitId).withPredictId(predictId);
        return predictUrlGenerator.generateUrlString();
    }

    public static interface EventListener {
        public void onPredictSuccess(String var1, List<String> var2);

        public void onPredictFailed(String var1, AppierError var2);
    }
}

