/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import com.appier.ads.AppierAdPlacer;
import com.appier.ads.AppierBannerAd;
import com.appier.ads.AppierBannerWebView;
import com.appier.ads.AppierNativeAd;

public class AppierAdAdapter
implements ListAdapter {
    private final DataSetObservable mDataSetObservable = new DataSetObservable();
    private Adapter mOriginalAdapter;
    private AppierAdPlacer mAppierAdPlacer;

    public AppierAdAdapter(Adapter originalAdapter) {
        this.mOriginalAdapter = originalAdapter;
        this.mAppierAdPlacer = new AppierAdPlacer(this.mOriginalAdapter.getCount());
    }

    public void destroy() {
        if (this.mAppierAdPlacer != null) {
            this.mAppierAdPlacer.destroy();
        }
    }

    public void insertAd(int originalPosition, Object ad) {
        this.mAppierAdPlacer.insertAdAtOriginalPosition(originalPosition, ad);
        this.mDataSetObservable.notifyChanged();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public int getCount() {
        return this.mAppierAdPlacer.getItemCount();
    }

    public Object getItem(int position) {
        Object ad = this.mAppierAdPlacer.getAd(position);
        if (ad != null) {
            return ad;
        }
        int originalPosition = this.mAppierAdPlacer.getOriginalPosition(position);
        return this.mOriginalAdapter.getItem(originalPosition);
    }

    public long getItemId(int position) {
        Object ad = this.mAppierAdPlacer.getAd(position);
        if (ad != null) {
            return -System.identityHashCode(ad);
        }
        int originalPosition = this.mAppierAdPlacer.getOriginalPosition(position);
        return this.mOriginalAdapter.getItemId(originalPosition);
    }

    public boolean hasStableIds() {
        return this.mOriginalAdapter.hasStableIds();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View resultView;
        if (this.mAppierAdPlacer.isNativeAd(position)) {
            AppierNativeAd appierNativeAd = (AppierNativeAd)this.mAppierAdPlacer.getAd(position);
            resultView = appierNativeAd.getAdView();
        } else if (this.mAppierAdPlacer.isBannerAd(position)) {
            AppierBannerAd appierBannerAd = (AppierBannerAd)this.mAppierAdPlacer.getAd(position);
            AppierBannerWebView appierBannerWebView = appierBannerAd.getView();
            RelativeLayout layout = new RelativeLayout(appierBannerAd.getContext());
            if (appierBannerWebView.getParent() != null) {
                ((ViewGroup)appierBannerWebView.getParent()).removeView((View)appierBannerWebView);
            }
            layout.addView((View)appierBannerWebView);
            appierBannerWebView.setCenterInParent();
            resultView = layout;
        } else {
            int originalPosition = this.mAppierAdPlacer.getOriginalPosition(position);
            resultView = this.mOriginalAdapter.getView(originalPosition, convertView, parent);
        }
        return resultView;
    }

    public int getItemViewType(int position) {
        int viewType = this.mAppierAdPlacer.getItemViewType(position);
        if (this.mAppierAdPlacer.isAd(position)) {
            return this.mOriginalAdapter.getViewTypeCount() + viewType - 1;
        }
        int originalPosition = this.mAppierAdPlacer.getOriginalPosition(position);
        return this.mOriginalAdapter.getItemViewType(originalPosition);
    }

    public int getViewTypeCount() {
        return this.mOriginalAdapter.getViewTypeCount() + this.mAppierAdPlacer.getAdTypeCount();
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public boolean areAllItemsEnabled() {
        return this.mOriginalAdapter instanceof ListAdapter && ((ListAdapter)this.mOriginalAdapter).areAllItemsEnabled();
    }

    public boolean isEnabled(int position) {
        int originalPosition = this.mAppierAdPlacer.getOriginalPosition(position);
        return this.mAppierAdPlacer.isAd(position) || this.mOriginalAdapter instanceof ListAdapter && ((ListAdapter)this.mOriginalAdapter).isEnabled(originalPosition);
    }
}

