/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;

public class Network {
    public static Type getType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return Type.NONE;
        }
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            return Type.NONE;
        }
        if (networkInfo.getType() == 9) {
            return Type.ETHERNET;
        }
        if (networkInfo.getType() == 1) {
            return Type.WIFI;
        }
        if (networkInfo.getType() == 0) {
            int networkType = networkInfo.getSubtype();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    return Type.CELLULAR_2G;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: {
                    return Type.CELLULAR_3G;
                }
                case 13: 
                case 18: 
                case 19: {
                    return Type.CELLULAR_4G;
                }
                case 20: {
                    return Type.CELLULAR_5G;
                }
            }
            return Type.CELLULAR_UNKNOWN;
        }
        return Type.UNKNOWN;
    }

    public static enum Type {
        NONE("none"),
        ETHERNET("ethernet"),
        CELLULAR_UNKNOWN("cellular_unknown"),
        WIFI("wifi"),
        UNKNOWN("unknown"),
        CELLULAR_2G("cellular_2g"),
        CELLULAR_3G("cellular_3g"),
        CELLULAR_4G("cellular_4g"),
        CELLULAR_5G("cellular_5g");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        @NonNull
        public final String toString() {
            return this.type;
        }
    }
}

