/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data.network;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/apphud/sdk/internal/data/network/HttpRetryInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "sdk_release"})
public final class HttpRetryInterceptor
implements Interceptor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    public static final long RETRY_DELAY = 2000L;
    @Deprecated
    public static final int MAX_COUNT = 3;
    @Deprecated
    public static final int FIRST_TRY_CONNECT_TIMEOUT = 2;
    @Deprecated
    public static final int TRY_CONNECT_TIMEOUT = 5;
    @NotNull
    private static final Set<Integer> FALLBACK_ERRORS;
    @Deprecated
    public static final int TOO_MANY_REQUESTS = 429;
    @NotNull
    private static final IntRange NO_RETRY_RANGE;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = null;
        int tryCount = 0;
        while (true) {
            try {
                int connectTimeout = tryCount == 0 ? 2 : 5;
                response = chain.withConnectTimeout(connectTimeout, TimeUnit.SECONDS).proceed(request);
                IntRange intRange = NO_RETRY_RANGE;
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                int n3 = response.code();
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (bl || response.code() == 429) {
                    return response;
                }
                response.close();
                if (++tryCount == 3) {
                    throw new IllegalStateException("APPHUD_NO_TIME_TO_RETRY".toString());
                }
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception e) {
                if (++tryCount == 3) {
                    throw e;
                }
                Thread.sleep(2000L);
                continue;
            }
            break;
        }
    }

    static {
        Object[] objectArray = new Integer[]{408, 404, 500, 502, 503};
        FALLBACK_ERRORS = SetsKt.setOf((Object[])objectArray);
        NO_RETRY_RANGE = new IntRange(200, 403);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/apphud/sdk/internal/data/network/HttpRetryInterceptor$Companion;", "", "<init>", "()V", "RETRY_DELAY", "", "MAX_COUNT", "", "FIRST_TRY_CONNECT_TIMEOUT", "TRY_CONNECT_TIMEOUT", "FALLBACK_ERRORS", "", "getFALLBACK_ERRORS", "()Ljava/util/Set;", "TOO_MANY_REQUESTS", "NO_RETRY_RANGE", "Lkotlin/ranges/IntRange;", "getNO_RETRY_RANGE", "()Lkotlin/ranges/IntRange;", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Integer> getFALLBACK_ERRORS() {
            return FALLBACK_ERRORS;
        }

        @NotNull
        public final IntRange getNO_RETRY_RANGE() {
            return NO_RETRY_RANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

