/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.managers;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.android.billingclient.api.ProductDetails;
import com.android.billingclient.api.Purchase;
import com.apphud.sdk.ApphudError;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudInternal;
import com.apphud.sdk.ApphudInternal_FallbackKt;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUtils;
import com.apphud.sdk.ContextKt;
import com.apphud.sdk.body.AttributionBody;
import com.apphud.sdk.body.BenchmarkBody;
import com.apphud.sdk.body.ErrorLogsBody;
import com.apphud.sdk.body.GrantPromotionalBody;
import com.apphud.sdk.body.PaywallEventBody;
import com.apphud.sdk.body.PurchaseBody;
import com.apphud.sdk.body.PurchaseItemBody;
import com.apphud.sdk.body.RegistrationBody;
import com.apphud.sdk.body.UserPropertiesBody;
import com.apphud.sdk.client.ApiClient;
import com.apphud.sdk.client.ApphudUrl;
import com.apphud.sdk.client.dto.ApphudGroupDto;
import com.apphud.sdk.client.dto.AttributionDto;
import com.apphud.sdk.client.dto.CustomerDto;
import com.apphud.sdk.client.dto.ResponseDto;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.ApphudProduct;
import com.apphud.sdk.domain.ApphudUser;
import com.apphud.sdk.domain.Attribution;
import com.apphud.sdk.domain.ProductInfo;
import com.apphud.sdk.domain.PurchaseRecordDetails;
import com.apphud.sdk.managers.AdvertisingIdManager;
import com.apphud.sdk.managers.HeadersInterceptor;
import com.apphud.sdk.managers.HttpRetryInterceptor;
import com.apphud.sdk.managers.RequestManager;
import com.apphud.sdk.managers.RequestManagerKt;
import com.apphud.sdk.mappers.AttributionMapper;
import com.apphud.sdk.mappers.CustomerMapper;
import com.apphud.sdk.mappers.PaywallsMapper;
import com.apphud.sdk.mappers.PlacementsMapper;
import com.apphud.sdk.mappers.ProductMapper;
import com.apphud.sdk.mappers.SubscriptionMapper;
import com.apphud.sdk.parser.GsonParser;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.storage.SharedPreferencesStorage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u000100H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00108\u001a\u00020\u0001H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020\bH\u0002J\b\u0010;\u001a\u00020<H\u0002J\u001d\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u0002042\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAJ\u0006\u0010B\u001a\u00020CJ\u0013\u0010D\u001a\u0004\u0018\u00010\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\b\u0010E\u001a\u0004\u0018\u00010\bJ\u000f\u0010F\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010GJ\u001a\u0010H\u001a\u00020I2\u0006\u0010>\u001a\u0002042\b\b\u0002\u0010J\u001a\u00020<H\u0002J@\u0010K\u001a\u00020C2\u0006\u0010L\u001a\u00020\u00042\b\u0010M\u001a\u0004\u0018\u00010\b2\b\u0010N\u001a\u0004\u0018\u0001012\u001c\u0010O\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PJ-\u0010R\u001a\u00020S2\u0006\u0010L\u001a\u00020\u00042\n\b\u0002\u0010M\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010N\u001a\u0004\u0018\u000101H\u0000\u00a2\u0006\u0002\bTJ\u0010\u0010U\u001a\u00020<2\u0006\u0010V\u001a\u00020\bH\u0002J\b\u0010W\u001a\u00020<H\u0002J\"\u0010X\u001a\u00020C2\u0006\u0010>\u001a\u0002042\b\u0010Y\u001a\u0004\u0018\u00010\b2\u0006\u0010Z\u001a\u00020\u0004H\u0002J\u0010\u0010[\u001a\u00020C2\u0006\u0010>\u001a\u000204H\u0002J!\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020\b2\n\b\u0002\u0010_\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b`J<\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\b2\b\u0010d\u001a\u0004\u0018\u00010\b2\b\u0010e\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010\bH\u0002JL\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010m\u001a\u0004\u0018\u00010\b2\b\u0010n\u001a\u0004\u0018\u00010\b2\b\u0010_\u001a\u0004\u0018\u00010\b2\b\u0010o\u001a\u0004\u0018\u00010\b2\b\u0010p\u001a\u0004\u0018\u00010\bH\u0002J8\u0010q\u001a\u00020C2\u0006\u0010>\u001a\u0002042\b\b\u0002\u0010J\u001a\u00020<2\u001c\u0010O\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PH\u0002J*\u0010r\u001a\u00020h2\n\b\u0002\u0010s\u001a\u0004\u0018\u00010t2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020v002\u0006\u0010w\u001a\u00020<H\u0002J6\u0010x\u001a\u00020h2\n\b\u0002\u0010s\u001a\u0004\u0018\u00010t2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\b\u0010o\u001a\u0004\u0018\u00010\b2\u0006\u0010w\u001a\u00020<H\u0002J8\u0010y\u001a\u00020C2\u0006\u0010>\u001a\u0002042\b\b\u0002\u0010J\u001a\u00020<2\u001c\u0010O\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PH\u0002J\u0018\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020<2\u0006\u0010}\u001a\u00020<H\u0002J$\u0010~\u001a\u00020C2\b\u0010d\u001a\u0004\u0018\u00010\b2\b\u0010e\u001a\u0004\u0018\u00010\b2\b\u0010M\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u007f\u001a\u00020C2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001J%\u0010\u0082\u0001\u001a\u00020C2\b\u0010d\u001a\u0004\u0018\u00010\b2\b\u0010e\u001a\u0004\u0018\u00010\b2\b\u0010M\u001a\u0004\u0018\u00010\bJ/\u0010\u0083\u0001\u001a\u00020C2\b\u0010d\u001a\u0004\u0018\u00010\b2\b\u0010e\u001a\u0004\u0018\u00010\b2\b\u0010M\u001a\u0004\u0018\u00010\b2\b\u0010f\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0084\u0001\u001a\u00020C2\u0007\u0010\u0085\u0001\u001a\u00020\u0004J\u0011\u0010\u0086\u0001\u001a\u00020C2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001J8\u0010\u0087\u0001\u001a\u00020C2\u0007\u0010\u0088\u0001\u001a\u00020I2\u0006\u0010>\u001a\u0002042\u001c\u0010O\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PH\u0002J\u0018\u0010\u0089\u0001\u001a\u00020\b2\u0007\u0010\u0088\u0001\u001a\u00020I2\u0006\u0010>\u001a\u000204JL\u0010\u008a\u0001\u001a\u00020C2\u0006\u0010i\u001a\u00020j2\b\u0010s\u001a\u0004\u0018\u00010t2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\b2\b\u0010p\u001a\u0004\u0018\u00010\b2\u001c\u0010O\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PJ@\u0010\u008c\u0001\u001a\u00020C2\u0006\u0010|\u001a\u00020<2\u0006\u0010}\u001a\u00020<2\t\b\u0002\u0010\u008d\u0001\u001a\u00020<2\u001c\u0010O\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PJ0\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00152\u0006\u0010|\u001a\u00020<2\u0006\u0010}\u001a\u00020<2\t\b\u0002\u0010\u008d\u0001\u001a\u00020<H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008f\u0001JX\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010s\u001a\u0004\u0018\u00010t2\u000f\u0010\u0091\u0001\u001a\n\u0012\u0004\u0012\u00020v\u0018\u0001002\b\u0010i\u001a\u0004\u0018\u00010j2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010o\u001a\u0004\u0018\u00010\b2\u0006\u0010w\u001a\u00020<H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J0\u0010\u0093\u0001\u001a\u00020C2\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u001d\u0010O\u001a\u0019\u0012\u0007\u0012\u0005\u0018\u00010\u0096\u0001\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PJ\u0011\u0010\u0097\u0001\u001a\u00020C2\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001J\u000f\u0010\u009a\u0001\u001a\u00020C2\u0006\u0010^\u001a\u00020\bJ\u001b\u0010\u009b\u0001\u001a\u00020C2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u009c\u0001\u001a\u00020C2\u0007\u0010\u0098\u0001\u001a\u00020bH\u0002J0\u0010\u009d\u0001\u001a\u00020C2\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u001d\u0010O\u001a\u0019\u0012\u0007\u0012\u0005\u0018\u00010\u0096\u0001\u0012\u0006\u0012\u0004\u0018\u00010Q\u0012\u0004\u0012\u00020C0PR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020*X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00a0\u0001"}, d2={"Lcom/apphud/sdk/managers/RequestManager;", "", "()V", "BILLING_VERSION", "", "getBILLING_VERSION", "()I", "MUST_REGISTER_ERROR", "", "ONE_HOUR", "", "apiKey", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "setApplicationContext", "(Landroid/content/Context;)V", "attributionMapper", "Lcom/apphud/sdk/mappers/AttributionMapper;", "currentUser", "Lcom/apphud/sdk/domain/ApphudUser;", "getCurrentUser", "()Lcom/apphud/sdk/domain/ApphudUser;", "customerMapper", "Lcom/apphud/sdk/mappers/CustomerMapper;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGson", "()Lcom/google/gson/Gson;", "parser", "Lcom/apphud/sdk/parser/Parser;", "getParser", "()Lcom/apphud/sdk/parser/Parser;", "paywallsMapper", "Lcom/apphud/sdk/mappers/PaywallsMapper;", "placementsMapper", "Lcom/apphud/sdk/mappers/PlacementsMapper;", "productMapper", "Lcom/apphud/sdk/mappers/ProductMapper;", "storage", "Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "getStorage", "()Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "setStorage", "(Lcom/apphud/sdk/storage/SharedPreferencesStorage;)V", "allProducts", "", "Lcom/apphud/sdk/domain/ApphudGroup;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildGetRequest", "Lokhttp3/Request;", "url", "Ljava/net/URL;", "buildPostRequest", "params", "buildPrettyPrintedBy", "jsonString", "canPerformRequest", "", "checkLock403", "request", "response", "Lokhttp3/Response;", "checkLock403$sdk_release", "cleanRegistration", "", "fetchAdvertisingId", "fetchFallbackHost", "getInstallationDate", "()Ljava/lang/Long;", "getOkHttpClient", "Lokhttp3/OkHttpClient;", "retry", "grantPromotional", "daysCount", "productId", "permissionGroup", "completionHandler", "Lkotlin/Function2;", "Lcom/apphud/sdk/ApphudError;", "grantPromotionalBody", "Lcom/apphud/sdk/body/GrantPromotionalBody;", "grantPromotionalBody$sdk_release", "hasPermission", "permission", "isNetworkAvailable", "logRequestFinish", "responseBody", "responseCode", "logRequestStart", "makeErrorLogsBody", "Lcom/apphud/sdk/body/ErrorLogsBody;", "message", "apphud_product_id", "makeErrorLogsBody$sdk_release", "makePaywallEventBody", "Lcom/apphud/sdk/body/PaywallEventBody;", "name", "paywallId", "placementId", "errorMessage", "makePurchaseBody", "Lcom/apphud/sdk/body/PurchaseBody;", "purchase", "Lcom/android/billingclient/api/Purchase;", "productDetails", "Lcom/android/billingclient/api/ProductDetails;", "paywall_id", "placement_id", "offerIdToken", "oldToken", "makeRequest", "makeRestorePurchasesBody", "apphudProduct", "Lcom/apphud/sdk/domain/ApphudProduct;", "purchases", "Lcom/apphud/sdk/domain/PurchaseRecordDetails;", "observerMode", "makeTrackPurchasesBody", "makeUserRegisteredRequest", "mkRegistrationBody", "Lcom/apphud/sdk/body/RegistrationBody;", "needPaywalls", "isNew", "paywallCheckoutInitiated", "paywallClosed", "paywall", "Lcom/apphud/sdk/domain/ApphudPaywall;", "paywallPaymentCancelled", "paywallPaymentError", "paywallProductsLoaded", "count", "paywallShown", "performRequest", "client", "performRequestSync", "purchased", "offerToken", "registration", "forceRegistration", "registrationSync", "(ZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restorePurchasesSync", "purchaseRecordDetailsSet", "(Lcom/apphud/sdk/domain/ApphudProduct;Ljava/util/List;Lcom/android/billingclient/api/Purchase;Lcom/android/billingclient/api/ProductDetails;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "attributionBody", "Lcom/apphud/sdk/body/AttributionBody;", "Lcom/apphud/sdk/domain/Attribution;", "sendBenchmarkLogs", "body", "Lcom/apphud/sdk/body/BenchmarkBody;", "sendErrorLogs", "setParams", "trackPaywallEvent", "userProperties", "userPropertiesBody", "Lcom/apphud/sdk/body/UserPropertiesBody;", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nRequestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestManager.kt\ncom/apphud/sdk/managers/RequestManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1193:1\n1#2:1194\n314#3,11:1195\n314#3,11:1206\n314#3,11:1217\n314#3,11:1233\n1549#4:1228\n1620#4,3:1229\n1054#4:1232\n*S KotlinDebug\n*F\n+ 1 RequestManager.kt\ncom/apphud/sdk/managers/RequestManager\n*L\n341#1:1195,11\n418#1:1206,11\n517#1:1217,11\n1116#1:1233,11\n1020#1:1228\n1020#1:1229,3\n1042#1:1232\n*E\n"})
public final class RequestManager {
    @NotNull
    public static final RequestManager INSTANCE = new RequestManager();
    @NotNull
    private static final String MUST_REGISTER_ERROR = " :You must call the Apphud.start method once when your application starts before calling any other methods.";
    private static final int BILLING_VERSION = 5;
    private static final Gson gson = new GsonBuilder().serializeNulls().create();
    @NotNull
    private static final Parser parser;
    @NotNull
    private static final ProductMapper productMapper;
    @NotNull
    private static final PaywallsMapper paywallsMapper;
    @NotNull
    private static final AttributionMapper attributionMapper;
    @NotNull
    private static final PlacementsMapper placementsMapper;
    @NotNull
    private static final CustomerMapper customerMapper;
    @Nullable
    private static String apiKey;
    public static Context applicationContext;
    public static SharedPreferencesStorage storage;
    private static final long ONE_HOUR;

    private RequestManager() {
    }

    public final int getBILLING_VERSION() {
        return BILLING_VERSION;
    }

    @Nullable
    public final ApphudUser getCurrentUser() {
        return ApphudInternal.INSTANCE.getCurrentUser$sdk_release();
    }

    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final Parser getParser() {
        return parser;
    }

    @NotNull
    public final Context getApplicationContext() {
        Context context = applicationContext;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
        return null;
    }

    public final void setApplicationContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        applicationContext = context;
    }

    @NotNull
    public final SharedPreferencesStorage getStorage() {
        SharedPreferencesStorage sharedPreferencesStorage = storage;
        if (sharedPreferencesStorage != null) {
            return sharedPreferencesStorage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"storage");
        return null;
    }

    public final void setStorage(@NotNull SharedPreferencesStorage sharedPreferencesStorage) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferencesStorage, (String)"<set-?>");
        storage = sharedPreferencesStorage;
    }

    public final void setParams(@NotNull Context applicationContext, @Nullable String apiKey) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.setApplicationContext(applicationContext);
        String string = apiKey;
        if (string != null) {
            String it = string;
            boolean bl = false;
            RequestManager.apiKey = it;
        }
        this.setStorage(SharedPreferencesStorage.INSTANCE);
    }

    public static /* synthetic */ void setParams$default(RequestManager requestManager, Context context, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        requestManager.setParams(context, string);
    }

    public final void cleanRegistration() {
        apiKey = null;
    }

    private final boolean canPerformRequest() {
        return applicationContext != null && apiKey != null;
    }

    private final OkHttpClient getOkHttpClient(Request request, boolean retry) {
        HttpRetryInterceptor retryInterceptor = new HttpRetryInterceptor();
        HeadersInterceptor headersInterceptor = new HeadersInterceptor(apiKey);
        long readTimeout = ApiClient.INSTANCE.getReadTimeout();
        if (Intrinsics.areEqual((Object)request.method(), (Object)"POST") && StringsKt.contains$default((CharSequence)request.url().toString(), (CharSequence)"subscriptions", (boolean)false, (int)2, null)) {
            readTimeout = 30L;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(readTimeout, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).connectTimeout(10L, TimeUnit.SECONDS);
        if (retry) {
            builder.addInterceptor((Interceptor)retryInterceptor);
        }
        builder.addNetworkInterceptor((Interceptor)headersInterceptor);
        return builder.build();
    }

    static /* synthetic */ OkHttpClient getOkHttpClient$default(RequestManager requestManager, Request request, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return requestManager.getOkHttpClient(request, bl);
    }

    private final void logRequestStart(Request request) {
        try {
            Ref.ObjectRef body = new Ref.ObjectRef();
            body.element = "";
            if (ApphudUtils.INSTANCE.getHttpLogging()) {
                Function0<Unit> function0;
                RequestBody requestBody = request.body();
                if (requestBody != null) {
                    RequestBody it = requestBody;
                    boolean bl = false;
                    Buffer buffer = new Buffer();
                    it.writeTo((BufferedSink)buffer);
                    Charset charset = Charset.forName("UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
                    body.element = buffer.readString(charset);
                    String string = (String)body.element;
                    if (string != null) {
                        String it2 = string;
                        boolean bl2 = false;
                        if (parser.isJson(it2)) {
                            body.element = INSTANCE.buildPrettyPrintedBy(it2);
                        }
                    }
                    String string2 = (String)body.element;
                    if (string2 != null) {
                        String it3 = string2;
                        boolean bl3 = false;
                        if (((CharSequence)it3).length() > 0) {
                            body.element = '\n' + it3;
                        }
                        function0 = Unit.INSTANCE;
                    } else {
                        function0 = new Function0<Unit>((Ref.ObjectRef<String>)body){
                            final /* synthetic */ Ref.ObjectRef<String> $body;
                            {
                                this.$body = $body;
                                super(0);
                            }

                            public final void invoke() {
                                this.$body.element = "";
                            }
                        };
                    }
                } else {
                    function0 = null;
                }
            }
            ApphudLog.logI$default(ApphudLog.INSTANCE, "Start " + request.method() + " request " + request.url() + " with params:" + (String)body.element, false, 2, null);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            ApphudLog.logE$default(ApphudLog.INSTANCE, string, false, 2, null);
        }
    }

    private final void logRequestFinish(Request request, String responseBody, int responseCode) {
        String outputBody = "";
        if (ApphudUtils.INSTANCE.getHttpLogging()) {
            String string;
            String string2 = responseBody;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = this.buildPrettyPrintedBy(string2)) == null) {
                string = "";
            }
            outputBody = string;
        }
        ApphudLog.logI$default(ApphudLog.INSTANCE, "Finished " + request.method() + " request " + request.url() + " with response: " + responseCode + '\n' + outputBody, false, 2, null);
    }

    private final void performRequest(OkHttpClient client, Request request, Function2<? super String, ? super ApphudError, Unit> completionHandler) {
        try {
            if (HeadersInterceptor.Shared.isBlocked()) {
                String message = "Unable to perform API requests, because your account has been suspended.";
                ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
                completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
            } else {
                this.logRequestStart(request);
                Date start = new Date();
                Response response = client.newCall(request).execute();
                ResponseBody responseBody = response.body();
                String responseBody2 = responseBody != null ? responseBody.string() : null;
                Date finish = new Date();
                long diff = finish.getTime() - start.getTime();
                ApphudLog.INSTANCE.logBenchmark(request.url().encodedPath(), diff);
                this.logRequestFinish(request, responseBody2, response.code());
                if (response.isSuccessful()) {
                    Unit unit;
                    String string = responseBody2;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        completionHandler.invoke((Object)it, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        RequestManager $this$performRequest_u24lambda_u245 = this;
                        boolean bl = false;
                        completionHandler.invoke(null, (Object)new ApphudError("Request failed", null, response.code()));
                    }
                } else {
                    this.checkLock403$sdk_release(request, response);
                    String message = "finish " + request.method() + " request " + request.url() + " failed with code: " + response.code() + " response: " + this.buildPrettyPrintedBy(String.valueOf(responseBody2));
                    completionHandler.invoke(null, (Object)new ApphudError(message, null, response.code()));
                }
                response.close();
            }
        }
        catch (SocketTimeoutException e) {
            ApphudInternal_FallbackKt.processFallbackError(ApphudInternal.INSTANCE, request, true);
            String string = e.getMessage();
            if (string == null) {
                string = "Undefined error";
            }
            String message = string;
            completionHandler.invoke(null, (Object)new ApphudError(message, null, 408));
        }
        catch (IOException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Undefined error";
            }
            String message = string;
            completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
        }
    }

    @NotNull
    public final String performRequestSync(@NotNull OkHttpClient client, @NotNull Request request) throws Exception {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (HeadersInterceptor.Shared.isBlocked()) {
            String message = "SDK networking is locked until application restart";
            ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
            throw new Exception(message);
        }
        this.logRequestStart(request);
        Date start = new Date();
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        String responseBody2 = responseBody != null ? responseBody.string() : null;
        Date finish = new Date();
        long diff = finish.getTime() - start.getTime();
        ApphudLog.INSTANCE.logBenchmark(request.url().encodedPath(), diff);
        this.logRequestFinish(request, responseBody2, response.code());
        response.close();
        if (response.isSuccessful()) {
            String string = responseBody2;
            if (string == null) {
                string = "";
            }
            return string;
        }
        this.checkLock403$sdk_release(request, response);
        StringBuilder stringBuilder = new StringBuilder().append("finish ").append(request.method()).append(" request ").append(request.url()).append(" failed with code: ").append(response.code()).append(" response: ");
        String string = responseBody2;
        if (string == null) {
            string = "";
        }
        String message = stringBuilder.append(this.buildPrettyPrintedBy(string)).toString();
        ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
        throw new Exception(message);
    }

    public final boolean checkLock403$sdk_release(@NotNull Request request, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.code() == 403 && Intrinsics.areEqual((Object)request.method(), (Object)"POST") && StringsKt.endsWith$default((String)request.url().encodedPath(), (String)"/customers", (boolean)false, (int)2, null)) {
            HeadersInterceptor.Shared.setBlocked(true);
            ApphudLog.logE$default(ApphudLog.INSTANCE, "Unable to perform API requests, because your account has been suspended.", false, 2, null);
        }
        return HeadersInterceptor.Shared.isBlocked();
    }

    private final void makeRequest(Request request, boolean retry, Function2<? super String, ? super ApphudError, Unit> completionHandler) {
        OkHttpClient httpClient = this.getOkHttpClient(request, retry);
        this.performRequest(httpClient, request, completionHandler);
    }

    static /* synthetic */ void makeRequest$default(RequestManager requestManager, Request request, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        requestManager.makeRequest(request, bl, (Function2<? super String, ? super ApphudError, Unit>)function2);
    }

    private final void makeUserRegisteredRequest(Request request, boolean retry, Function2<? super String, ? super ApphudError, Unit> completionHandler) {
        OkHttpClient httpClient = this.getOkHttpClient(request, retry);
        if (this.getCurrentUser() == null) {
            RequestManager.registration$default(this, true, true, false, (Function2)new Function2<ApphudUser, ApphudError, Unit>(httpClient, request, completionHandler){
                final /* synthetic */ OkHttpClient $httpClient;
                final /* synthetic */ Request $request;
                final /* synthetic */ Function2<String, ApphudError, Unit> $completionHandler;
                {
                    this.$httpClient = $httpClient;
                    this.$request = $request;
                    this.$completionHandler = $completionHandler;
                    super(2);
                }

                public final void invoke(@Nullable ApphudUser customer, @Nullable ApphudError error) {
                    block2: {
                        Unit unit;
                        Function2<String, ApphudError, Unit> function2;
                        Object object;
                        ApphudUser apphudUser2 = customer;
                        if (apphudUser2 != null) {
                            object = apphudUser2;
                            function2 = this.$httpClient;
                            Request request = this.$request;
                            Function2<String, ApphudError, Unit> function22 = this.$completionHandler;
                            Object it = object;
                            boolean bl = false;
                            RequestManager.access$performRequest(RequestManager.INSTANCE, function2, request, function22);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit != null) break block2;
                        object = RequestManager.INSTANCE;
                        function2 = this.$completionHandler;
                        Object $this$invoke_u24lambda_u241 = object;
                        boolean bl = false;
                        function2.invoke(null, (Object)error);
                    }
                }
            }, 4, null);
        } else {
            this.performRequest(httpClient, request, completionHandler);
        }
    }

    static /* synthetic */ void makeUserRegisteredRequest$default(RequestManager requestManager, Request request, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        requestManager.makeUserRegisteredRequest(request, bl, (Function2<? super String, ? super ApphudError, Unit>)function2);
    }

    private final Request buildPostRequest(URL url, Object params) {
        String json = parser.toJson(params);
        MediaType mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.Companion.create(json, mediaType);
        Request.Builder request = new Request.Builder();
        return request.url(url).post(requestBody).build();
    }

    private final Request buildGetRequest(URL url) {
        Request.Builder request = new Request.Builder();
        return request.url(url).get().build();
    }

    @Nullable
    public final Object registrationSync(boolean needPaywalls, boolean isNew, boolean forceRegistration, @NotNull Continuation<? super ApphudUser> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super ApphudUser> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        if (!RequestManager.INSTANCE.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "registrationSync  :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            if (continuation.isActive()) {
                ((Continuation)continuation).resumeWith(Result.constructor-impl(null));
            }
        }
        if (INSTANCE.getCurrentUser() == null || forceRegistration) {
            INSTANCE.registration(needPaywalls, isNew, forceRegistration, (Function2<? super ApphudUser, ? super ApphudError, Unit>)((Function2)new Function2<ApphudUser, ApphudError, Unit>((CancellableContinuation<? super ApphudUser>)continuation){
                final /* synthetic */ CancellableContinuation<ApphudUser> $continuation;
                {
                    this.$continuation = $continuation;
                    super(2);
                }

                public final void invoke(@Nullable ApphudUser customer, @Nullable ApphudError error) {
                    if (this.$continuation.isActive()) {
                        ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)customer));
                    }
                }
            }));
        } else if (continuation.isActive()) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)INSTANCE.getCurrentUser()));
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public static /* synthetic */ Object registrationSync$default(RequestManager requestManager, boolean bl, boolean bl2, boolean bl3, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return requestManager.registrationSync(bl, bl2, bl3, (Continuation<? super ApphudUser>)continuation);
    }

    public final synchronized void registration(boolean needPaywalls, boolean isNew, boolean forceRegistration, @NotNull Function2<? super ApphudUser, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "registration :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        if (this.getCurrentUser() == null || forceRegistration) {
            ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("customers").build();
            Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), this.mkRegistrationBody(needPaywalls, isNew));
            OkHttpClient httpClient = this.getOkHttpClient(request, !ApphudInternal.INSTANCE.getFallbackMode$sdk_release());
            try {
                Unit unit;
                ResponseDto responseDto2;
                String serverResponse = this.performRequestSync(httpClient, request);
                Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
                ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                if (responseDto3 != null) {
                    ApphudUser apphudUser2;
                    ResponseDto cDto = responseDto3;
                    boolean bl = false;
                    CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                    if (customerDto != null) {
                        CustomerDto customerObj = customerDto;
                        boolean bl2 = false;
                        apphudUser2 = customerMapper.map(customerObj);
                    } else {
                        apphudUser2 = null;
                    }
                    ApphudUser currentUser = apphudUser2;
                    completionHandler.invoke((Object)currentUser, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    RequestManager $this$registration_u24lambda_u249 = this;
                    boolean bl = false;
                    completionHandler.invoke(null, (Object)new ApphudError("Registration failed", null, null, 6, null));
                }
            }
            catch (SocketTimeoutException e) {
                ApphudInternal_FallbackKt.processFallbackError(ApphudInternal.INSTANCE, request, true);
                String string = e.getMessage();
                if (string == null) {
                    string = "Registration failed";
                }
                String message = string;
                completionHandler.invoke(null, (Object)new ApphudError(message, null, 408));
            }
            catch (UnknownHostException ex) {
                String string = ex.getMessage();
                if (string == null) {
                    string = "Registration failed";
                }
                String message = string;
                completionHandler.invoke(null, (Object)new ApphudError(message, null, -999));
            }
            catch (Exception ex) {
                String string = ex.getMessage();
                if (string == null) {
                    string = "Registration failed";
                }
                String message = string;
                completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
            }
        } else {
            completionHandler.invoke((Object)this.getCurrentUser(), null);
        }
    }

    public static /* synthetic */ void registration$default(RequestManager requestManager, boolean bl, boolean bl2, boolean bl3, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            bl3 = false;
        }
        requestManager.registration(bl, bl2, bl3, (Function2<? super ApphudUser, ? super ApphudError, Unit>)function2);
    }

    @Nullable
    public final Object allProducts(@NotNull Continuation<? super List<ApphudGroup>> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super List<ApphudGroup>> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v2").path("products").build();
        Request request = RequestManager.INSTANCE.buildGetRequest(new URL(apphudUrl.getUrl()));
        RequestManager.makeRequest$default(INSTANCE, request, false, (Function2)new Function2<String, ApphudError, Unit>((CancellableContinuation<? super List<ApphudGroup>>)continuation){
            final /* synthetic */ CancellableContinuation<List<ApphudGroup>> $continuation;
            {
                this.$continuation = $continuation;
                super(2);
            }

            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block11: {
                    Unit unit;
                    CancellableContinuation<List<ApphudGroup>> cancellableContinuation;
                    Object object;
                    String string = serverResponse;
                    if (string != null) {
                        Unit unit2;
                        ResponseDto responseDto2;
                        object = string;
                        cancellableContinuation = this.$continuation;
                        String it = object;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<List<? extends ApphudGroupDto>>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026phudGroupDto>>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                        if (responseDto3 != null) {
                            List<ApphudGroup> productsList;
                            List<ApphudGroup> list;
                            ResponseDto response = responseDto3;
                            boolean bl2 = false;
                            List list2 = (List)response.getData().getResults();
                            if (list2 != null) {
                                List it1 = list2;
                                boolean bl3 = false;
                                list = RequestManager.access$getProductMapper$p().map(it1);
                            } else {
                                list = productsList = null;
                            }
                            if (cancellableContinuation.isActive()) {
                                ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl(productsList));
                            }
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if (unit2 == null) {
                            RequestManager $this$invoke_u24lambda_u243_u24lambda_u242 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            ApphudLog.logE$default(ApphudLog.INSTANCE, "Failed to load products", false, 2, null);
                            if (cancellableContinuation.isActive()) {
                                ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl(null));
                            }
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block11;
                    object = RequestManager.INSTANCE;
                    cancellableContinuation = this.$continuation;
                    Object $this$invoke_u24lambda_u244 = object;
                    boolean bl = false;
                    if (error != null) {
                        ApphudLog.logE$default(ApphudLog.INSTANCE, error.getMessage(), false, 2, null);
                    }
                    if (cancellableContinuation.isActive()) {
                        ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl(null));
                    }
                }
            }
        }, 2, null);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public final void purchased(@NotNull Purchase purchase2, @Nullable ApphudProduct apphudProduct, @Nullable String offerToken, @Nullable String oldToken, @NotNull Function2<? super ApphudUser, ? super ApphudError, Unit> completionHandler) {
        PurchaseBody purchaseBody;
        PurchaseBody purchaseBody2;
        Intrinsics.checkNotNullParameter((Object)purchase2, (String)"purchase");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "purchased :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("subscriptions").build();
        ApphudProduct apphudProduct2 = apphudProduct;
        if (apphudProduct2 != null) {
            ApphudProduct it = apphudProduct2;
            boolean bl = false;
            purchaseBody2 = INSTANCE.makePurchaseBody(purchase2, it.getProductDetails(), it.getPaywallId$sdk_release(), it.getPlacementId$sdk_release(), it.getId$sdk_release(), offerToken, oldToken);
        } else {
            purchaseBody2 = purchaseBody = null;
        }
        if (purchaseBody == null) {
            String message = "ProductsDetails and ApphudProduct can not be null at the same time";
            ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
            completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
            return;
        }
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), purchaseBody);
        this.makeUserRegisteredRequest(request, !ApphudInternal.INSTANCE.getFallbackMode$sdk_release(), (Function2<? super String, ? super ApphudError, Unit>)((Function2)new Function2<String, ApphudError, Unit>(completionHandler){
            final /* synthetic */ Function2<ApphudUser, ApphudError, Unit> $completionHandler;
            {
                this.$completionHandler = $completionHandler;
                super(2);
            }

            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block7: {
                    Unit unit;
                    Function2<ApphudUser, ApphudError, Unit> function2;
                    Object object;
                    String string = serverResponse;
                    if (string != null) {
                        Unit unit2;
                        ResponseDto responseDto2;
                        object = string;
                        function2 = this.$completionHandler;
                        String it = object;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                        if (responseDto3 != null) {
                            ApphudUser apphudUser2;
                            ResponseDto cDto = responseDto3;
                            boolean bl2 = false;
                            CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                            if (customerDto != null) {
                                CustomerDto customerObj = customerDto;
                                boolean bl3 = false;
                                apphudUser2 = RequestManager.access$getCustomerMapper$p().map(customerObj);
                            } else {
                                apphudUser2 = null;
                            }
                            ApphudUser currentUser = apphudUser2;
                            function2.invoke((Object)currentUser, null);
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if (unit2 == null) {
                            RequestManager $this$invoke_u24lambda_u243_u24lambda_u242 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            function2.invoke(null, (Object)new ApphudError("Purchase failed", null, null, 6, null));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block7;
                    object = RequestManager.INSTANCE;
                    function2 = this.$completionHandler;
                    Object $this$invoke_u24lambda_u244 = object;
                    boolean bl = false;
                    function2.invoke(null, (Object)error);
                }
            }
        }));
    }

    @Nullable
    public final Object restorePurchasesSync(@Nullable ApphudProduct apphudProduct, @Nullable List<PurchaseRecordDetails> purchaseRecordDetailsSet, @Nullable Purchase purchase2, @Nullable ProductDetails productDetails2, @Nullable String offerIdToken, boolean observerMode, @NotNull Continuation<? super ApphudUser> $completion) {
        Unit unit;
        PurchaseBody purchaseBody;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super ApphudUser> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        if (!RequestManager.INSTANCE.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "restorePurchasesSync  :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            if (continuation.isActive()) {
                ((Continuation)continuation).resumeWith(Result.constructor-impl(null));
            }
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("subscriptions").build();
        PurchaseBody purchaseBody2 = purchaseBody = purchaseRecordDetailsSet != null ? RequestManager.INSTANCE.makeRestorePurchasesBody(apphudProduct, purchaseRecordDetailsSet, observerMode) : (purchase2 != null && productDetails2 != null ? RequestManager.INSTANCE.makeTrackPurchasesBody(apphudProduct, purchase2, productDetails2, offerIdToken, observerMode) : null);
        if (purchaseBody2 != null) {
            PurchaseBody it = purchaseBody2;
            boolean bl3 = false;
            Request request = RequestManager.INSTANCE.buildPostRequest(new URL(apphudUrl.getUrl()), it);
            RequestManager.INSTANCE.makeUserRegisteredRequest(request, !ApphudInternal.INSTANCE.getFallbackMode$sdk_release(), (Function2<? super String, ? super ApphudError, Unit>)((Function2)new Function2<String, ApphudError, Unit>((CancellableContinuation<? super ApphudUser>)continuation){
                final /* synthetic */ CancellableContinuation<ApphudUser> $continuation;
                {
                    this.$continuation = $continuation;
                    super(2);
                }

                public final void invoke(@Nullable String serverResponse, @Nullable ApphudError apphudError) {
                    block10: {
                        Unit unit;
                        CancellableContinuation<ApphudUser> cancellableContinuation;
                        Object object;
                        String string = serverResponse;
                        if (string != null) {
                            Unit unit2;
                            ResponseDto responseDto2;
                            object = string;
                            cancellableContinuation = this.$continuation;
                            String it = object;
                            boolean bl = false;
                            Parser parser = RequestManager.INSTANCE.getParser();
                            Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
                            ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                            if (responseDto3 != null) {
                                ApphudUser currentUser;
                                ApphudUser apphudUser2;
                                ResponseDto cDto = responseDto3;
                                boolean bl2 = false;
                                CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                                if (customerDto != null) {
                                    CustomerDto customerObj = customerDto;
                                    boolean bl3 = false;
                                    apphudUser2 = RequestManager.access$getCustomerMapper$p().map(customerObj);
                                } else {
                                    apphudUser2 = currentUser = null;
                                }
                                if (cancellableContinuation.isActive()) {
                                    ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl((Object)currentUser));
                                }
                                unit2 = Unit.INSTANCE;
                            } else {
                                unit2 = null;
                            }
                            if (unit2 == null) {
                                RequestManager $this$invoke_u24lambda_u243_u24lambda_u242 = RequestManager.INSTANCE;
                                boolean bl4 = false;
                                if (cancellableContinuation.isActive()) {
                                    ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl(null));
                                }
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit != null) break block10;
                        object = RequestManager.INSTANCE;
                        cancellableContinuation = this.$continuation;
                        Object $this$invoke_u24lambda_u244 = object;
                        boolean bl = false;
                        if (cancellableContinuation.isActive()) {
                            ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl(null));
                        }
                    }
                }
            }));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            RequestManager $this$restorePurchasesSync_u24lambda_u2414_u24lambda_u2413 = INSTANCE;
            boolean bl4 = false;
            if (continuation.isActive()) {
                ((Continuation)continuation).resumeWith(Result.constructor-impl(null));
            }
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public static /* synthetic */ Object restorePurchasesSync$default(RequestManager requestManager, ApphudProduct apphudProduct, List list, Purchase purchase2, ProductDetails productDetails2, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            apphudProduct = null;
        }
        return requestManager.restorePurchasesSync(apphudProduct, list, purchase2, productDetails2, string, bl, (Continuation<? super ApphudUser>)continuation);
    }

    public final void send(@NotNull AttributionBody attributionBody, @NotNull Function2<? super Attribution, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter((Object)attributionBody, (String)"attributionBody");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "send :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("customers/attribution").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), attributionBody);
        RequestManager.makeUserRegisteredRequest$default(this, request, false, (Function2)new Function2<String, ApphudError, Unit>(completionHandler){
            final /* synthetic */ Function2<Attribution, ApphudError, Unit> $completionHandler;
            {
                this.$completionHandler = $completionHandler;
                super(2);
            }

            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block7: {
                    Unit unit;
                    Function2<Attribution, ApphudError, Unit> function2;
                    Object object;
                    String string = serverResponse;
                    if (string != null) {
                        Unit unit2;
                        ResponseDto responseDto2;
                        object = string;
                        function2 = this.$completionHandler;
                        String it = object;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<AttributionDto>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026ttributionDto>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                        if (responseDto3 != null) {
                            Attribution attribution;
                            ResponseDto response = responseDto3;
                            boolean bl2 = false;
                            AttributionDto attributionDto = (AttributionDto)response.getData().getResults();
                            if (attributionDto != null) {
                                AttributionDto it1 = attributionDto;
                                boolean bl3 = false;
                                attribution = RequestManager.access$getAttributionMapper$p().map(it1);
                            } else {
                                attribution = null;
                            }
                            Attribution attribution2 = attribution;
                            function2.invoke((Object)attribution2, null);
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if (unit2 == null) {
                            RequestManager $this$invoke_u24lambda_u243_u24lambda_u242 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            function2.invoke(null, (Object)new ApphudError("Failed to send attribution", null, null, 6, null));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block7;
                    object = RequestManager.INSTANCE;
                    function2 = this.$completionHandler;
                    Object $this$invoke_u24lambda_u244 = object;
                    boolean bl = false;
                    function2.invoke(null, (Object)error);
                }
            }
        }, 2, null);
    }

    public final void userProperties(@NotNull UserPropertiesBody userPropertiesBody, @NotNull Function2<? super Attribution, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter((Object)userPropertiesBody, (String)"userPropertiesBody");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "userProperties :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("customers/properties").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), userPropertiesBody);
        RequestManager.makeUserRegisteredRequest$default(this, request, false, (Function2)new Function2<String, ApphudError, Unit>(completionHandler){
            final /* synthetic */ Function2<Attribution, ApphudError, Unit> $completionHandler;
            {
                this.$completionHandler = $completionHandler;
                super(2);
            }

            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block7: {
                    Unit unit;
                    Function2<Attribution, ApphudError, Unit> function2;
                    Object object;
                    String string = serverResponse;
                    if (string != null) {
                        Unit unit2;
                        ResponseDto responseDto2;
                        object = string;
                        function2 = this.$completionHandler;
                        String it = object;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<AttributionDto>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026ttributionDto>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                        if (responseDto3 != null) {
                            Attribution attribution;
                            ResponseDto response = responseDto3;
                            boolean bl2 = false;
                            AttributionDto attributionDto = (AttributionDto)response.getData().getResults();
                            if (attributionDto != null) {
                                AttributionDto it1 = attributionDto;
                                boolean bl3 = false;
                                attribution = RequestManager.access$getAttributionMapper$p().map(it1);
                            } else {
                                attribution = null;
                            }
                            Attribution attribution2 = attribution;
                            function2.invoke((Object)attribution2, null);
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if (unit2 == null) {
                            RequestManager $this$invoke_u24lambda_u243_u24lambda_u242 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            function2.invoke(null, (Object)new ApphudError("Failed to send properties", null, null, 6, null));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block7;
                    object = RequestManager.INSTANCE;
                    function2 = this.$completionHandler;
                    Object $this$invoke_u24lambda_u244 = object;
                    boolean bl = false;
                    function2.invoke(null, (Object)error);
                }
            }
        }, 2, null);
    }

    @Nullable
    public final String fetchFallbackHost() {
        String url = "https://apphud.blob.core.windows.net/apphud-gateway/fallback.txt";
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).build();
        Response response = null;
        try {
            response = client.newCall(request).execute();
        }
        catch (Exception ex) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "Unable to load fallback host", false, 2, null);
        }
        Response response2 = response;
        if (response2 != null) {
            Response it = response2;
            boolean bl = false;
            if (it.isSuccessful()) {
                ResponseBody responseBody = it.body();
                return responseBody != null ? responseBody.string() : null;
            }
        }
        return null;
    }

    public final void grantPromotional(int daysCount, @Nullable String productId, @Nullable ApphudGroup permissionGroup, @NotNull Function2<? super ApphudUser, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "grantPromotional :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("promotions").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), this.grantPromotionalBody$sdk_release(daysCount, productId, permissionGroup));
        OkHttpClient httpClient = RequestManager.getOkHttpClient$default(this, request, false, 2, null);
        try {
            Unit unit;
            ResponseDto responseDto2;
            String serverResponse = this.performRequestSync(httpClient, request);
            Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
            ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
            if (responseDto3 != null) {
                ApphudUser apphudUser2;
                ResponseDto cDto = responseDto3;
                boolean bl = false;
                CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                if (customerDto != null) {
                    CustomerDto customerObj = customerDto;
                    boolean bl2 = false;
                    apphudUser2 = customerMapper.map(customerObj);
                } else {
                    apphudUser2 = null;
                }
                ApphudUser currentUser = apphudUser2;
                completionHandler.invoke((Object)currentUser, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                RequestManager $this$grantPromotional_u24lambda_u2418 = this;
                boolean bl = false;
                completionHandler.invoke(null, (Object)new ApphudError("Promotional request failed", null, null, 6, null));
            }
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "Undefined error";
            }
            String message = string;
            completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
        }
    }

    public final void paywallShown(@NotNull ApphudPaywall paywall2) {
        Intrinsics.checkNotNullParameter((Object)paywall2, (String)"paywall");
        this.trackPaywallEvent(RequestManager.makePaywallEventBody$default(this, "paywall_shown", paywall2.getId$sdk_release(), paywall2.getPlacementId$sdk_release(), null, null, 24, null));
    }

    public final void paywallClosed(@NotNull ApphudPaywall paywall2) {
        Intrinsics.checkNotNullParameter((Object)paywall2, (String)"paywall");
        this.trackPaywallEvent(RequestManager.makePaywallEventBody$default(this, "paywall_closed", paywall2.getId$sdk_release(), paywall2.getPlacementId$sdk_release(), null, null, 24, null));
    }

    public final void paywallProductsLoaded(int count) {
        this.trackPaywallEvent(RequestManager.makePaywallEventBody$default(this, "paywall_products_loaded", null, null, String.valueOf(count), null, 16, null));
    }

    public final void paywallCheckoutInitiated(@Nullable String paywallId, @Nullable String placementId, @Nullable String productId) {
        this.trackPaywallEvent(RequestManager.makePaywallEventBody$default(this, "paywall_checkout_initiated", paywallId, placementId, productId, null, 16, null));
    }

    public final void paywallPaymentCancelled(@Nullable String paywallId, @Nullable String placementId, @Nullable String productId) {
        this.trackPaywallEvent(RequestManager.makePaywallEventBody$default(this, "paywall_payment_cancelled", paywallId, placementId, productId, null, 16, null));
    }

    public final void paywallPaymentError(@Nullable String paywallId, @Nullable String placementId, @Nullable String productId, @Nullable String errorMessage) {
        this.trackPaywallEvent(this.makePaywallEventBody("paywall_payment_error", paywallId, placementId, productId, errorMessage));
    }

    private final void trackPaywallEvent(PaywallEventBody body) {
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "trackPaywallEvent :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("events").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), body);
        RequestManager.makeUserRegisteredRequest$default(this, request, false, trackPaywallEvent.1.INSTANCE, 2, null);
    }

    public final void sendErrorLogs(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "sendErrorLogs :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        ErrorLogsBody body = this.makeErrorLogsBody$sdk_release(message, ApphudUtils.INSTANCE.getPackageName());
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("logs").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), body);
        this.makeRequest(request, false, (Function2<? super String, ? super ApphudError, Unit>)((Function2)sendErrorLogs.1.INSTANCE));
    }

    public final void sendBenchmarkLogs(@NotNull BenchmarkBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "sendErrorLogs :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v2").path("logs").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), body);
        this.makeRequest(request, false, (Function2<? super String, ? super ApphudError, Unit>)((Function2)sendBenchmarkLogs.1.INSTANCE));
    }

    private final boolean isNetworkAvailable() {
        Object object = this.getApplicationContext().getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT >= 29) {
            NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            if (capabilities != null) {
                if (capabilities.hasTransport(0)) {
                    return true;
                }
                if (capabilities.hasTransport(1)) {
                    return true;
                }
                if (capabilities.hasTransport(3)) {
                    return true;
                }
            }
        } else {
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo != null && activeNetworkInfo.isConnected()) {
                return true;
            }
        }
        return false;
    }

    private final PaywallEventBody makePaywallEventBody(String name, String paywallId, String placementId, String productId, String errorMessage) {
        Map map;
        String it;
        Map properties2 = new LinkedHashMap();
        String string = paywallId;
        if (string != null) {
            it = string;
            boolean bl = false;
            properties2.put("paywall_id", it);
        }
        String string2 = productId;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            properties2.put("product_id", it);
        }
        String string3 = placementId;
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            properties2.put("placement_id", it);
        }
        String string4 = errorMessage;
        if (string4 != null) {
            it = string4;
            boolean bl = false;
            properties2.put("error_message", it);
        }
        String string5 = name;
        String string6 = ApphudInternal.INSTANCE.getUserId$sdk_release();
        String string7 = ApphudInternal.INSTANCE.getDeviceId();
        String string8 = ApphudExtensionsKt.isDebuggable(this.getApplicationContext()) ? "sandbox" : "production";
        long l = System.currentTimeMillis();
        Map map2 = properties2;
        if (map2.isEmpty()) {
            long l2 = l;
            String string9 = string8;
            String string10 = string7;
            String string11 = string6;
            String string12 = string5;
            boolean bl = false;
            Object var16_16 = null;
            string5 = string12;
            string6 = string11;
            string7 = string10;
            string8 = string9;
            l = l2;
            map = var16_16;
        } else {
            map = map2;
        }
        Map map3 = map;
        long l3 = l;
        String string13 = string8;
        String string14 = string7;
        String string15 = string6;
        String string16 = string5;
        return new PaywallEventBody(string16, string15, string14, string13, l3, map3);
    }

    static /* synthetic */ PaywallEventBody makePaywallEventBody$default(RequestManager requestManager, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        return requestManager.makePaywallEventBody(string, string2, string3, string4, string5);
    }

    private final RegistrationBody mkRegistrationBody(boolean needPaywalls, boolean isNew) {
        String string;
        String string2;
        String[] deviceIds = this.getStorage().getDeviceIdentifiers();
        String idfa = deviceIds[0];
        String appSetId = deviceIds[1];
        String androidId = null;
        androidId = deviceIds[2];
        if (((CharSequence)androidId).length() == 0) {
            String string3 = ApphudInternal.INSTANCE.fetchAndroidIdSync();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                androidId = it;
            }
        }
        String string4 = Locale.getDefault().toString();
        String string5 = HeadersInterceptor.Shared.getX_SDK_VERSION();
        String string6 = ContextKt.buildAppVersion(this.getApplicationContext());
        String string7 = Build.MANUFACTURER;
        String string8 = ApphudUtils.INSTANCE.getOptOutOfTracking() ? "Restricted" : Build.MODEL;
        String string9 = Build.VERSION.RELEASE;
        String string10 = ContextKt.buildAppVersion(this.getApplicationContext());
        String string11 = ApphudUtils.INSTANCE.getOptOutOfTracking() || ((CharSequence)appSetId).length() == 0 ? null : (string2 = appSetId);
        String string12 = ApphudUtils.INSTANCE.getOptOutOfTracking() || ((CharSequence)idfa).length() == 0 ? null : (string = idfa);
        String string13 = ApphudUtils.INSTANCE.getOptOutOfTracking() || ((CharSequence)androidId).length() == 0 ? null : androidId;
        String string14 = ApphudInternal.INSTANCE.getUserId$sdk_release();
        String string15 = ApphudInternal.INSTANCE.getDeviceId();
        String string16 = TimeZone.getDefault().getID();
        boolean bl = ApphudExtensionsKt.isDebuggable(this.getApplicationContext());
        Long l = this.getInstallationDate();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"MANUFACTURER");
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"if (ApphudUtils.optOutOf\u2026tricted\" else Build.MODEL");
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"RELEASE");
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"id");
        return new RegistrationBody(string4, string5, string6, string7, string8, "Android", string9, string10, string2, string, string13, string14, string15, string16, bl, isNew, needPaywalls, needPaywalls, l);
    }

    private final Long getInstallationDate() {
        Long dateInSecond;
        block2: {
            dateInSecond = null;
            try {
                PackageManager packageManager = this.getApplicationContext().getPackageManager();
                if (packageManager == null) break block2;
                PackageManager manager = packageManager;
                boolean bl = false;
                dateInSecond = manager.getPackageInfo((String)this.getApplicationContext().getPackageName(), (int)0).firstInstallTime / 1000L;
            }
            catch (Exception ex) {
                String string = ex.getMessage();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                ApphudLog.logE$default(ApphudLog.INSTANCE, it, false, 2, null);
            }
        }
        return dateInSecond;
    }

    private final PurchaseBody makePurchaseBody(Purchase purchase2, ProductDetails productDetails2, String paywall_id, String placement_id, String apphud_product_id, String offerIdToken, String oldToken) {
        ProductInfo productInfo;
        String string;
        String string2;
        String string3;
        Object object;
        String string4;
        String string5;
        block6: {
            block5: {
                string5 = ApphudInternal.INSTANCE.getDeviceId();
                string4 = purchase2.getOrderId();
                object = productDetails2;
                if (object == null) break block5;
                ProductDetails productDetails3 = object;
                string3 = string4;
                string2 = string5;
                boolean bl = false;
                string = productDetails2.getProductId();
                string5 = string2;
                string4 = string3;
                String string6 = string;
                object = string6;
                if (string6 != null) break block6;
            }
            List list = purchase2.getProducts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"purchase.products");
            object = (String)CollectionsKt.first((List)list);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"productDetails?.let { pr\u2026purchase.products.first()");
        String string7 = purchase2.getPurchaseToken();
        String string8 = string7;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"purchase.purchaseToken");
        ProductDetails productDetails4 = productDetails2;
        String string9 = productDetails4 != null ? RequestManagerKt.priceCurrencyCode(productDetails4) : null;
        ProductDetails productDetails5 = productDetails2;
        Long l = productDetails5 != null ? RequestManagerKt.priceAmountMicros(productDetails5) : null;
        ProductDetails productDetails6 = productDetails2;
        String string10 = productDetails6 != null ? RequestManagerKt.subscriptionPeriod(productDetails6) : null;
        String string11 = paywall_id;
        String string12 = placement_id;
        String string13 = apphud_product_id;
        boolean bl = false;
        int n = BILLING_VERSION;
        long l2 = purchase2.getPurchaseTime();
        ProductDetails productDetails7 = productDetails2;
        if (productDetails7 != null) {
            ProductDetails productDetails8 = productDetails7;
            long l3 = l2;
            int n2 = n;
            boolean bl2 = bl;
            String string14 = string13;
            String string15 = string12;
            String string16 = string11;
            String string17 = string10;
            Long l4 = l;
            String string18 = string9;
            String string19 = string8;
            string = object2;
            string3 = string4;
            string2 = string5;
            boolean bl3 = false;
            ProductInfo productInfo2 = new ProductInfo(productDetails2, offerIdToken);
            string5 = string2;
            string4 = string3;
            object2 = string;
            string8 = string19;
            string9 = string18;
            l = l4;
            string10 = string17;
            string11 = string16;
            string12 = string15;
            string13 = string14;
            bl = bl2;
            n = n2;
            l2 = l3;
            productInfo = productInfo2;
        } else {
            productInfo = null;
        }
        ProductDetails productDetails9 = productDetails2;
        String string20 = productDetails9 != null ? productDetails9.getProductType() : null;
        ProductInfo productInfo3 = productInfo;
        long l5 = l2;
        int n3 = n;
        boolean bl4 = bl;
        String string21 = string13;
        String string22 = string12;
        String string23 = string11;
        String string24 = string10;
        Long l6 = l;
        String string25 = string9;
        String string26 = string8;
        Object object3 = object2;
        String string27 = string4;
        List list = CollectionsKt.listOf((Object)new PurchaseItemBody(string27, (String)object3, string26, string25, l6, string24, string23, string22, string21, bl4, n3, l5, productInfo3, string20));
        String string28 = string5;
        return new PurchaseBody(string28, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PurchaseBody makeRestorePurchasesBody(ApphudProduct apphudProduct, List<PurchaseRecordDetails> purchases, boolean observerMode) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = purchases;
        String string = ApphudInternal.INSTANCE.getDeviceId();
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ApphudProduct apphudProduct2;
            ApphudProduct apphudProduct3;
            ApphudProduct apphudProduct4;
            void purchase2;
            PurchaseRecordDetails purchaseRecordDetails = (PurchaseRecordDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = purchase2.getDetails().getProductId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchase.details.productId");
            String string3 = purchase2.getRecord().getPurchaseToken();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"purchase.record.purchaseToken");
            collection.add(new PurchaseItemBody(null, string2, string3, RequestManagerKt.priceCurrencyCode(purchase2.getDetails()), System.currentTimeMillis() - purchase2.getRecord().getPurchaseTime() < ONE_HOUR ? RequestManagerKt.priceAmountMicros(purchase2.getDetails()) : null, RequestManagerKt.subscriptionPeriod(purchase2.getDetails()), Intrinsics.areEqual((Object)((apphudProduct4 = apphudProduct) != null && (apphudProduct4 = apphudProduct4.getProductDetails()) != null ? apphudProduct4.getProductId() : null), (Object)purchase2.getDetails().getProductId()) ? apphudProduct.getPaywallId$sdk_release() : null, Intrinsics.areEqual((Object)((apphudProduct3 = apphudProduct) != null && (apphudProduct3 = apphudProduct3.getProductDetails()) != null ? apphudProduct3.getProductId() : null), (Object)purchase2.getDetails().getProductId()) ? apphudProduct.getPlacementId$sdk_release() : null, Intrinsics.areEqual((Object)((apphudProduct2 = apphudProduct) != null && (apphudProduct2 = apphudProduct2.getProductDetails()) != null ? apphudProduct2.getProductId() : null), (Object)purchase2.getDetails().getProductId()) ? apphudProduct.getId$sdk_release() : null, observerMode, BILLING_VERSION, purchase2.getRecord().getPurchaseTime(), null, purchase2.getDetails().getProductType()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PurchaseItemBody it = (PurchaseItemBody)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getPurchase_time());
                it = (PurchaseItemBody)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getPurchase_time()));
            }
        });
        String string4 = string;
        return new PurchaseBody(string4, list);
    }

    static /* synthetic */ PurchaseBody makeRestorePurchasesBody$default(RequestManager requestManager, ApphudProduct apphudProduct, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            apphudProduct = null;
        }
        return requestManager.makeRestorePurchasesBody(apphudProduct, list, bl);
    }

    private final PurchaseBody makeTrackPurchasesBody(ApphudProduct apphudProduct, Purchase purchase2, ProductDetails productDetails2, String offerIdToken, boolean observerMode) {
        String string;
        ApphudProduct apphudProduct2;
        String string2;
        ApphudProduct apphudProduct3;
        String string3;
        String string4 = ApphudInternal.INSTANCE.getDeviceId();
        String string5 = purchase2.getOrderId();
        List list = purchase2.getProducts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"purchase.products");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"purchase.products.first()");
        String string6 = (String)object;
        String string7 = purchase2.getPurchaseToken();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"purchase.purchaseToken");
        String string8 = RequestManagerKt.priceCurrencyCode(productDetails2);
        Long l = RequestManagerKt.priceAmountMicros(productDetails2);
        String string9 = RequestManagerKt.subscriptionPeriod(productDetails2);
        ApphudProduct apphudProduct4 = apphudProduct;
        String string10 = apphudProduct4 != null && (apphudProduct4 = apphudProduct4.getProductDetails()) != null ? apphudProduct4.getProductId() : null;
        List list2 = purchase2.getProducts();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"purchase.products");
        if (Intrinsics.areEqual((Object)string10, (Object)CollectionsKt.first((List)list2))) {
            ApphudProduct apphudProduct5 = apphudProduct;
            string3 = apphudProduct5 != null ? apphudProduct5.getPaywallId$sdk_release() : null;
        } else {
            string3 = null;
        }
        String string11 = (apphudProduct3 = apphudProduct) != null && (apphudProduct3 = apphudProduct3.getProductDetails()) != null ? apphudProduct3.getProductId() : null;
        List list3 = purchase2.getProducts();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"purchase.products");
        if (Intrinsics.areEqual((Object)string11, (Object)CollectionsKt.first((List)list3))) {
            ApphudProduct apphudProduct6 = apphudProduct;
            string2 = apphudProduct6 != null ? apphudProduct6.getPlacementId$sdk_release() : null;
        } else {
            string2 = null;
        }
        String string12 = (apphudProduct2 = apphudProduct) != null && (apphudProduct2 = apphudProduct2.getProductDetails()) != null ? apphudProduct2.getProductId() : null;
        List list4 = purchase2.getProducts();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"purchase.products");
        if (Intrinsics.areEqual((Object)string12, (Object)CollectionsKt.first((List)list4))) {
            ApphudProduct apphudProduct7 = apphudProduct;
            string = apphudProduct7 != null ? apphudProduct7.getId$sdk_release() : null;
        } else {
            string = null;
        }
        return new PurchaseBody(string4, CollectionsKt.listOf((Object)new PurchaseItemBody(string5, string6, string7, string8, l, string9, string3, string2, string, observerMode, BILLING_VERSION, purchase2.getPurchaseTime(), new ProductInfo(productDetails2, offerIdToken), productDetails2.getProductType())));
    }

    static /* synthetic */ PurchaseBody makeTrackPurchasesBody$default(RequestManager requestManager, ApphudProduct apphudProduct, Purchase purchase2, ProductDetails productDetails2, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            apphudProduct = null;
        }
        return requestManager.makeTrackPurchasesBody(apphudProduct, purchase2, productDetails2, string, bl);
    }

    @NotNull
    public final ErrorLogsBody makeErrorLogsBody$sdk_release(@NotNull String message, @Nullable String apphud_product_id) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new ErrorLogsBody(message, apphud_product_id, ApphudInternal.INSTANCE.getUserId$sdk_release(), ApphudInternal.INSTANCE.getDeviceId(), ApphudExtensionsKt.isDebuggable(this.getApplicationContext()) ? "sandbox" : "production", System.currentTimeMillis());
    }

    public static /* synthetic */ ErrorLogsBody makeErrorLogsBody$sdk_release$default(RequestManager requestManager, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return requestManager.makeErrorLogsBody$sdk_release(string, string2);
    }

    @NotNull
    public final GrantPromotionalBody grantPromotionalBody$sdk_release(int daysCount, @Nullable String productId, @Nullable ApphudGroup permissionGroup) {
        ApphudGroup apphudGroup = permissionGroup;
        return new GrantPromotionalBody(daysCount, ApphudInternal.INSTANCE.getUserId$sdk_release(), ApphudInternal.INSTANCE.getDeviceId(), productId, apphudGroup != null ? apphudGroup.getId$sdk_release() : null);
    }

    public static /* synthetic */ GrantPromotionalBody grantPromotionalBody$sdk_release$default(RequestManager requestManager, int n, String string, ApphudGroup apphudGroup, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            apphudGroup = null;
        }
        return requestManager.grantPromotionalBody$sdk_release(n, string, apphudGroup);
    }

    private final String buildPrettyPrintedBy(String jsonString) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public final Object fetchAdvertisingId(@NotNull Continuation<? super String> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super String> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        if (RequestManager.INSTANCE.hasPermission("com.google.android.gms.permission.AD_ID")) {
            String advId = null;
            try {
                AdvertisingIdManager.AdInfo adInfo = AdvertisingIdManager.INSTANCE.getAdvertisingIdInfo(INSTANCE.getApplicationContext());
                advId = adInfo.getId();
            }
            catch (Exception e) {
                ApphudLog.logE$default(ApphudLog.INSTANCE, "Finish load advertisingId: " + e, false, 2, null);
            }
            if (continuation.isActive()) {
                ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)advId));
            }
        } else if (continuation.isActive()) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl(null));
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final boolean hasPermission(String permission) {
        try {
            PackageInfo pInfo;
            PackageInfo packageInfo = pInfo = Build.VERSION.SDK_INT >= 33 ? this.getApplicationContext().getPackageManager().getPackageInfo(ApphudUtils.INSTANCE.getPackageName(), PackageManager.PackageInfoFlags.of((long)4096L)) : this.getApplicationContext().getPackageManager().getPackageInfo(ApphudUtils.INSTANCE.getPackageName(), 4096);
            if (pInfo.requestedPermissions != null) {
                Intrinsics.checkNotNullExpressionValue((Object)pInfo.requestedPermissions, (String)"pInfo.requestedPermissions");
                for (String p : pInfo.requestedPermissions) {
                    if (!Intrinsics.areEqual((Object)p, (Object)permission)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static final /* synthetic */ void access$performRequest(RequestManager $this, OkHttpClient client, Request request, Function2 completionHandler) {
        $this.performRequest(client, request, (Function2<? super String, ? super ApphudError, Unit>)completionHandler);
    }

    public static final /* synthetic */ CustomerMapper access$getCustomerMapper$p() {
        return customerMapper;
    }

    public static final /* synthetic */ AttributionMapper access$getAttributionMapper$p() {
        return attributionMapper;
    }

    public static final /* synthetic */ ProductMapper access$getProductMapper$p() {
        return productMapper;
    }

    static {
        Gson gson = RequestManager.gson;
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gson");
        parser = new GsonParser(gson);
        productMapper = new ProductMapper();
        paywallsMapper = new PaywallsMapper(parser);
        attributionMapper = new AttributionMapper();
        placementsMapper = new PlacementsMapper(parser);
        customerMapper = new CustomerMapper(new SubscriptionMapper(), paywallsMapper, placementsMapper);
        ONE_HOUR = 3600000L;
    }
}

