/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.managers;

import com.apphud.sdk.ApphudInternal;
import com.apphud.sdk.ApphudInternal_FallbackKt;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.managers.RequestManager;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/apphud/sdk/managers/HttpRetryInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "sdk_release"})
public final class HttpRetryInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long STEP = 1000L;
    private static int MAX_COUNT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = null;
        boolean isSuccess = false;
        int tryCount = 0;
        while (!isSuccess && tryCount < MAX_COUNT) {
            Response response2;
            block25: {
                Response response3;
                block23: {
                    block24: {
                        try {
                            response = chain.proceed(request);
                            isSuccess = response.isSuccessful();
                            if (isSuccess) continue;
                            if (response != null) {
                                boolean isBlocked = RequestManager.INSTANCE.checkLock403$sdk_release(request, response);
                                if (isBlocked) {
                                    response3 = response;
                                    if (isSuccess || ++tryCount >= MAX_COUNT) break block23;
                                    break block24;
                                }
                                if (response.code() == 429) {
                                    STEP = 6000L;
                                    MAX_COUNT = 1;
                                } else {
                                    int n = response.code();
                                    boolean bl = 200 <= n ? n < 500 : false;
                                    if (bl) {
                                        response2 = response;
                                        break block25;
                                    }
                                }
                            }
                            if (ApphudInternal.INSTANCE.getFALLBACK_ERRORS$sdk_release().contains(response.code())) {
                                ApphudInternal_FallbackKt.processFallbackError(ApphudInternal.INSTANCE, request);
                                if (ApphudInternal.INSTANCE.getFallbackMode$sdk_release()) {
                                    tryCount = MAX_COUNT;
                                }
                            }
                            ApphudLog.logE$default(ApphudLog.INSTANCE, "Request (" + request.url().encodedPath() + ") failed with code (" + response.code() + "). Will retry in " + STEP / (long)1000 + " seconds (" + tryCount + ").", false, 2, null);
                            Thread.sleep(STEP);
                            continue;
                        }
                        catch (SocketTimeoutException e) {
                            ApphudInternal_FallbackKt.processFallbackError(ApphudInternal.INSTANCE, request);
                            ApphudLog.logE$default(ApphudLog.INSTANCE, "Request (" + request.url().encodedPath() + ") failed with SocketTimeoutException. Will retry in " + STEP / (long)1000 + " seconds (" + tryCount + ").", false, 2, null);
                            if (ApphudInternal.INSTANCE.getFallbackMode$sdk_release()) {
                                throw e;
                            }
                            Thread.sleep(STEP);
                            continue;
                        }
                        catch (UnknownHostException e) {
                            tryCount = MAX_COUNT;
                            continue;
                        }
                        catch (Exception e) {
                            ApphudLog.logE$default(ApphudLog.INSTANCE, "Request (" + request.url().encodedPath() + ") failed with Exception. Will retry in " + STEP / (long)1000 + " seconds (" + tryCount + ").", false, 2, null);
                            Thread.sleep(STEP);
                            continue;
                        }
                    }
                    response.close();
                }
                return response3;
            }
            if (!isSuccess && ++tryCount < MAX_COUNT) {
                response.close();
            }
            return response2;
            finally {
                if (isSuccess || ++tryCount >= MAX_COUNT) continue;
                Response response4 = response;
                if (response4 == null) continue;
                response4.close();
            }
        }
        if (!isSuccess) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "Reached max number (" + MAX_COUNT + ") of (" + request.url().encodedPath() + ") request retries. Exiting..", false, 2, null);
        }
        if (response != null) {
            return response;
        }
        ApphudLog.log$default(ApphudLog.INSTANCE, "Performing one more request " + request.url().encodedPath(), false, 2, null);
        return chain.proceed(request);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/apphud/sdk/managers/HttpRetryInterceptor$Companion;", "", "()V", "MAX_COUNT", "", "STEP", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

