/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloMutationCall;
import com.apollographql.apollo3.ApolloQueryCall;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.cache.http.HttpCache;
import com.apollographql.apollo3.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo3.api.internal.Action;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.Optional;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.exception.ApolloCanceledException;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.exception.ApolloParseException;
import com.apollographql.apollo3.fetcher.ApolloResponseFetchers;
import com.apollographql.apollo3.fetcher.ResponseFetcher;
import com.apollographql.apollo3.interceptor.ApolloAutoPersistedOperationInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.interceptor.ApolloInterceptorFactory;
import com.apollographql.apollo3.internal.ApolloCallTracker;
import com.apollographql.apollo3.internal.CallState;
import com.apollographql.apollo3.internal.QueryReFetcher;
import com.apollographql.apollo3.internal.RealApolloCall$WhenMappings;
import com.apollographql.apollo3.internal.RealApolloQueryWatcher;
import com.apollographql.apollo3.internal.interceptor.ApolloCacheInterceptor;
import com.apollographql.apollo3.internal.interceptor.ApolloParseInterceptor;
import com.apollographql.apollo3.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo3.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo3.request.RequestHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0083\u0001*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0004\u0082\u0001\u0083\u0001B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010n\u001a\u00020o2\u0012\u0010p\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000B0=H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010q\u001a\u00020oH\u0016J\u000e\u0010r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0018\u0010s\u001a\u00020o2\u000e\u0010t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010BH\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010u\u001a\u00020vH\u0002J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0016J\u0014\u0010w\u001a\u0002002\n\u00108\u001a\u0006\u0012\u0002\b\u000309H\u0002J/\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u001a\u0010x\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030K0y\"\u0006\u0012\u0002\b\u00030KH\u0016\u00a2\u0006\u0002\u0010zJ'\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0012\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020N0y\"\u00020NH\u0016\u00a2\u0006\u0002\u0010|J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010P\u001a\u00020QH\u0016J\u0012\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000B0=J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010}\u001a\u00020YH\u0016J\u0012\u0010~\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000B0=J\u000e\u0010\u007f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0010\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u0081\u0001H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\"R\u0013\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0017\u00108\u001a\b\u0012\u0004\u0012\u00028\u000009\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u001f\u0010@\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010B0A\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\"\u0010E\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010?\"\u0004\bH\u0010IR\u001b\u0010J\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030K0\r\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u0010R\u0017\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\r\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u0010R\u0011\u0010P\u001a\u00020Q\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0011\u0010T\u001a\u00020U\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u0013\u0010X\u001a\u0004\u0018\u00010Y\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u0013\u0010\\\u001a\u0004\u0018\u00010]\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R\u001f\u0010`\u001a\u0010\u0012\f\u0012\n b*\u0004\u0018\u00010a0a0A\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010DR\u0013\u0010d\u001a\u0004\u0018\u00010e\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010gR\u0011\u0010h\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\"R\u0011\u0010j\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\"R\u0011\u0010l\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010\"\u00a8\u0006\u0084\u0001"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloCall;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/ApolloQueryCall;", "Lcom/apollographql/apollo3/ApolloMutationCall;", "builder", "Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;", "(Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;)V", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "applicationInterceptorFactories", "", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "getApplicationInterceptorFactories", "()Ljava/util/List;", "applicationInterceptors", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "getApplicationInterceptors", "autoPersistedOperationsInterceptorFactory", "getAutoPersistedOperationsInterceptorFactory", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "getCacheHeaders", "()Lcom/apollographql/apollo3/cache/CacheHeaders;", "dispatcher", "Ljava/util/concurrent/Executor;", "getDispatcher", "()Ljava/util/concurrent/Executor;", "enableAutoPersistedQueries", "", "getEnableAutoPersistedQueries", "()Z", "httpCache", "Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "getHttpCache", "()Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "httpCachePolicy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "getHttpCachePolicy", "()Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "httpCallFactory", "Lokhttp3/Call$Factory;", "getHttpCallFactory", "()Lokhttp3/Call$Factory;", "interceptorChain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "getInterceptorChain", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "isCanceled", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "getOperation", "()Lcom/apollographql/apollo3/api/Operation;", "optimisticUpdates", "Lcom/apollographql/apollo3/api/internal/Optional;", "getOptimisticUpdates", "()Lcom/apollographql/apollo3/api/internal/Optional;", "originalCallback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/ApolloCall$Callback;", "getOriginalCallback", "()Ljava/util/concurrent/atomic/AtomicReference;", "queryReFetcher", "Lcom/apollographql/apollo3/internal/QueryReFetcher;", "getQueryReFetcher", "setQueryReFetcher", "(Lcom/apollographql/apollo3/api/internal/Optional;)V", "refetchQueries", "Lcom/apollographql/apollo3/api/Query;", "getRefetchQueries", "refetchQueryNames", "", "getRefetchQueryNames", "requestHeaders", "Lcom/apollographql/apollo3/request/RequestHeaders;", "getRequestHeaders", "()Lcom/apollographql/apollo3/request/RequestHeaders;", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "getResponseAdapterCache", "()Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "responseFetcher", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "getResponseFetcher", "()Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "serverUrl", "Lokhttp3/HttpUrl;", "getServerUrl", "()Lokhttp3/HttpUrl;", "state", "Lcom/apollographql/apollo3/internal/CallState;", "kotlin.jvm.PlatformType", "getState", "tracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "getTracker", "()Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "useHttpGetMethodForPersistedQueries", "getUseHttpGetMethodForPersistedQueries", "useHttpGetMethodForQueries", "getUseHttpGetMethodForQueries", "writeToCacheAsynchronously", "getWriteToCacheAsynchronously", "activate", "", "callback", "cancel", "clone", "enqueue", "responseCallback", "interceptorCallbackProxy", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "prepareInterceptorChain", "queries", "", "([Lcom/apollographql/apollo3/api/Query;)Lcom/apollographql/apollo3/ApolloMutationCall;", "operationNames", "([Ljava/lang/String;)Lcom/apollographql/apollo3/ApolloMutationCall;", "fetcher", "terminate", "toBuilder", "watcher", "Lcom/apollographql/apollo3/internal/RealApolloQueryWatcher;", "Builder", "Companion", "apollo-runtime"})
public final class RealApolloCall<D extends Operation.Data>
implements ApolloQueryCall<D>,
ApolloMutationCall<D> {
    @NotNull
    private final Operation<D> operation;
    @Nullable
    private final HttpUrl serverUrl;
    @Nullable
    private final Call.Factory httpCallFactory;
    @Nullable
    private final HttpCache httpCache;
    @Nullable
    private final HttpCachePolicy.Policy httpCachePolicy;
    @NotNull
    private final ResponseAdapterCache responseAdapterCache;
    @Nullable
    private final ApolloStore apolloStore;
    @Nullable
    private final CacheHeaders cacheHeaders;
    @NotNull
    private final RequestHeaders requestHeaders;
    @Nullable
    private final ResponseFetcher responseFetcher;
    @NotNull
    private final ApolloInterceptorChain interceptorChain;
    @Nullable
    private final Executor dispatcher;
    @Nullable
    private final ApolloLogger logger;
    @Nullable
    private final ApolloCallTracker tracker;
    @Nullable
    private final List<ApolloInterceptor> applicationInterceptors;
    @Nullable
    private final List<ApolloInterceptorFactory> applicationInterceptorFactories;
    @Nullable
    private final ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
    @NotNull
    private final List<String> refetchQueryNames;
    @NotNull
    private final List<Query<?>> refetchQueries;
    @Nullable
    private Optional<QueryReFetcher> queryReFetcher;
    private final boolean enableAutoPersistedQueries;
    @NotNull
    private final AtomicReference<CallState> state;
    @NotNull
    private final AtomicReference<ApolloCall.Callback<D>> originalCallback;
    @NotNull
    private final Optional<Operation.Data> optimisticUpdates;
    private final boolean useHttpGetMethodForQueries;
    private final boolean useHttpGetMethodForPersistedQueries;
    private final boolean writeToCacheAsynchronously;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Operation<D> getOperation() {
        return this.operation;
    }

    @Nullable
    public final HttpUrl getServerUrl() {
        return this.serverUrl;
    }

    @Nullable
    public final Call.Factory getHttpCallFactory() {
        return this.httpCallFactory;
    }

    @Nullable
    public final HttpCache getHttpCache() {
        return this.httpCache;
    }

    @Nullable
    public final HttpCachePolicy.Policy getHttpCachePolicy() {
        return this.httpCachePolicy;
    }

    @NotNull
    public final ResponseAdapterCache getResponseAdapterCache() {
        return this.responseAdapterCache;
    }

    @Nullable
    public final ApolloStore getApolloStore() {
        return this.apolloStore;
    }

    @Nullable
    public final CacheHeaders getCacheHeaders() {
        return this.cacheHeaders;
    }

    @NotNull
    public final RequestHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    @Nullable
    public final ResponseFetcher getResponseFetcher() {
        return this.responseFetcher;
    }

    @NotNull
    public final ApolloInterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Nullable
    public final Executor getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ApolloCallTracker getTracker() {
        return this.tracker;
    }

    @Nullable
    public final List<ApolloInterceptor> getApplicationInterceptors() {
        return this.applicationInterceptors;
    }

    @Nullable
    public final List<ApolloInterceptorFactory> getApplicationInterceptorFactories() {
        return this.applicationInterceptorFactories;
    }

    @Nullable
    public final ApolloInterceptorFactory getAutoPersistedOperationsInterceptorFactory() {
        return this.autoPersistedOperationsInterceptorFactory;
    }

    @NotNull
    public final List<String> getRefetchQueryNames() {
        return this.refetchQueryNames;
    }

    @NotNull
    public final List<Query<?>> getRefetchQueries() {
        return this.refetchQueries;
    }

    @Nullable
    public final Optional<QueryReFetcher> getQueryReFetcher() {
        return this.queryReFetcher;
    }

    public final void setQueryReFetcher(@Nullable Optional<QueryReFetcher> optional) {
        this.queryReFetcher = optional;
    }

    public final boolean getEnableAutoPersistedQueries() {
        return this.enableAutoPersistedQueries;
    }

    @NotNull
    public final AtomicReference<CallState> getState() {
        return this.state;
    }

    @NotNull
    public final AtomicReference<ApolloCall.Callback<D>> getOriginalCallback() {
        return this.originalCallback;
    }

    @NotNull
    public final Optional<Operation.Data> getOptimisticUpdates() {
        return this.optimisticUpdates;
    }

    public final boolean getUseHttpGetMethodForQueries() {
        return this.useHttpGetMethodForQueries;
    }

    public final boolean getUseHttpGetMethodForPersistedQueries() {
        return this.useHttpGetMethodForPersistedQueries;
    }

    public final boolean getWriteToCacheAsynchronously() {
        return this.writeToCacheAsynchronously;
    }

    @Override
    public void enqueue(@Nullable ApolloCall.Callback<D> responseCallback) {
        try {
            this.activate(Optional.Companion.fromNullable(responseCallback));
        }
        catch (ApolloCanceledException e) {
            if (responseCallback != null) {
                responseCallback.onCanceledError(e);
            } else {
                ApolloLogger apolloLogger = this.logger;
                Intrinsics.checkNotNull((Object)apolloLogger);
                apolloLogger.e((Throwable)e, "Operation: %s was canceled", new Object[]{this.operation().name()});
            }
            return;
        }
        ApolloInterceptor.InterceptorRequest.Builder builder = ApolloInterceptor.InterceptorRequest.Companion.builder(this.operation);
        CacheHeaders cacheHeaders = this.cacheHeaders;
        Intrinsics.checkNotNull((Object)cacheHeaders);
        ApolloInterceptor.InterceptorRequest request = builder.cacheHeaders(cacheHeaders).requestHeaders(this.requestHeaders).fetchFromCache(false).optimisticUpdates(this.optimisticUpdates).writeToCacheAsynchronously(this.writeToCacheAsynchronously).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).build();
        Executor executor = this.dispatcher;
        Intrinsics.checkNotNull((Object)executor);
        this.interceptorChain.proceedAsync(request, executor, this.interceptorCallbackProxy());
    }

    @Override
    @NotNull
    public RealApolloQueryWatcher<D> watcher() {
        ApolloCall apolloCall = this.clone();
        ApolloStore apolloStore = this.apolloStore;
        Intrinsics.checkNotNull((Object)apolloStore);
        ResponseAdapterCache responseAdapterCache = this.responseAdapterCache;
        Intrinsics.checkNotNull((Object)responseAdapterCache);
        ApolloLogger apolloLogger = this.logger;
        Intrinsics.checkNotNull((Object)apolloLogger);
        ApolloCallTracker apolloCallTracker = this.tracker;
        Intrinsics.checkNotNull((Object)apolloCallTracker);
        return new RealApolloQueryWatcher(apolloCall, apolloStore, responseAdapterCache, apolloLogger, apolloCallTracker, ApolloResponseFetchers.CACHE_FIRST);
    }

    @Override
    @NotNull
    public RealApolloCall<D> httpCachePolicy(@NotNull HttpCachePolicy.Policy httpCachePolicy) {
        Intrinsics.checkNotNullParameter((Object)httpCachePolicy, (String)"httpCachePolicy");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).httpCachePolicy(httpCachePolicy)).build();
    }

    @Override
    @NotNull
    public RealApolloCall<D> responseFetcher(@NotNull ResponseFetcher fetcher) {
        Intrinsics.checkNotNullParameter((Object)fetcher, (String)"fetcher");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).responseFetcher(fetcher)).build();
    }

    @Override
    @NotNull
    public RealApolloCall<D> cacheHeaders(@NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).cacheHeaders(cacheHeaders)).build();
    }

    @Override
    @NotNull
    public RealApolloCall<D> requestHeaders(@NotNull RequestHeaders requestHeaders) {
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).requestHeaders(requestHeaders)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void cancel() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloCall$WhenMappings.$EnumSwitchMapping$0[callState.ordinal()]) {
            case 1: {
                this.state.set(CallState.CANCELED);
                try {
                    this.interceptorChain.dispose();
                    Optional<QueryReFetcher> optional = this.queryReFetcher;
                    Intrinsics.checkNotNull(optional);
                    if (!optional.isPresent()) return;
                    Optional<QueryReFetcher> optional2 = this.queryReFetcher;
                    Intrinsics.checkNotNull(optional2);
                    optional2.get().cancel();
                    return;
                }
                finally {
                    ApolloCallTracker apolloCallTracker = this.tracker;
                    Intrinsics.checkNotNull((Object)apolloCallTracker);
                    apolloCallTracker.unregisterCall(this);
                    this.originalCallback.set(null);
                }
            }
            case 2: {
                this.state.set(CallState.CANCELED);
                return;
            }
            case 3: 
            case 4: {
                return;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public RealApolloCall<D> clone() {
        return ((Builder)this.toBuilder()).build();
    }

    @Override
    @NotNull
    public ApolloMutationCall<D> refetchQueries(String ... operationNames) {
        Intrinsics.checkNotNullParameter((Object)operationNames, (String)"operationNames");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (ApolloMutationCall)((Builder)((Builder)this.toBuilder()).refetchQueryNames(ArraysKt.toList((Object[])operationNames))).build();
    }

    @Override
    @NotNull
    public ApolloMutationCall<D> refetchQueries(Query<?> ... queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (ApolloMutationCall)((Builder)((Builder)this.toBuilder()).refetchQueries(ArraysKt.toList((Object[])queries))).build();
    }

    @Override
    @NotNull
    public Operation<D> operation() {
        return this.operation;
    }

    private final ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(this){
            final /* synthetic */ RealApolloCall this$0;

            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Optional<ApolloCall.Callback<D>> callback = this.this$0.responseCallback();
                if (!callback.isPresent()) {
                    ApolloLogger apolloLogger = this.this$0.getLogger();
                    Intrinsics.checkNotNull((Object)apolloLogger);
                    apolloLogger.d("onResponse for operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                ApolloResponse<?> apolloResponse = response.parsedResponse.get();
                if (apolloResponse == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.ApolloResponse<D>");
                }
                callback.get().onResponse(apolloResponse);
            }

            public void onFailure(@NotNull ApolloException e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Optional<ApolloCall.Callback<D>> callback = this.this$0.terminate();
                if (!callback.isPresent()) {
                    ApolloLogger apolloLogger = this.this$0.getLogger();
                    Intrinsics.checkNotNull((Object)apolloLogger);
                    apolloLogger.d((Throwable)e, "onFailure for operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.get().onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    callback.get().onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.get().onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.get().onFailure(e);
                }
            }

            public void onCompleted() {
                Optional<ApolloCall.Callback<D>> callback = this.this$0.terminate();
                Optional<QueryReFetcher> optional = this.this$0.getQueryReFetcher();
                Intrinsics.checkNotNull(optional);
                if (optional.isPresent()) {
                    Optional<QueryReFetcher> optional2 = this.this$0.getQueryReFetcher();
                    Intrinsics.checkNotNull(optional2);
                    optional2.get().refetch();
                }
                if (!callback.isPresent()) {
                    ApolloLogger apolloLogger = this.this$0.getLogger();
                    Intrinsics.checkNotNull((Object)apolloLogger);
                    apolloLogger.d("onCompleted for operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                callback.get().onStatusEvent(ApolloCall.StatusEvent.COMPLETED);
            }

            public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                this.this$0.responseCallback().apply(new Action<ApolloCall.Callback<D>>(sourceType){
                    final /* synthetic */ ApolloInterceptor.FetchSourceType $sourceType;

                    public void apply(@NotNull ApolloCall.Callback<D> t) {
                        Intrinsics.checkNotNullParameter(t, (String)"t");
                        switch (RealApolloCall$WhenMappings.$EnumSwitchMapping$1[this.$sourceType.ordinal()]) {
                            case 1: {
                                t.onStatusEvent(ApolloCall.StatusEvent.FETCH_CACHE);
                                break;
                            }
                            case 2: {
                                t.onStatusEvent(ApolloCall.StatusEvent.FETCH_NETWORK);
                                break;
                            }
                        }
                    }
                    {
                        this.$sourceType = $captured_local_variable$0;
                    }
                });
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Override
    @NotNull
    public Builder<D> toBuilder() {
        Builder builder = Companion.builder().operation(this.operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache);
        HttpCachePolicy.Policy policy = this.httpCachePolicy;
        Intrinsics.checkNotNull((Object)policy);
        Builder builder2 = ((Builder)builder.httpCachePolicy(policy)).scalarTypeAdapters(this.responseAdapterCache).apolloStore(this.apolloStore);
        CacheHeaders cacheHeaders = this.cacheHeaders;
        Intrinsics.checkNotNull((Object)cacheHeaders);
        ApolloQueryCall.Builder builder3 = ((Builder)builder2.cacheHeaders(cacheHeaders)).requestHeaders(this.requestHeaders);
        ResponseFetcher responseFetcher = this.responseFetcher;
        Intrinsics.checkNotNull((Object)responseFetcher);
        return ((Builder)((Builder)((Builder)((Builder)builder3).responseFetcher(responseFetcher)).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).applicationInterceptorFactories(this.applicationInterceptorFactories).autoPersistedOperationsInterceptorFactory(this.autoPersistedOperationsInterceptorFactory).tracker(this.tracker).refetchQueryNames((List)this.refetchQueryNames)).refetchQueries(this.refetchQueries)).enableAutoPersistedQueries(this.enableAutoPersistedQueries).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).useHttpGetMethodForPersistedQueries(this.useHttpGetMethodForPersistedQueries).optimisticUpdates(this.optimisticUpdates).writeToCacheAsynchronously(this.writeToCacheAsynchronously);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void activate(Optional<ApolloCall.Callback<D>> callback) {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloCall$WhenMappings.$EnumSwitchMapping$2[callState.ordinal()]) {
            case 1: {
                this.originalCallback.set(callback.orNull());
                ApolloCallTracker apolloCallTracker = this.tracker;
                Intrinsics.checkNotNull((Object)apolloCallTracker);
                apolloCallTracker.registerCall(this);
                callback.apply(new Action<ApolloCall.Callback<D>>(){

                    public void apply(@NotNull ApolloCall.Callback<D> t) {
                        Intrinsics.checkNotNullParameter(t, (String)"t");
                        t.onStatusEvent(ApolloCall.StatusEvent.SCHEDULED);
                    }
                });
                break;
            }
            case 2: {
                throw (Throwable)new ApolloCanceledException(null, null, 3, null);
            }
            case 3: 
            case 4: {
                throw (Throwable)new IllegalStateException("Already Executed");
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final synchronized Optional<ApolloCall.Callback<D>> responseCallback() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloCall$WhenMappings.$EnumSwitchMapping$3[callState.ordinal()]) {
            case 1: 
            case 2: {
                return Optional.Companion.fromNullable(this.originalCallback.get());
            }
            case 3: 
            case 4: {
                CallState callState2 = this.state.get();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)callState2), (String)"state.get()");
                throw (Throwable)new IllegalStateException(CallState.IllegalStateMessage.Companion.forCurrentState(callState2).expected(CallState.ACTIVE, CallState.CANCELED));
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final synchronized Optional<ApolloCall.Callback<D>> terminate() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloCall$WhenMappings.$EnumSwitchMapping$4[callState.ordinal()]) {
            case 1: {
                ApolloCallTracker apolloCallTracker = this.tracker;
                Intrinsics.checkNotNull((Object)apolloCallTracker);
                apolloCallTracker.unregisterCall(this);
                this.state.set(CallState.TERMINATED);
                Optional<Object> optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                return optional;
            }
            case 2: {
                Optional<Object> optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                return optional;
            }
            case 3: 
            case 4: {
                CallState callState2 = this.state.get();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)callState2), (String)"state.get()");
                throw (Throwable)new IllegalStateException(CallState.IllegalStateMessage.Companion.forCurrentState(callState2).expected(CallState.ACTIVE, CallState.CANCELED));
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    private final ApolloInterceptorChain prepareInterceptorChain(Operation<?> operation) {
        HttpCachePolicy.Policy httpCachePolicy = operation instanceof Query ? this.httpCachePolicy : null;
        List interceptors = new ArrayList();
        List<ApolloInterceptorFactory> list = this.applicationInterceptorFactories;
        Intrinsics.checkNotNull(list);
        for (ApolloInterceptorFactory factory : list) {
            ApolloLogger apolloLogger = this.logger;
            Intrinsics.checkNotNull((Object)apolloLogger);
            ApolloInterceptor interceptor = factory.newInterceptor(apolloLogger, operation);
            if (interceptor == null) continue;
            interceptors.add(interceptor);
        }
        List<ApolloInterceptor> list2 = this.applicationInterceptors;
        Intrinsics.checkNotNull(list2);
        interceptors.addAll((Collection)list2);
        ResponseFetcher responseFetcher = this.responseFetcher;
        Intrinsics.checkNotNull((Object)responseFetcher);
        interceptors.add(responseFetcher.provideInterceptor(this.logger));
        ApolloStore apolloStore = this.apolloStore;
        Intrinsics.checkNotNull((Object)apolloStore);
        Executor executor = this.dispatcher;
        Intrinsics.checkNotNull((Object)executor);
        ApolloLogger apolloLogger = this.logger;
        Intrinsics.checkNotNull((Object)apolloLogger);
        interceptors.add(new ApolloCacheInterceptor<D>(apolloStore, executor, apolloLogger, this.originalCallback, this.responseAdapterCache));
        if (this.autoPersistedOperationsInterceptorFactory != null) {
            ApolloInterceptor interceptor = this.autoPersistedOperationsInterceptorFactory.newInterceptor(this.logger, operation);
            if (interceptor != null) {
                interceptors.add(interceptor);
            }
        } else if (this.enableAutoPersistedQueries && (operation instanceof Query || operation instanceof Mutation)) {
            interceptors.add(new ApolloAutoPersistedOperationInterceptor(this.logger, this.useHttpGetMethodForPersistedQueries && !(operation instanceof Mutation)));
        }
        interceptors.add(new ApolloParseInterceptor(this.httpCache, this.responseAdapterCache, this.logger));
        HttpUrl httpUrl = this.serverUrl;
        Intrinsics.checkNotNull((Object)httpUrl);
        Call.Factory factory = this.httpCallFactory;
        Intrinsics.checkNotNull((Object)factory);
        interceptors.add(new ApolloServerInterceptor(httpUrl, factory, httpCachePolicy, false, this.responseAdapterCache, this.logger));
        return new RealApolloInterceptorChain(interceptors);
    }

    public RealApolloCall(@NotNull Builder<D> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.state = new AtomicReference<CallState>(CallState.IDLE);
        this.originalCallback = new AtomicReference();
        Operation<?> operation = builder.getOperation();
        if (operation == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.Operation<D>");
        }
        this.operation = operation;
        this.serverUrl = builder.getServerUrl();
        this.httpCallFactory = builder.getHttpCallFactory();
        this.httpCache = builder.getHttpCache();
        this.httpCachePolicy = builder.getHttpCachePolicy();
        ResponseAdapterCache responseAdapterCache = builder.getResponseAdapterCache();
        if (responseAdapterCache == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.responseAdapterCache = responseAdapterCache;
        this.apolloStore = builder.getApolloStore();
        this.responseFetcher = builder.getResponseFetcher();
        this.cacheHeaders = builder.getCacheHeaders();
        this.requestHeaders = builder.getRequestHeaders();
        this.dispatcher = builder.getDispatcher();
        this.logger = builder.getLogger();
        this.applicationInterceptors = builder.getApplicationInterceptors();
        this.applicationInterceptorFactories = builder.getApplicationInterceptorFactories();
        this.autoPersistedOperationsInterceptorFactory = builder.getAutoPersistedOperationsInterceptorFactory();
        this.refetchQueryNames = builder.getRefetchQueryNames();
        this.refetchQueries = builder.getRefetchQueries();
        this.tracker = builder.getTracker();
        this.queryReFetcher = this.refetchQueries.isEmpty() && this.refetchQueryNames.isEmpty() || builder.getApolloStore() == null ? Optional.Companion.absent() : Optional.Companion.of(QueryReFetcher.Companion.builder().queries(builder.getRefetchQueries()).queryWatchers(this.refetchQueryNames).serverUrl(builder.getServerUrl()).httpCallFactory(builder.getHttpCallFactory()).scalarTypeAdapters(builder.getResponseAdapterCache()).apolloStore(builder.getApolloStore()).dispatcher(builder.getDispatcher()).logger(builder.getLogger()).applicationInterceptors(builder.getApplicationInterceptors()).applicationInterceptorFactories(builder.getApplicationInterceptorFactories()).autoPersistedOperationsInterceptorFactory(builder.getAutoPersistedOperationsInterceptorFactory()).callTracker(builder.getTracker()).build());
        this.useHttpGetMethodForQueries = builder.getUseHttpGetMethodForQueries();
        this.enableAutoPersistedQueries = builder.getEnableAutoPersistedQueries();
        this.useHttpGetMethodForPersistedQueries = builder.getUseHttpGetMethodForPersistedQueries();
        this.optimisticUpdates = builder.getOptimisticUpdates();
        this.writeToCacheAsynchronously = builder.getWriteToCacheAsynchronously();
        this.interceptorChain = this.prepareInterceptorChain(this.operation);
    }

    @JvmStatic
    @NotNull
    public static final <D extends Operation.Data> Builder<D> builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\rJ\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u00028\u00010\u0083\u0001H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010\"\u001a\u0004\u0018\u00010#J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010(\u001a\u00020)J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010.\u001a\u0004\u0018\u00010/J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u00104\u001a\u000205H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010:\u001a\u0004\u0018\u00010;J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010@\u001a\u0004\u0018\u00010AJ\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010F\u001a\b\u0012\u0002\b\u0003\u0018\u00010GJ\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00020MJ \u0010R\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0010\u0010R\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030S0\rH\u0016J\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010V\u001a\b\u0012\u0004\u0012\u00020W0\rH\u0016J\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010Z\u001a\u00020[H\u0016J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010f\u001a\u00020gH\u0016J\u0017\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010`\u001a\u0004\u0018\u00010aJ\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010l\u001a\u0004\u0018\u00010mJ\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010r\u001a\u0004\u0018\u00010sJ\u0014\u0010x\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010x\u001a\u00020)J\u0014\u0010{\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010{\u001a\u00020)J\u0016\u0010~\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010~\u001a\u00020)H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER \u0010F\u001a\b\u0012\u0002\b\u0003\u0018\u00010GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR \u0010L\u001a\b\u0012\u0004\u0012\u00020\u00020MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR$\u0010R\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030S0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u0010\"\u0004\bU\u0010\u0012R \u0010V\u001a\b\u0012\u0004\u0012\u00020W0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\u0010\"\u0004\bY\u0010\u0012R\u001a\u0010Z\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001c\u0010`\u001a\u0004\u0018\u00010aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u001c\u0010f\u001a\u0004\u0018\u00010gX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u001c\u0010l\u001a\u0004\u0018\u00010mX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010o\"\u0004\bp\u0010qR\u001c\u0010r\u001a\u0004\u0018\u00010sX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010u\"\u0004\bv\u0010wR\u001a\u0010x\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u0010+\"\u0004\bz\u0010-R\u001a\u0010{\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010+\"\u0004\b}\u0010-R\u001b\u0010~\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000f\n\u0000\u001a\u0004\b\u007f\u0010+\"\u0005\b\u0080\u0001\u0010-\u00a8\u0006\u0085\u0001"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/ApolloQueryCall$Builder;", "Lcom/apollographql/apollo3/ApolloMutationCall$Builder;", "()V", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "setApolloStore", "(Lcom/apollographql/apollo3/cache/normalized/ApolloStore;)V", "applicationInterceptorFactories", "", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "getApplicationInterceptorFactories", "()Ljava/util/List;", "setApplicationInterceptorFactories", "(Ljava/util/List;)V", "applicationInterceptors", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "getApplicationInterceptors", "setApplicationInterceptors", "autoPersistedOperationsInterceptorFactory", "getAutoPersistedOperationsInterceptorFactory", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "setAutoPersistedOperationsInterceptorFactory", "(Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;)V", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "getCacheHeaders", "()Lcom/apollographql/apollo3/cache/CacheHeaders;", "setCacheHeaders", "(Lcom/apollographql/apollo3/cache/CacheHeaders;)V", "dispatcher", "Ljava/util/concurrent/Executor;", "getDispatcher", "()Ljava/util/concurrent/Executor;", "setDispatcher", "(Ljava/util/concurrent/Executor;)V", "enableAutoPersistedQueries", "", "getEnableAutoPersistedQueries", "()Z", "setEnableAutoPersistedQueries", "(Z)V", "httpCache", "Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "getHttpCache", "()Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "setHttpCache", "(Lcom/apollographql/apollo3/api/cache/http/HttpCache;)V", "httpCachePolicy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "getHttpCachePolicy", "()Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "setHttpCachePolicy", "(Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;)V", "httpCallFactory", "Lokhttp3/Call$Factory;", "getHttpCallFactory", "()Lokhttp3/Call$Factory;", "setHttpCallFactory", "(Lokhttp3/Call$Factory;)V", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "setLogger", "(Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "operation", "Lcom/apollographql/apollo3/api/Operation;", "getOperation", "()Lcom/apollographql/apollo3/api/Operation;", "setOperation", "(Lcom/apollographql/apollo3/api/Operation;)V", "optimisticUpdates", "Lcom/apollographql/apollo3/api/internal/Optional;", "getOptimisticUpdates", "()Lcom/apollographql/apollo3/api/internal/Optional;", "setOptimisticUpdates", "(Lcom/apollographql/apollo3/api/internal/Optional;)V", "refetchQueries", "Lcom/apollographql/apollo3/api/Query;", "getRefetchQueries", "setRefetchQueries", "refetchQueryNames", "", "getRefetchQueryNames", "setRefetchQueryNames", "requestHeaders", "Lcom/apollographql/apollo3/request/RequestHeaders;", "getRequestHeaders", "()Lcom/apollographql/apollo3/request/RequestHeaders;", "setRequestHeaders", "(Lcom/apollographql/apollo3/request/RequestHeaders;)V", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "getResponseAdapterCache", "()Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "setResponseAdapterCache", "(Lcom/apollographql/apollo3/api/ResponseAdapterCache;)V", "responseFetcher", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "getResponseFetcher", "()Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "setResponseFetcher", "(Lcom/apollographql/apollo3/fetcher/ResponseFetcher;)V", "serverUrl", "Lokhttp3/HttpUrl;", "getServerUrl", "()Lokhttp3/HttpUrl;", "setServerUrl", "(Lokhttp3/HttpUrl;)V", "tracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "getTracker", "()Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "setTracker", "(Lcom/apollographql/apollo3/internal/ApolloCallTracker;)V", "useHttpGetMethodForPersistedQueries", "getUseHttpGetMethodForPersistedQueries", "setUseHttpGetMethodForPersistedQueries", "useHttpGetMethodForQueries", "getUseHttpGetMethodForQueries", "setUseHttpGetMethodForQueries", "writeToCacheAsynchronously", "getWriteToCacheAsynchronously", "setWriteToCacheAsynchronously", "interceptorFactory", "build", "Lcom/apollographql/apollo3/internal/RealApolloCall;", "scalarTypeAdapters", "apollo-runtime"})
    public static final class Builder<D extends Operation.Data>
    implements ApolloQueryCall.Builder<D>,
    ApolloMutationCall.Builder<D> {
        @Nullable
        private Operation<?> operation;
        @Nullable
        private HttpUrl serverUrl;
        @Nullable
        private Call.Factory httpCallFactory;
        @Nullable
        private HttpCache httpCache;
        @Nullable
        private HttpCachePolicy.Policy httpCachePolicy;
        @Nullable
        private ResponseAdapterCache responseAdapterCache;
        @Nullable
        private ApolloStore apolloStore;
        @Nullable
        private ResponseFetcher responseFetcher;
        @Nullable
        private CacheHeaders cacheHeaders;
        @NotNull
        private RequestHeaders requestHeaders = RequestHeaders.Companion.getNONE();
        @Nullable
        private Executor dispatcher;
        @Nullable
        private ApolloLogger logger;
        @Nullable
        private List<? extends ApolloInterceptor> applicationInterceptors;
        @Nullable
        private List<? extends ApolloInterceptorFactory> applicationInterceptorFactories;
        @Nullable
        private ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
        @NotNull
        private List<String> refetchQueryNames = CollectionsKt.emptyList();
        @NotNull
        private List<? extends Query<?>> refetchQueries = CollectionsKt.emptyList();
        @Nullable
        private ApolloCallTracker tracker;
        private boolean enableAutoPersistedQueries;
        @NotNull
        private Optional<Operation.Data> optimisticUpdates = Optional.Companion.absent();
        private boolean useHttpGetMethodForQueries;
        private boolean useHttpGetMethodForPersistedQueries;
        private boolean writeToCacheAsynchronously;

        @Nullable
        public final Operation<?> getOperation() {
            return this.operation;
        }

        public final void setOperation(@Nullable Operation<?> operation) {
            this.operation = operation;
        }

        @Nullable
        public final HttpUrl getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(@Nullable HttpUrl httpUrl) {
            this.serverUrl = httpUrl;
        }

        @Nullable
        public final Call.Factory getHttpCallFactory() {
            return this.httpCallFactory;
        }

        public final void setHttpCallFactory(@Nullable Call.Factory factory) {
            this.httpCallFactory = factory;
        }

        @Nullable
        public final HttpCache getHttpCache() {
            return this.httpCache;
        }

        public final void setHttpCache(@Nullable HttpCache httpCache) {
            this.httpCache = httpCache;
        }

        @Nullable
        public final HttpCachePolicy.Policy getHttpCachePolicy() {
            return this.httpCachePolicy;
        }

        public final void setHttpCachePolicy(@Nullable HttpCachePolicy.Policy policy) {
            this.httpCachePolicy = policy;
        }

        @Nullable
        public final ResponseAdapterCache getResponseAdapterCache() {
            return this.responseAdapterCache;
        }

        public final void setResponseAdapterCache(@Nullable ResponseAdapterCache responseAdapterCache) {
            this.responseAdapterCache = responseAdapterCache;
        }

        @Nullable
        public final ApolloStore getApolloStore() {
            return this.apolloStore;
        }

        public final void setApolloStore(@Nullable ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
        }

        @Nullable
        public final ResponseFetcher getResponseFetcher() {
            return this.responseFetcher;
        }

        public final void setResponseFetcher(@Nullable ResponseFetcher responseFetcher) {
            this.responseFetcher = responseFetcher;
        }

        @Nullable
        public final CacheHeaders getCacheHeaders() {
            return this.cacheHeaders;
        }

        public final void setCacheHeaders(@Nullable CacheHeaders cacheHeaders) {
            this.cacheHeaders = cacheHeaders;
        }

        @NotNull
        public final RequestHeaders getRequestHeaders() {
            return this.requestHeaders;
        }

        public final void setRequestHeaders(@NotNull RequestHeaders requestHeaders) {
            Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"<set-?>");
            this.requestHeaders = requestHeaders;
        }

        @Nullable
        public final Executor getDispatcher() {
            return this.dispatcher;
        }

        public final void setDispatcher(@Nullable Executor executor) {
            this.dispatcher = executor;
        }

        @Nullable
        public final ApolloLogger getLogger() {
            return this.logger;
        }

        public final void setLogger(@Nullable ApolloLogger apolloLogger) {
            this.logger = apolloLogger;
        }

        @Nullable
        public final List<ApolloInterceptor> getApplicationInterceptors() {
            return this.applicationInterceptors;
        }

        public final void setApplicationInterceptors(@Nullable List<? extends ApolloInterceptor> list) {
            this.applicationInterceptors = list;
        }

        @Nullable
        public final List<ApolloInterceptorFactory> getApplicationInterceptorFactories() {
            return this.applicationInterceptorFactories;
        }

        public final void setApplicationInterceptorFactories(@Nullable List<? extends ApolloInterceptorFactory> list) {
            this.applicationInterceptorFactories = list;
        }

        @Nullable
        public final ApolloInterceptorFactory getAutoPersistedOperationsInterceptorFactory() {
            return this.autoPersistedOperationsInterceptorFactory;
        }

        public final void setAutoPersistedOperationsInterceptorFactory(@Nullable ApolloInterceptorFactory apolloInterceptorFactory) {
            this.autoPersistedOperationsInterceptorFactory = apolloInterceptorFactory;
        }

        @NotNull
        public final List<String> getRefetchQueryNames() {
            return this.refetchQueryNames;
        }

        public final void setRefetchQueryNames(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.refetchQueryNames = list;
        }

        @NotNull
        public final List<Query<?>> getRefetchQueries() {
            return this.refetchQueries;
        }

        public final void setRefetchQueries(@NotNull List<? extends Query<?>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.refetchQueries = list;
        }

        @Nullable
        public final ApolloCallTracker getTracker() {
            return this.tracker;
        }

        public final void setTracker(@Nullable ApolloCallTracker apolloCallTracker) {
            this.tracker = apolloCallTracker;
        }

        public final boolean getEnableAutoPersistedQueries() {
            return this.enableAutoPersistedQueries;
        }

        public final void setEnableAutoPersistedQueries(boolean bl) {
            this.enableAutoPersistedQueries = bl;
        }

        @NotNull
        public final Optional<Operation.Data> getOptimisticUpdates() {
            return this.optimisticUpdates;
        }

        public final void setOptimisticUpdates(@NotNull Optional<Operation.Data> optional) {
            Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
            this.optimisticUpdates = optional;
        }

        public final boolean getUseHttpGetMethodForQueries() {
            return this.useHttpGetMethodForQueries;
        }

        public final void setUseHttpGetMethodForQueries(boolean bl) {
            this.useHttpGetMethodForQueries = bl;
        }

        public final boolean getUseHttpGetMethodForPersistedQueries() {
            return this.useHttpGetMethodForPersistedQueries;
        }

        public final void setUseHttpGetMethodForPersistedQueries(boolean bl) {
            this.useHttpGetMethodForPersistedQueries = bl;
        }

        public final boolean getWriteToCacheAsynchronously() {
            return this.writeToCacheAsynchronously;
        }

        public final void setWriteToCacheAsynchronously(boolean bl) {
            this.writeToCacheAsynchronously = bl;
        }

        @NotNull
        public final Builder<D> operation(@Nullable Operation<?> operation) {
            this.operation = operation;
            return this;
        }

        @NotNull
        public final Builder<D> serverUrl(@Nullable HttpUrl serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @NotNull
        public final Builder<D> httpCallFactory(@Nullable Call.Factory httpCallFactory) {
            this.httpCallFactory = httpCallFactory;
            return this;
        }

        @NotNull
        public final Builder<D> httpCache(@Nullable HttpCache httpCache) {
            this.httpCache = httpCache;
            return this;
        }

        @NotNull
        public final Builder<D> scalarTypeAdapters(@Nullable ResponseAdapterCache responseAdapterCache) {
            this.responseAdapterCache = responseAdapterCache;
            return this;
        }

        @NotNull
        public final Builder<D> apolloStore(@Nullable ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> cacheHeaders(@NotNull CacheHeaders cacheHeaders) {
            Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
            this.cacheHeaders = cacheHeaders;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> httpCachePolicy(@NotNull HttpCachePolicy.Policy httpCachePolicy) {
            Intrinsics.checkNotNullParameter((Object)httpCachePolicy, (String)"httpCachePolicy");
            this.httpCachePolicy = httpCachePolicy;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> responseFetcher(@NotNull ResponseFetcher responseFetcher) {
            Intrinsics.checkNotNullParameter((Object)responseFetcher, (String)"responseFetcher");
            this.responseFetcher = responseFetcher;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> requestHeaders(@NotNull RequestHeaders requestHeaders) {
            Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
            this.requestHeaders = requestHeaders;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> refetchQueryNames(@NotNull List<String> refetchQueryNames) {
            Intrinsics.checkNotNullParameter(refetchQueryNames, (String)"refetchQueryNames");
            this.refetchQueryNames = new ArrayList(refetchQueryNames);
            return this;
        }

        @Override
        @NotNull
        public Builder<D> refetchQueries(@NotNull List<? extends Query<?>> refetchQueries2) {
            Intrinsics.checkNotNullParameter(refetchQueries2, (String)"refetchQueries");
            this.refetchQueries = new ArrayList(refetchQueries2);
            return this;
        }

        @Override
        @NotNull
        public Builder<D> writeToCacheAsynchronously(boolean writeToCacheAsynchronously) {
            this.writeToCacheAsynchronously = writeToCacheAsynchronously;
            return this;
        }

        @NotNull
        public final Builder<D> dispatcher(@Nullable Executor dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        @NotNull
        public final Builder<D> logger(@Nullable ApolloLogger logger) {
            this.logger = logger;
            return this;
        }

        @NotNull
        public final Builder<D> tracker(@Nullable ApolloCallTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        @NotNull
        public final Builder<D> applicationInterceptors(@Nullable List<? extends ApolloInterceptor> applicationInterceptors) {
            this.applicationInterceptors = applicationInterceptors;
            return this;
        }

        @NotNull
        public final Builder<D> applicationInterceptorFactories(@Nullable List<? extends ApolloInterceptorFactory> applicationInterceptorFactories) {
            this.applicationInterceptorFactories = applicationInterceptorFactories;
            return this;
        }

        @NotNull
        public final Builder<D> autoPersistedOperationsInterceptorFactory(@Nullable ApolloInterceptorFactory interceptorFactory) {
            this.autoPersistedOperationsInterceptorFactory = interceptorFactory;
            return this;
        }

        @NotNull
        public final Builder<D> enableAutoPersistedQueries(boolean enableAutoPersistedQueries) {
            this.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return this;
        }

        @NotNull
        public final Builder<D> optimisticUpdates(@NotNull Optional<Operation.Data> optimisticUpdates) {
            Intrinsics.checkNotNullParameter(optimisticUpdates, (String)"optimisticUpdates");
            this.optimisticUpdates = optimisticUpdates;
            return this;
        }

        @NotNull
        public final Builder<D> useHttpGetMethodForQueries(boolean useHttpGetMethodForQueries) {
            this.useHttpGetMethodForQueries = useHttpGetMethodForQueries;
            return this;
        }

        @NotNull
        public final Builder<D> useHttpGetMethodForPersistedQueries(boolean useHttpGetMethodForPersistedQueries) {
            this.useHttpGetMethodForPersistedQueries = useHttpGetMethodForPersistedQueries;
            return this;
        }

        @Override
        @NotNull
        public RealApolloCall<D> build() {
            return new RealApolloCall(this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloCall$Companion;", "", "()V", "builder", "Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apollo-runtime"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <D extends Operation.Data> Builder<D> builder() {
            return new Builder();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

