/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloQueryWatcher;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.fetcher.ApolloResponseFetchers;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorFactory;
import com.apollographql.apollo3.internal.ApolloCallTracker;
import com.apollographql.apollo3.internal.RealApolloCall;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0003\u001f !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/apollographql/apollo3/internal/QueryReFetcher;", "", "builder", "Lcom/apollographql/apollo3/internal/QueryReFetcher$Builder;", "(Lcom/apollographql/apollo3/internal/QueryReFetcher$Builder;)V", "callTracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "calls", "", "Lcom/apollographql/apollo3/internal/RealApolloCall;", "Lcom/apollographql/apollo3/api/Operation$Data;", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "onCompleteCallback", "Lcom/apollographql/apollo3/internal/QueryReFetcher$OnCompleteCallback;", "getOnCompleteCallback", "()Lcom/apollographql/apollo3/internal/QueryReFetcher$OnCompleteCallback;", "setOnCompleteCallback", "(Lcom/apollographql/apollo3/internal/QueryReFetcher$OnCompleteCallback;)V", "queryWatchers", "", "", "cancel", "", "refetch", "refetchQueries", "refetchQueryWatchers", "Builder", "Companion", "OnCompleteCallback", "apollo-runtime"})
public final class QueryReFetcher {
    @Nullable
    private final ApolloLogger logger;
    private final List<RealApolloCall<Operation.Data>> calls;
    private final List<String> queryWatchers;
    private final ApolloCallTracker callTracker;
    private final AtomicBoolean executed;
    @Nullable
    private OnCompleteCallback onCompleteCallback;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final OnCompleteCallback getOnCompleteCallback() {
        return this.onCompleteCallback;
    }

    public final void setOnCompleteCallback(@Nullable OnCompleteCallback onCompleteCallback) {
        this.onCompleteCallback = onCompleteCallback;
    }

    public final void refetch() {
        boolean bl = this.executed.compareAndSet(false, true);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.refetchQueryWatchers();
        this.refetchQueries();
    }

    public final void cancel() {
        for (RealApolloCall<Operation.Data> call : this.calls) {
            call.cancel();
        }
    }

    private final void refetchQueryWatchers() {
        try {
            for (String operationName : this.queryWatchers) {
                ApolloCallTracker apolloCallTracker = this.callTracker;
                Intrinsics.checkNotNull((Object)apolloCallTracker);
                for (ApolloQueryWatcher<?> queryWatcher : apolloCallTracker.activeQueryWatchers(operationName)) {
                    queryWatcher.refetch();
                }
            }
        }
        catch (Exception e) {
            ApolloLogger apolloLogger = this.logger;
            Intrinsics.checkNotNull((Object)apolloLogger);
            apolloLogger.e((Throwable)e, "Failed to re-fetch query watcher", new Object[0]);
        }
    }

    private final void refetchQueries() {
        OnCompleteCallback completeCallback = this.onCompleteCallback;
        AtomicInteger callsLeft = new AtomicInteger(this.calls.size());
        for (RealApolloCall<Operation.Data> call : this.calls) {
            call.enqueue(new ApolloCall.Callback<Operation.Data>(this, completeCallback, callsLeft, call){
                final /* synthetic */ QueryReFetcher this$0;
                final /* synthetic */ OnCompleteCallback $completeCallback;
                final /* synthetic */ AtomicInteger $callsLeft;
                final /* synthetic */ RealApolloCall $call;

                public void onResponse(@NotNull ApolloResponse<? extends Operation.Data> response) {
                    Intrinsics.checkNotNullParameter(response, (String)"response");
                    if (this.$callsLeft.decrementAndGet() == 0 && this.$completeCallback != null) {
                        this.$completeCallback.onFetchComplete();
                    }
                }

                public void onFailure(@NotNull ApolloException e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ApolloLogger apolloLogger = this.this$0.getLogger();
                    if (apolloLogger != null) {
                        apolloLogger.e((Throwable)e, "Failed to fetch query: %s", new Object[]{this.$call.getOperation()});
                    }
                    if (this.$callsLeft.decrementAndGet() == 0 && this.$completeCallback != null) {
                        this.$completeCallback.onFetchComplete();
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$completeCallback = $captured_local_variable$1;
                    this.$callsLeft = $captured_local_variable$2;
                    this.$call = $captured_local_variable$3;
                }
            });
        }
    }

    public QueryReFetcher(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.executed = new AtomicBoolean();
        this.logger = builder.getLogger();
        this.calls = new ArrayList(builder.getQueries().size());
        for (Query<?> query : builder.getQueries()) {
            this.calls.add((RealApolloCall<Operation.Data>)((RealApolloCall.Builder)((RealApolloCall.Builder)((RealApolloCall.Builder)RealApolloCall.Companion.builder().operation((Operation)query).serverUrl(builder.getServerUrl()).httpCallFactory(builder.getHttpCallFactory()).scalarTypeAdapters(builder.getResponseAdapterCache()).apolloStore(builder.getApolloStore()).httpCachePolicy(HttpCachePolicy.NETWORK_ONLY)).responseFetcher(ApolloResponseFetchers.NETWORK_ONLY)).cacheHeaders(CacheHeaders.NONE)).logger(builder.getLogger()).applicationInterceptors(builder.getApplicationInterceptors()).applicationInterceptorFactories(builder.getApplicationInterceptorFactories()).autoPersistedOperationsInterceptorFactory(builder.getAutoPersistedOperationsInterceptorFactory()).tracker(builder.getCallTracker()).dispatcher(builder.getDispatcher()).build());
        }
        this.queryWatchers = builder.getQueryWatchers();
        this.callTracker = builder.getCallTracker();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\t\u001a\u00020\u00002\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u0016\u0010\u0010\u001a\u00020\u00002\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\nJ\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010E\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010F\u001a\u00020GJ\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010%\u001a\u00020\u00002\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010+\u001a\u00020\u00002\b\u0010+\u001a\u0004\u0018\u00010,J\u001a\u00101\u001a\u00020\u00002\u0012\u00101\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u000302\u0018\u00010\nJ\u0016\u00105\u001a\u00020\u00002\u000e\u00105\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010\nJ\u0010\u0010H\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010?\u001a\u00020\u00002\b\u0010?\u001a\u0004\u0018\u00010@R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\r\"\u0004\b4\u0010\u000fR \u00105\u001a\b\u0012\u0004\u0012\u0002060\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u000fR\u001c\u00109\u001a\u0004\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001c\u0010?\u001a\u0004\u0018\u00010@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006I"}, d2={"Lcom/apollographql/apollo3/internal/QueryReFetcher$Builder;", "", "()V", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "setApolloStore", "(Lcom/apollographql/apollo3/cache/normalized/ApolloStore;)V", "applicationInterceptorFactories", "", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "getApplicationInterceptorFactories", "()Ljava/util/List;", "setApplicationInterceptorFactories", "(Ljava/util/List;)V", "applicationInterceptors", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "getApplicationInterceptors", "setApplicationInterceptors", "autoPersistedOperationsInterceptorFactory", "getAutoPersistedOperationsInterceptorFactory", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "setAutoPersistedOperationsInterceptorFactory", "(Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;)V", "callTracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "getCallTracker", "()Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "setCallTracker", "(Lcom/apollographql/apollo3/internal/ApolloCallTracker;)V", "dispatcher", "Ljava/util/concurrent/Executor;", "getDispatcher", "()Ljava/util/concurrent/Executor;", "setDispatcher", "(Ljava/util/concurrent/Executor;)V", "httpCallFactory", "Lokhttp3/Call$Factory;", "getHttpCallFactory", "()Lokhttp3/Call$Factory;", "setHttpCallFactory", "(Lokhttp3/Call$Factory;)V", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "setLogger", "(Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "queries", "Lcom/apollographql/apollo3/api/Query;", "getQueries", "setQueries", "queryWatchers", "", "getQueryWatchers", "setQueryWatchers", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "getResponseAdapterCache", "()Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "setResponseAdapterCache", "(Lcom/apollographql/apollo3/api/ResponseAdapterCache;)V", "serverUrl", "Lokhttp3/HttpUrl;", "getServerUrl", "()Lokhttp3/HttpUrl;", "setServerUrl", "(Lokhttp3/HttpUrl;)V", "interceptorFactories", "build", "Lcom/apollographql/apollo3/internal/QueryReFetcher;", "scalarTypeAdapters", "apollo-runtime"})
    public static final class Builder {
        @NotNull
        private List<? extends Query<?>> queries = CollectionsKt.emptyList();
        @NotNull
        private List<String> queryWatchers = CollectionsKt.emptyList();
        @Nullable
        private HttpUrl serverUrl;
        @Nullable
        private Call.Factory httpCallFactory;
        @Nullable
        private ResponseAdapterCache responseAdapterCache;
        @Nullable
        private ApolloStore apolloStore;
        @Nullable
        private Executor dispatcher;
        @Nullable
        private ApolloLogger logger;
        @Nullable
        private List<? extends ApolloInterceptor> applicationInterceptors;
        @Nullable
        private List<? extends ApolloInterceptorFactory> applicationInterceptorFactories;
        @Nullable
        private ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
        @Nullable
        private ApolloCallTracker callTracker;

        @NotNull
        public final List<Query<?>> getQueries() {
            return this.queries;
        }

        public final void setQueries(@NotNull List<? extends Query<?>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.queries = list;
        }

        @NotNull
        public final List<String> getQueryWatchers() {
            return this.queryWatchers;
        }

        public final void setQueryWatchers(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.queryWatchers = list;
        }

        @Nullable
        public final HttpUrl getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(@Nullable HttpUrl httpUrl) {
            this.serverUrl = httpUrl;
        }

        @Nullable
        public final Call.Factory getHttpCallFactory() {
            return this.httpCallFactory;
        }

        public final void setHttpCallFactory(@Nullable Call.Factory factory) {
            this.httpCallFactory = factory;
        }

        @Nullable
        public final ResponseAdapterCache getResponseAdapterCache() {
            return this.responseAdapterCache;
        }

        public final void setResponseAdapterCache(@Nullable ResponseAdapterCache responseAdapterCache) {
            this.responseAdapterCache = responseAdapterCache;
        }

        @Nullable
        public final ApolloStore getApolloStore() {
            return this.apolloStore;
        }

        public final void setApolloStore(@Nullable ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
        }

        @Nullable
        public final Executor getDispatcher() {
            return this.dispatcher;
        }

        public final void setDispatcher(@Nullable Executor executor) {
            this.dispatcher = executor;
        }

        @Nullable
        public final ApolloLogger getLogger() {
            return this.logger;
        }

        public final void setLogger(@Nullable ApolloLogger apolloLogger) {
            this.logger = apolloLogger;
        }

        @Nullable
        public final List<ApolloInterceptor> getApplicationInterceptors() {
            return this.applicationInterceptors;
        }

        public final void setApplicationInterceptors(@Nullable List<? extends ApolloInterceptor> list) {
            this.applicationInterceptors = list;
        }

        @Nullable
        public final List<ApolloInterceptorFactory> getApplicationInterceptorFactories() {
            return this.applicationInterceptorFactories;
        }

        public final void setApplicationInterceptorFactories(@Nullable List<? extends ApolloInterceptorFactory> list) {
            this.applicationInterceptorFactories = list;
        }

        @Nullable
        public final ApolloInterceptorFactory getAutoPersistedOperationsInterceptorFactory() {
            return this.autoPersistedOperationsInterceptorFactory;
        }

        public final void setAutoPersistedOperationsInterceptorFactory(@Nullable ApolloInterceptorFactory apolloInterceptorFactory) {
            this.autoPersistedOperationsInterceptorFactory = apolloInterceptorFactory;
        }

        @Nullable
        public final ApolloCallTracker getCallTracker() {
            return this.callTracker;
        }

        public final void setCallTracker(@Nullable ApolloCallTracker apolloCallTracker) {
            this.callTracker = apolloCallTracker;
        }

        @NotNull
        public final Builder queries(@Nullable List<? extends Query<?>> queries) {
            List list = queries;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.queries = list;
            return this;
        }

        @NotNull
        public final Builder queryWatchers(@Nullable List<String> queryWatchers) {
            List list = queryWatchers;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.queryWatchers = list;
            return this;
        }

        @NotNull
        public final Builder serverUrl(@Nullable HttpUrl serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @NotNull
        public final Builder httpCallFactory(@Nullable Call.Factory httpCallFactory) {
            this.httpCallFactory = httpCallFactory;
            return this;
        }

        @NotNull
        public final Builder scalarTypeAdapters(@Nullable ResponseAdapterCache responseAdapterCache) {
            this.responseAdapterCache = responseAdapterCache;
            return this;
        }

        @NotNull
        public final Builder apolloStore(@Nullable ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
            return this;
        }

        @NotNull
        public final Builder dispatcher(@Nullable Executor dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        @NotNull
        public final Builder logger(@Nullable ApolloLogger logger) {
            this.logger = logger;
            return this;
        }

        @NotNull
        public final Builder applicationInterceptors(@Nullable List<? extends ApolloInterceptor> applicationInterceptors) {
            this.applicationInterceptors = applicationInterceptors;
            return this;
        }

        @NotNull
        public final Builder applicationInterceptorFactories(@Nullable List<? extends ApolloInterceptorFactory> applicationInterceptorFactories) {
            this.applicationInterceptorFactories = applicationInterceptorFactories;
            return this;
        }

        @NotNull
        public final Builder autoPersistedOperationsInterceptorFactory(@Nullable ApolloInterceptorFactory interceptorFactories) {
            this.autoPersistedOperationsInterceptorFactory = interceptorFactories;
            return this;
        }

        @NotNull
        public final Builder callTracker(@Nullable ApolloCallTracker callTracker) {
            this.callTracker = callTracker;
            return this;
        }

        @NotNull
        public final QueryReFetcher build() {
            return new QueryReFetcher(this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/apollographql/apollo3/internal/QueryReFetcher$OnCompleteCallback;", "", "onFetchComplete", "", "apollo-runtime"})
    public static interface OnCompleteCallback {
        public void onFetchComplete();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/apollographql/apollo3/internal/QueryReFetcher$Companion;", "", "()V", "builder", "Lcom/apollographql/apollo3/internal/QueryReFetcher$Builder;", "apollo-runtime"})
    public static final class Companion {
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

