/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloSubscriptionCall;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Response;
import com.apollographql.apollo3.api.Subscription;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.exception.ApolloCanceledException;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.internal.CallState;
import com.apollographql.apollo3.internal.RealApolloSubscriptionCall$WhenMappings;
import com.apollographql.apollo3.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo3.internal.subscription.SubscriptionManager;
import com.apollographql.apollo3.internal.subscription.SubscriptionResponse;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001#B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\u0010\u0010 \u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010!H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/ApolloSubscriptionCall;", "subscription", "Lcom/apollographql/apollo3/api/Subscription;", "subscriptionManager", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager;", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "cachePolicy", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$CachePolicy;", "dispatcher", "Ljava/util/concurrent/Executor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "(Lcom/apollographql/apollo3/api/Subscription;Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager;Lcom/apollographql/apollo3/cache/normalized/ApolloStore;Lcom/apollographql/apollo3/ApolloSubscriptionCall$CachePolicy;Ljava/util/concurrent/Executor;Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "isCanceled", "", "()Z", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/internal/CallState;", "kotlin.jvm.PlatformType", "subscriptionCallback", "Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall$SubscriptionManagerCallback;", "cancel", "", "clone", "execute", "callback", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;", "resolveFromCache", "Lcom/apollographql/apollo3/api/Response;", "terminate", "SubscriptionManagerCallback", "apollo-runtime"})
public final class RealApolloSubscriptionCall<D extends Operation.Data>
implements ApolloSubscriptionCall<D> {
    private final AtomicReference<CallState> state;
    private SubscriptionManagerCallback<D> subscriptionCallback;
    private final Subscription<D> subscription;
    private final SubscriptionManager subscriptionManager;
    private final ApolloStore apolloStore;
    private final ApolloSubscriptionCall.CachePolicy cachePolicy;
    private final Executor dispatcher;
    private final ApolloLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(@NotNull ApolloSubscriptionCall.Callback<D> callback) throws ApolloCanceledException {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realApolloSubscriptionCall) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
            switch (RealApolloSubscriptionCall$WhenMappings.$EnumSwitchMapping$0[callState.ordinal()]) {
                case 1: {
                    this.state.set(CallState.ACTIVE);
                    if (this.cachePolicy == ApolloSubscriptionCall.CachePolicy.CACHE_AND_NETWORK) {
                        this.dispatcher.execute(new Runnable(this, callback){
                            final /* synthetic */ RealApolloSubscriptionCall this$0;
                            final /* synthetic */ ApolloSubscriptionCall.Callback $callback$inlined;
                            {
                                this.this$0 = realApolloSubscriptionCall;
                                this.$callback$inlined = callback;
                            }

                            public final void run() {
                                Response cachedResponse = RealApolloSubscriptionCall.access$resolveFromCache(this.this$0);
                                if (cachedResponse != null) {
                                    this.$callback$inlined.onResponse(cachedResponse);
                                }
                            }
                        });
                    }
                    SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback = new SubscriptionManagerCallback<D>(callback, this);
                    if (subscriptionManagerCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    this.subscriptionManager.subscribe(this.subscription, subscriptionManagerCallback);
                    break;
                }
                case 2: {
                    throw (Throwable)new ApolloCanceledException(null, null, 3, null);
                }
                case 3: 
                case 4: {
                    throw (Throwable)new IllegalStateException("Already Executed");
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cancel() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realApolloSubscriptionCall) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
            switch (RealApolloSubscriptionCall$WhenMappings.$EnumSwitchMapping$1[callState.ordinal()]) {
                case 1: {
                    this.state.set(CallState.CANCELED);
                    break;
                }
                case 2: {
                    try {
                        this.subscriptionManager.unsubscribe(this.subscription);
                        break;
                    }
                    finally {
                        this.state.set(CallState.CANCELED);
                        SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback;
                        if (subscriptionManagerCallback == null) {
                            Intrinsics.throwNpe();
                        }
                        subscriptionManagerCallback.release();
                    }
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    @Override
    @NotNull
    public ApolloSubscriptionCall<D> clone() {
        return new RealApolloSubscriptionCall<D>(this.subscription, this.subscriptionManager, this.apolloStore, this.cachePolicy, this.dispatcher, this.logger);
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public ApolloSubscriptionCall<D> cachePolicy(@NotNull ApolloSubscriptionCall.CachePolicy cachePolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cachePolicy), (String)"cachePolicy");
        return new RealApolloSubscriptionCall<D>(this.subscription, this.subscriptionManager, this.apolloStore, cachePolicy, this.dispatcher, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void terminate() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realApolloSubscriptionCall) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
            switch (RealApolloSubscriptionCall$WhenMappings.$EnumSwitchMapping$2[callState.ordinal()]) {
                case 1: {
                    this.state.set(CallState.TERMINATED);
                    SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback;
                    if (subscriptionManagerCallback == null) {
                        Intrinsics.throwNpe();
                    }
                    subscriptionManagerCallback.release();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    CallState callState2 = this.state.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)callState2), (String)"state.get()");
                    throw (Throwable)new IllegalStateException(CallState.IllegalStateMessage.Companion.forCurrentState(callState2).expected(CallState.ACTIVE, CallState.CANCELED));
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    private final Response<D> resolveFromCache() {
        Response response;
        Operation.Data data = this.apolloStore.readOperation((Operation)this.subscription, CacheHeaders.NONE);
        if (data != null) {
            this.logger.d("Cache HIT for subscription `%s`", new Object[]{this.subscription});
            response = Response.Companion.builder((Operation)this.subscription).data(data).fromCache(true).build();
        } else {
            this.logger.d("Cache MISS for subscription `%s`", new Object[]{this.subscription});
            response = null;
        }
        return response;
    }

    public RealApolloSubscriptionCall(@NotNull Subscription<D> subscription, @NotNull SubscriptionManager subscriptionManager, @NotNull ApolloStore apolloStore, @NotNull ApolloSubscriptionCall.CachePolicy cachePolicy, @NotNull Executor dispatcher, @NotNull ApolloLogger logger) {
        Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
        Intrinsics.checkParameterIsNotNull((Object)subscriptionManager, (String)"subscriptionManager");
        Intrinsics.checkParameterIsNotNull((Object)apolloStore, (String)"apolloStore");
        Intrinsics.checkParameterIsNotNull((Object)((Object)cachePolicy), (String)"cachePolicy");
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.subscription = subscription;
        this.subscriptionManager = subscriptionManager;
        this.apolloStore = apolloStore;
        this.cachePolicy = cachePolicy;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.state = new AtomicReference<CallState>(CallState.IDLE);
    }

    public static final /* synthetic */ Response access$resolveFromCache(RealApolloSubscriptionCall $this) {
        return $this.resolveFromCache();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\nR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall$SubscriptionManagerCallback;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager$Callback;", "originalCallback", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;", "delegate", "Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;", "(Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;)V", "onCompleted", "", "onConnected", "onError", "error", "Lcom/apollographql/apollo3/internal/subscription/ApolloSubscriptionException;", "onNetworkError", "t", "", "onResponse", "response", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionResponse;", "onTerminated", "release", "terminate", "apollo-runtime"})
    private static final class SubscriptionManagerCallback<D extends Operation.Data>
    implements SubscriptionManager.Callback<D> {
        private ApolloSubscriptionCall.Callback<D> originalCallback;
        private RealApolloSubscriptionCall<D> delegate;

        @Override
        public void onResponse(@NotNull SubscriptionResponse<D> response) {
            Intrinsics.checkParameterIsNotNull(response, (String)"response");
            ApolloSubscriptionCall.Callback<D> callback = this.originalCallback;
            Operation.Data data = response.getResponse().getData();
            if (callback != null) {
                if (data != null) {
                    RealApolloSubscriptionCall<D> realApolloSubscriptionCall = this.delegate;
                    if (realApolloSubscriptionCall == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((RealApolloSubscriptionCall)realApolloSubscriptionCall).cachePolicy != ApolloSubscriptionCall.CachePolicy.NO_CACHE) {
                        RealApolloSubscriptionCall<D> realApolloSubscriptionCall2 = this.delegate;
                        if (realApolloSubscriptionCall2 == null) {
                            Intrinsics.throwNpe();
                        }
                        ApolloStore.DefaultImpls.writeOperation$default((ApolloStore)((RealApolloSubscriptionCall)realApolloSubscriptionCall2).apolloStore, (Operation)((Operation)response.getSubscription()), (Operation.Data)data, null, (boolean)false, (int)12, null);
                    }
                }
                callback.onResponse(response.getResponse());
            }
        }

        @Override
        public void onError(@NotNull ApolloSubscriptionException error) {
            ApolloSubscriptionCall.Callback<D> callback;
            Intrinsics.checkParameterIsNotNull((Object)((Object)error), (String)"error");
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onFailure(error);
            }
            this.terminate();
        }

        @Override
        public void onNetworkError(@NotNull Throwable t) {
            ApolloSubscriptionCall.Callback<D> callback;
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onFailure((ApolloException)new ApolloNetworkException("Subscription failed", t));
            }
            this.terminate();
        }

        @Override
        public void onCompleted() {
            ApolloSubscriptionCall.Callback<D> callback;
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onCompleted();
            }
            this.terminate();
        }

        @Override
        public void onTerminated() {
            ApolloSubscriptionCall.Callback<D> callback;
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onTerminated();
            }
            this.terminate();
        }

        @Override
        public void onConnected() {
            block0: {
                ApolloSubscriptionCall.Callback<D> callback;
                ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
                if (callback2 == null) break block0;
                callback2.onConnected();
            }
        }

        public final void terminate() {
            block0: {
                RealApolloSubscriptionCall<D> delegate;
                RealApolloSubscriptionCall<D> realApolloSubscriptionCall = delegate = this.delegate;
                if (realApolloSubscriptionCall == null) break block0;
                ((RealApolloSubscriptionCall)realApolloSubscriptionCall).terminate();
            }
        }

        public final void release() {
            this.originalCallback = null;
            this.delegate = null;
        }

        public SubscriptionManagerCallback(@Nullable ApolloSubscriptionCall.Callback<D> originalCallback, @Nullable RealApolloSubscriptionCall<D> delegate) {
            this.originalCallback = originalCallback;
            this.delegate = delegate;
        }
    }
}

