/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloMutationCall;
import com.apollographql.apollo3.ApolloQueryCall;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.cache.http.HttpCache;
import com.apollographql.apollo3.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo3.api.exception.ApolloCanceledException;
import com.apollographql.apollo3.api.exception.ApolloException;
import com.apollographql.apollo3.api.exception.ApolloHttpException;
import com.apollographql.apollo3.api.exception.ApolloNetworkException;
import com.apollographql.apollo3.api.exception.ApolloParseException;
import com.apollographql.apollo3.api.internal.Action;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.Optional;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.fetcher.ApolloResponseFetchers;
import com.apollographql.apollo3.fetcher.ResponseFetcher;
import com.apollographql.apollo3.interceptor.ApolloAutoPersistedOperationInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.interceptor.ApolloInterceptorFactory;
import com.apollographql.apollo3.internal.ApolloCallTracker;
import com.apollographql.apollo3.internal.CallState;
import com.apollographql.apollo3.internal.QueryReFetcher;
import com.apollographql.apollo3.internal.RealApolloCall;
import com.apollographql.apollo3.internal.RealApolloQueryWatcher;
import com.apollographql.apollo3.internal.interceptor.ApolloCacheInterceptor;
import com.apollographql.apollo3.internal.interceptor.ApolloParseInterceptor;
import com.apollographql.apollo3.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo3.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo3.request.RequestHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0083\u0001*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0004\u0082\u0001\u0083\u0001B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010n\u001a\u00020o2\u0012\u0010p\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000F0AH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010q\u001a\u00020oH\u0016J\u000e\u0010r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0018\u0010s\u001a\u00020o2\u000e\u0010t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010FH\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010u\u001a\u00020vH\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000=H\u0016J\u0014\u0010w\u001a\u0002042\n\u0010<\u001a\u0006\u0012\u0002\b\u00030=H\u0002J/\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u001a\u0010x\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030O0y\"\u0006\u0012\u0002\b\u00030OH\u0016\u00a2\u0006\u0002\u0010zJ'\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0012\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020R0y\"\u00020RH\u0016\u00a2\u0006\u0002\u0010|J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010T\u001a\u00020UH\u0016J\u0012\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000F0AJ\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010}\u001a\u00020YH\u0016J\u0012\u0010~\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000F0AJ\u000e\u0010\u007f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0010\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u0081\u0001H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010/\u001a\u0004\u0018\u000100\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u000204\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010&R\u0013\u00108\u001a\u0004\u0018\u000109\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001f\u0010D\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010F0E\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\"\u0010I\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010C\"\u0004\bL\u0010MR\u001b\u0010N\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030O0\r\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010\u0010R\u0017\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0\r\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u0010R\u0011\u0010T\u001a\u00020U\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u0013\u0010X\u001a\u0004\u0018\u00010Y\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u0013\u0010\\\u001a\u0004\u0018\u00010]\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R\u001f\u0010`\u001a\u0010\u0012\f\u0012\n b*\u0004\u0018\u00010a0a0E\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010HR\u0013\u0010d\u001a\u0004\u0018\u00010e\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010gR\u0011\u0010h\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010&R\u0011\u0010j\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010&R\u0011\u0010l\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010&\u00a8\u0006\u0084\u0001"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloCall;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/ApolloQueryCall;", "Lcom/apollographql/apollo3/ApolloMutationCall;", "builder", "Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;", "(Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;)V", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "applicationInterceptorFactories", "", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "getApplicationInterceptorFactories", "()Ljava/util/List;", "applicationInterceptors", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "getApplicationInterceptors", "autoPersistedOperationsInterceptorFactory", "getAutoPersistedOperationsInterceptorFactory", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "getCacheHeaders", "()Lcom/apollographql/apollo3/cache/CacheHeaders;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "getCustomScalarAdapters", "()Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "dispatcher", "Ljava/util/concurrent/Executor;", "getDispatcher", "()Ljava/util/concurrent/Executor;", "enableAutoPersistedQueries", "", "getEnableAutoPersistedQueries", "()Z", "httpCache", "Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "getHttpCache", "()Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "httpCachePolicy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "getHttpCachePolicy", "()Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "httpCallFactory", "Lokhttp3/Call$Factory;", "getHttpCallFactory", "()Lokhttp3/Call$Factory;", "interceptorChain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "getInterceptorChain", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "isCanceled", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "getOperation", "()Lcom/apollographql/apollo3/api/Operation;", "optimisticUpdates", "Lcom/apollographql/apollo3/api/internal/Optional;", "getOptimisticUpdates", "()Lcom/apollographql/apollo3/api/internal/Optional;", "originalCallback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/ApolloCall$Callback;", "getOriginalCallback", "()Ljava/util/concurrent/atomic/AtomicReference;", "queryReFetcher", "Lcom/apollographql/apollo3/internal/QueryReFetcher;", "getQueryReFetcher", "setQueryReFetcher", "(Lcom/apollographql/apollo3/api/internal/Optional;)V", "refetchQueries", "Lcom/apollographql/apollo3/api/Query;", "getRefetchQueries", "refetchQueryNames", "", "getRefetchQueryNames", "requestHeaders", "Lcom/apollographql/apollo3/request/RequestHeaders;", "getRequestHeaders", "()Lcom/apollographql/apollo3/request/RequestHeaders;", "responseFetcher", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "getResponseFetcher", "()Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "serverUrl", "Lokhttp3/HttpUrl;", "getServerUrl", "()Lokhttp3/HttpUrl;", "state", "Lcom/apollographql/apollo3/internal/CallState;", "kotlin.jvm.PlatformType", "getState", "tracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "getTracker", "()Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "useHttpGetMethodForPersistedQueries", "getUseHttpGetMethodForPersistedQueries", "useHttpGetMethodForQueries", "getUseHttpGetMethodForQueries", "writeToCacheAsynchronously", "getWriteToCacheAsynchronously", "activate", "", "callback", "cancel", "clone", "enqueue", "responseCallback", "interceptorCallbackProxy", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "prepareInterceptorChain", "queries", "", "([Lcom/apollographql/apollo3/api/Query;)Lcom/apollographql/apollo3/ApolloMutationCall;", "operationNames", "([Ljava/lang/String;)Lcom/apollographql/apollo3/ApolloMutationCall;", "fetcher", "terminate", "toBuilder", "watcher", "Lcom/apollographql/apollo3/internal/RealApolloQueryWatcher;", "Builder", "Companion", "apollo-runtime"})
public final class RealApolloCall<D extends Operation.Data>
implements ApolloQueryCall<D>,
ApolloMutationCall<D> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Operation<D> operation;
    @Nullable
    private final HttpUrl serverUrl;
    @Nullable
    private final Call.Factory httpCallFactory;
    @Nullable
    private final HttpCache httpCache;
    @Nullable
    private final HttpCachePolicy.Policy httpCachePolicy;
    @NotNull
    private final CustomScalarAdapters customScalarAdapters;
    @Nullable
    private final ApolloStore apolloStore;
    @Nullable
    private final CacheHeaders cacheHeaders;
    @NotNull
    private final RequestHeaders requestHeaders;
    @Nullable
    private final ResponseFetcher responseFetcher;
    @NotNull
    private final ApolloInterceptorChain interceptorChain;
    @Nullable
    private final Executor dispatcher;
    @Nullable
    private final ApolloLogger logger;
    @Nullable
    private final ApolloCallTracker tracker;
    @Nullable
    private final List<ApolloInterceptor> applicationInterceptors;
    @Nullable
    private final List<ApolloInterceptorFactory> applicationInterceptorFactories;
    @Nullable
    private final ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
    @NotNull
    private final List<String> refetchQueryNames;
    @NotNull
    private final List<Query<?>> refetchQueries;
    @Nullable
    private Optional<QueryReFetcher> queryReFetcher;
    private final boolean enableAutoPersistedQueries;
    @NotNull
    private final AtomicReference<CallState> state;
    @NotNull
    private final AtomicReference<ApolloCall.Callback<D>> originalCallback;
    @NotNull
    private final Optional<Operation.Data> optimisticUpdates;
    private final boolean useHttpGetMethodForQueries;
    private final boolean useHttpGetMethodForPersistedQueries;
    private final boolean writeToCacheAsynchronously;

    public RealApolloCall(@NotNull Builder<D> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.state = new AtomicReference<CallState>(CallState.IDLE);
        this.originalCallback = new AtomicReference();
        CustomScalarAdapters customScalarAdapters = builder.getOperation();
        if (customScalarAdapters == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.Operation<D of com.apollographql.apollo3.internal.RealApolloCall>");
        }
        this.operation = customScalarAdapters;
        this.serverUrl = builder.getServerUrl();
        this.httpCallFactory = builder.getHttpCallFactory();
        this.httpCache = builder.getHttpCache();
        this.httpCachePolicy = builder.getHttpCachePolicy();
        customScalarAdapters = builder.getCustomScalarAdapters();
        if (customScalarAdapters == null) {
            throw new IllegalArgumentException();
        }
        this.customScalarAdapters = customScalarAdapters;
        this.apolloStore = builder.getApolloStore();
        this.responseFetcher = builder.getResponseFetcher();
        this.cacheHeaders = builder.getCacheHeaders();
        this.requestHeaders = builder.getRequestHeaders();
        this.dispatcher = builder.getDispatcher();
        this.logger = builder.getLogger();
        this.applicationInterceptors = builder.getApplicationInterceptors();
        this.applicationInterceptorFactories = builder.getApplicationInterceptorFactories();
        this.autoPersistedOperationsInterceptorFactory = builder.getAutoPersistedOperationsInterceptorFactory();
        this.refetchQueryNames = builder.getRefetchQueryNames();
        this.refetchQueries = builder.getRefetchQueries();
        this.tracker = builder.getTracker();
        this.queryReFetcher = this.refetchQueries.isEmpty() && this.refetchQueryNames.isEmpty() || builder.getApolloStore() == null ? Optional.Companion.absent() : Optional.Companion.of(QueryReFetcher.Companion.builder().queries(builder.getRefetchQueries()).queryWatchers(this.refetchQueryNames).serverUrl(builder.getServerUrl()).httpCallFactory(builder.getHttpCallFactory()).scalarTypeAdapters(builder.getCustomScalarAdapters()).apolloStore(builder.getApolloStore()).dispatcher(builder.getDispatcher()).logger(builder.getLogger()).applicationInterceptors(builder.getApplicationInterceptors()).applicationInterceptorFactories(builder.getApplicationInterceptorFactories()).autoPersistedOperationsInterceptorFactory(builder.getAutoPersistedOperationsInterceptorFactory()).callTracker(builder.getTracker()).build());
        this.useHttpGetMethodForQueries = builder.getUseHttpGetMethodForQueries();
        this.enableAutoPersistedQueries = builder.getEnableAutoPersistedQueries();
        this.useHttpGetMethodForPersistedQueries = builder.getUseHttpGetMethodForPersistedQueries();
        this.optimisticUpdates = builder.getOptimisticUpdates();
        this.writeToCacheAsynchronously = builder.getWriteToCacheAsynchronously();
        this.interceptorChain = this.prepareInterceptorChain(this.operation);
    }

    @NotNull
    public final Operation<D> getOperation() {
        return this.operation;
    }

    @Nullable
    public final HttpUrl getServerUrl() {
        return this.serverUrl;
    }

    @Nullable
    public final Call.Factory getHttpCallFactory() {
        return this.httpCallFactory;
    }

    @Nullable
    public final HttpCache getHttpCache() {
        return this.httpCache;
    }

    @Nullable
    public final HttpCachePolicy.Policy getHttpCachePolicy() {
        return this.httpCachePolicy;
    }

    @NotNull
    public final CustomScalarAdapters getCustomScalarAdapters() {
        return this.customScalarAdapters;
    }

    @Nullable
    public final ApolloStore getApolloStore() {
        return this.apolloStore;
    }

    @Nullable
    public final CacheHeaders getCacheHeaders() {
        return this.cacheHeaders;
    }

    @NotNull
    public final RequestHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    @Nullable
    public final ResponseFetcher getResponseFetcher() {
        return this.responseFetcher;
    }

    @NotNull
    public final ApolloInterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Nullable
    public final Executor getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ApolloCallTracker getTracker() {
        return this.tracker;
    }

    @Nullable
    public final List<ApolloInterceptor> getApplicationInterceptors() {
        return this.applicationInterceptors;
    }

    @Nullable
    public final List<ApolloInterceptorFactory> getApplicationInterceptorFactories() {
        return this.applicationInterceptorFactories;
    }

    @Nullable
    public final ApolloInterceptorFactory getAutoPersistedOperationsInterceptorFactory() {
        return this.autoPersistedOperationsInterceptorFactory;
    }

    @NotNull
    public final List<String> getRefetchQueryNames() {
        return this.refetchQueryNames;
    }

    @NotNull
    public final List<Query<?>> getRefetchQueries() {
        return this.refetchQueries;
    }

    @Nullable
    public final Optional<QueryReFetcher> getQueryReFetcher() {
        return this.queryReFetcher;
    }

    public final void setQueryReFetcher(@Nullable Optional<QueryReFetcher> optional) {
        this.queryReFetcher = optional;
    }

    public final boolean getEnableAutoPersistedQueries() {
        return this.enableAutoPersistedQueries;
    }

    @NotNull
    public final AtomicReference<CallState> getState() {
        return this.state;
    }

    @NotNull
    public final AtomicReference<ApolloCall.Callback<D>> getOriginalCallback() {
        return this.originalCallback;
    }

    @NotNull
    public final Optional<Operation.Data> getOptimisticUpdates() {
        return this.optimisticUpdates;
    }

    public final boolean getUseHttpGetMethodForQueries() {
        return this.useHttpGetMethodForQueries;
    }

    public final boolean getUseHttpGetMethodForPersistedQueries() {
        return this.useHttpGetMethodForPersistedQueries;
    }

    public final boolean getWriteToCacheAsynchronously() {
        return this.writeToCacheAsynchronously;
    }

    @Override
    public void enqueue(@Nullable ApolloCall.Callback<D> responseCallback) {
        try {
            this.activate(Optional.Companion.fromNullable(responseCallback));
        }
        catch (ApolloCanceledException e) {
            if (responseCallback != null) {
                responseCallback.onCanceledError(e);
            } else {
                Object[] objectArray = this.logger;
                Intrinsics.checkNotNull((Object)objectArray);
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{this.operation().name()};
                objectArray2.e((Throwable)e, "Operation: %s was canceled", objectArray);
            }
            return;
        }
        ApolloInterceptor.InterceptorRequest.Builder builder = ApolloInterceptor.InterceptorRequest.Companion.builder(this.operation);
        Object object = this.cacheHeaders;
        Intrinsics.checkNotNull((Object)object);
        ApolloInterceptor.InterceptorRequest request = builder.cacheHeaders((CacheHeaders)object).requestHeaders(this.requestHeaders).fetchFromCache(false).optimisticUpdates(this.optimisticUpdates).writeToCacheAsynchronously(this.writeToCacheAsynchronously).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).build();
        object = this.dispatcher;
        Intrinsics.checkNotNull((Object)object);
        this.interceptorChain.proceedAsync(request, (Executor)object, this.interceptorCallbackProxy());
    }

    @Override
    @NotNull
    public RealApolloQueryWatcher<D> watcher() {
        ApolloQueryCall apolloQueryCall = this.clone();
        Object object = this.apolloStore;
        Intrinsics.checkNotNull((Object)object);
        ApolloStore apolloStore = object;
        object = this.customScalarAdapters;
        Intrinsics.checkNotNull((Object)object);
        ApolloStore apolloStore2 = object;
        object = this.logger;
        Intrinsics.checkNotNull((Object)object);
        ApolloStore apolloStore3 = object;
        object = this.tracker;
        Intrinsics.checkNotNull((Object)object);
        return new RealApolloQueryWatcher(apolloQueryCall, apolloStore, (CustomScalarAdapters)apolloStore2, (ApolloLogger)apolloStore3, (ApolloCallTracker)object, ApolloResponseFetchers.CACHE_FIRST);
    }

    @Override
    @NotNull
    public RealApolloCall<D> httpCachePolicy(@NotNull HttpCachePolicy.Policy httpCachePolicy) {
        Intrinsics.checkNotNullParameter((Object)httpCachePolicy, (String)"httpCachePolicy");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).httpCachePolicy(httpCachePolicy)).build();
    }

    @Override
    @NotNull
    public RealApolloCall<D> responseFetcher(@NotNull ResponseFetcher fetcher) {
        Intrinsics.checkNotNullParameter((Object)fetcher, (String)"fetcher");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).responseFetcher(fetcher)).build();
    }

    @Override
    @NotNull
    public RealApolloCall<D> cacheHeaders(@NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).cacheHeaders(cacheHeaders)).build();
    }

    @Override
    @NotNull
    public RealApolloCall<D> requestHeaders(@NotNull RequestHeaders requestHeaders) {
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((Builder)((Builder)this.toBuilder()).requestHeaders(requestHeaders)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cancel() {
        CallState callState = this.state.get();
        int n = callState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[callState.ordinal()];
        switch (n) {
            case 1: {
                Object object;
                this.state.set(CallState.CANCELED);
                try {
                    this.interceptorChain.dispose();
                    object = this.queryReFetcher;
                    Intrinsics.checkNotNull(object);
                    if (!((Optional)object).isPresent()) break;
                    object = this.queryReFetcher;
                    Intrinsics.checkNotNull((Object)object);
                    ((QueryReFetcher)((Optional)object).get()).cancel();
                    break;
                }
                finally {
                    object = this.tracker;
                    Intrinsics.checkNotNull((Object)object);
                    ((ApolloCallTracker)object).unregisterCall(this);
                    this.originalCallback.set(null);
                }
            }
            case 2: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public RealApolloCall<D> clone() {
        return ((Builder)this.toBuilder()).build();
    }

    @Override
    @NotNull
    public ApolloMutationCall<D> refetchQueries(String ... operationNames) {
        Intrinsics.checkNotNullParameter((Object)operationNames, (String)"operationNames");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (ApolloMutationCall)((Object)((Builder)((Builder)this.toBuilder()).refetchQueryNames(ArraysKt.toList((Object[])operationNames))).build());
    }

    @Override
    @NotNull
    public ApolloMutationCall<D> refetchQueries(Query<?> ... queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (ApolloMutationCall)((Object)((Builder)((Builder)this.toBuilder()).refetchQueries(ArraysKt.toList((Object[])queries))).build());
    }

    @Override
    @NotNull
    public Operation<D> operation() {
        return this.operation;
    }

    private final ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(this){
            final /* synthetic */ RealApolloCall<D> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Optional<ApolloCall.Callback<D>> callback = this.this$0.responseCallback();
                if (!callback.isPresent()) {
                    Object[] objectArray = this.this$0.getLogger();
                    Intrinsics.checkNotNull((Object)objectArray);
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{this.this$0.operation().name()};
                    objectArray2.d("onResponse for operation: %s. No callback present.", objectArray);
                    return;
                }
                ApolloResponse<?> apolloResponse = response.parsedResponse.get();
                if (apolloResponse == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.apollographql.apollo3.api.ApolloResponse<D of com.apollographql.apollo3.internal.RealApolloCall>");
                }
                callback.get().onResponse(apolloResponse);
            }

            public void onFailure(@NotNull ApolloException e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Optional<ApolloCall.Callback<D>> callback = this.this$0.terminate();
                if (!callback.isPresent()) {
                    Object[] objectArray = this.this$0.getLogger();
                    Intrinsics.checkNotNull((Object)objectArray);
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{this.this$0.operation().name()};
                    objectArray2.d((Throwable)e, "onFailure for operation: %s. No callback present.", objectArray);
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.get().onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    callback.get().onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.get().onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.get().onFailure(e);
                }
            }

            public void onCompleted() {
                Optional<ApolloCall.Callback<D>> callback = this.this$0.terminate();
                Object[] objectArray = this.this$0.getQueryReFetcher();
                Intrinsics.checkNotNull(objectArray);
                if (objectArray.isPresent()) {
                    objectArray = this.this$0.getQueryReFetcher();
                    Intrinsics.checkNotNull(objectArray);
                    ((QueryReFetcher)objectArray.get()).refetch();
                }
                if (!callback.isPresent()) {
                    objectArray = this.this$0.getLogger();
                    Intrinsics.checkNotNull((Object)objectArray);
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[]{this.this$0.operation().name()};
                    objectArray2.d("onCompleted for operation: %s. No callback present.", objectArray);
                    return;
                }
                callback.get().onStatusEvent(ApolloCall.StatusEvent.COMPLETED);
            }

            public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                this.this$0.responseCallback().apply(new Action<ApolloCall.Callback<D>>(sourceType){
                    final /* synthetic */ ApolloInterceptor.FetchSourceType $sourceType;
                    {
                        this.$sourceType = $sourceType;
                    }

                    public void apply(@NotNull ApolloCall.Callback<D> t) {
                        Intrinsics.checkNotNullParameter(t, (String)"t");
                        ApolloInterceptor.FetchSourceType fetchSourceType = this.$sourceType;
                        int n = interceptorCallbackProxy.onFetch.WhenMappings.$EnumSwitchMapping$0[fetchSourceType.ordinal()];
                        switch (n) {
                            case 1: {
                                t.onStatusEvent(ApolloCall.StatusEvent.FETCH_CACHE);
                                break;
                            }
                            case 2: {
                                t.onStatusEvent(ApolloCall.StatusEvent.FETCH_NETWORK);
                            }
                        }
                    }
                });
            }
        };
    }

    @Override
    @NotNull
    public Builder<D> toBuilder() {
        Builder builder = Companion.builder().operation(this.operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache);
        Object object = this.httpCachePolicy;
        Intrinsics.checkNotNull((Object)object);
        Builder builder2 = ((Builder)builder.httpCachePolicy((HttpCachePolicy.Policy)object)).scalarTypeAdapters(this.customScalarAdapters).apolloStore(this.apolloStore);
        object = this.cacheHeaders;
        Intrinsics.checkNotNull((Object)object);
        ApolloQueryCall.Builder builder3 = ((Builder)builder2.cacheHeaders((CacheHeaders)object)).requestHeaders(this.requestHeaders);
        object = this.responseFetcher;
        Intrinsics.checkNotNull((Object)object);
        return ((Builder)((Builder)((Builder)((Builder)builder3).responseFetcher((ResponseFetcher)object)).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).applicationInterceptorFactories(this.applicationInterceptorFactories).autoPersistedOperationsInterceptorFactory(this.autoPersistedOperationsInterceptorFactory).tracker(this.tracker).refetchQueryNames((List)this.refetchQueryNames)).refetchQueries(this.refetchQueries)).enableAutoPersistedQueries(this.enableAutoPersistedQueries).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).useHttpGetMethodForPersistedQueries(this.useHttpGetMethodForPersistedQueries).optimisticUpdates(this.optimisticUpdates).writeToCacheAsynchronously(this.writeToCacheAsynchronously);
    }

    private final synchronized void activate(Optional<ApolloCall.Callback<D>> callback) {
        CallState callState = this.state.get();
        int n = callState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[callState.ordinal()];
        switch (n) {
            case 2: {
                this.originalCallback.set(callback.orNull());
                ApolloCallTracker apolloCallTracker = this.tracker;
                Intrinsics.checkNotNull((Object)apolloCallTracker);
                apolloCallTracker.registerCall(this);
                callback.apply(new Action<ApolloCall.Callback<D>>(){

                    public void apply(@NotNull ApolloCall.Callback<D> t) {
                        Intrinsics.checkNotNullParameter(t, (String)"t");
                        t.onStatusEvent(ApolloCall.StatusEvent.SCHEDULED);
                    }
                });
                break;
            }
            case 3: {
                throw new ApolloCanceledException(null, null, 3, null);
            }
            case 1: 
            case 4: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    @NotNull
    public final synchronized Optional<ApolloCall.Callback<D>> responseCallback() {
        CallState callState = this.state.get();
        int n = callState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[callState.ordinal()];
        switch (n) {
            case 1: 
            case 3: {
                break;
            }
            case 2: 
            case 4: {
                CallState[] callStateArray = this.state.get();
                Intrinsics.checkNotNullExpressionValue((Object)callStateArray, (String)"state.get()");
                CallState.IllegalStateMessage illegalStateMessage = CallState.IllegalStateMessage.Companion.forCurrentState((CallState)callStateArray);
                callStateArray = new CallState[]{CallState.ACTIVE, CallState.CANCELED};
                throw new IllegalStateException(illegalStateMessage.expected(callStateArray));
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        return Optional.Companion.fromNullable(this.originalCallback.get());
    }

    @NotNull
    public final synchronized Optional<ApolloCall.Callback<D>> terminate() {
        Optional<Object> optional;
        CallState callState = this.state.get();
        int n = callState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[callState.ordinal()];
        switch (n) {
            case 1: {
                ApolloCallTracker apolloCallTracker = this.tracker;
                Intrinsics.checkNotNull((Object)apolloCallTracker);
                apolloCallTracker.unregisterCall(this);
                this.state.set(CallState.TERMINATED);
                optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                break;
            }
            case 3: {
                optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                break;
            }
            case 2: 
            case 4: {
                CallState[] callStateArray = this.state.get();
                Intrinsics.checkNotNullExpressionValue((Object)callStateArray, (String)"state.get()");
                CallState.IllegalStateMessage illegalStateMessage = CallState.IllegalStateMessage.Companion.forCurrentState((CallState)callStateArray);
                callStateArray = new CallState[]{CallState.ACTIVE, CallState.CANCELED};
                throw new IllegalStateException(illegalStateMessage.expected(callStateArray));
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        return optional;
    }

    private final ApolloInterceptorChain prepareInterceptorChain(Operation<?> operation) {
        HttpCachePolicy.Policy httpCachePolicy = operation instanceof Query ? this.httpCachePolicy : null;
        List interceptors = new ArrayList();
        List<ApolloInterceptorFactory> list = this.applicationInterceptorFactories;
        Intrinsics.checkNotNull(list);
        for (ApolloInterceptorFactory factory : list) {
            ApolloLogger apolloLogger = this.logger;
            Intrinsics.checkNotNull((Object)apolloLogger);
            ApolloInterceptor interceptor = factory.newInterceptor(apolloLogger, operation);
            if (interceptor == null) continue;
            interceptors.add(interceptor);
        }
        Object object = this.applicationInterceptors;
        Intrinsics.checkNotNull((Object)object);
        interceptors.addAll((Collection)object);
        object = this.responseFetcher;
        Intrinsics.checkNotNull((Object)object);
        interceptors.add(object.provideInterceptor(this.logger));
        object = this.apolloStore;
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        object = this.dispatcher;
        Intrinsics.checkNotNull((Object)object);
        Object object3 = object;
        object = this.logger;
        Intrinsics.checkNotNull((Object)object);
        interceptors.add(new ApolloCacheInterceptor<D>((ApolloStore)object2, (Executor)object3, (ApolloLogger)object, this.originalCallback, this.customScalarAdapters));
        if (this.autoPersistedOperationsInterceptorFactory != null) {
            ApolloInterceptor interceptor = this.autoPersistedOperationsInterceptorFactory.newInterceptor(this.logger, operation);
            if (interceptor != null) {
                interceptors.add(interceptor);
            }
        } else if (this.enableAutoPersistedQueries && (operation instanceof Query || operation instanceof Mutation)) {
            interceptors.add(new ApolloAutoPersistedOperationInterceptor(this.logger, this.useHttpGetMethodForPersistedQueries && !(operation instanceof Mutation)));
        }
        interceptors.add(new ApolloParseInterceptor(this.httpCache, this.customScalarAdapters, this.logger));
        object = this.serverUrl;
        Intrinsics.checkNotNull((Object)object);
        Object object4 = object;
        object = this.httpCallFactory;
        Intrinsics.checkNotNull((Object)object);
        interceptors.add(new ApolloServerInterceptor((HttpUrl)object4, (Call.Factory)object, httpCachePolicy, false, this.customScalarAdapters, this.logger));
        return new RealApolloInterceptorChain(interceptors);
    }

    @JvmStatic
    @NotNull
    public static final <D extends Operation.Data> Builder<D> builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\rJ\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u00028\u00010\u0083\u0001H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010(\u001a\u0004\u0018\u00010)J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010.\u001a\u00020/J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u00104\u001a\u0004\u0018\u000105J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010:\u001a\u00020;H\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010@\u001a\u0004\u0018\u00010AJ\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010F\u001a\u0004\u0018\u00010GJ\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010MJ\u001a\u0010R\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00020SJ \u0010X\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0010\u0010X\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030Y0\rH\u0016J\u001c\u0010\\\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\rH\u0016J\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010`\u001a\u00020aH\u0016J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010f\u001a\u00020gH\u0016J\u0017\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010\"\u001a\u0004\u0018\u00010#J\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010l\u001a\u0004\u0018\u00010mJ\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010r\u001a\u0004\u0018\u00010sJ\u0014\u0010x\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010x\u001a\u00020/J\u0014\u0010{\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010{\u001a\u00020/J\u0016\u0010~\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010~\u001a\u00020/H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001c\u0010F\u001a\u0004\u0018\u00010GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR \u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR \u0010R\u001a\b\u0012\u0004\u0012\u00020\u00020SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010X\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030Y0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u0010\"\u0004\b[\u0010\u0012R \u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010\u0010\"\u0004\b_\u0010\u0012R\u001a\u0010`\u001a\u00020aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u001c\u0010f\u001a\u0004\u0018\u00010gX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u001c\u0010l\u001a\u0004\u0018\u00010mX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010o\"\u0004\bp\u0010qR\u001c\u0010r\u001a\u0004\u0018\u00010sX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010u\"\u0004\bv\u0010wR\u001a\u0010x\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u00101\"\u0004\bz\u00103R\u001a\u0010{\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u00101\"\u0004\b}\u00103R\u001b\u0010~\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000f\n\u0000\u001a\u0004\b\u007f\u00101\"\u0005\b\u0080\u0001\u00103\u00a8\u0006\u0085\u0001"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/ApolloQueryCall$Builder;", "Lcom/apollographql/apollo3/ApolloMutationCall$Builder;", "()V", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "setApolloStore", "(Lcom/apollographql/apollo3/cache/normalized/ApolloStore;)V", "applicationInterceptorFactories", "", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "getApplicationInterceptorFactories", "()Ljava/util/List;", "setApplicationInterceptorFactories", "(Ljava/util/List;)V", "applicationInterceptors", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "getApplicationInterceptors", "setApplicationInterceptors", "autoPersistedOperationsInterceptorFactory", "getAutoPersistedOperationsInterceptorFactory", "()Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;", "setAutoPersistedOperationsInterceptorFactory", "(Lcom/apollographql/apollo3/interceptor/ApolloInterceptorFactory;)V", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "getCacheHeaders", "()Lcom/apollographql/apollo3/cache/CacheHeaders;", "setCacheHeaders", "(Lcom/apollographql/apollo3/cache/CacheHeaders;)V", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "getCustomScalarAdapters", "()Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "setCustomScalarAdapters", "(Lcom/apollographql/apollo3/api/CustomScalarAdapters;)V", "dispatcher", "Ljava/util/concurrent/Executor;", "getDispatcher", "()Ljava/util/concurrent/Executor;", "setDispatcher", "(Ljava/util/concurrent/Executor;)V", "enableAutoPersistedQueries", "", "getEnableAutoPersistedQueries", "()Z", "setEnableAutoPersistedQueries", "(Z)V", "httpCache", "Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "getHttpCache", "()Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "setHttpCache", "(Lcom/apollographql/apollo3/api/cache/http/HttpCache;)V", "httpCachePolicy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "getHttpCachePolicy", "()Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "setHttpCachePolicy", "(Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;)V", "httpCallFactory", "Lokhttp3/Call$Factory;", "getHttpCallFactory", "()Lokhttp3/Call$Factory;", "setHttpCallFactory", "(Lokhttp3/Call$Factory;)V", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "setLogger", "(Lcom/apollographql/apollo3/api/internal/ApolloLogger;)V", "operation", "Lcom/apollographql/apollo3/api/Operation;", "getOperation", "()Lcom/apollographql/apollo3/api/Operation;", "setOperation", "(Lcom/apollographql/apollo3/api/Operation;)V", "optimisticUpdates", "Lcom/apollographql/apollo3/api/internal/Optional;", "getOptimisticUpdates", "()Lcom/apollographql/apollo3/api/internal/Optional;", "setOptimisticUpdates", "(Lcom/apollographql/apollo3/api/internal/Optional;)V", "refetchQueries", "Lcom/apollographql/apollo3/api/Query;", "getRefetchQueries", "setRefetchQueries", "refetchQueryNames", "", "getRefetchQueryNames", "setRefetchQueryNames", "requestHeaders", "Lcom/apollographql/apollo3/request/RequestHeaders;", "getRequestHeaders", "()Lcom/apollographql/apollo3/request/RequestHeaders;", "setRequestHeaders", "(Lcom/apollographql/apollo3/request/RequestHeaders;)V", "responseFetcher", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "getResponseFetcher", "()Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "setResponseFetcher", "(Lcom/apollographql/apollo3/fetcher/ResponseFetcher;)V", "serverUrl", "Lokhttp3/HttpUrl;", "getServerUrl", "()Lokhttp3/HttpUrl;", "setServerUrl", "(Lokhttp3/HttpUrl;)V", "tracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "getTracker", "()Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "setTracker", "(Lcom/apollographql/apollo3/internal/ApolloCallTracker;)V", "useHttpGetMethodForPersistedQueries", "getUseHttpGetMethodForPersistedQueries", "setUseHttpGetMethodForPersistedQueries", "useHttpGetMethodForQueries", "getUseHttpGetMethodForQueries", "setUseHttpGetMethodForQueries", "writeToCacheAsynchronously", "getWriteToCacheAsynchronously", "setWriteToCacheAsynchronously", "interceptorFactory", "build", "Lcom/apollographql/apollo3/internal/RealApolloCall;", "scalarTypeAdapters", "apollo-runtime"})
    public static final class Builder<D extends Operation.Data>
    implements ApolloQueryCall.Builder<D>,
    ApolloMutationCall.Builder<D> {
        @Nullable
        private Operation<?> operation;
        @Nullable
        private HttpUrl serverUrl;
        @Nullable
        private Call.Factory httpCallFactory;
        @Nullable
        private HttpCache httpCache;
        @Nullable
        private HttpCachePolicy.Policy httpCachePolicy;
        @Nullable
        private CustomScalarAdapters customScalarAdapters;
        @Nullable
        private ApolloStore apolloStore;
        @Nullable
        private ResponseFetcher responseFetcher;
        @Nullable
        private CacheHeaders cacheHeaders;
        @NotNull
        private RequestHeaders requestHeaders = RequestHeaders.Companion.getNONE();
        @Nullable
        private Executor dispatcher;
        @Nullable
        private ApolloLogger logger;
        @Nullable
        private List<? extends ApolloInterceptor> applicationInterceptors;
        @Nullable
        private List<? extends ApolloInterceptorFactory> applicationInterceptorFactories;
        @Nullable
        private ApolloInterceptorFactory autoPersistedOperationsInterceptorFactory;
        @NotNull
        private List<String> refetchQueryNames = CollectionsKt.emptyList();
        @NotNull
        private List<? extends Query<?>> refetchQueries = CollectionsKt.emptyList();
        @Nullable
        private ApolloCallTracker tracker;
        private boolean enableAutoPersistedQueries;
        @NotNull
        private Optional<Operation.Data> optimisticUpdates = Optional.Companion.absent();
        private boolean useHttpGetMethodForQueries;
        private boolean useHttpGetMethodForPersistedQueries;
        private boolean writeToCacheAsynchronously;

        @Nullable
        public final Operation<?> getOperation() {
            return this.operation;
        }

        public final void setOperation(@Nullable Operation<?> operation) {
            this.operation = operation;
        }

        @Nullable
        public final HttpUrl getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(@Nullable HttpUrl httpUrl) {
            this.serverUrl = httpUrl;
        }

        @Nullable
        public final Call.Factory getHttpCallFactory() {
            return this.httpCallFactory;
        }

        public final void setHttpCallFactory(@Nullable Call.Factory factory) {
            this.httpCallFactory = factory;
        }

        @Nullable
        public final HttpCache getHttpCache() {
            return this.httpCache;
        }

        public final void setHttpCache(@Nullable HttpCache httpCache) {
            this.httpCache = httpCache;
        }

        @Nullable
        public final HttpCachePolicy.Policy getHttpCachePolicy() {
            return this.httpCachePolicy;
        }

        public final void setHttpCachePolicy(@Nullable HttpCachePolicy.Policy policy) {
            this.httpCachePolicy = policy;
        }

        @Nullable
        public final CustomScalarAdapters getCustomScalarAdapters() {
            return this.customScalarAdapters;
        }

        public final void setCustomScalarAdapters(@Nullable CustomScalarAdapters customScalarAdapters) {
            this.customScalarAdapters = customScalarAdapters;
        }

        @Nullable
        public final ApolloStore getApolloStore() {
            return this.apolloStore;
        }

        public final void setApolloStore(@Nullable ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
        }

        @Nullable
        public final ResponseFetcher getResponseFetcher() {
            return this.responseFetcher;
        }

        public final void setResponseFetcher(@Nullable ResponseFetcher responseFetcher) {
            this.responseFetcher = responseFetcher;
        }

        @Nullable
        public final CacheHeaders getCacheHeaders() {
            return this.cacheHeaders;
        }

        public final void setCacheHeaders(@Nullable CacheHeaders cacheHeaders) {
            this.cacheHeaders = cacheHeaders;
        }

        @NotNull
        public final RequestHeaders getRequestHeaders() {
            return this.requestHeaders;
        }

        public final void setRequestHeaders(@NotNull RequestHeaders requestHeaders) {
            Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"<set-?>");
            this.requestHeaders = requestHeaders;
        }

        @Nullable
        public final Executor getDispatcher() {
            return this.dispatcher;
        }

        public final void setDispatcher(@Nullable Executor executor) {
            this.dispatcher = executor;
        }

        @Nullable
        public final ApolloLogger getLogger() {
            return this.logger;
        }

        public final void setLogger(@Nullable ApolloLogger apolloLogger) {
            this.logger = apolloLogger;
        }

        @Nullable
        public final List<ApolloInterceptor> getApplicationInterceptors() {
            return this.applicationInterceptors;
        }

        public final void setApplicationInterceptors(@Nullable List<? extends ApolloInterceptor> list) {
            this.applicationInterceptors = list;
        }

        @Nullable
        public final List<ApolloInterceptorFactory> getApplicationInterceptorFactories() {
            return this.applicationInterceptorFactories;
        }

        public final void setApplicationInterceptorFactories(@Nullable List<? extends ApolloInterceptorFactory> list) {
            this.applicationInterceptorFactories = list;
        }

        @Nullable
        public final ApolloInterceptorFactory getAutoPersistedOperationsInterceptorFactory() {
            return this.autoPersistedOperationsInterceptorFactory;
        }

        public final void setAutoPersistedOperationsInterceptorFactory(@Nullable ApolloInterceptorFactory apolloInterceptorFactory) {
            this.autoPersistedOperationsInterceptorFactory = apolloInterceptorFactory;
        }

        @NotNull
        public final List<String> getRefetchQueryNames() {
            return this.refetchQueryNames;
        }

        public final void setRefetchQueryNames(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.refetchQueryNames = list;
        }

        @NotNull
        public final List<Query<?>> getRefetchQueries() {
            return this.refetchQueries;
        }

        public final void setRefetchQueries(@NotNull List<? extends Query<?>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.refetchQueries = list;
        }

        @Nullable
        public final ApolloCallTracker getTracker() {
            return this.tracker;
        }

        public final void setTracker(@Nullable ApolloCallTracker apolloCallTracker) {
            this.tracker = apolloCallTracker;
        }

        public final boolean getEnableAutoPersistedQueries() {
            return this.enableAutoPersistedQueries;
        }

        public final void setEnableAutoPersistedQueries(boolean bl) {
            this.enableAutoPersistedQueries = bl;
        }

        @NotNull
        public final Optional<Operation.Data> getOptimisticUpdates() {
            return this.optimisticUpdates;
        }

        public final void setOptimisticUpdates(@NotNull Optional<Operation.Data> optional) {
            Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
            this.optimisticUpdates = optional;
        }

        public final boolean getUseHttpGetMethodForQueries() {
            return this.useHttpGetMethodForQueries;
        }

        public final void setUseHttpGetMethodForQueries(boolean bl) {
            this.useHttpGetMethodForQueries = bl;
        }

        public final boolean getUseHttpGetMethodForPersistedQueries() {
            return this.useHttpGetMethodForPersistedQueries;
        }

        public final void setUseHttpGetMethodForPersistedQueries(boolean bl) {
            this.useHttpGetMethodForPersistedQueries = bl;
        }

        public final boolean getWriteToCacheAsynchronously() {
            return this.writeToCacheAsynchronously;
        }

        public final void setWriteToCacheAsynchronously(boolean bl) {
            this.writeToCacheAsynchronously = bl;
        }

        @NotNull
        public final Builder<D> operation(@Nullable Operation<?> operation) {
            this.operation = operation;
            return this;
        }

        @NotNull
        public final Builder<D> serverUrl(@Nullable HttpUrl serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @NotNull
        public final Builder<D> httpCallFactory(@Nullable Call.Factory httpCallFactory) {
            this.httpCallFactory = httpCallFactory;
            return this;
        }

        @NotNull
        public final Builder<D> httpCache(@Nullable HttpCache httpCache) {
            this.httpCache = httpCache;
            return this;
        }

        @NotNull
        public final Builder<D> scalarTypeAdapters(@Nullable CustomScalarAdapters customScalarAdapters) {
            this.customScalarAdapters = customScalarAdapters;
            return this;
        }

        @NotNull
        public final Builder<D> apolloStore(@Nullable ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> cacheHeaders(@NotNull CacheHeaders cacheHeaders) {
            Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
            this.cacheHeaders = cacheHeaders;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> httpCachePolicy(@NotNull HttpCachePolicy.Policy httpCachePolicy) {
            Intrinsics.checkNotNullParameter((Object)httpCachePolicy, (String)"httpCachePolicy");
            this.httpCachePolicy = httpCachePolicy;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> responseFetcher(@NotNull ResponseFetcher responseFetcher) {
            Intrinsics.checkNotNullParameter((Object)responseFetcher, (String)"responseFetcher");
            this.responseFetcher = responseFetcher;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> requestHeaders(@NotNull RequestHeaders requestHeaders) {
            Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
            this.requestHeaders = requestHeaders;
            return this;
        }

        @Override
        @NotNull
        public Builder<D> refetchQueryNames(@NotNull List<String> refetchQueryNames) {
            Intrinsics.checkNotNullParameter(refetchQueryNames, (String)"refetchQueryNames");
            this.refetchQueryNames = new ArrayList(refetchQueryNames);
            return this;
        }

        @Override
        @NotNull
        public Builder<D> refetchQueries(@NotNull List<? extends Query<?>> refetchQueries2) {
            Intrinsics.checkNotNullParameter(refetchQueries2, (String)"refetchQueries");
            this.refetchQueries = new ArrayList(refetchQueries2);
            return this;
        }

        @Override
        @NotNull
        public Builder<D> writeToCacheAsynchronously(boolean writeToCacheAsynchronously) {
            this.writeToCacheAsynchronously = writeToCacheAsynchronously;
            return this;
        }

        @NotNull
        public final Builder<D> dispatcher(@Nullable Executor dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        @NotNull
        public final Builder<D> logger(@Nullable ApolloLogger logger) {
            this.logger = logger;
            return this;
        }

        @NotNull
        public final Builder<D> tracker(@Nullable ApolloCallTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        @NotNull
        public final Builder<D> applicationInterceptors(@Nullable List<? extends ApolloInterceptor> applicationInterceptors) {
            this.applicationInterceptors = applicationInterceptors;
            return this;
        }

        @NotNull
        public final Builder<D> applicationInterceptorFactories(@Nullable List<? extends ApolloInterceptorFactory> applicationInterceptorFactories) {
            this.applicationInterceptorFactories = applicationInterceptorFactories;
            return this;
        }

        @NotNull
        public final Builder<D> autoPersistedOperationsInterceptorFactory(@Nullable ApolloInterceptorFactory interceptorFactory) {
            this.autoPersistedOperationsInterceptorFactory = interceptorFactory;
            return this;
        }

        @NotNull
        public final Builder<D> enableAutoPersistedQueries(boolean enableAutoPersistedQueries) {
            this.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return this;
        }

        @NotNull
        public final Builder<D> optimisticUpdates(@NotNull Optional<Operation.Data> optimisticUpdates) {
            Intrinsics.checkNotNullParameter(optimisticUpdates, (String)"optimisticUpdates");
            this.optimisticUpdates = optimisticUpdates;
            return this;
        }

        @NotNull
        public final Builder<D> useHttpGetMethodForQueries(boolean useHttpGetMethodForQueries) {
            this.useHttpGetMethodForQueries = useHttpGetMethodForQueries;
            return this;
        }

        @NotNull
        public final Builder<D> useHttpGetMethodForPersistedQueries(boolean useHttpGetMethodForPersistedQueries) {
            this.useHttpGetMethodForPersistedQueries = useHttpGetMethodForPersistedQueries;
            return this;
        }

        @Override
        @NotNull
        public RealApolloCall<D> build() {
            return new RealApolloCall(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloCall$Companion;", "", "()V", "builder", "Lcom/apollographql/apollo3/internal/RealApolloCall$Builder;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "apollo-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <D extends Operation.Data> Builder<D> builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallState.values().length];
            nArray[CallState.ACTIVE.ordinal()] = 1;
            nArray[CallState.IDLE.ordinal()] = 2;
            nArray[CallState.CANCELED.ordinal()] = 3;
            nArray[CallState.TERMINATED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

