package com.apollographql.apollo3.cache.normalized.sql

import com.apollographql.apollo3.cache.normalized.sql.apollonormalizedcachesqlite.newInstance
import com.apollographql.apollo3.cache.normalized.sql.apollonormalizedcachesqlite.schema
import com.squareup.sqldelight.Transacter
import com.squareup.sqldelight.db.SqlDriver

public interface ApolloDatabase : Transacter {
  public val cacheQueries: CacheQueries

  public companion object {
    public val Schema: SqlDriver.Schema
      get() = ApolloDatabase::class.schema

    public operator fun invoke(driver: SqlDriver): ApolloDatabase =
        ApolloDatabase::class.newInstance(driver)
  }
}
