/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000203:\u00011B=\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012,\b\u0002\u0010\u0007\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0004\u0012\u00020\u00030\u0005j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0006\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\n\u001a\u00028\u00002\b\u0010\u000b\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0018\u001a\u00020\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0016J\u001b\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b\u00a2\u0006\u0004\b\u001a\u0010\u001dJ\u0019\u0010\u001e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\n\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0016J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0003\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b#\u0010\u0011J#\u0010$\u001a\u00020\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0002\u00a2\u0006\u0004\b$\u0010\u0019RJ\u0010'\u001a6\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f0%j\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f`&8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R$\u0010)\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010,\u001a\u00020+8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010\u0004\u001a\u00020\u00038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010.R\u0016\u0010!\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010.R$\u0010/\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010*R:\u0010\u0007\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0004\u0012\u00020\u00030\u0005j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u00068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00100\u00a8\u00062"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/LruCache;", "Key", "Value", "", "maxSize", "Lkotlin/Function2;", "Lcom/apollographql/apollo3/cache/normalized/internal/Weigher;", "weigher", "<init>", "(ILkotlin/jvm/functions/Function2;)V", "key", "value", "Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;", "addNode", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;", "", "clear", "()V", "", "dump", "()Ljava/util/Map;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "node", "moveNodeToHead", "(Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;)V", "remove", "", "keys", "(Ljava/util/Collection;)V", "removeUnsafe", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "size", "()I", "trim", "unlinkNode", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "cache", "Ljava/util/LinkedHashMap;", "headNode", "Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "I", "tailNode", "Lkotlin/jvm/functions/Function2;", "Node", "apollo-normalized-cache", ""})
public final class LruCache<Key, Value> {
    private final LinkedHashMap<Key, Node<Key, Value>> cache;
    private Node<Key, Value> headNode;
    private Node<Key, Value> tailNode;
    private final ReentrantLock lock;
    private int size;
    private final int maxSize;
    private final Function2<Key, Value, Integer> weigher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value get(Key key) {
        Value Value;
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            Node<Key, Value> node = this.cache.get(key);
            if (node != null) {
                this.moveNodeToHead(node);
            }
            Node<Key, Value> node2 = node;
            Value = node2 != null ? node2.getValue() : null;
        }
        finally {
            reentrantLock.unlock();
        }
        return Value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(Key key, Value value) {
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            Node<Key, Value> node = this.cache.get(key);
            if (node == null) {
                ((Map)this.cache).put(key, this.addNode(key, value));
            } else {
                node.setValue(value);
                this.moveNodeToHead(node);
            }
            this.trim();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value remove(Key key) {
        Value Value;
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            Value = this.removeUnsafe(key);
        }
        finally {
            reentrantLock.unlock();
        }
        return Value;
    }

    private final Value removeUnsafe(Key key) {
        Object value;
        Node nodeToRemove;
        Node node = nodeToRemove = (Node)this.cache.remove(key);
        Object object = value = node != null ? node.getValue() : null;
        if (nodeToRemove != null) {
            this.unlinkNode(nodeToRemove);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull Collection<? extends Key> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object key = element$iv = iterator.next();
                boolean bl3 = false;
                this.removeUnsafe(key);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            this.cache.clear();
            this.headNode = null;
            this.tailNode = null;
            this.size = 0;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            n = this.size;
        }
        finally {
            reentrantLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Key, Value> dump() {
        Map map;
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        reentrantLock.lock();
        try {
            void $this$mapValuesTo$iv$iv;
            boolean bl2 = false;
            Map $this$mapValues$iv = this.cache;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $dstr$_u24__u24$value;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl3 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map4 = map3;
                boolean bl4 = false;
                void var21_23 = $dstr$_u24__u24$value;
                boolean bl5 = false;
                Node value = (Node)var21_23.getValue();
                Object Value = value.getValue();
                map4.put(k2, Value);
            }
            map = destination$iv$iv;
        }
        finally {
            reentrantLock.unlock();
        }
        return map;
    }

    private final void trim() {
        Node<Key, Value> nodeToRemove = this.tailNode;
        while (nodeToRemove != null && this.size > this.maxSize) {
            Map map = this.cache;
            Key Key = nodeToRemove.getKey();
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            TypeIntrinsics.asMutableMap((Object)map2).remove(Key);
            this.unlinkNode(nodeToRemove);
            nodeToRemove = this.tailNode;
        }
    }

    private final Node<Key, Value> addNode(Key key, Value value) {
        Node<Key, Value> node = new Node<Key, Value>(key, value, this.headNode, null);
        this.headNode = node;
        if (node.getNext() == null) {
            this.tailNode = this.headNode;
        } else {
            Node<Key, Value> node2 = node.getNext();
            if (node2 != null) {
                node2.setPrev(this.headNode);
            }
        }
        this.size += ((Number)this.weigher.invoke(key, value)).intValue();
        return node;
    }

    private final void moveNodeToHead(Node<Key, Value> node) {
        if (node.getPrev() == null) {
            return;
        }
        Node<Key, Value> node2 = node.getPrev();
        if (node2 != null) {
            node2.setNext(node.getNext());
        }
        Node<Key, Value> node3 = node.getNext();
        if (node3 != null) {
            node3.setPrev(node.getPrev());
        }
        Node<Key, Value> node4 = this.headNode;
        node.setNext(node4 != null ? node4.getNext() : null);
        node.setPrev(null);
        Node<Key, Value> node5 = this.headNode;
        if (node5 != null) {
            node5.setPrev(node);
        }
        this.headNode = node;
    }

    private final void unlinkNode(Node<Key, Value> node) {
        if (node.getPrev() == null) {
            this.headNode = node.getNext();
        } else {
            Node<Key, Value> node2 = node.getPrev();
            if (node2 != null) {
                node2.setNext(node.getNext());
            }
        }
        if (node.getNext() == null) {
            this.tailNode = node.getPrev();
        } else {
            Node<Key, Value> node3 = node.getNext();
            if (node3 != null) {
                node3.setPrev(node.getPrev());
            }
        }
        Key Key = node.getKey();
        Intrinsics.checkNotNull(Key);
        this.size -= ((Number)this.weigher.invoke(Key, node.getValue())).intValue();
        node.setKey(null);
        node.setValue(null);
        node.setNext(null);
        node.setPrev(null);
    }

    public LruCache(int maxSize, @NotNull Function2<? super Key, ? super Value, Integer> weigher) {
        Intrinsics.checkNotNullParameter(weigher, (String)"weigher");
        this.maxSize = maxSize;
        this.weigher = weigher;
        this.cache = new LinkedHashMap(0, 0.75f);
        boolean bl = false;
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ LruCache(int n, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function2 = 1.INSTANCE;
        }
        this(n, function2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0013\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003BE\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\bR\u001e\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0005\u001a\u0004\u0018\u00018\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;", "Key", "Value", "", "key", "value", "next", "prev", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;)V", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getNext", "()Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;", "setNext", "(Lcom/apollographql/apollo3/cache/normalized/internal/LruCache$Node;)V", "getPrev", "setPrev", "getValue", "setValue", "apollo-normalized-cache"})
    private static final class Node<Key, Value> {
        @Nullable
        private Key key;
        @Nullable
        private Value value;
        @Nullable
        private Node<Key, Value> next;
        @Nullable
        private Node<Key, Value> prev;

        @Nullable
        public final Key getKey() {
            return this.key;
        }

        public final void setKey(@Nullable Key Key) {
            this.key = Key;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public final void setValue(@Nullable Value Value) {
            this.value = Value;
        }

        @Nullable
        public final Node<Key, Value> getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Node<Key, Value> node) {
            this.next = node;
        }

        @Nullable
        public final Node<Key, Value> getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Node<Key, Value> node) {
            this.prev = node;
        }

        public Node(@Nullable Key key, @Nullable Value value, @Nullable Node<Key, Value> next, @Nullable Node<Key, Value> prev) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.prev = prev;
        }
    }
}

