/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.internal;

import com.apollographql.apollo3.api.CompiledField;
import com.apollographql.apollo3.api.CompiledFragment;
import com.apollographql.apollo3.api.CompiledSelection;
import com.apollographql.apollo3.api.CompiledType;
import com.apollographql.apollo3.api.Executable;
import com.apollographql.apollo3.api.exception.CacheMissException;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.CacheKey;
import com.apollographql.apollo3.cache.normalized.CacheResolver;
import com.apollographql.apollo3.cache.normalized.ReadOnlyNormalizedCache;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.internal.ShouldSkipKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002!\"B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012J$\u0010\u0017\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\r*\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002J\u001c\u0010\u001e\u001a\u00020\u0018*\u0004\u0018\u00010\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/CacheBatchReader;", "", "cache", "Lcom/apollographql/apollo3/cache/normalized/ReadOnlyNormalizedCache;", "rootKey", "", "variables", "Lcom/apollographql/apollo3/api/Executable$Variables;", "cacheResolver", "Lcom/apollographql/apollo3/cache/normalized/CacheResolver;", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "rootSelections", "", "Lcom/apollographql/apollo3/api/CompiledSelection;", "(Lcom/apollographql/apollo3/cache/normalized/ReadOnlyNormalizedCache;Ljava/lang/String;Lcom/apollographql/apollo3/api/Executable$Variables;Lcom/apollographql/apollo3/cache/normalized/CacheResolver;Lcom/apollographql/apollo3/cache/CacheHeaders;Ljava/util/List;)V", "data", "", "", "pendingReferences", "", "Lcom/apollographql/apollo3/cache/normalized/internal/CacheBatchReader$PendingReference;", "toMap", "collect", "", "typename", "state", "Lcom/apollographql/apollo3/cache/normalized/internal/CacheBatchReader$CollectState;", "collectAndMergeSameDirectives", "Lcom/apollographql/apollo3/api/CompiledField;", "registerCacheKeys", "selections", "resolveCacheKeys", "CollectState", "PendingReference", "apollo-normalized-cache"})
public final class CacheBatchReader {
    @NotNull
    private final ReadOnlyNormalizedCache cache;
    @NotNull
    private final String rootKey;
    @NotNull
    private final Executable.Variables variables;
    @NotNull
    private final CacheResolver cacheResolver;
    @NotNull
    private final CacheHeaders cacheHeaders;
    @NotNull
    private final List<CompiledSelection> rootSelections;
    @NotNull
    private final Map<String, Map<String, Object>> data;
    @NotNull
    private final List<PendingReference> pendingReferences;

    public CacheBatchReader(@NotNull ReadOnlyNormalizedCache cache, @NotNull String rootKey, @NotNull Executable.Variables variables, @NotNull CacheResolver cacheResolver, @NotNull CacheHeaders cacheHeaders, @NotNull List<? extends CompiledSelection> rootSelections) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)rootKey, (String)"rootKey");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)cacheResolver, (String)"cacheResolver");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter(rootSelections, (String)"rootSelections");
        this.cache = cache;
        this.rootKey = rootKey;
        this.variables = variables;
        this.cacheResolver = cacheResolver;
        this.cacheHeaders = cacheHeaders;
        this.rootSelections = rootSelections;
        boolean bl = false;
        this.data = new LinkedHashMap();
        bl = false;
        this.pendingReferences = new ArrayList();
    }

    private final void collect(List<? extends CompiledSelection> $this$collect, String typename, CollectState state) {
        Iterable $this$forEach$iv = $this$collect;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompiledSelection it = (CompiledSelection)element$iv;
            boolean bl = false;
            CompiledSelection compiledSelection = it;
            if (compiledSelection instanceof CompiledField) {
                state.getFields().add((CompiledField)it);
                continue;
            }
            if (!(compiledSelection instanceof CompiledFragment) || !CollectionsKt.contains((Iterable)((CompiledFragment)it).getPossibleTypes(), (Object)typename)) continue;
            this.collect(((CompiledFragment)it).getSelections(), typename, state);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<CompiledField> collectAndMergeSameDirectives(List<? extends CompiledSelection> $this$collectAndMergeSameDirectives, String typename) {
        void $this$mapTo$iv$iv;
        List list$iv$iv;
        CompiledField it;
        Iterable $this$groupByTo$iv$iv;
        CollectState state = new CollectState();
        this.collect($this$collectAndMergeSameDirectives, typename, state);
        Iterable $this$groupBy$iv = state.getFields();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (CompiledField)element$iv$iv;
            boolean bl = false;
            Pair key$iv$iv = TuplesKt.to((Object)it.getResponseName(), (Object)it.getCondition());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$flatMapTo$iv$iv;
            list$iv$iv = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            CompiledField first = (CompiledField)CollectionsKt.first((List)it);
            String string = first.getAlias();
            String string2 = first.getName();
            CompiledType compiledType = first.getType();
            List list = first.getCondition();
            List list2 = first.getArguments();
            Iterable $this$flatMap$iv = (Iterable)it;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CompiledField it2 = (CompiledField)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv2 = it2.getSelections();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
            }
            List list3 = (List)destination$iv$iv2;
            CompiledField compiledField = new CompiledField(string2, string, compiledType, list, list2, list3);
            object.add(compiledField);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMap() {
        Object object;
        this.pendingReferences.add(new PendingReference(this.rootKey, this.rootSelections));
        block0: while (true) {
            void $this$associateByTo$iv$iv;
            Object object2;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = this.pendingReferences;
            boolean bl = false;
            if (!(!object.isEmpty())) break;
            Iterable iterable = this.pendingReferences;
            Object object3 = this.cache;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                PendingReference pendingReference = (PendingReference)item$iv$iv2;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getKey();
                object2.add(string);
            }
            object2 = (List)destination$iv$iv;
            Iterable $this$associateBy$iv = object3.loadRecords((Collection)object2, this.cacheHeaders);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            item$iv$iv2 = $this$associateByTo$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                void it;
                Object element$iv$iv = item$iv$iv2.next();
                Record bl2 = (Record)element$iv$iv;
                object3 = destination$iv$iv2;
                boolean bl3 = false;
                object2 = it.getKey();
                object3.put(object2, element$iv$iv);
            }
            Map records = destination$iv$iv2;
            List copy = CollectionsKt.toList((Iterable)this.pendingReferences);
            this.pendingReferences.clear();
            Iterable $this$forEach$iv = copy;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (true) {
                void $this$mapNotNullTo$iv$iv;
                Object it;
                if (!iterator.hasNext()) continue block0;
                Object element$iv = iterator.next();
                PendingReference pendingReference = (PendingReference)element$iv;
                boolean bl4 = false;
                Record record = null;
                record = (Record)records.get(pendingReference.getKey());
                if (record == null) {
                    if (Intrinsics.areEqual((Object)pendingReference.getKey(), (Object)CacheKey.Companion.rootKey().getKey())) {
                        record = new Record(pendingReference.getKey(), MapsKt.emptyMap(), null, 4, null);
                    } else {
                        throw new CacheMissException(pendingReference.getKey(), null, 2, null);
                    }
                }
                List<CompiledField> collectedFields = this.collectAndMergeSameDirectives(pendingReference.getSelections(), (it = ((Record)record).get((Object)"__typename")) instanceof String ? (String)it : null);
                Iterable $this$mapNotNull$iv = collectedFields;
                boolean $i$f$mapNotNull = false;
                Object object4 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl5 = false;
                    CompiledField it2 = (CompiledField)element$iv$iv;
                    boolean bl6 = false;
                    if (ShouldSkipKt.shouldSkip(it2, this.variables.getValueMap())) {
                        pair = null;
                    } else {
                        Object value = this.cacheResolver.resolveField(it2, this.variables, (Map)record, record.getKey());
                        this.registerCacheKeys(value, it2.getSelections());
                        pair = TuplesKt.to((Object)it2.getResponseName(), (Object)value);
                    }
                    if (pair == null) continue;
                    Pair pair2 = pair;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Pair it$iv$iv = pair2;
                    boolean bl9 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
                Map<String, Object> existingValue = this.data.get(record.getKey());
                Map newValue = existingValue != null ? MapsKt.plus(existingValue, (Map)map) : map;
                object4 = this.data;
                String string = record.getKey();
                boolean bl10 = false;
                object4.put(string, newValue);
            }
            break;
        }
        object = this.resolveCacheKeys(this.data.get(this.rootKey));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        }
        return (Map)object;
    }

    private final void registerCacheKeys(Object $this$registerCacheKeys, List<? extends CompiledSelection> selections) {
        Object object = $this$registerCacheKeys;
        if (object instanceof CacheKey) {
            this.pendingReferences.add(new PendingReference(((CacheKey)$this$registerCacheKeys).getKey(), selections));
        } else if (object instanceof List) {
            Iterable $this$forEach$iv = (Iterable)$this$registerCacheKeys;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                this.registerCacheKeys(it, selections);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object resolveCacheKeys(Object $this$resolveCacheKeys) {
        Object object;
        Object object2 = $this$resolveCacheKeys;
        if (object2 instanceof CacheKey) {
            object = this.resolveCacheKeys(this.data.get(((CacheKey)$this$resolveCacheKeys).getKey()));
        } else if (object2 instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)$this$resolveCacheKeys;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object3 = this.resolveCacheKeys(it);
                collection.add(object3);
            }
            object = (List)destination$iv$iv;
        } else if (object2 instanceof Map) {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = (Map)$this$resolveCacheKeys;
            boolean $i$f$mapValues = false;
            Map $this$mapTo$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map2 = map;
                boolean bl2 = false;
                Object object4 = this.resolveCacheKeys(it.getValue());
                map2.put(k2, object4);
            }
            object = destination$iv$iv;
        } else {
            object = $this$resolveCacheKeys;
        }
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/CacheBatchReader$PendingReference;", "", "key", "", "selections", "", "Lcom/apollographql/apollo3/api/CompiledSelection;", "(Ljava/lang/String;Ljava/util/List;)V", "getKey", "()Ljava/lang/String;", "getSelections", "()Ljava/util/List;", "apollo-normalized-cache"})
    public static final class PendingReference {
        @NotNull
        private final String key;
        @NotNull
        private final List<CompiledSelection> selections;

        public PendingReference(@NotNull String key, @NotNull List<? extends CompiledSelection> selections) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(selections, (String)"selections");
            this.key = key;
            this.selections = selections;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final List<CompiledSelection> getSelections() {
            return this.selections;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/CacheBatchReader$CollectState;", "", "()V", "fields", "", "Lcom/apollographql/apollo3/api/CompiledField;", "getFields", "()Ljava/util/List;", "apollo-normalized-cache"})
    private static final class CollectState {
        @NotNull
        private final List<CompiledField> fields;

        public CollectState() {
            boolean bl = false;
            this.fields = new ArrayList();
        }

        @NotNull
        public final List<CompiledField> getFields() {
            return this.fields;
        }
    }
}

