/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.Logger;
import com.apollographql.apollo3.api.cache.http.HttpCache;
import com.apollographql.apollo3.api.cache.http.HttpCacheRecord;
import com.apollographql.apollo3.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo3.api.cache.http.HttpCacheStore;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.http.CacheResponseBody;
import com.apollographql.apollo3.cache.http.HttpCacheInterceptor;
import com.apollographql.apollo3.cache.http.ResponseBodyProxy;
import com.apollographql.apollo3.cache.http.ResponseHeaderRecord;
import com.apollographql.apollo3.cache.http.Utils;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ForwardingSource;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "Lcom/apollographql/apollo3/api/cache/http/HttpCache;", "cacheStore", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheStore;", "logger", "Lcom/apollographql/apollo3/api/Logger;", "(Lcom/apollographql/apollo3/api/cache/http/HttpCacheStore;Lcom/apollographql/apollo3/api/Logger;)V", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "abortQuietly", "", "cacheRecordEditor", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecordEditor;", "cacheProxy", "Lokhttp3/Response;", "response", "cacheKey", "", "clear", "closeQuietly", "cacheRecord", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecord;", "sink", "Lokio/Sink;", "interceptor", "Lokhttp3/Interceptor;", "read", "expireAfterRead", "", "remove", "removeQuietly", "write", "apollo-http-cache"})
public final class ApolloHttpCache
implements HttpCache {
    @NotNull
    private final HttpCacheStore cacheStore;
    @NotNull
    private final ApolloLogger logger;

    @JvmOverloads
    public ApolloHttpCache(@NotNull HttpCacheStore cacheStore, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)cacheStore, (String)"cacheStore");
        this.cacheStore = (HttpCacheStore)com.apollographql.apollo3.api.internal.Utils.checkNotNull((Object)cacheStore, (Object)"cacheStore == null");
        this.logger = new ApolloLogger(logger);
    }

    public /* synthetic */ ApolloHttpCache(HttpCacheStore httpCacheStore, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = null;
        }
        this(httpCacheStore, logger);
    }

    public void clear() {
        try {
            this.cacheStore.delete();
        }
        catch (IOException e) {
            this.logger.e((Throwable)e, "Failed to clear http cache", new Object[0]);
        }
    }

    public void remove(@NotNull String cacheKey) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        this.cacheStore.remove(cacheKey);
    }

    public void removeQuietly(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        try {
            this.remove(cacheKey);
        }
        catch (Exception ignore) {
            Object[] objectArray = new Object[]{cacheKey};
            this.logger.w((Throwable)ignore, "Failed to remove cached record for key: %s", objectArray);
        }
    }

    @Nullable
    public Response read(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return this.read(cacheKey, false);
    }

    @Nullable
    public Response read(@NotNull String cacheKey, boolean expireAfterRead) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        HttpCacheRecord responseCacheRecord = null;
        try {
            responseCacheRecord = this.cacheStore.cacheRecord(cacheKey);
            if (responseCacheRecord == null) {
                return null;
            }
            HttpCacheRecord cacheRecord2 = responseCacheRecord;
            Source source = responseCacheRecord.bodySource();
            Source cacheResponseSource2 = (Source)new ForwardingSource(this, cacheRecord2, expireAfterRead, cacheKey, source){
                final /* synthetic */ ApolloHttpCache this$0;
                final /* synthetic */ HttpCacheRecord $cacheRecord;
                final /* synthetic */ boolean $expireAfterRead;
                final /* synthetic */ String $cacheKey;
                {
                    this.this$0 = $receiver;
                    this.$cacheRecord = $cacheRecord;
                    this.$expireAfterRead = $expireAfterRead;
                    this.$cacheKey = $cacheKey;
                    super($super_call_param$1);
                }

                public void close() throws IOException {
                    super.close();
                    this.this$0.closeQuietly(this.$cacheRecord);
                    if (this.$expireAfterRead) {
                        this.this$0.removeQuietly(this.$cacheKey);
                    }
                }
            };
            Response response2 = new ResponseHeaderRecord(responseCacheRecord.headerSource()).response();
            String contentType = response2.header("Content-Type");
            String contentLength = response2.header("Content-Length");
            response = response2.newBuilder().addHeader("X-APOLLO-FROM-CACHE", "true").body((ResponseBody)new CacheResponseBody(cacheResponseSource2, contentType, contentLength)).build();
        }
        catch (Exception e) {
            this.closeQuietly(responseCacheRecord);
            Object[] objectArray = new Object[]{cacheKey};
            this.logger.e((Throwable)e, "Failed to read http cache entry for key: %s", objectArray);
            response = null;
        }
        return response;
    }

    @NotNull
    public Interceptor interceptor() {
        return new HttpCacheInterceptor(this, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response cacheProxy(@NotNull Response response, @NotNull String cacheKey) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            Request request = response.request();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"response.request()");
            if (Utils.INSTANCE.skipStoreResponse(request)) {
                return response;
            }
            HttpCacheRecordEditor cacheRecordEditor2 = null;
            try {
                cacheRecordEditor2 = this.cacheStore.cacheRecordEditor(cacheKey);
                if (cacheRecordEditor2 == null) break block6;
                Sink headerSink = cacheRecordEditor2.headerSink();
                try {
                    new ResponseHeaderRecord(response).writeTo(headerSink);
                }
                finally {
                    this.closeQuietly(headerSink);
                }
                Response response2 = response.newBuilder().body((ResponseBody)new ResponseBodyProxy(cacheRecordEditor2, response, this.logger)).build();
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response.newBuilder()\n            .body(ResponseBodyProxy(cacheRecordEditor, response, logger))\n            .build()");
                return response2;
            }
            catch (Exception e) {
                this.abortQuietly(cacheRecordEditor2);
                Object[] objectArray = new Object[]{cacheKey};
                this.logger.e((Throwable)e, "Failed to proxy http response for key: %s", objectArray);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull Response response, @NotNull String cacheKey) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            HttpCacheRecordEditor cacheRecordEditor2 = null;
            try {
                cacheRecordEditor2 = this.cacheStore.cacheRecordEditor(cacheKey);
                if (cacheRecordEditor2 == null) break block8;
                Sink headerSink = cacheRecordEditor2.headerSink();
                try {
                    new ResponseHeaderRecord(response).writeTo(headerSink);
                }
                finally {
                    this.closeQuietly(headerSink);
                }
                Sink bodySink = cacheRecordEditor2.bodySink();
                try {
                    Utils.INSTANCE.copyResponseBody(response, bodySink);
                }
                finally {
                    this.closeQuietly(bodySink);
                }
                cacheRecordEditor2.commit();
            }
            catch (Exception e) {
                this.abortQuietly(cacheRecordEditor2);
                Object[] objectArray = new Object[]{cacheKey};
                this.logger.e((Throwable)e, "Failed to cache http response for key: %s", objectArray);
            }
        }
    }

    public final void closeQuietly(@Nullable HttpCacheRecord cacheRecord2) {
        try {
            HttpCacheRecord httpCacheRecord = cacheRecord2;
            if (httpCacheRecord != null) {
                httpCacheRecord.close();
            }
        }
        catch (Exception ignore) {
            this.logger.w((Throwable)ignore, "Failed to close cache record", new Object[0]);
        }
    }

    private final void abortQuietly(HttpCacheRecordEditor cacheRecordEditor2) {
        try {
            HttpCacheRecordEditor httpCacheRecordEditor = cacheRecordEditor2;
            if (httpCacheRecordEditor != null) {
                httpCacheRecordEditor.abort();
            }
        }
        catch (Exception ignore) {
            this.logger.w((Throwable)ignore, "Failed to abort cache record edit", new Object[0]);
        }
    }

    private final void closeQuietly(Sink sink) {
        try {
            sink.close();
        }
        catch (Exception ignore) {
            this.logger.w((Throwable)ignore, "Failed to close sink", new Object[0]);
        }
    }

    @JvmOverloads
    public ApolloHttpCache(@NotNull HttpCacheStore cacheStore) {
        Intrinsics.checkNotNullParameter((Object)cacheStore, (String)"cacheStore");
        this(cacheStore, null, 2, null);
    }
}

