/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.api.QueryDocumentMinifier;
import com.apollographql.apollo3.compiler.ApolloMetadata;
import com.apollographql.apollo3.compiler.MetadataFragment;
import com.apollographql.apollo3.compiler.OperationIdGenerator;
import com.apollographql.apollo3.compiler.OperationOutputGenerator;
import com.apollographql.apollo3.compiler.PackageNameProvider;
import com.apollographql.apollo3.compiler.Roots;
import com.apollographql.apollo3.compiler.VersionKt;
import com.apollographql.apollo3.compiler.frontend.Add_typenameKt;
import com.apollographql.apollo3.compiler.frontend.GQLDocument;
import com.apollographql.apollo3.compiler.frontend.GQLFragmentDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLOperationDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLScalarTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GraphQLParser;
import com.apollographql.apollo3.compiler.frontend.Issue;
import com.apollographql.apollo3.compiler.frontend.Schema;
import com.apollographql.apollo3.compiler.frontend.SourceAwareException;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import com.apollographql.apollo3.compiler.operationoutput.OperationOutputKt;
import com.apollographql.apollo3.compiler.unified.codegen.KotlinCodeGenerator;
import com.apollographql.apollo3.compiler.unified.ir.IntermediateRepresentation;
import com.apollographql.apollo3.compiler.unified.ir.IrBuilder;
import com.apollographql.apollo3.compiler.unified.ir.IrDumperKt;
import com.apollographql.apollo3.compiler.unified.ir.IrEnum;
import com.apollographql.apollo3.compiler.unified.ir.IrInputObject;
import com.apollographql.apollo3.compiler.unified.ir.IrOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J8\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler;", "", "()V", "checkCustomScalars", "", "incomingOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "write", "operationFiles", "", "Ljava/io/File;", "outputDir", "debugDir", "moduleOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "Companion", "IncomingOptions", "Logger", "ModuleOptions", "apollo-compiler"})
public final class GraphQLCompiler {
    @NotNull
    private static final Logger NoOpLogger;
    @NotNull
    private static final List<MetadataFragment> defaultMetadataFragments;
    @NotNull
    private static final Set<String> defaultMetadataInputObjects;
    @NotNull
    private static final Set<String> defaultMetadataEnums;
    private static final boolean defaultMetadataCustomScalars;
    @NotNull
    private static final PackageNameProvider.Flat defaultPackageNameProvider;
    @NotNull
    private static final Set<String> defaultAlwaysGenerateTypesMatching;
    @Nullable
    private static final Void defaultOperationOutputFile;
    @NotNull
    private static final OperationOutputGenerator.Default defaultOperationOutputGenerator;
    @NotNull
    private static final Map<String, String> defaultCustomScalarsMapping;
    private static final boolean defaultUseSemanticNaming;
    private static final boolean defaultWarnOnDeprecatedUsages;
    private static final boolean defaultFailOnWarnings;
    @NotNull
    private static final Logger defaultLogger;
    private static final boolean defaultGenerateAsInternal;
    private static final boolean defaultGenerateFilterNotNull;
    private static final boolean defaultGenerateFragmentsAsInterfaces;
    private static final boolean defaultGenerateFragmentImplementations;
    private static final boolean defaultGenerateResponseFields;
    private static final boolean defaultGenerateQueryDocument;
    @NotNull
    private static final String defaultModuleName;
    @Nullable
    private static final Void defaultMetadataOutputFile;
    @NotNull
    private static final ModuleOptions DefaultModuleOptions;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull Set<? extends File> operationFiles, @NotNull File outputDir, @Nullable File debugDir, @NotNull IncomingOptions incomingOptions, @NotNull ModuleOptions moduleOptions) {
        void $this$mapTo$iv$iv5222;
        Set<String> $this$mapTo$iv$iv2;
        void $this$map$iv;
        Object object;
        Object $this$filterIsInstanceTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Iterable destination$iv$iv;
        void $this$flatMapTo$iv$iv2;
        void documents;
        Iterable<Object> element$iv32;
        void errors;
        Object object2;
        Object object3;
        void $this$mapTo$iv$iv4;
        void $this$map$iv3;
        Intrinsics.checkParameterIsNotNull(operationFiles, (String)"operationFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)incomingOptions, (String)"incomingOptions");
        Intrinsics.checkParameterIsNotNull((Object)moduleOptions, (String)"moduleOptions");
        this.checkCustomScalars(incomingOptions);
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        File file = debugDir;
        Boolean bl = file != null ? Boolean.valueOf(FilesKt.deleteRecursively((File)file)) : null;
        File file2 = debugDir;
        Boolean bl2 = file2 != null ? Boolean.valueOf(file2.mkdirs()) : null;
        Iterable iterable = incomingOptions.getMetadataFragments();
        Schema schema = incomingOptions.getSchema();
        Object object4 = operationFiles;
        Object object5 = GraphQLParser.INSTANCE;
        boolean $i$f$map232 = false;
        void var11_12 = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it2;
            MetadataFragment metadataFragment = (MetadataFragment)item$iv$iv;
            object3 = destination$iv$iv2;
            boolean bl3 = false;
            object2 = it2.getDefinition();
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv2;
        Object object6 = ((GraphQLParser)object5).parseExecutableFiles((Set<? extends File>)object4, schema, (List<GQLFragmentDefinition>)object3);
        List list = (List)object6.component1();
        List issues = (List)object6.component2();
        Iterable $this$partition$iv = issues;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            Issue it3 = (Issue)element$iv2;
            boolean bl4 = false;
            if (it3.getSeverity() == Issue.Severity.ERROR) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair $i$f$map232 = new Pair(first$iv, second$iv);
        object6 = (List)$i$f$map232.component1();
        List warnings = (List)$i$f$map232.component2();
        Issue firstError = (Issue)CollectionsKt.firstOrNull((List)errors);
        if (firstError != null) {
            throw (Throwable)new SourceAwareException(firstError.getMessage(), firstError.getSourceLocation());
        }
        if (moduleOptions.getWarnOnDeprecatedUsages()) {
            Iterable $this$forEach$iv = warnings;
            boolean $i$f$forEach = false;
            for (Iterable<Object> element$iv32 : $this$forEach$iv) {
                Issue it4 = (Issue)((Object)element$iv32);
                boolean bl5 = false;
                int column = it4.getSourceLocation().getPosition() + 1;
                moduleOptions.getLogger().warning("w: " + it4.getSourceLocation().getFilePath() + ':' + it4.getSourceLocation().getLine() + ':' + column + ": ApolloGraphQL: " + it4.getMessage());
            }
            if (moduleOptions.getFailOnWarnings()) {
                $this$forEach$iv = warnings;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    throw (Throwable)new IllegalStateException("ApolloGraphQL: Warnings found and 'failOnWarnings' is true, aborting.");
                }
            }
        }
        Iterable $this$flatMap$iv = (Iterable)documents;
        boolean $i$f$flatMap = false;
        element$iv32 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$filterIsInstanceTo$iv$iv2;
            GQLDocument gQLDocument = (GQLDocument)element$iv$iv;
            boolean bl6 = false;
            Iterable $this$filterIsInstance$iv = gQLDocument.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv2 instanceof GQLFragmentDefinition)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)iterable3);
        }
        $this$flatMap$iv = (List)destination$iv$iv3;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv2;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)item$iv$iv;
            object5 = destination$iv$iv4;
            boolean bl7 = false;
            object4 = Add_typenameKt.withTypenameWhenNeeded(gQLFragmentDefinition, incomingOptions.getSchema());
            object5.add(object4);
        }
        List fragments = (List)destination$iv$iv4;
        Iterable $this$flatMap$iv2 = (Iterable)documents;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv4 = $this$flatMap$iv2;
        Collection destination$iv$iv42 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            GQLDocument it5 = (GQLDocument)t;
            boolean bl8 = false;
            Iterable $this$filterIsInstance$iv = it5.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            object = $this$filterIsInstanceTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv3 = object.next();
                if (!(element$iv$iv3 instanceof GQLOperationDefinition)) continue;
                destination$iv$iv5.add(element$iv$iv3);
            }
            Iterable list$iv$iv2 = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv42, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv42;
        boolean $i$f$map3 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        Set<String> destination$iv$iv5 = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo2232 = false;
        for (Object t : $this$mapTo$iv$iv2) {
            void it6;
            GQLOperationDefinition list$iv$iv2 = (GQLOperationDefinition)t;
            object5 = destination$iv$iv5;
            boolean bl9 = false;
            object4 = Add_typenameKt.withTypenameWhenNeeded((GQLOperationDefinition)it6, incomingOptions.getSchema());
            object5.add(object4);
        }
        List operations = (List)((Object)destination$iv$iv5);
        $i$f$map3 = incomingOptions.isFromMetadata();
        $this$mapTo$iv$iv2 = incomingOptions.getMetadataInputObjects();
        destination$iv$iv5 = incomingOptions.getMetadataEnums();
        Iterable<MetadataFragment> $i$f$mapTo2232 = incomingOptions.getMetadataFragments();
        boolean item$iv$iv = incomingOptions.getGenerateFragmentsAsInterfaces();
        IntermediateRepresentation ir = new IrBuilder(incomingOptions.getSchema(), operations, fragments, moduleOptions.getAlwaysGenerateTypesMatching(), incomingOptions.getCustomScalarsMapping(), (List<MetadataFragment>)$i$f$mapTo2232, destination$iv$iv5, $this$mapTo$iv$iv2, item$iv$iv, $i$f$map3).build();
        if (debugDir != null) {
            IrDumperKt.dumpTo(ir, new File(debugDir, "ir.json"));
        }
        Iterable $this$map$iv2232 = ir.getOperations();
        boolean $i$f$map4 = false;
        $i$f$mapTo2232 = $this$map$iv2232;
        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2232, (int)10));
        boolean bl3 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv5222) {
            void it7;
            IrOperation $this$filterIsInstance$iv = (IrOperation)item$iv$iv2;
            object5 = destination$iv$iv6;
            boolean bl10 = false;
            object4 = new OperationDescriptor(it7.getName(), QueryDocumentMinifier.minify(it7.getSourceWithFragments()));
            object5.add(object4);
        }
        $this$map$iv2232 = (List)destination$iv$iv6;
        $i$f$map4 = false;
        boolean $this$mapTo$iv$iv5222 = false;
        Iterable it8 = $this$map$iv2232;
        boolean bl4 = false;
        Map<String, OperationDescriptor> operationOutput = moduleOptions.getOperationOutputGenerator().generate((Collection)it8);
        boolean $this$map$iv2232 = operationOutput.size() == operations.size();
        $i$f$map4 = false;
        $this$mapTo$iv$iv5222 = false;
        if (!$this$map$iv2232) {
            boolean bl12 = false;
            String $this$mapTo$iv$iv5222 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw (Throwable)new IllegalStateException($this$mapTo$iv$iv5222.toString());
        }
        if (moduleOptions.getOperationOutputFile() != null) {
            FilesKt.writeText$default((File)moduleOptions.getOperationOutputFile(), (String)OperationOutputKt.toJson(operationOutput, "  "), null, (int)2, null);
        }
        $this$map$iv2232 = moduleOptions.getGenerateQueryDocument();
        $i$f$map4 = moduleOptions.getGenerateResponseFields();
        $this$mapTo$iv$iv5222 = moduleOptions.getGenerateFragmentImplementations();
        boolean bl12 = incomingOptions.getGenerateFragmentsAsInterfaces();
        boolean bl5 = moduleOptions.getGenerateFilterNotNull();
        boolean it6 = !incomingOptions.isFromMetadata();
        String item$iv$iv2 = incomingOptions.getSchemaPackageName() + ".type";
        Object object7 = moduleOptions.getPackageNameProvider();
        boolean bl10 = moduleOptions.getUseSemanticNaming();
        $this$filterIsInstanceTo$iv$iv = operationOutput;
        new KotlinCodeGenerator(ir, moduleOptions.getGenerateAsInternal(), bl10, (PackageNameProvider)object7, item$iv$iv2, (Map<String, OperationDescriptor>)$this$filterIsInstanceTo$iv$iv, it6, bl5, $this$mapTo$iv$iv5222, $i$f$map4, $this$map$iv2232, bl12).write(outputDir);
        if (moduleOptions.getMetadataOutputFile() != null) {
            Object object8;
            IrInputObject it;
            Collection collection;
            Iterable $this$map$iv4;
            IrEnum it9;
            moduleOptions.getMetadataOutputFile().getParentFile().mkdirs();
            Schema schema2 = incomingOptions.isFromMetadata() ? null : incomingOptions.getSchema();
            Iterable $this$map$iv42 = fragments;
            boolean $i$f$map5 = false;
            Iterable iterable4 = $this$map$iv42;
            Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv42, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv3 : iterable4) {
                $this$filterIsInstanceTo$iv$iv = (GQLFragmentDefinition)item$iv$iv3;
                object5 = destination$iv$iv7;
                boolean bl13 = false;
                String string = ((GQLFragmentDefinition)((Object)it9)).getName();
                PackageNameProvider packageNameProvider = moduleOptions.getPackageNameProvider();
                String string2 = ((GQLFragmentDefinition)((Object)it9)).getSourceLocation().getFilePath();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                void var26_104 = it9;
                object = packageNameProvider.fragmentPackageName(string2);
                object4 = new MetadataFragment(string, (GQLFragmentDefinition)var26_104, (String)object);
                object5.add(object4);
            }
            List outgoingMetadataFragments = (List)destination$iv$iv7;
            $this$map$iv42 = ir.getEnums();
            object2 = outgoingMetadataFragments;
            object3 = incomingOptions.getCustomScalarsMapping();
            schema = schema2;
            boolean $i$f$map2 = false;
            void var19_67 = $this$map$iv4;
            Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : var19_67) {
                it9 = (IrEnum)item$iv$iv4;
                collection = destination$iv$iv8;
                boolean bl14 = false;
                object8 = ((IrEnum)((Object)it)).getName();
                collection.add(object8);
            }
            collection = (List)destination$iv$iv8;
            $this$map$iv4 = ir.getInputObjects();
            collection = CollectionsKt.toSet((Iterable)collection);
            $i$f$map2 = false;
            Iterable iterable5 = $this$map$iv4;
            destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv5 : iterable5) {
                it = (IrInputObject)item$iv$iv5;
                object8 = destination$iv$iv8;
                boolean bl15 = false;
                String string = it.getName();
                object8.add(string);
            }
            object8 = (List)destination$iv$iv8;
            String string = incomingOptions.getSchemaPackageName();
            String string3 = VersionKt.getVERSION();
            String string4 = moduleOptions.getModuleName();
            boolean bl6 = incomingOptions.getGenerateFragmentsAsInterfaces();
            Set set = CollectionsKt.toSet((Iterable)((Iterable)object8));
            object7 = collection;
            Object object9 = object2;
            Object object10 = object3;
            boolean bl7 = bl6;
            Object object11 = object10;
            String string5 = string3;
            String string6 = string4;
            String string7 = string;
            Set set2 = set;
            Object object12 = object7;
            Object object13 = object9;
            Schema schema3 = schema;
            new ApolloMetadata(schema3, (List<MetadataFragment>)object13, (Set<String>)object12, set2, string7, string6, string5, (Map<String, String>)object11, bl7).writeTo(moduleOptions.getMetadataOutputFile());
        }
    }

    public static /* synthetic */ void write$default(GraphQLCompiler graphQLCompiler, Set set, File file, File file2, IncomingOptions incomingOptions, ModuleOptions moduleOptions, int n, Object object) {
        if ((n & 4) != 0) {
            file2 = null;
        }
        graphQLCompiler.write(set, file, file2, incomingOptions, moduleOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCustomScalars(IncomingOptions incomingOptions) {
        void $this$mapTo$iv$iv;
        GQLScalarTypeDefinition it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = incomingOptions.getSchema().getTypeDefinitions().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLScalarTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GQLScalarTypeDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBuiltIn())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            it = (GQLScalarTypeDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = type.getName();
            collection.add(string);
        }
        Set schemaScalars = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set unknownScalars = CollectionsKt.subtract((Iterable)incomingOptions.getCustomScalarsMapping().keySet(), (Iterable)schemaScalars);
        boolean bl = unknownScalars.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "ApolloGraphQL: unknown custom scalar(s): " + CollectionsKt.joinToString$default((Iterable)unknownScalars, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    static {
        Companion = new Companion(null);
        NoOpLogger = new Logger(){

            public void warning(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            }
        };
        defaultMetadataFragments = CollectionsKt.emptyList();
        defaultMetadataInputObjects = SetsKt.emptySet();
        defaultMetadataEnums = SetsKt.emptySet();
        defaultPackageNameProvider = new PackageNameProvider.Flat("com.apollographql.generated");
        defaultAlwaysGenerateTypesMatching = SetsKt.emptySet();
        defaultOperationOutputGenerator = new OperationOutputGenerator.Default(OperationIdGenerator.Sha256.INSTANCE);
        defaultCustomScalarsMapping = MapsKt.emptyMap();
        defaultUseSemanticNaming = true;
        defaultWarnOnDeprecatedUsages = true;
        defaultLogger = NoOpLogger;
        defaultGenerateResponseFields = true;
        defaultGenerateQueryDocument = true;
        String string = defaultModuleName = "apollographql";
        File file = (File)((Object)defaultMetadataOutputFile);
        PackageNameProvider packageNameProvider = defaultPackageNameProvider;
        boolean bl = defaultGenerateQueryDocument;
        boolean bl2 = defaultGenerateResponseFields;
        boolean bl3 = defaultGenerateFragmentImplementations;
        boolean bl4 = defaultGenerateFilterNotNull;
        boolean bl5 = defaultGenerateAsInternal;
        Logger logger2 = defaultLogger;
        boolean bl6 = defaultFailOnWarnings;
        boolean bl7 = defaultWarnOnDeprecatedUsages;
        boolean bl8 = defaultUseSemanticNaming;
        OperationOutputGenerator operationOutputGenerator = defaultOperationOutputGenerator;
        File file2 = (File)((Object)defaultOperationOutputFile);
        DefaultModuleOptions = new ModuleOptions(defaultAlwaysGenerateTypesMatching, file, packageNameProvider, file2, operationOutputGenerator, bl8, bl7, bl6, logger2, bl5, bl4, bl3, bl2, bl, string);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0006\u0010\r\u001a\u00020\t\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "", "schema", "Lcom/apollographql/apollo3/compiler/frontend/Schema;", "schemaPackageName", "", "customScalarsMapping", "", "generateFragmentsAsInterfaces", "", "metadataInputObjects", "", "metadataEnums", "isFromMetadata", "metadataFragments", "", "Lcom/apollographql/apollo3/compiler/MetadataFragment;", "(Lcom/apollographql/apollo3/compiler/frontend/Schema;Ljava/lang/String;Ljava/util/Map;ZLjava/util/Set;Ljava/util/Set;ZLjava/util/List;)V", "getCustomScalarsMapping", "()Ljava/util/Map;", "getGenerateFragmentsAsInterfaces", "()Z", "getMetadataEnums", "()Ljava/util/Set;", "getMetadataFragments", "()Ljava/util/List;", "getMetadataInputObjects", "getSchema", "()Lcom/apollographql/apollo3/compiler/frontend/Schema;", "getSchemaPackageName", "()Ljava/lang/String;", "Companion", "apollo-compiler"})
    public static final class IncomingOptions {
        @NotNull
        private final Schema schema;
        @NotNull
        private final String schemaPackageName;
        @NotNull
        private final Map<String, String> customScalarsMapping;
        private final boolean generateFragmentsAsInterfaces;
        @NotNull
        private final Set<String> metadataInputObjects;
        @NotNull
        private final Set<String> metadataEnums;
        private final boolean isFromMetadata;
        @NotNull
        private final List<MetadataFragment> metadataFragments;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Schema getSchema() {
            return this.schema;
        }

        @NotNull
        public final String getSchemaPackageName() {
            return this.schemaPackageName;
        }

        @NotNull
        public final Map<String, String> getCustomScalarsMapping() {
            return this.customScalarsMapping;
        }

        public final boolean getGenerateFragmentsAsInterfaces() {
            return this.generateFragmentsAsInterfaces;
        }

        @NotNull
        public final Set<String> getMetadataInputObjects() {
            return this.metadataInputObjects;
        }

        @NotNull
        public final Set<String> getMetadataEnums() {
            return this.metadataEnums;
        }

        public final boolean isFromMetadata() {
            return this.isFromMetadata;
        }

        @NotNull
        public final List<MetadataFragment> getMetadataFragments() {
            return this.metadataFragments;
        }

        public IncomingOptions(@NotNull Schema schema, @NotNull String schemaPackageName, @NotNull Map<String, String> customScalarsMapping, boolean generateFragmentsAsInterfaces, @NotNull Set<String> metadataInputObjects, @NotNull Set<String> metadataEnums, boolean isFromMetadata, @NotNull List<MetadataFragment> metadataFragments) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
            Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
            Intrinsics.checkParameterIsNotNull(metadataInputObjects, (String)"metadataInputObjects");
            Intrinsics.checkParameterIsNotNull(metadataEnums, (String)"metadataEnums");
            Intrinsics.checkParameterIsNotNull(metadataFragments, (String)"metadataFragments");
            this.schema = schema;
            this.schemaPackageName = schemaPackageName;
            this.customScalarsMapping = customScalarsMapping;
            this.generateFragmentsAsInterfaces = generateFragmentsAsInterfaces;
            this.metadataInputObjects = metadataInputObjects;
            this.metadataEnums = metadataEnums;
            this.isFromMetadata = isFromMetadata;
            this.metadataFragments = metadataFragments;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions$Companion;", "", "()V", "from", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$IncomingOptions;", "roots", "Lcom/apollographql/apollo3/compiler/Roots;", "schemaFile", "Ljava/io/File;", "customScalarsMapping", "", "", "generateFragmentsAsInterfaces", "", "rootPackageName", "fromMetadata", "metadata", "Lcom/apollographql/apollo3/compiler/ApolloMetadata;", "apollo-compiler"})
        public static final class Companion {
            @NotNull
            public final IncomingOptions fromMetadata(@NotNull ApolloMetadata metadata) {
                Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
                Schema schema = metadata.getSchema();
                if (schema == null) {
                    Intrinsics.throwNpe();
                }
                return new IncomingOptions(schema, metadata.getSchemaPackageName(), metadata.getCustomScalarsMapping(), metadata.getGenerateFragmentsAsInterfaces(), metadata.getGeneratedInputObjects(), metadata.getGeneratedEnums(), true, metadata.getGeneratedFragments());
            }

            @NotNull
            public final IncomingOptions from(@NotNull Roots roots, @NotNull File schemaFile, @NotNull Map<String, String> customScalarsMapping, boolean generateFragmentsAsInterfaces, @NotNull String rootPackageName) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
                Intrinsics.checkParameterIsNotNull((Object)schemaFile, (String)"schemaFile");
                Intrinsics.checkParameterIsNotNull(customScalarsMapping, (String)"customScalarsMapping");
                Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
                try {
                    String string2 = schemaFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"schemaFile.absolutePath");
                    string = roots.filePackageName(string2);
                }
                catch (Exception e) {
                    string = "";
                }
                String relativeSchemaPackageName = string;
                return new IncomingOptions(Schema.Companion.fromFile(schemaFile), StringsKt.removeSuffix((String)StringsKt.removePrefix((String)(rootPackageName + '.' + relativeSchemaPackageName), (CharSequence)"."), (CharSequence)"."), customScalarsMapping, generateFragmentsAsInterfaces, SetsKt.emptySet(), SetsKt.emptySet(), false, CollectionsKt.emptyList());
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\u0006\u0010\u0013\u001a\u00020\r\u0012\u0006\u0010\u0014\u001a\u00020\r\u0012\u0006\u0010\u0015\u001a\u00020\r\u0012\u0006\u0010\u0016\u001a\u00020\r\u0012\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0018J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\rH\u00c6\u0003J\t\u00101\u001a\u00020\rH\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\t\u00103\u001a\u00020\rH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\t\u00105\u001a\u00020\u0004H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\bH\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\u000bH\u00c6\u0003J\t\u0010:\u001a\u00020\rH\u00c6\u0003J\t\u0010;\u001a\u00020\rH\u00c6\u0003J\t\u0010<\u001a\u00020\rH\u00c6\u0003J\t\u0010=\u001a\u00020\u0011H\u00c6\u0003J\u00a9\u0001\u0010>\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010?\u001a\u00020\r2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020BH\u00d6\u0001J\t\u0010C\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u0013\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001c\u00a8\u0006D"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "", "alwaysGenerateTypesMatching", "", "", "metadataOutputFile", "Ljava/io/File;", "packageNameProvider", "Lcom/apollographql/apollo3/compiler/PackageNameProvider;", "operationOutputFile", "operationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "useSemanticNaming", "", "warnOnDeprecatedUsages", "failOnWarnings", "logger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "generateAsInternal", "generateFilterNotNull", "generateFragmentImplementations", "generateResponseFields", "generateQueryDocument", "moduleName", "(Ljava/util/Set;Ljava/io/File;Lcom/apollographql/apollo3/compiler/PackageNameProvider;Ljava/io/File;Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;ZZZLcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;ZZZZZLjava/lang/String;)V", "getAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "getFailOnWarnings", "()Z", "getGenerateAsInternal", "getGenerateFilterNotNull", "getGenerateFragmentImplementations", "getGenerateQueryDocument", "getGenerateResponseFields", "getLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getMetadataOutputFile", "()Ljava/io/File;", "getModuleName", "()Ljava/lang/String;", "getOperationOutputFile", "getOperationOutputGenerator", "()Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "getPackageNameProvider", "()Lcom/apollographql/apollo3/compiler/PackageNameProvider;", "getUseSemanticNaming", "getWarnOnDeprecatedUsages", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "apollo-compiler"})
    public static final class ModuleOptions {
        @NotNull
        private final Set<String> alwaysGenerateTypesMatching;
        @Nullable
        private final File metadataOutputFile;
        @NotNull
        private final PackageNameProvider packageNameProvider;
        @Nullable
        private final File operationOutputFile;
        @NotNull
        private final OperationOutputGenerator operationOutputGenerator;
        private final boolean useSemanticNaming;
        private final boolean warnOnDeprecatedUsages;
        private final boolean failOnWarnings;
        @NotNull
        private final Logger logger;
        private final boolean generateAsInternal;
        private final boolean generateFilterNotNull;
        private final boolean generateFragmentImplementations;
        private final boolean generateResponseFields;
        private final boolean generateQueryDocument;
        @NotNull
        private final String moduleName;

        @NotNull
        public final Set<String> getAlwaysGenerateTypesMatching() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File getMetadataOutputFile() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final PackageNameProvider getPackageNameProvider() {
            return this.packageNameProvider;
        }

        @Nullable
        public final File getOperationOutputFile() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator getOperationOutputGenerator() {
            return this.operationOutputGenerator;
        }

        public final boolean getUseSemanticNaming() {
            return this.useSemanticNaming;
        }

        public final boolean getWarnOnDeprecatedUsages() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        public final boolean getGenerateAsInternal() {
            return this.generateAsInternal;
        }

        public final boolean getGenerateFilterNotNull() {
            return this.generateFilterNotNull;
        }

        public final boolean getGenerateFragmentImplementations() {
            return this.generateFragmentImplementations;
        }

        public final boolean getGenerateResponseFields() {
            return this.generateResponseFields;
        }

        public final boolean getGenerateQueryDocument() {
            return this.generateQueryDocument;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        public ModuleOptions(@NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File metadataOutputFile, @NotNull PackageNameProvider packageNameProvider, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @NotNull Logger logger2, boolean generateAsInternal, boolean generateFilterNotNull, boolean generateFragmentImplementations, boolean generateResponseFields, boolean generateQueryDocument, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)logger2, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            this.alwaysGenerateTypesMatching = alwaysGenerateTypesMatching;
            this.metadataOutputFile = metadataOutputFile;
            this.packageNameProvider = packageNameProvider;
            this.operationOutputFile = operationOutputFile;
            this.operationOutputGenerator = operationOutputGenerator;
            this.useSemanticNaming = useSemanticNaming;
            this.warnOnDeprecatedUsages = warnOnDeprecatedUsages;
            this.failOnWarnings = failOnWarnings;
            this.logger = logger2;
            this.generateAsInternal = generateAsInternal;
            this.generateFilterNotNull = generateFilterNotNull;
            this.generateFragmentImplementations = generateFragmentImplementations;
            this.generateResponseFields = generateResponseFields;
            this.generateQueryDocument = generateQueryDocument;
            this.moduleName = moduleName;
        }

        @NotNull
        public final Set<String> component1() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File component2() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final PackageNameProvider component3() {
            return this.packageNameProvider;
        }

        @Nullable
        public final File component4() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator component5() {
            return this.operationOutputGenerator;
        }

        public final boolean component6() {
            return this.useSemanticNaming;
        }

        public final boolean component7() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean component8() {
            return this.failOnWarnings;
        }

        @NotNull
        public final Logger component9() {
            return this.logger;
        }

        public final boolean component10() {
            return this.generateAsInternal;
        }

        public final boolean component11() {
            return this.generateFilterNotNull;
        }

        public final boolean component12() {
            return this.generateFragmentImplementations;
        }

        public final boolean component13() {
            return this.generateResponseFields;
        }

        public final boolean component14() {
            return this.generateQueryDocument;
        }

        @NotNull
        public final String component15() {
            return this.moduleName;
        }

        @NotNull
        public final ModuleOptions copy(@NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File metadataOutputFile, @NotNull PackageNameProvider packageNameProvider, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @NotNull Logger logger2, boolean generateAsInternal, boolean generateFilterNotNull, boolean generateFragmentImplementations, boolean generateResponseFields, boolean generateQueryDocument, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, (String)"alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)logger2, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            return new ModuleOptions(alwaysGenerateTypesMatching, metadataOutputFile, packageNameProvider, operationOutputFile, operationOutputGenerator, useSemanticNaming, warnOnDeprecatedUsages, failOnWarnings, logger2, generateAsInternal, generateFilterNotNull, generateFragmentImplementations, generateResponseFields, generateQueryDocument, moduleName);
        }

        public static /* synthetic */ ModuleOptions copy$default(ModuleOptions moduleOptions, Set set, File file, PackageNameProvider packageNameProvider, File file2, OperationOutputGenerator operationOutputGenerator, boolean bl, boolean bl2, boolean bl3, Logger logger2, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String string, int n, Object object) {
            if ((n & 1) != 0) {
                set = moduleOptions.alwaysGenerateTypesMatching;
            }
            if ((n & 2) != 0) {
                file = moduleOptions.metadataOutputFile;
            }
            if ((n & 4) != 0) {
                packageNameProvider = moduleOptions.packageNameProvider;
            }
            if ((n & 8) != 0) {
                file2 = moduleOptions.operationOutputFile;
            }
            if ((n & 0x10) != 0) {
                operationOutputGenerator = moduleOptions.operationOutputGenerator;
            }
            if ((n & 0x20) != 0) {
                bl = moduleOptions.useSemanticNaming;
            }
            if ((n & 0x40) != 0) {
                bl2 = moduleOptions.warnOnDeprecatedUsages;
            }
            if ((n & 0x80) != 0) {
                bl3 = moduleOptions.failOnWarnings;
            }
            if ((n & 0x100) != 0) {
                logger2 = moduleOptions.logger;
            }
            if ((n & 0x200) != 0) {
                bl4 = moduleOptions.generateAsInternal;
            }
            if ((n & 0x400) != 0) {
                bl5 = moduleOptions.generateFilterNotNull;
            }
            if ((n & 0x800) != 0) {
                bl6 = moduleOptions.generateFragmentImplementations;
            }
            if ((n & 0x1000) != 0) {
                bl7 = moduleOptions.generateResponseFields;
            }
            if ((n & 0x2000) != 0) {
                bl8 = moduleOptions.generateQueryDocument;
            }
            if ((n & 0x4000) != 0) {
                string = moduleOptions.moduleName;
            }
            return moduleOptions.copy(set, file, packageNameProvider, file2, operationOutputGenerator, bl, bl2, bl3, logger2, bl4, bl5, bl6, bl7, bl8, string);
        }

        @NotNull
        public String toString() {
            return "ModuleOptions(alwaysGenerateTypesMatching=" + this.alwaysGenerateTypesMatching + ", metadataOutputFile=" + this.metadataOutputFile + ", packageNameProvider=" + this.packageNameProvider + ", operationOutputFile=" + this.operationOutputFile + ", operationOutputGenerator=" + this.operationOutputGenerator + ", useSemanticNaming=" + this.useSemanticNaming + ", warnOnDeprecatedUsages=" + this.warnOnDeprecatedUsages + ", failOnWarnings=" + this.failOnWarnings + ", logger=" + this.logger + ", generateAsInternal=" + this.generateAsInternal + ", generateFilterNotNull=" + this.generateFilterNotNull + ", generateFragmentImplementations=" + this.generateFragmentImplementations + ", generateResponseFields=" + this.generateResponseFields + ", generateQueryDocument=" + this.generateQueryDocument + ", moduleName=" + this.moduleName + ")";
        }

        public int hashCode() {
            Set<String> set = this.alwaysGenerateTypesMatching;
            File file = this.metadataOutputFile;
            PackageNameProvider packageNameProvider = this.packageNameProvider;
            File file2 = this.operationOutputFile;
            OperationOutputGenerator operationOutputGenerator = this.operationOutputGenerator;
            int n = (((((set != null ? ((Object)set).hashCode() : 0) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (packageNameProvider != null ? packageNameProvider.hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (operationOutputGenerator != null ? operationOutputGenerator.hashCode() : 0)) * 31;
            int n2 = this.useSemanticNaming ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.warnOnDeprecatedUsages ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.failOnWarnings ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            Logger logger2 = this.logger;
            int n7 = ((n5 + n6) * 31 + (logger2 != null ? logger2.hashCode() : 0)) * 31;
            int n8 = this.generateAsInternal ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            int n9 = (n7 + n8) * 31;
            int n10 = this.generateFilterNotNull ? 1 : 0;
            if (n10 != 0) {
                n10 = 1;
            }
            int n11 = (n9 + n10) * 31;
            int n12 = this.generateFragmentImplementations ? 1 : 0;
            if (n12 != 0) {
                n12 = 1;
            }
            int n13 = (n11 + n12) * 31;
            int n14 = this.generateResponseFields ? 1 : 0;
            if (n14 != 0) {
                n14 = 1;
            }
            int n15 = (n13 + n14) * 31;
            int n16 = this.generateQueryDocument ? 1 : 0;
            if (n16 != 0) {
                n16 = 1;
            }
            String string = this.moduleName;
            return (n15 + n16) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleOptions)) break block3;
                    ModuleOptions moduleOptions = (ModuleOptions)object;
                    if (!Intrinsics.areEqual(this.alwaysGenerateTypesMatching, moduleOptions.alwaysGenerateTypesMatching) || !Intrinsics.areEqual((Object)this.metadataOutputFile, (Object)moduleOptions.metadataOutputFile) || !Intrinsics.areEqual((Object)this.packageNameProvider, (Object)moduleOptions.packageNameProvider) || !Intrinsics.areEqual((Object)this.operationOutputFile, (Object)moduleOptions.operationOutputFile) || !Intrinsics.areEqual((Object)this.operationOutputGenerator, (Object)moduleOptions.operationOutputGenerator) || this.useSemanticNaming != moduleOptions.useSemanticNaming || this.warnOnDeprecatedUsages != moduleOptions.warnOnDeprecatedUsages || this.failOnWarnings != moduleOptions.failOnWarnings || !Intrinsics.areEqual((Object)this.logger, (Object)moduleOptions.logger) || this.generateAsInternal != moduleOptions.generateAsInternal || this.generateFilterNotNull != moduleOptions.generateFilterNotNull || this.generateFragmentImplementations != moduleOptions.generateFragmentImplementations || this.generateResponseFields != moduleOptions.generateResponseFields || this.generateQueryDocument != moduleOptions.generateQueryDocument || !Intrinsics.areEqual((Object)this.moduleName, (Object)moduleOptions.moduleName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0014\u0010 \u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0011\u0010$\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u0014\u0010&\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0017R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000fR\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u000fR\u0013\u00101\u001a\u0004\u0018\u000102\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0013\u00108\u001a\u0004\u0018\u000102\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00104R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0017R\u0014\u0010D\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0017\u00a8\u0006F"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion;", "", "()V", "DefaultModuleOptions", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "getDefaultModuleOptions", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$ModuleOptions;", "NoOpLogger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "defaultAlwaysGenerateTypesMatching", "", "", "getDefaultAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "defaultCustomScalarsMapping", "", "getDefaultCustomScalarsMapping", "()Ljava/util/Map;", "defaultFailOnWarnings", "", "getDefaultFailOnWarnings", "()Z", "defaultGenerateAsInternal", "getDefaultGenerateAsInternal", "defaultGenerateFilterNotNull", "getDefaultGenerateFilterNotNull", "defaultGenerateFragmentImplementations", "getDefaultGenerateFragmentImplementations", "defaultGenerateFragmentsAsInterfaces", "getDefaultGenerateFragmentsAsInterfaces", "defaultGenerateQueryDocument", "getDefaultGenerateQueryDocument", "defaultGenerateResponseFields", "getDefaultGenerateResponseFields", "defaultLogger", "getDefaultLogger", "defaultMetadataCustomScalars", "getDefaultMetadataCustomScalars", "defaultMetadataEnums", "getDefaultMetadataEnums", "defaultMetadataFragments", "", "Lcom/apollographql/apollo3/compiler/MetadataFragment;", "getDefaultMetadataFragments", "()Ljava/util/List;", "defaultMetadataInputObjects", "getDefaultMetadataInputObjects", "defaultMetadataOutputFile", "", "getDefaultMetadataOutputFile", "()Ljava/lang/Void;", "defaultModuleName", "getDefaultModuleName", "()Ljava/lang/String;", "defaultOperationOutputFile", "getDefaultOperationOutputFile", "defaultOperationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator$Default;", "getDefaultOperationOutputGenerator", "()Lcom/apollographql/apollo3/compiler/OperationOutputGenerator$Default;", "defaultPackageNameProvider", "Lcom/apollographql/apollo3/compiler/PackageNameProvider$Flat;", "getDefaultPackageNameProvider", "()Lcom/apollographql/apollo3/compiler/PackageNameProvider$Flat;", "defaultUseSemanticNaming", "getDefaultUseSemanticNaming", "defaultWarnOnDeprecatedUsages", "getDefaultWarnOnDeprecatedUsages", "apollo-compiler"})
    public static final class Companion {
        @NotNull
        public final Logger getNoOpLogger() {
            return NoOpLogger;
        }

        @NotNull
        public final List<MetadataFragment> getDefaultMetadataFragments() {
            return defaultMetadataFragments;
        }

        @NotNull
        public final Set<String> getDefaultMetadataInputObjects() {
            return defaultMetadataInputObjects;
        }

        @NotNull
        public final Set<String> getDefaultMetadataEnums() {
            return defaultMetadataEnums;
        }

        public final boolean getDefaultMetadataCustomScalars() {
            return defaultMetadataCustomScalars;
        }

        @NotNull
        public final PackageNameProvider.Flat getDefaultPackageNameProvider() {
            return defaultPackageNameProvider;
        }

        @NotNull
        public final Set<String> getDefaultAlwaysGenerateTypesMatching() {
            return defaultAlwaysGenerateTypesMatching;
        }

        @Nullable
        public final Void getDefaultOperationOutputFile() {
            return defaultOperationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator.Default getDefaultOperationOutputGenerator() {
            return defaultOperationOutputGenerator;
        }

        @NotNull
        public final Map<String, String> getDefaultCustomScalarsMapping() {
            return defaultCustomScalarsMapping;
        }

        public final boolean getDefaultUseSemanticNaming() {
            return defaultUseSemanticNaming;
        }

        public final boolean getDefaultWarnOnDeprecatedUsages() {
            return defaultWarnOnDeprecatedUsages;
        }

        public final boolean getDefaultFailOnWarnings() {
            return defaultFailOnWarnings;
        }

        @NotNull
        public final Logger getDefaultLogger() {
            return defaultLogger;
        }

        public final boolean getDefaultGenerateAsInternal() {
            return defaultGenerateAsInternal;
        }

        public final boolean getDefaultGenerateFilterNotNull() {
            return defaultGenerateFilterNotNull;
        }

        public final boolean getDefaultGenerateFragmentsAsInterfaces() {
            return defaultGenerateFragmentsAsInterfaces;
        }

        public final boolean getDefaultGenerateFragmentImplementations() {
            return defaultGenerateFragmentImplementations;
        }

        public final boolean getDefaultGenerateResponseFields() {
            return defaultGenerateResponseFields;
        }

        public final boolean getDefaultGenerateQueryDocument() {
            return defaultGenerateQueryDocument;
        }

        @NotNull
        public final String getDefaultModuleName() {
            return defaultModuleName;
        }

        @Nullable
        public final Void getDefaultMetadataOutputFile() {
            return defaultMetadataOutputFile;
        }

        @NotNull
        public final ModuleOptions getDefaultModuleOptions() {
            return DefaultModuleOptions;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

