/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.ClassFactory;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.moshi.internal.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

final class ClassJsonAdapter<T>
extends JsonAdapter<T> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        @Nullable
        public JsonAdapter<?> create(Type type2, Set<? extends Annotation> annotations2, Moshi moshi) {
            if (!(type2 instanceof Class) && !(type2 instanceof ParameterizedType)) {
                return null;
            }
            Class<?> rawType = Types.getRawType(type2);
            if (rawType.isInterface() || rawType.isEnum()) {
                return null;
            }
            if (!annotations2.isEmpty()) {
                return null;
            }
            if (Util.isPlatformType(rawType)) {
                this.throwIfIsCollectionClass(type2, List.class);
                this.throwIfIsCollectionClass(type2, Set.class);
                this.throwIfIsCollectionClass(type2, Map.class);
                this.throwIfIsCollectionClass(type2, Collection.class);
                String messagePrefix = "Platform " + rawType;
                if (type2 instanceof ParameterizedType) {
                    messagePrefix = messagePrefix + " in " + type2;
                }
                throw new IllegalArgumentException(messagePrefix + " requires explicit JsonAdapter to be registered");
            }
            if (rawType.isAnonymousClass()) {
                throw new IllegalArgumentException("Cannot serialize anonymous class " + rawType.getName());
            }
            if (rawType.isLocalClass()) {
                throw new IllegalArgumentException("Cannot serialize local class " + rawType.getName());
            }
            if (rawType.getEnclosingClass() != null && !Modifier.isStatic(rawType.getModifiers())) {
                throw new IllegalArgumentException("Cannot serialize non-static nested class " + rawType.getName());
            }
            if (Modifier.isAbstract(rawType.getModifiers())) {
                throw new IllegalArgumentException("Cannot serialize abstract class " + rawType.getName());
            }
            if (Util.isKotlin(rawType)) {
                throw new IllegalArgumentException("Cannot serialize Kotlin type " + rawType.getName() + ". Reflective serialization of Kotlin classes without using kotlin-reflect has undefined and unexpected behavior. Please use KotlinJsonAdapterFactory from the moshi-kotlin artifact or use code gen from the moshi-kotlin-codegen artifact.");
            }
            ClassFactory classFactory = ClassFactory.get(rawType);
            TreeMap fields2 = new TreeMap();
            Type t = type2;
            while (t != Object.class) {
                this.createFieldBindings(moshi, t, fields2);
                t = Types.getGenericSuperclass(t);
            }
            return new ClassJsonAdapter(classFactory, fields2).nullSafe();
        }

        private void throwIfIsCollectionClass(Type type2, Class<?> collectionInterface) {
            Class<?> rawClass = Types.getRawType(type2);
            if (collectionInterface.isAssignableFrom(rawClass)) {
                throw new IllegalArgumentException("No JsonAdapter for " + type2 + ", you should probably use " + collectionInterface.getSimpleName() + " instead of " + rawClass.getSimpleName() + " (Moshi only supports the collection interfaces by default) or else register a custom JsonAdapter.");
            }
        }

        private void createFieldBindings(Moshi moshi, Type type2, Map<String, FieldBinding<?>> fieldBindings) {
            Class<?> rawType = Types.getRawType(type2);
            boolean platformType = Util.isPlatformType(rawType);
            for (Field field : rawType.getDeclaredFields()) {
                if (!this.includeField(platformType, field.getModifiers())) continue;
                Type fieldType = Util.resolve(type2, rawType, field.getGenericType());
                Set<? extends Annotation> annotations2 = Util.jsonAnnotations(field);
                String fieldName = field.getName();
                JsonAdapter adapter = moshi.adapter(fieldType, annotations2, fieldName);
                field.setAccessible(true);
                Json jsonAnnotation = field.getAnnotation(Json.class);
                String name = jsonAnnotation != null ? jsonAnnotation.name() : fieldName;
                FieldBinding fieldBinding = new FieldBinding(name, field, adapter);
                FieldBinding replaced = fieldBindings.put(name, fieldBinding);
                if (replaced == null) continue;
                throw new IllegalArgumentException("Conflicting fields:\n    " + replaced.field + "\n    " + fieldBinding.field);
            }
        }

        private boolean includeField(boolean platformType, int modifiers) {
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) {
                return false;
            }
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !platformType;
        }
    };
    private final ClassFactory<T> classFactory;
    private final FieldBinding<?>[] fieldsArray;
    private final JsonReader.Options options;

    ClassJsonAdapter(ClassFactory<T> classFactory, Map<String, FieldBinding<?>> fieldsMap) {
        this.classFactory = classFactory;
        this.fieldsArray = fieldsMap.values().toArray(new FieldBinding[fieldsMap.size()]);
        this.options = JsonReader.Options.of(fieldsMap.keySet().toArray(new String[fieldsMap.size()]));
    }

    @Override
    public T fromJson(JsonReader reader) throws IOException {
        T result2;
        try {
            result2 = this.classFactory.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw Util.rethrowCause(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                int index = reader.selectName(this.options);
                if (index == -1) {
                    reader.skipName();
                    reader.skipValue();
                    continue;
                }
                this.fieldsArray[index].read(reader, result2);
            }
            reader.endObject();
            return result2;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void toJson(JsonWriter writer, T value) throws IOException {
        try {
            writer.beginObject();
            for (FieldBinding<?> fieldBinding : this.fieldsArray) {
                writer.name(fieldBinding.name);
                fieldBinding.write(writer, value);
            }
            writer.endObject();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "JsonAdapter(" + this.classFactory + ")";
    }

    static class FieldBinding<T> {
        final String name;
        final Field field;
        final JsonAdapter<T> adapter;

        FieldBinding(String name, Field field, JsonAdapter<T> adapter) {
            this.name = name;
            this.field = field;
            this.adapter = adapter;
        }

        void read(JsonReader reader, Object value) throws IOException, IllegalAccessException {
            T fieldValue = this.adapter.fromJson(reader);
            this.field.set(value, fieldValue);
        }

        void write(JsonWriter writer, Object value) throws IllegalAccessException, IOException {
            Object fieldValue = this.field.get(value);
            this.adapter.toJson(writer, fieldValue);
        }
    }
}

