/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.SymbolMatcher;
import com.ibm.icu.impl.number.parse.UnicodeSetStaticCache;
import com.ibm.icu.text.DecimalFormatSymbols;

public class PermilleMatcher
extends SymbolMatcher {
    private static final PermilleMatcher DEFAULT = new PermilleMatcher();

    public static PermilleMatcher getInstance(DecimalFormatSymbols symbols) {
        String symbolString = symbols.getPerMillString();
        if (PermilleMatcher.DEFAULT.uniSet.contains(symbolString)) {
            return DEFAULT;
        }
        return new PermilleMatcher(symbolString);
    }

    private PermilleMatcher(String symbolString) {
        super(symbolString, PermilleMatcher.DEFAULT.uniSet);
    }

    private PermilleMatcher() {
        super(UnicodeSetStaticCache.Key.PERMILLE_SIGN);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return 0 != (result2.flags & 4);
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.flags |= 4;
        result2.setCharsConsumed(segment);
    }

    @Override
    public void postProcess(ParsedNumber result2) {
        super.postProcess(result2);
        if (0 != (result2.flags & 4) && result2.quantity != null) {
            result2.quantity.adjustMagnitude(-3);
        }
    }

    public String toString() {
        return "<PermilleMatcher>";
    }
}

