/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.CustomSymbolCurrency;
import com.ibm.icu.impl.number.DecimalFormatProperties;
import com.ibm.icu.impl.number.Grouper;
import com.ibm.icu.impl.number.PatternStringParser;
import com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import com.ibm.icu.impl.number.RoundingUtils;
import com.ibm.icu.impl.number.parse.AffixMatcher;
import com.ibm.icu.impl.number.parse.CurrencyMatcher;
import com.ibm.icu.impl.number.parse.CurrencyTrieMatcher;
import com.ibm.icu.impl.number.parse.DecimalMatcher;
import com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import com.ibm.icu.impl.number.parse.InfinityMatcher;
import com.ibm.icu.impl.number.parse.MatcherFactory;
import com.ibm.icu.impl.number.parse.MinusSignMatcher;
import com.ibm.icu.impl.number.parse.MultiplierHandler;
import com.ibm.icu.impl.number.parse.NanMatcher;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.PaddingMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.PercentMatcher;
import com.ibm.icu.impl.number.parse.PermilleMatcher;
import com.ibm.icu.impl.number.parse.PlusSignMatcher;
import com.ibm.icu.impl.number.parse.RequireAffixMatcher;
import com.ibm.icu.impl.number.parse.RequireCurrencyMatcher;
import com.ibm.icu.impl.number.parse.RequireDecimalSeparatorMatcher;
import com.ibm.icu.impl.number.parse.RequireExponentMatcher;
import com.ibm.icu.impl.number.parse.RequireNumberMatcher;
import com.ibm.icu.impl.number.parse.ScientificMatcher;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class NumberParserImpl {
    private final int parseFlags;
    private final List<NumberParseMatcher> matchers = new ArrayList<NumberParseMatcher>();
    private final List<UnicodeSet> leadCodePointses;
    private Comparator<ParsedNumber> comparator;
    private boolean frozen;

    @Deprecated
    public static NumberParserImpl removeMeWhenMerged(ULocale locale, String pattern, int parseFlags) {
        NumberParserImpl parser = new NumberParserImpl(parseFlags);
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        IgnorablesMatcher ignorables = IgnorablesMatcher.DEFAULT;
        MatcherFactory factory2 = new MatcherFactory();
        factory2.currency = Currency.getInstance("USD");
        factory2.symbols = symbols;
        factory2.ignorables = ignorables;
        factory2.locale = locale;
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        AffixMatcher.newGenerate(patternInfo, parser, factory2, ignorables, parseFlags);
        Grouper grouper = Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO).withLocaleData(locale, patternInfo);
        parser.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        parser.addMatcher(CurrencyTrieMatcher.getInstance(locale));
        parser.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
        parser.freeze();
        return parser;
    }

    @Deprecated
    public static NumberParserImpl createParserFromPattern(ULocale locale, String pattern, boolean strictGrouping) {
        int parseFlags = 4225;
        if (strictGrouping) {
            parseFlags |= 8;
        }
        NumberParserImpl parser = new NumberParserImpl(parseFlags);
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        IgnorablesMatcher ignorables = IgnorablesMatcher.DEFAULT;
        MatcherFactory factory2 = new MatcherFactory();
        factory2.currency = Currency.getInstance("USD");
        factory2.symbols = symbols;
        factory2.ignorables = ignorables;
        factory2.locale = locale;
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        AffixMatcher.newGenerate(patternInfo, parser, factory2, ignorables, parseFlags);
        Grouper grouper = Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO).withLocaleData(locale, patternInfo);
        parser.addMatcher(ignorables);
        parser.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        parser.addMatcher(MinusSignMatcher.getInstance(symbols, false));
        parser.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
        parser.addMatcher(ScientificMatcher.getInstance(symbols, grouper));
        parser.addMatcher(CurrencyTrieMatcher.getInstance(locale));
        parser.addMatcher(new RequireNumberMatcher());
        parser.freeze();
        return parser;
    }

    public static Number parseStatic(String input, ParsePosition ppos, DecimalFormatProperties properties2, DecimalFormatSymbols symbols) {
        NumberParserImpl parser = NumberParserImpl.createParserFromProperties(properties2, symbols, false, false);
        ParsedNumber result2 = new ParsedNumber();
        parser.parse(input, true, result2);
        if (result2.success()) {
            ppos.setIndex(result2.charEnd);
            return result2.getNumber();
        }
        ppos.setErrorIndex(result2.charEnd);
        return null;
    }

    public static CurrencyAmount parseStaticCurrency(String input, ParsePosition ppos, DecimalFormatProperties properties2, DecimalFormatSymbols symbols) {
        NumberParserImpl parser = NumberParserImpl.createParserFromProperties(properties2, symbols, true, false);
        ParsedNumber result2 = new ParsedNumber();
        parser.parse(input, true, result2);
        if (result2.success()) {
            Currency currency;
            ppos.setIndex(result2.charEnd);
            if (result2.currencyCode != null) {
                currency = Currency.getInstance(result2.currencyCode);
            } else {
                assert (0 != (result2.flags & 0x10));
                currency = CustomSymbolCurrency.resolve(properties2.getCurrency(), symbols.getULocale(), symbols);
            }
            return new CurrencyAmount(result2.getNumber(), currency);
        }
        ppos.setErrorIndex(result2.charEnd);
        return null;
    }

    public static NumberParserImpl createDefaultParserForLocale(ULocale loc, boolean optimize) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(loc);
        DecimalFormatProperties properties2 = PatternStringParser.parseToProperties("0");
        return NumberParserImpl.createParserFromProperties(properties2, symbols, false, optimize);
    }

    public static NumberParserImpl createParserFromProperties(DecimalFormatProperties properties2, DecimalFormatSymbols symbols, boolean parseCurrency, boolean optimize) {
        ULocale locale = symbols.getULocale();
        PropertiesAffixPatternProvider patternInfo = new PropertiesAffixPatternProvider(properties2);
        Currency currency = CustomSymbolCurrency.resolve(properties2.getCurrency(), locale, symbols);
        boolean isStrict = properties2.getParseMode() == ParseMode.STRICT;
        Grouper grouper = Grouper.forProperties(properties2);
        int parseFlags = 0;
        parseFlags |= 0x800;
        if (!properties2.getParseCaseSensitive()) {
            parseFlags |= 1;
        }
        if (properties2.getParseIntegerOnly()) {
            parseFlags |= 0x10;
        }
        if (properties2.getSignAlwaysShown()) {
            parseFlags |= 0x400;
        }
        if (isStrict) {
            parseFlags |= 8;
            parseFlags |= 4;
            parseFlags |= 0x100;
            parseFlags |= 0x200;
        } else {
            parseFlags |= 0x80;
        }
        if (grouper.getPrimary() <= 0) {
            parseFlags |= 0x20;
        }
        if (parseCurrency || patternInfo.hasCurrencySign()) {
            parseFlags |= 2;
        }
        if (optimize) {
            parseFlags |= 0x1000;
        }
        IgnorablesMatcher ignorables = isStrict ? IgnorablesMatcher.STRICT : IgnorablesMatcher.DEFAULT;
        NumberParserImpl parser = new NumberParserImpl(parseFlags);
        MatcherFactory factory2 = new MatcherFactory();
        factory2.currency = currency;
        factory2.symbols = symbols;
        factory2.ignorables = ignorables;
        factory2.locale = locale;
        AffixMatcher.newGenerate(patternInfo, parser, factory2, ignorables, parseFlags);
        if (parseCurrency || patternInfo.hasCurrencySign()) {
            parser.addMatcher(CurrencyMatcher.getInstance(currency, locale));
            parser.addMatcher(CurrencyTrieMatcher.getInstance(locale));
        }
        if (!isStrict) {
            parser.addMatcher(PlusSignMatcher.getInstance(symbols, false));
            parser.addMatcher(MinusSignMatcher.getInstance(symbols, false));
            parser.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
            parser.addMatcher(PercentMatcher.getInstance(symbols));
            parser.addMatcher(PermilleMatcher.getInstance(symbols));
        }
        parser.addMatcher(InfinityMatcher.getInstance(symbols));
        String padString = properties2.getPadString();
        if (padString != null && !ignorables.getSet().contains(padString)) {
            parser.addMatcher(PaddingMatcher.getInstance(padString));
        }
        parser.addMatcher(ignorables);
        parser.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        if (!properties2.getParseNoExponent()) {
            parser.addMatcher(ScientificMatcher.getInstance(symbols, grouper));
        }
        parser.addMatcher(new RequireNumberMatcher());
        if (isStrict) {
            parser.addMatcher(new RequireAffixMatcher());
        }
        if (isStrict && properties2.getMinimumExponentDigits() > 0) {
            parser.addMatcher(new RequireExponentMatcher());
        }
        if (parseCurrency) {
            parser.addMatcher(new RequireCurrencyMatcher());
        }
        if (properties2.getDecimalPatternMatchRequired()) {
            boolean patternHasDecimalSeparator = properties2.getDecimalSeparatorAlwaysShown() || properties2.getMaximumFractionDigits() != 0;
            parser.addMatcher(RequireDecimalSeparatorMatcher.getInstance(patternHasDecimalSeparator));
        }
        if (properties2.getMultiplier() != null) {
            parser.addMatcher(new MultiplierHandler(properties2.getMultiplier(), RoundingUtils.getMathContextOr34Digits(properties2)));
        }
        parser.freeze();
        return parser;
    }

    public NumberParserImpl(int parseFlags) {
        this.leadCodePointses = 0 != (parseFlags & 0x1000) ? new ArrayList<UnicodeSet>() : null;
        this.comparator = ParsedNumber.COMPARATOR;
        this.parseFlags = parseFlags;
        this.frozen = false;
    }

    public void addMatcher(NumberParseMatcher matcher) {
        assert (!this.frozen);
        this.matchers.add(matcher);
        if (this.leadCodePointses != null) {
            this.addLeadCodePointsForMatcher(matcher);
        }
    }

    public void addMatchers(Collection<? extends NumberParseMatcher> matchers) {
        assert (!this.frozen);
        this.matchers.addAll(matchers);
        if (this.leadCodePointses != null) {
            for (NumberParseMatcher numberParseMatcher : matchers) {
                this.addLeadCodePointsForMatcher(numberParseMatcher);
            }
        }
    }

    private void addLeadCodePointsForMatcher(NumberParseMatcher matcher) {
        UnicodeSet leadCodePoints = matcher.getLeadCodePoints();
        assert (leadCodePoints.isFrozen());
        if (0 != (this.parseFlags & 1)) {
            leadCodePoints = leadCodePoints.cloneAsThawed().closeOver(4).freeze();
        }
        this.leadCodePointses.add(leadCodePoints);
    }

    public void setComparator(Comparator<ParsedNumber> comparator) {
        assert (!this.frozen);
        this.comparator = comparator;
    }

    public void freeze() {
        this.frozen = true;
    }

    public void parse(String input, boolean greedy, ParsedNumber result2) {
        this.parse(input, 0, greedy, result2);
    }

    public void parse(String input, int start, boolean greedy, ParsedNumber result2) {
        assert (this.frozen);
        assert (start >= 0 && start < input.length());
        StringSegment segment = new StringSegment(input, 0 != (this.parseFlags & 1));
        segment.adjustOffset(start);
        if (greedy) {
            this.parseGreedyRecursive(segment, result2);
        } else {
            this.parseLongestRecursive(segment, result2);
        }
        for (NumberParseMatcher matcher : this.matchers) {
            matcher.postProcess(result2);
        }
    }

    private void parseGreedyRecursive(StringSegment segment, ParsedNumber result2) {
        if (segment.length() == 0) {
            return;
        }
        int initialOffset = segment.getOffset();
        int leadCp = segment.getCodePoint();
        for (int i = 0; i < this.matchers.size(); ++i) {
            if (this.leadCodePointses != null && !this.leadCodePointses.get(i).contains(leadCp)) continue;
            NumberParseMatcher matcher = this.matchers.get(i);
            matcher.match(segment, result2);
            if (segment.getOffset() == initialOffset) continue;
            this.parseGreedyRecursive(segment, result2);
            segment.setOffset(initialOffset);
            return;
        }
    }

    private void parseLongestRecursive(StringSegment segment, ParsedNumber result2) {
        if (segment.length() == 0) {
            return;
        }
        ParsedNumber initial = new ParsedNumber();
        initial.copyFrom(result2);
        ParsedNumber candidate = new ParsedNumber();
        int initialOffset = segment.getOffset();
        block0: for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            int charsToConsume = 0;
            while (charsToConsume < segment.length()) {
                charsToConsume += Character.charCount(Character.codePointAt(segment, charsToConsume));
                candidate.copyFrom(initial);
                segment.setLength(charsToConsume);
                boolean maybeMore = matcher.match(segment, candidate);
                segment.resetLength();
                if (segment.getOffset() - initialOffset == charsToConsume) {
                    this.parseLongestRecursive(segment, candidate);
                    if (this.comparator.compare(candidate, result2) > 0) {
                        result2.copyFrom(candidate);
                    }
                }
                segment.setOffset(initialOffset);
                if (maybeMore) continue;
                continue block0;
            }
        }
    }

    public String toString() {
        return "<NumberParserImpl matchers=" + this.matchers.toString() + ">";
    }

    public static enum ParseMode {
        LENIENT,
        STRICT;

    }
}

