/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.impl.number.Grouper;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.ParsingUtils;
import com.ibm.icu.impl.number.parse.UnicodeSetStaticCache;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.UnicodeSet;

public class DecimalMatcher
implements NumberParseMatcher {
    private final boolean requireGroupingMatch;
    private final boolean groupingDisabled;
    private final boolean fractionGroupingDisabled;
    private final boolean integerOnly;
    private final boolean isScientific;
    private final int grouping1;
    private final int grouping2;
    private final String groupingSeparator;
    private final String decimalSeparator;
    private final UnicodeSet groupingUniSet;
    private final UnicodeSet decimalUniSet;
    private final UnicodeSet separatorSet;
    private final UnicodeSet leadSet;
    private final String[] digitStrings;

    public static DecimalMatcher getInstance(DecimalFormatSymbols symbols, Grouper grouper, int parseFlags) {
        return new DecimalMatcher(symbols, grouper, parseFlags);
    }

    private DecimalMatcher(DecimalFormatSymbols symbols, Grouper grouper, int parseFlags) {
        if (0 != (parseFlags & 2)) {
            this.groupingSeparator = symbols.getMonetaryGroupingSeparatorString();
            this.decimalSeparator = symbols.getMonetaryDecimalSeparatorString();
        } else {
            this.groupingSeparator = symbols.getGroupingSeparatorString();
            this.decimalSeparator = symbols.getDecimalSeparatorString();
        }
        boolean strictSeparators = 0 != (parseFlags & 4);
        UnicodeSetStaticCache.Key groupingKey = strictSeparators ? UnicodeSetStaticCache.Key.STRICT_ALL_SEPARATORS : UnicodeSetStaticCache.Key.ALL_SEPARATORS;
        this.groupingUniSet = UnicodeSetStaticCache.get(groupingKey);
        UnicodeSetStaticCache.Key decimalKey = UnicodeSetStaticCache.chooseFrom(this.decimalSeparator, strictSeparators ? UnicodeSetStaticCache.Key.STRICT_COMMA : UnicodeSetStaticCache.Key.COMMA, strictSeparators ? UnicodeSetStaticCache.Key.STRICT_PERIOD : UnicodeSetStaticCache.Key.PERIOD);
        this.decimalUniSet = decimalKey != null ? UnicodeSetStaticCache.get(decimalKey) : new UnicodeSet().add(this.decimalSeparator.codePointAt(0)).freeze();
        if (groupingKey != null && decimalKey != null) {
            this.separatorSet = this.groupingUniSet;
            this.leadSet = UnicodeSetStaticCache.get(strictSeparators ? UnicodeSetStaticCache.Key.DIGITS_OR_ALL_SEPARATORS : UnicodeSetStaticCache.Key.DIGITS_OR_STRICT_ALL_SEPARATORS);
        } else {
            this.separatorSet = new UnicodeSet().addAll(this.groupingUniSet).addAll(this.decimalUniSet).freeze();
            this.leadSet = null;
        }
        int cpZero = symbols.getCodePointZero();
        this.digitStrings = cpZero == -1 || !UCharacter.isDigit(cpZero) || UCharacter.digit(cpZero) != 0 ? symbols.getDigitStringsLocal() : null;
        this.requireGroupingMatch = 0 != (parseFlags & 8);
        this.groupingDisabled = 0 != (parseFlags & 0x20);
        this.fractionGroupingDisabled = 0 != (parseFlags & 0x800);
        this.integerOnly = 0 != (parseFlags & 0x10);
        this.isScientific = 0 != (parseFlags & 0x40);
        this.grouping1 = grouper.getPrimary();
        this.grouping2 = grouper.getSecondary();
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result2) {
        return this.match(segment, result2, false);
    }

    public boolean match(StringSegment segment, ParsedNumber result2, boolean negativeExponent) {
        if (result2.seenNumber() && !this.isScientific) {
            return false;
        }
        ParsedNumber backupResult = null;
        if (this.requireGroupingMatch) {
            backupResult = new ParsedNumber();
            backupResult.copyFrom(result2);
        }
        boolean strictFail = false;
        String actualGroupingString = this.groupingSeparator;
        String actualDecimalString = this.decimalSeparator;
        int groupedDigitCount = 0;
        int backupOffset = -1;
        boolean afterFirstGrouping = false;
        boolean seenGrouping = false;
        boolean seenDecimal = false;
        int digitsAfterDecimal = 0;
        int initialOffset = segment.getOffset();
        int exponent = 0;
        boolean hasPartialPrefix = false;
        while (segment.length() > 0) {
            hasPartialPrefix = false;
            byte digit = -1;
            int cp = segment.getCodePoint();
            if (UCharacter.isDigit(cp)) {
                segment.adjustOffset(Character.charCount(cp));
                digit = (byte)UCharacter.digit(cp);
            }
            if (digit == -1 && this.digitStrings != null) {
                for (int i = 0; i < this.digitStrings.length; ++i) {
                    String str = this.digitStrings[i];
                    int overlap = segment.getCommonPrefixLength(str);
                    if (overlap == str.length()) {
                        segment.adjustOffset(overlap);
                        digit = (byte)i;
                        break;
                    }
                    if (overlap != segment.length()) continue;
                    hasPartialPrefix = true;
                }
            }
            if (digit >= 0) {
                if (backupOffset != -1) {
                    if (this.requireGroupingMatch && (afterFirstGrouping && groupedDigitCount != this.grouping2 || !afterFirstGrouping && groupedDigitCount > this.grouping2)) {
                        strictFail = true;
                        break;
                    }
                    afterFirstGrouping = true;
                    backupOffset = -1;
                    groupedDigitCount = 0;
                }
                if (this.isScientific) {
                    int nextExponent = digit + exponent * 10;
                    exponent = nextExponent < exponent ? Integer.MAX_VALUE : nextExponent;
                } else {
                    if (result2.quantity == null) {
                        result2.quantity = new DecimalQuantity_DualStorageBCD();
                    }
                    result2.quantity.appendDigit(digit, 0, true);
                }
                result2.setCharsConsumed(segment);
                ++groupedDigitCount;
                if (!seenDecimal) continue;
                ++digitsAfterDecimal;
                continue;
            }
            int decimalOverlap = segment.getCommonPrefixLength(actualDecimalString);
            boolean decimalStringMatch = decimalOverlap == actualDecimalString.length();
            int groupingOverlap = segment.getCommonPrefixLength(actualGroupingString);
            boolean groupingStringMatch = groupingOverlap == actualGroupingString.length();
            boolean bl = hasPartialPrefix = decimalOverlap == segment.length() || groupingOverlap == segment.length();
            if (!seenDecimal && !groupingStringMatch && (decimalStringMatch || !seenDecimal && this.decimalUniSet.contains(cp))) {
                if (this.requireGroupingMatch && (backupOffset != -1 || seenGrouping && groupedDigitCount != this.grouping1)) {
                    strictFail = true;
                    break;
                }
                if (this.integerOnly) break;
                seenDecimal = true;
                if (!decimalStringMatch) {
                    actualDecimalString = UCharacter.toString(cp);
                }
                segment.adjustOffset(actualDecimalString.length());
                result2.setCharsConsumed(segment);
                result2.flags |= 0x20;
                continue;
            }
            if (this.groupingDisabled || decimalStringMatch || !groupingStringMatch && (seenGrouping || !this.groupingUniSet.contains(cp))) break;
            if (this.requireGroupingMatch) {
                if (groupedDigitCount == 0) {
                    strictFail = true;
                    break;
                }
                if (backupOffset != -1) break;
            }
            if (this.fractionGroupingDisabled && seenDecimal) break;
            seenGrouping = true;
            if (!groupingStringMatch) {
                actualGroupingString = UCharacter.toString(cp);
            }
            backupOffset = segment.getOffset();
            segment.adjustOffset(actualGroupingString.length());
        }
        if (this.requireGroupingMatch && !seenDecimal && seenGrouping && afterFirstGrouping && groupedDigitCount != this.grouping1) {
            strictFail = true;
        }
        if (this.requireGroupingMatch && strictFail) {
            result2.copyFrom(backupResult);
            segment.setOffset(initialOffset);
        }
        if (result2.quantity == null && segment.getOffset() != initialOffset) {
            segment.setOffset(initialOffset);
            hasPartialPrefix = true;
        }
        if (result2.quantity != null) {
            result2.quantity.adjustMagnitude(-digitsAfterDecimal);
        }
        if (this.isScientific && segment.getOffset() != initialOffset) {
            boolean overflow;
            assert (result2.quantity != null);
            boolean bl = overflow = exponent == Integer.MAX_VALUE;
            if (!overflow) {
                try {
                    result2.quantity.adjustMagnitude(negativeExponent ? -exponent : exponent);
                }
                catch (ArithmeticException e) {
                    overflow = true;
                }
            }
            if (overflow) {
                if (negativeExponent) {
                    result2.quantity.clear();
                } else {
                    result2.quantity = null;
                    result2.flags |= 0x80;
                }
            }
        }
        return segment.length() == 0 || hasPartialPrefix;
    }

    @Override
    public UnicodeSet getLeadCodePoints() {
        if (this.digitStrings == null && this.leadSet != null) {
            return this.leadSet;
        }
        UnicodeSet leadCodePoints = new UnicodeSet();
        leadCodePoints.addAll(UnicodeSetStaticCache.get(UnicodeSetStaticCache.Key.DIGITS));
        leadCodePoints.addAll(this.separatorSet);
        if (this.digitStrings != null) {
            for (int i = 0; i < this.digitStrings.length; ++i) {
                ParsingUtils.putLeadCodePoint(this.digitStrings[i], leadCodePoints);
            }
        }
        return leadCodePoints.freeze();
    }

    @Override
    public void postProcess(ParsedNumber result2) {
    }

    public String toString() {
        return "<DecimalMatcher>";
    }
}

