/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.TextTrieMap;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;

public class CurrencyTrieMatcher
implements NumberParseMatcher {
    private final TextTrieMap<Currency.CurrencyStringInfo> longNameTrie;
    private final TextTrieMap<Currency.CurrencyStringInfo> symbolTrie;

    public static CurrencyTrieMatcher getInstance(ULocale locale) {
        return new CurrencyTrieMatcher(locale);
    }

    private CurrencyTrieMatcher(ULocale locale) {
        this.longNameTrie = Currency.getParsingTrie(locale, 1);
        this.symbolTrie = Currency.getParsingTrie(locale, 0);
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result2) {
        if (result2.currencyCode != null) {
            return false;
        }
        TextTrieMap.Output trieOutput = new TextTrieMap.Output();
        Iterator<Currency.CurrencyStringInfo> values2 = this.longNameTrie.get(segment, 0, trieOutput);
        if (values2 == null) {
            values2 = this.symbolTrie.get(segment, 0, trieOutput);
        }
        if (values2 != null) {
            result2.currencyCode = values2.next().getISOCode();
            segment.adjustOffset(trieOutput.matchLength);
            result2.setCharsConsumed(segment);
        }
        return trieOutput.partialMatch;
    }

    @Override
    public UnicodeSet getLeadCodePoints() {
        UnicodeSet leadCodePoints = new UnicodeSet();
        this.longNameTrie.putLeadCodePoints(leadCodePoints);
        this.symbolTrie.putLeadCodePoints(leadCodePoints);
        return leadCodePoints.freeze();
    }

    @Override
    public void postProcess(ParsedNumber result2) {
    }

    public String toString() {
        return "<CurrencyTrieMatcher>";
    }
}

