/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.ParsingUtils;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;

public class CurrencyMatcher
implements NumberParseMatcher {
    private final String isoCode;
    private final String currency1;
    private final String currency2;

    public static CurrencyMatcher getInstance(Currency currency, ULocale loc) {
        return new CurrencyMatcher(currency.getSubtype(), currency.getSymbol(loc), currency.getCurrencyCode());
    }

    private CurrencyMatcher(String isoCode, String currency1, String currency2) {
        this.isoCode = isoCode;
        this.currency1 = currency1;
        this.currency2 = currency2;
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result2) {
        int overlap2;
        if (result2.currencyCode != null) {
            return false;
        }
        int overlap1 = segment.getCommonPrefixLength(this.currency1);
        if (overlap1 == this.currency1.length()) {
            result2.currencyCode = this.isoCode;
            segment.adjustOffset(overlap1);
            result2.setCharsConsumed(segment);
        }
        if ((overlap2 = segment.getCommonPrefixLength(this.currency2)) == this.currency2.length()) {
            result2.currencyCode = this.isoCode;
            segment.adjustOffset(overlap2);
            result2.setCharsConsumed(segment);
        }
        return overlap1 == segment.length() || overlap2 == segment.length();
    }

    @Override
    public UnicodeSet getLeadCodePoints() {
        UnicodeSet leadCodePoints = new UnicodeSet();
        ParsingUtils.putLeadCodePoint(this.currency1, leadCodePoints);
        ParsingUtils.putLeadCodePoint(this.currency2, leadCodePoints);
        return leadCodePoints.freeze();
    }

    @Override
    public void postProcess(ParsedNumber result2) {
    }

    public String toString() {
        return "<CurrencyMatcher " + this.isoCode + ">";
    }
}

