/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.api.QueryDocumentMinifier;
import com.apollographql.apollo3.compiler.ApolloMetadata;
import com.apollographql.apollo3.compiler.DefaultPackageNameProvider;
import com.apollographql.apollo3.compiler.OperationIdGenerator;
import com.apollographql.apollo3.compiler.OperationOutputGenerator;
import com.apollographql.apollo3.compiler.PackageNameProvider;
import com.apollographql.apollo3.compiler.Roots;
import com.apollographql.apollo3.compiler.TypesToGenerate;
import com.apollographql.apollo3.compiler.TypesToGenerateKt;
import com.apollographql.apollo3.compiler.VersionKt;
import com.apollographql.apollo3.compiler.backend.GraphQLCodeGenerator;
import com.apollographql.apollo3.compiler.backend.ir.BackendIr;
import com.apollographql.apollo3.compiler.backend.ir.BackendIrBuilder;
import com.apollographql.apollo3.compiler.frontend.Add_typenameKt;
import com.apollographql.apollo3.compiler.frontend.GQLDocument;
import com.apollographql.apollo3.compiler.frontend.GQLFragmentDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLOperationDefinition;
import com.apollographql.apollo3.compiler.frontend.GQLTypeDefinition;
import com.apollographql.apollo3.compiler.frontend.GraphQLParser;
import com.apollographql.apollo3.compiler.frontend.Introspection_to_schemaKt;
import com.apollographql.apollo3.compiler.frontend.Issue;
import com.apollographql.apollo3.compiler.frontend.Schema;
import com.apollographql.apollo3.compiler.frontend.Schema_to_introspectionKt;
import com.apollographql.apollo3.compiler.frontend.SourceAwareException;
import com.apollographql.apollo3.compiler.frontend.ir.FrontendIr;
import com.apollographql.apollo3.compiler.frontend.ir.FrontendIrBuilder;
import com.apollographql.apollo3.compiler.introspection.IntrospectionSchema;
import com.apollographql.apollo3.compiler.operationoutput.OperationDescriptor;
import com.apollographql.apollo3.compiler.operationoutput.OperationOutputKt;
import com.squareup.kotlinpoet.ClassNames;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0003\u000f\u0010\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler;", "", "logger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "(Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;)V", "getLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "anyClassName", "", "generateKotlinModels", "", "write", "", "args", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Arguments;", "Arguments", "Companion", "Logger", "apollo-compiler"})
public final class GraphQLCompiler {
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Logger NoOpLogger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull Arguments args2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable<Regex> iterable;
        void $this$map$iv332;
        Object it;
        String $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapTo$iv$iv22322;
        Iterable $this$filterTo$iv$iv;
        List<GQLFragmentDefinition> $this$mapTo$iv$iv4;
        void $this$map$iv3;
        Object element$iv$iv6;
        BackendIr.Operation $this$filterIsInstanceTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Pair<void, String> pair;
        Collection collection;
        void $this$mapTo$iv$iv5;
        void $this$map$iv4;
        Object destination$iv$iv;
        boolean bl;
        void $this$flatMapTo$iv$iv3;
        void documents;
        Iterable<Object> element$iv32;
        void errors;
        void schema;
        Intrinsics.checkParameterIsNotNull(args2, "args");
        FilesKt.deleteRecursively(args2.getOutputDir());
        args2.getOutputDir().mkdirs();
        Roots roots = new Roots((Collection<? extends File>)args2.getRootFolders());
        ApolloMetadata metadata2 = GraphQLCompiler.Companion.collectMetadata(args2.getMetadata());
        Companion.SchemaInfo schemaInfo = GraphQLCompiler.Companion.getSchemaInfo(roots, args2.getRootPackageName(), args2.getSchemaFile(), metadata2);
        Schema schema2 = schemaInfo.component1();
        String schemaPackageName = schemaInfo.component2();
        ApolloMetadata apolloMetadata = metadata2;
        boolean generateKotlinModels = apolloMetadata != null ? apolloMetadata.getGenerateKotlinModels() : args2.getGenerateKotlinModels();
        Object object = metadata2;
        if (object == null || (object = ((ApolloMetadata)object).getCustomScalarsMapping()) == null) {
            object = args2.getCustomScalarsMapping();
        }
        Map<String, String> userScalarTypesMap = object;
        String string = args2.getRootPackageName();
        Object object2 = roots;
        DefaultPackageNameProvider packageNameProvider = new DefaultPackageNameProvider(string, (Roots)object2);
        Object object3 = metadata2;
        if (object3 == null || (object3 = ((ApolloMetadata)object3).getFragments()) == null) {
            object3 = CollectionsKt.emptyList();
        }
        List<GQLFragmentDefinition> metadataFragments = object3;
        Object object4 = GraphQLParser.INSTANCE.parseExecutableFiles(args2.getGraphqlFiles(), (Schema)schema, metadataFragments);
        object2 = ((Pair)object4).component1();
        List<Issue> issues = ((Pair)object4).component2();
        Iterable $this$partition$iv = issues;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            Issue it3 = (Issue)element$iv2;
            boolean bl2 = false;
            if (it3.getSeverity() == Issue.Severity.ERROR) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair pair2 = new Pair(first$iv, second$iv);
        object4 = pair2.component1();
        List warnings = pair2.component2();
        Issue firstError = (Issue)CollectionsKt.firstOrNull(errors);
        if (firstError != null) {
            throw (Throwable)new SourceAwareException(firstError.getMessage(), firstError.getSourceLocation());
        }
        if (args2.getWarnOnDeprecatedUsages()) {
            Iterable $this$forEach$iv = warnings;
            boolean $i$f$forEach = false;
            for (Iterable<Object> element$iv32 : $this$forEach$iv) {
                Issue it4 = (Issue)((Object)element$iv32);
                boolean bl3 = false;
                int column = it4.getSourceLocation().getPosition() + 1;
                this.logger.warning("w: " + it4.getSourceLocation().getFilePath() + ':' + it4.getSourceLocation().getLine() + ':' + column + ": ApolloGraphQL: " + it4.getMessage());
            }
            if (args2.getFailOnWarnings()) {
                $this$forEach$iv = warnings;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    throw (Throwable)new IllegalStateException("ApolloGraphQL: Warnings found and 'failOnWarnings' is true, aborting.");
                }
            }
        }
        Iterable $this$flatMap$iv2 = (Iterable)documents;
        boolean $i$f$flatMap = false;
        element$iv32 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv3) {
            void $this$filterIsInstanceTo$iv$iv2;
            GQLDocument gQLDocument = (GQLDocument)element$iv$iv2;
            bl = false;
            Iterable $this$filterIsInstance$iv = gQLDocument.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv3 instanceof GQLFragmentDefinition)) continue;
                destination$iv$iv.add(element$iv$iv3);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            CollectionsKt.addAll(destination$iv$iv2, iterable3);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv3 = $this$map$iv4;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
            GQLFragmentDefinition gQLFragmentDefinition = (GQLFragmentDefinition)item$iv$iv2;
            collection = destination$iv$iv3;
            bl = false;
            pair = Add_typenameKt.withTypenameWhenNeeded(gQLFragmentDefinition, (Schema)schema);
            collection.add(pair);
        }
        List fragments2 = (List)destination$iv$iv3;
        Iterable $this$flatMap$iv3 = (Iterable)documents;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv3 = $this$flatMap$iv3;
        Collection destination$iv$iv32 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object t : $this$flatMapTo$iv$iv2) {
            Object element$iv$iv3;
            GQLDocument it5 = (GQLDocument)t;
            boolean bl4 = false;
            Iterable $this$filterIsInstance$iv = it5.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            element$iv$iv3 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (element$iv$iv3.hasNext()) {
                element$iv$iv6 = element$iv$iv3.next();
                if (!(element$iv$iv6 instanceof GQLOperationDefinition)) continue;
                destination$iv$iv4.add(element$iv$iv6);
            }
            Iterable list$iv$iv2 = (List)destination$iv$iv4;
            CollectionsKt.addAll(destination$iv$iv32, list$iv$iv2);
        }
        $this$flatMap$iv3 = (List)destination$iv$iv32;
        boolean $i$f$map2 = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv232 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo232 = false;
        for (Object t : $this$mapTo$iv$iv4) {
            void it6;
            GQLOperationDefinition list$iv$iv2 = (GQLOperationDefinition)t;
            collection = destination$iv$iv232;
            boolean bl5 = false;
            pair = Add_typenameKt.withTypenameWhenNeeded((GQLOperationDefinition)it6, (Schema)schema);
            collection.add(pair);
        }
        List operations = (List)destination$iv$iv232;
        TypesToGenerate typesToGenerate = TypesToGenerateKt.computeTypesToGenerate((List<GQLDocument>)documents, (Schema)schema, metadata2, args2.getAlwaysGenerateTypesMatching());
        $this$mapTo$iv$iv4 = metadataFragments;
        destination$iv$iv232 = fragments2;
        FrontendIr frontendIr = new FrontendIrBuilder((Schema)schema, operations, $this$mapTo$iv$iv4, (List<GQLFragmentDefinition>)destination$iv$iv232).build();
        boolean destination$iv$iv232 = args2.getGenerateFragmentsAsInterfaces();
        PackageNameProvider $i$f$mapTo232 = packageNameProvider;
        BackendIr backendIr = new BackendIrBuilder((Schema)schema, args2.getUseSemanticNaming(), destination$iv$iv232, $i$f$mapTo232).buildBackendIR(frontendIr);
        Iterable $this$map$iv2232 = backendIr.getOperations();
        boolean $i$f$map3 = false;
        Iterable iterable4 = $this$map$iv2232;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2232, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : iterable4) {
            Iterator it7;
            $this$filterIsInstanceTo$iv$iv = (BackendIr.Operation)item$iv$iv4;
            collection = destination$iv$iv5;
            boolean bl6 = false;
            pair = new OperationDescriptor(((BackendIr.Operation)((Object)it7)).getOperationName(), ((BackendIr.Operation)((Object)it7)).getTargetPackageName(), "", QueryDocumentMinifier.minify(((BackendIr.Operation)((Object)it7)).getDefinition()));
            collection.add(pair);
        }
        $this$map$iv2232 = (List)destination$iv$iv5;
        $i$f$map3 = false;
        boolean bl7 = false;
        Iterable it8 = $this$map$iv2232;
        boolean $i$a$-let-GraphQLCompiler$write$operationOutput$332 = false;
        Map<String, OperationDescriptor> operationOutput = args2.getOperationOutputGenerator().generate((Collection)it8);
        boolean $this$map$iv2232 = operationOutput.size() == operations.size();
        $i$f$map3 = false;
        boolean bl8 = false;
        if (!$this$map$iv2232) {
            boolean bl9 = false;
            String string2 = StringsKt.trimMargin$default("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + operations.size() + ").\n        |Check that all your IDs are unique.\n      ", null, 1, null);
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (args2.getOperationOutputFile() != null) {
            FilesKt.writeText$default(args2.getOperationOutputFile(), OperationOutputKt.toJson(operationOutput, "  "), null, 2, null);
        }
        IntrospectionSchema introspectionSchema = Schema_to_introspectionKt.toIntrospectionSchema((Schema)schema);
        Iterable iterable5 = introspectionSchema.getTypes().values();
        boolean $i$f$filter = false;
        Iterable $i$a$-let-GraphQLCompiler$write$operationOutput$332 = iterable5;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
            IntrospectionSchema.Type type2 = (IntrospectionSchema.Type)element$iv$iv5;
            boolean bl10 = false;
            if (!(type2 instanceof IntrospectionSchema.Type.Scalar && !GQLTypeDefinition.Companion.getBuiltInTypes().contains(type2.getName()))) continue;
            destination$iv$iv6.add(element$iv$iv5);
        }
        Iterable iterable6 = (List)destination$iv$iv6;
        boolean $i$f$map4 = false;
        $this$filterTo$iv$iv = iterable6;
        Collection destination$iv$iv32322 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable6, 10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv5 : $this$mapTo$iv$iv22322) {
            void type232;
            IntrospectionSchema.Type type2 = (IntrospectionSchema.Type)item$iv$iv5;
            collection = destination$iv$iv32322;
            boolean bl11 = false;
            pair = type232.getName();
            collection.add(pair);
        }
        List schemaScalars = (List)destination$iv$iv32322;
        Set set = CollectionsKt.subtract((Iterable)userScalarTypesMap.keySet(), CollectionsKt.toSet(schemaScalars));
        $i$f$map4 = set.isEmpty();
        boolean $this$mapTo$iv$iv22322 = false;
        boolean destination$iv$iv32322 = false;
        if (!$i$f$map4) {
            boolean bl12 = false;
            String destination$iv$iv32322 = "ApolloGraphQL: unknown custom scalar(s): " + CollectionsKt.joinToString$default(set, ",", null, null, 0, null, null, 62, null);
            throw (Throwable)new IllegalStateException(destination$iv$iv32322.toString());
        }
        Iterable $this$mapTo$iv$iv22322 = schemaScalars;
        boolean $i$f$map5 = false;
        void bl12 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo5 = false;
        Iterator type232 = $this$mapTo$iv$iv.iterator();
        while (type232.hasNext()) {
            Object item$iv$iv6 = type232.next();
            element$iv$iv6 = (String)item$iv$iv6;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string3 = userScalarTypesMap.get(it);
            if (string3 == null) {
                string3 = this.anyClassName(generateKotlinModels);
            }
            pair = TuplesKt.to(it, string3);
            collection.add(pair);
        }
        Map<String, String> customScalarsMapping = MapsKt.toMap((List)destination$iv$iv);
        $this$map$iv = args2.getEnumAsSealedClassPatternFilters();
        boolean bl13 = args2.getGenerateFilterNotNull();
        boolean bl14 = args2.getGenerateAsInternal();
        Map<String, OperationDescriptor> map2 = operationOutput;
        Map<String, String> map3 = customScalarsMapping;
        boolean bl15 = typesToGenerate.getGenerateScalarMapping();
        Set<String> set2 = typesToGenerate.getInputObjectsToGenerate();
        Object object5 = typesToGenerate.getEnumsToGenerate();
        String string4 = schema;
        BackendIr backendIr2 = backendIr;
        boolean $i$f$map232 = false;
        $this$mapTo$iv$iv = $this$map$iv332;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv332, 10));
        boolean $i$f$mapTo332 = false;
        type232 = $this$mapTo$iv$iv.iterator();
        while (type232.hasNext()) {
            Object item$iv$iv7 = type232.next();
            it = (String)item$iv$iv7;
            iterable = destination$iv$iv;
            boolean bl6 = false;
            String string5 = it;
            boolean bl16 = false;
            Regex regex = new Regex(string5);
            iterable.add(regex);
        }
        iterable = (List)destination$iv$iv;
        boolean $this$map$iv332 = args2.getGenerateFragmentsAsInterfaces();
        $i$f$map232 = args2.getGenerateFragmentImplementations();
        $this$mapTo$iv$iv = StringsKt.removePrefix(schemaPackageName + ".fragment", (CharSequence)".");
        destination$iv$iv = StringsKt.removePrefix(schemaPackageName + ".type", (CharSequence)".");
        Iterable<Regex> $i$f$mapTo332 = iterable;
        boolean type232 = bl13;
        boolean bl17 = bl14;
        it = map2;
        Map<String, String> bl6 = map3;
        boolean bl18 = bl15;
        Set<String> set3 = set2;
        Set<String> set4 = object5;
        boolean bl19 = $this$map$iv332;
        boolean bl20 = $i$f$map232;
        String string6 = $this$mapTo$iv$iv;
        Object object6 = destination$iv$iv;
        boolean bl21 = bl18;
        Set<String> set5 = set3;
        Set<String> set6 = set4;
        Iterable<Regex> iterable7 = $i$f$mapTo332;
        boolean bl22 = type232;
        Object object7 = it;
        boolean bl23 = bl17;
        Map<String, String> map4 = bl6;
        void var67_147 = string4;
        BackendIr backendIr3 = backendIr2;
        new GraphQLCodeGenerator(backendIr3, (Schema)var67_147, map4, bl23, (Map<String, OperationDescriptor>)object7, bl22, (List<Regex>)iterable7, set6, set5, bl21, (String)object6, string6, bl20, bl19).write(args2.getOutputDir());
        args2.getMetadataOutputFile().getParentFile().mkdirs();
        Iterable $i$f$map232 = (Iterable)documents;
        set2 = SetsKt.plus(typesToGenerate.getEnumsToGenerate(), (Iterable)typesToGenerate.getInputObjectsToGenerate());
        object5 = args2.getModuleName();
        string4 = schemaPackageName;
        backendIr2 = metadata2 == null ? schema : null;
        boolean $i$f$flatMap3 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv7 = new ArrayList();
        boolean $i$f$flatMapTo3 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv3;
            GQLDocument it9 = (GQLDocument)element$iv$iv;
            boolean bl152 = false;
            Iterable $this$filterIsInstance$iv = it9.getDefinitions();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv8 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv7 : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv7 instanceof GQLFragmentDefinition)) continue;
                destination$iv$iv8.add(element$iv$iv7);
            }
            Iterable list$iv$iv3 = (List)destination$iv$iv8;
            CollectionsKt.addAll(destination$iv$iv7, list$iv$iv3);
        }
        List list = (List)destination$iv$iv7;
        String string7 = VersionKt.getVERSION();
        Map<String, String> map5 = args2.getCustomScalarsMapping();
        boolean bl24 = generateKotlinModels;
        List list2 = list;
        Set<String> set7 = set2;
        Object object8 = object5;
        String string8 = string4;
        Map<String, String> map6 = map5;
        String string9 = string7;
        boolean bl25 = bl24;
        Object object9 = object8;
        String string10 = string8;
        Set<String> set8 = set7;
        List list3 = list2;
        BackendIr backendIr4 = backendIr2;
        ApolloMetadata outgoingMetadata = new ApolloMetadata((Schema)((Object)backendIr4), list3, set8, string10, (String)object9, bl25, string9, map6);
        outgoingMetadata.writeTo(args2.getMetadataOutputFile());
    }

    private final String anyClassName(boolean generateKotlinModels) {
        if (!generateKotlinModels) {
            String string = "ClassNames.OBJECT.toString()";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return ClassNames.get(Reflection.getOrCreateKotlinClass(Object.class)).toString();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public GraphQLCompiler(@NotNull Logger logger2) {
        Intrinsics.checkParameterIsNotNull(logger2, "logger");
        this.logger = logger2;
    }

    public /* synthetic */ GraphQLCompiler(Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger2 = NoOpLogger;
        }
        this(logger2);
    }

    public GraphQLCompiler() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        NoOpLogger = new Logger(){

            public void warning(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull(message, "message");
            }
        };
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b@\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0085\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u0012\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u0012\u0012\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001fJ\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010>\u001a\u00020\u0010H\u00c6\u0003J\t\u0010?\u001a\u00020\u0012H\u00c6\u0003J\t\u0010@\u001a\u00020\u000bH\u00c6\u0003J\t\u0010A\u001a\u00020\u0012H\u00c6\u0003J\u0015\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0016H\u00c6\u0003J\t\u0010C\u001a\u00020\u0012H\u00c6\u0003J\t\u0010D\u001a\u00020\u0012H\u00c6\u0003J\t\u0010E\u001a\u00020\u0012H\u00c6\u0003J\t\u0010F\u001a\u00020\u0012H\u00c6\u0003J\t\u0010G\u001a\u00020\u0012H\u00c6\u0003J\u000f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003J\t\u0010I\u001a\u00020\u0012H\u00c6\u0003J\u000f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c6\u0003J\t\u0010K\u001a\u00020\u0012H\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010M\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010O\u001a\u00020\u000bH\u00c6\u0003J\t\u0010P\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0093\u0002\u0010S\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00042\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u00122\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u00122\b\b\u0002\u0010\u001a\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\u00122\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u0012H\u00c6\u0001J\u0013\u0010T\u001a\u00020\u00122\b\u0010U\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010V\u001a\u00020WH\u00d6\u0001J\t\u0010X\u001a\u00020\u000bH\u00d6\u0001R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0011\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0011\u0010\u001c\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010%R\u0011\u0010\u001a\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010%R\u0011\u0010\u001e\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010%R\u0011\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010%R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010!R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00101R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00101R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010/R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00103R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00101R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010%R\u0011\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010%\u00a8\u0006Y"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Arguments;", "", "rootFolders", "", "Ljava/io/File;", "graphqlFiles", "", "schemaFile", "outputDir", "metadata", "moduleName", "", "metadataOutputFile", "alwaysGenerateTypesMatching", "operationOutputFile", "operationOutputGenerator", "Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "dumpIR", "", "rootPackageName", "generateKotlinModels", "customScalarsMapping", "", "useSemanticNaming", "warnOnDeprecatedUsages", "failOnWarnings", "generateFragmentImplementations", "generateAsInternal", "generateFilterNotNull", "enumAsSealedClassPatternFilters", "generateFragmentsAsInterfaces", "(Ljava/util/List;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/util/List;Ljava/lang/String;Ljava/io/File;Ljava/util/Set;Ljava/io/File;Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;ZLjava/lang/String;ZLjava/util/Map;ZZZZZZLjava/util/Set;Z)V", "getAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "getCustomScalarsMapping", "()Ljava/util/Map;", "getDumpIR", "()Z", "getEnumAsSealedClassPatternFilters", "getFailOnWarnings", "getGenerateAsInternal", "getGenerateFilterNotNull", "getGenerateFragmentImplementations", "getGenerateFragmentsAsInterfaces", "getGenerateKotlinModels", "getGraphqlFiles", "getMetadata", "()Ljava/util/List;", "getMetadataOutputFile", "()Ljava/io/File;", "getModuleName", "()Ljava/lang/String;", "getOperationOutputFile", "getOperationOutputGenerator", "()Lcom/apollographql/apollo3/compiler/OperationOutputGenerator;", "getOutputDir", "getRootFolders", "getRootPackageName", "getSchemaFile", "getUseSemanticNaming", "getWarnOnDeprecatedUsages", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "apollo-compiler"})
    public static final class Arguments {
        @NotNull
        private final List<File> rootFolders;
        @NotNull
        private final Set<File> graphqlFiles;
        @Nullable
        private final File schemaFile;
        @NotNull
        private final File outputDir;
        @NotNull
        private final List<File> metadata;
        @NotNull
        private final String moduleName;
        @NotNull
        private final File metadataOutputFile;
        @NotNull
        private final Set<String> alwaysGenerateTypesMatching;
        @Nullable
        private final File operationOutputFile;
        @NotNull
        private final OperationOutputGenerator operationOutputGenerator;
        private final boolean dumpIR;
        @NotNull
        private final String rootPackageName;
        private final boolean generateKotlinModels;
        @NotNull
        private final Map<String, String> customScalarsMapping;
        private final boolean useSemanticNaming;
        private final boolean warnOnDeprecatedUsages;
        private final boolean failOnWarnings;
        private final boolean generateFragmentImplementations;
        private final boolean generateAsInternal;
        private final boolean generateFilterNotNull;
        @NotNull
        private final Set<String> enumAsSealedClassPatternFilters;
        private final boolean generateFragmentsAsInterfaces;

        @NotNull
        public final List<File> getRootFolders() {
            return this.rootFolders;
        }

        @NotNull
        public final Set<File> getGraphqlFiles() {
            return this.graphqlFiles;
        }

        @Nullable
        public final File getSchemaFile() {
            return this.schemaFile;
        }

        @NotNull
        public final File getOutputDir() {
            return this.outputDir;
        }

        @NotNull
        public final List<File> getMetadata() {
            return this.metadata;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final File getMetadataOutputFile() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final Set<String> getAlwaysGenerateTypesMatching() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File getOperationOutputFile() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator getOperationOutputGenerator() {
            return this.operationOutputGenerator;
        }

        public final boolean getDumpIR() {
            return this.dumpIR;
        }

        @NotNull
        public final String getRootPackageName() {
            return this.rootPackageName;
        }

        public final boolean getGenerateKotlinModels() {
            return this.generateKotlinModels;
        }

        @NotNull
        public final Map<String, String> getCustomScalarsMapping() {
            return this.customScalarsMapping;
        }

        public final boolean getUseSemanticNaming() {
            return this.useSemanticNaming;
        }

        public final boolean getWarnOnDeprecatedUsages() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        public final boolean getGenerateFragmentImplementations() {
            return this.generateFragmentImplementations;
        }

        public final boolean getGenerateAsInternal() {
            return this.generateAsInternal;
        }

        public final boolean getGenerateFilterNotNull() {
            return this.generateFilterNotNull;
        }

        @NotNull
        public final Set<String> getEnumAsSealedClassPatternFilters() {
            return this.enumAsSealedClassPatternFilters;
        }

        public final boolean getGenerateFragmentsAsInterfaces() {
            return this.generateFragmentsAsInterfaces;
        }

        public Arguments(@NotNull List<? extends File> rootFolders, @NotNull Set<? extends File> graphqlFiles, @Nullable File schemaFile, @NotNull File outputDir, @NotNull List<? extends File> metadata2, @NotNull String moduleName, @NotNull File metadataOutputFile, @NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean dumpIR, @NotNull String rootPackageName, boolean generateKotlinModels, @NotNull Map<String, String> customScalarsMapping, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, boolean generateFragmentImplementations, boolean generateAsInternal, boolean generateFilterNotNull, @NotNull Set<String> enumAsSealedClassPatternFilters, boolean generateFragmentsAsInterfaces) {
            Intrinsics.checkParameterIsNotNull(rootFolders, "rootFolders");
            Intrinsics.checkParameterIsNotNull(graphqlFiles, "graphqlFiles");
            Intrinsics.checkParameterIsNotNull(outputDir, "outputDir");
            Intrinsics.checkParameterIsNotNull(metadata2, "metadata");
            Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
            Intrinsics.checkParameterIsNotNull(metadataOutputFile, "metadataOutputFile");
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, "alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull(operationOutputGenerator, "operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull(rootPackageName, "rootPackageName");
            Intrinsics.checkParameterIsNotNull(customScalarsMapping, "customScalarsMapping");
            Intrinsics.checkParameterIsNotNull(enumAsSealedClassPatternFilters, "enumAsSealedClassPatternFilters");
            this.rootFolders = rootFolders;
            this.graphqlFiles = graphqlFiles;
            this.schemaFile = schemaFile;
            this.outputDir = outputDir;
            this.metadata = metadata2;
            this.moduleName = moduleName;
            this.metadataOutputFile = metadataOutputFile;
            this.alwaysGenerateTypesMatching = alwaysGenerateTypesMatching;
            this.operationOutputFile = operationOutputFile;
            this.operationOutputGenerator = operationOutputGenerator;
            this.dumpIR = dumpIR;
            this.rootPackageName = rootPackageName;
            this.generateKotlinModels = generateKotlinModels;
            this.customScalarsMapping = customScalarsMapping;
            this.useSemanticNaming = useSemanticNaming;
            this.warnOnDeprecatedUsages = warnOnDeprecatedUsages;
            this.failOnWarnings = failOnWarnings;
            this.generateFragmentImplementations = generateFragmentImplementations;
            this.generateAsInternal = generateAsInternal;
            this.generateFilterNotNull = generateFilterNotNull;
            this.enumAsSealedClassPatternFilters = enumAsSealedClassPatternFilters;
            this.generateFragmentsAsInterfaces = generateFragmentsAsInterfaces;
        }

        public /* synthetic */ Arguments(List list, Set set, File file, File file2, List list2, String string, File file3, Set set2, File file4, OperationOutputGenerator operationOutputGenerator, boolean bl, String string2, boolean bl2, Map map2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, Set set3, boolean bl9, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x20) != 0) {
                string = "?";
            }
            if ((n & 0x80) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 0x100) != 0) {
                file4 = null;
            }
            if ((n & 0x200) != 0) {
                operationOutputGenerator = new OperationOutputGenerator.DefaultOperationOuputGenerator(new OperationIdGenerator.Sha256());
            }
            if ((n & 0x400) != 0) {
                bl = false;
            }
            if ((n & 0x800) != 0) {
                string2 = "";
            }
            if ((n & 0x1000) != 0) {
                bl2 = false;
            }
            if ((n & 0x2000) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 0x4000) != 0) {
                bl3 = true;
            }
            if ((n & 0x8000) != 0) {
                bl4 = true;
            }
            if ((n & 0x10000) != 0) {
                bl5 = false;
            }
            if ((n & 0x20000) != 0) {
                bl6 = false;
            }
            if ((n & 0x40000) != 0) {
                bl7 = false;
            }
            if ((n & 0x80000) != 0) {
                bl8 = false;
            }
            if ((n & 0x100000) != 0) {
                set3 = SetsKt.emptySet();
            }
            if ((n & 0x200000) != 0) {
                bl9 = true;
            }
            this(list, set, file, file2, list2, string, file3, set2, file4, operationOutputGenerator, bl, string2, bl2, map2, bl3, bl4, bl5, bl6, bl7, bl8, set3, bl9);
        }

        @NotNull
        public final List<File> component1() {
            return this.rootFolders;
        }

        @NotNull
        public final Set<File> component2() {
            return this.graphqlFiles;
        }

        @Nullable
        public final File component3() {
            return this.schemaFile;
        }

        @NotNull
        public final File component4() {
            return this.outputDir;
        }

        @NotNull
        public final List<File> component5() {
            return this.metadata;
        }

        @NotNull
        public final String component6() {
            return this.moduleName;
        }

        @NotNull
        public final File component7() {
            return this.metadataOutputFile;
        }

        @NotNull
        public final Set<String> component8() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File component9() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator component10() {
            return this.operationOutputGenerator;
        }

        public final boolean component11() {
            return this.dumpIR;
        }

        @NotNull
        public final String component12() {
            return this.rootPackageName;
        }

        public final boolean component13() {
            return this.generateKotlinModels;
        }

        @NotNull
        public final Map<String, String> component14() {
            return this.customScalarsMapping;
        }

        public final boolean component15() {
            return this.useSemanticNaming;
        }

        public final boolean component16() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean component17() {
            return this.failOnWarnings;
        }

        public final boolean component18() {
            return this.generateFragmentImplementations;
        }

        public final boolean component19() {
            return this.generateAsInternal;
        }

        public final boolean component20() {
            return this.generateFilterNotNull;
        }

        @NotNull
        public final Set<String> component21() {
            return this.enumAsSealedClassPatternFilters;
        }

        public final boolean component22() {
            return this.generateFragmentsAsInterfaces;
        }

        @NotNull
        public final Arguments copy(@NotNull List<? extends File> rootFolders, @NotNull Set<? extends File> graphqlFiles, @Nullable File schemaFile, @NotNull File outputDir, @NotNull List<? extends File> metadata2, @NotNull String moduleName, @NotNull File metadataOutputFile, @NotNull Set<String> alwaysGenerateTypesMatching, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, boolean dumpIR, @NotNull String rootPackageName, boolean generateKotlinModels, @NotNull Map<String, String> customScalarsMapping, boolean useSemanticNaming, boolean warnOnDeprecatedUsages, boolean failOnWarnings, boolean generateFragmentImplementations, boolean generateAsInternal, boolean generateFilterNotNull, @NotNull Set<String> enumAsSealedClassPatternFilters, boolean generateFragmentsAsInterfaces) {
            Intrinsics.checkParameterIsNotNull(rootFolders, "rootFolders");
            Intrinsics.checkParameterIsNotNull(graphqlFiles, "graphqlFiles");
            Intrinsics.checkParameterIsNotNull(outputDir, "outputDir");
            Intrinsics.checkParameterIsNotNull(metadata2, "metadata");
            Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
            Intrinsics.checkParameterIsNotNull(metadataOutputFile, "metadataOutputFile");
            Intrinsics.checkParameterIsNotNull(alwaysGenerateTypesMatching, "alwaysGenerateTypesMatching");
            Intrinsics.checkParameterIsNotNull(operationOutputGenerator, "operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull(rootPackageName, "rootPackageName");
            Intrinsics.checkParameterIsNotNull(customScalarsMapping, "customScalarsMapping");
            Intrinsics.checkParameterIsNotNull(enumAsSealedClassPatternFilters, "enumAsSealedClassPatternFilters");
            return new Arguments(rootFolders, graphqlFiles, schemaFile, outputDir, metadata2, moduleName, metadataOutputFile, alwaysGenerateTypesMatching, operationOutputFile, operationOutputGenerator, dumpIR, rootPackageName, generateKotlinModels, customScalarsMapping, useSemanticNaming, warnOnDeprecatedUsages, failOnWarnings, generateFragmentImplementations, generateAsInternal, generateFilterNotNull, enumAsSealedClassPatternFilters, generateFragmentsAsInterfaces);
        }

        public static /* synthetic */ Arguments copy$default(Arguments arguments2, List list, Set set, File file, File file2, List list2, String string, File file3, Set set2, File file4, OperationOutputGenerator operationOutputGenerator, boolean bl, String string2, boolean bl2, Map map2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, Set set3, boolean bl9, int n, Object object) {
            if ((n & 1) != 0) {
                list = arguments2.rootFolders;
            }
            if ((n & 2) != 0) {
                set = arguments2.graphqlFiles;
            }
            if ((n & 4) != 0) {
                file = arguments2.schemaFile;
            }
            if ((n & 8) != 0) {
                file2 = arguments2.outputDir;
            }
            if ((n & 0x10) != 0) {
                list2 = arguments2.metadata;
            }
            if ((n & 0x20) != 0) {
                string = arguments2.moduleName;
            }
            if ((n & 0x40) != 0) {
                file3 = arguments2.metadataOutputFile;
            }
            if ((n & 0x80) != 0) {
                set2 = arguments2.alwaysGenerateTypesMatching;
            }
            if ((n & 0x100) != 0) {
                file4 = arguments2.operationOutputFile;
            }
            if ((n & 0x200) != 0) {
                operationOutputGenerator = arguments2.operationOutputGenerator;
            }
            if ((n & 0x400) != 0) {
                bl = arguments2.dumpIR;
            }
            if ((n & 0x800) != 0) {
                string2 = arguments2.rootPackageName;
            }
            if ((n & 0x1000) != 0) {
                bl2 = arguments2.generateKotlinModels;
            }
            if ((n & 0x2000) != 0) {
                map2 = arguments2.customScalarsMapping;
            }
            if ((n & 0x4000) != 0) {
                bl3 = arguments2.useSemanticNaming;
            }
            if ((n & 0x8000) != 0) {
                bl4 = arguments2.warnOnDeprecatedUsages;
            }
            if ((n & 0x10000) != 0) {
                bl5 = arguments2.failOnWarnings;
            }
            if ((n & 0x20000) != 0) {
                bl6 = arguments2.generateFragmentImplementations;
            }
            if ((n & 0x40000) != 0) {
                bl7 = arguments2.generateAsInternal;
            }
            if ((n & 0x80000) != 0) {
                bl8 = arguments2.generateFilterNotNull;
            }
            if ((n & 0x100000) != 0) {
                set3 = arguments2.enumAsSealedClassPatternFilters;
            }
            if ((n & 0x200000) != 0) {
                bl9 = arguments2.generateFragmentsAsInterfaces;
            }
            return arguments2.copy(list, set, file, file2, list2, string, file3, set2, file4, operationOutputGenerator, bl, string2, bl2, map2, bl3, bl4, bl5, bl6, bl7, bl8, set3, bl9);
        }

        @NotNull
        public String toString() {
            return "Arguments(rootFolders=" + this.rootFolders + ", graphqlFiles=" + this.graphqlFiles + ", schemaFile=" + this.schemaFile + ", outputDir=" + this.outputDir + ", metadata=" + this.metadata + ", moduleName=" + this.moduleName + ", metadataOutputFile=" + this.metadataOutputFile + ", alwaysGenerateTypesMatching=" + this.alwaysGenerateTypesMatching + ", operationOutputFile=" + this.operationOutputFile + ", operationOutputGenerator=" + this.operationOutputGenerator + ", dumpIR=" + this.dumpIR + ", rootPackageName=" + this.rootPackageName + ", generateKotlinModels=" + this.generateKotlinModels + ", customScalarsMapping=" + this.customScalarsMapping + ", useSemanticNaming=" + this.useSemanticNaming + ", warnOnDeprecatedUsages=" + this.warnOnDeprecatedUsages + ", failOnWarnings=" + this.failOnWarnings + ", generateFragmentImplementations=" + this.generateFragmentImplementations + ", generateAsInternal=" + this.generateAsInternal + ", generateFilterNotNull=" + this.generateFilterNotNull + ", enumAsSealedClassPatternFilters=" + this.enumAsSealedClassPatternFilters + ", generateFragmentsAsInterfaces=" + this.generateFragmentsAsInterfaces + ")";
        }

        public int hashCode() {
            List<File> list = this.rootFolders;
            Set<File> set = this.graphqlFiles;
            File file = this.schemaFile;
            File file2 = this.outputDir;
            List<File> list2 = this.metadata;
            String string = this.moduleName;
            File file3 = this.metadataOutputFile;
            Set<String> set2 = this.alwaysGenerateTypesMatching;
            File file4 = this.operationOutputFile;
            OperationOutputGenerator operationOutputGenerator = this.operationOutputGenerator;
            int n = ((((((((((list != null ? ((Object)list).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0)) * 31 + (operationOutputGenerator != null ? operationOutputGenerator.hashCode() : 0)) * 31;
            int n2 = this.dumpIR ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string2 = this.rootPackageName;
            int n3 = ((n + n2) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n4 = this.generateKotlinModels ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            Map<String, String> map2 = this.customScalarsMapping;
            int n5 = ((n3 + n4) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31;
            int n6 = this.useSemanticNaming ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            int n7 = (n5 + n6) * 31;
            int n8 = this.warnOnDeprecatedUsages ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            int n9 = (n7 + n8) * 31;
            int n10 = this.failOnWarnings ? 1 : 0;
            if (n10 != 0) {
                n10 = 1;
            }
            int n11 = (n9 + n10) * 31;
            int n12 = this.generateFragmentImplementations ? 1 : 0;
            if (n12 != 0) {
                n12 = 1;
            }
            int n13 = (n11 + n12) * 31;
            int n14 = this.generateAsInternal ? 1 : 0;
            if (n14 != 0) {
                n14 = 1;
            }
            int n15 = (n13 + n14) * 31;
            int n16 = this.generateFilterNotNull ? 1 : 0;
            if (n16 != 0) {
                n16 = 1;
            }
            Set<String> set3 = this.enumAsSealedClassPatternFilters;
            int n17 = ((n15 + n16) * 31 + (set3 != null ? ((Object)set3).hashCode() : 0)) * 31;
            int n18 = this.generateFragmentsAsInterfaces ? 1 : 0;
            if (n18 != 0) {
                n18 = 1;
            }
            return n17 + n18;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Arguments)) break block3;
                    Arguments arguments2 = (Arguments)object;
                    if (!Intrinsics.areEqual(this.rootFolders, arguments2.rootFolders) || !Intrinsics.areEqual(this.graphqlFiles, arguments2.graphqlFiles) || !Intrinsics.areEqual(this.schemaFile, arguments2.schemaFile) || !Intrinsics.areEqual(this.outputDir, arguments2.outputDir) || !Intrinsics.areEqual(this.metadata, arguments2.metadata) || !Intrinsics.areEqual(this.moduleName, arguments2.moduleName) || !Intrinsics.areEqual(this.metadataOutputFile, arguments2.metadataOutputFile) || !Intrinsics.areEqual(this.alwaysGenerateTypesMatching, arguments2.alwaysGenerateTypesMatching) || !Intrinsics.areEqual(this.operationOutputFile, arguments2.operationOutputFile) || !Intrinsics.areEqual(this.operationOutputGenerator, arguments2.operationOutputGenerator) || this.dumpIR != arguments2.dumpIR || !Intrinsics.areEqual(this.rootPackageName, arguments2.rootPackageName) || this.generateKotlinModels != arguments2.generateKotlinModels || !Intrinsics.areEqual(this.customScalarsMapping, arguments2.customScalarsMapping) || this.useSemanticNaming != arguments2.useSemanticNaming || this.warnOnDeprecatedUsages != arguments2.warnOnDeprecatedUsages || this.failOnWarnings != arguments2.failOnWarnings || this.generateFragmentImplementations != arguments2.generateFragmentImplementations || this.generateAsInternal != arguments2.generateAsInternal || this.generateFilterNotNull != arguments2.generateFilterNotNull || !Intrinsics.areEqual(this.enumAsSealedClassPatternFilters, arguments2.enumAsSealedClassPatternFilters) || this.generateFragmentsAsInterfaces != arguments2.generateFragmentsAsInterfaces) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion;", "", "()V", "NoOpLogger", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Logger;", "collectMetadata", "Lcom/apollographql/apollo3/compiler/ApolloMetadata;", "metadata", "", "Ljava/io/File;", "getSchemaInfo", "Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion$SchemaInfo;", "roots", "Lcom/apollographql/apollo3/compiler/Roots;", "rootPackageName", "", "schemaFile", "SchemaInfo", "apollo-compiler"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final ApolloMetadata collectMetadata(List<? extends File> metadata2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = metadata2;
            ApolloMetadata.Companion companion = ApolloMetadata.Companion;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ApolloMetadata apolloMetadata;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                if (ApolloMetadata.Companion.readFrom(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ApolloMetadata it$iv$iv = apolloMetadata;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return companion.merge(list);
        }

        private final SchemaInfo getSchemaInfo(Roots roots, String rootPackageName, File schemaFile, ApolloMetadata metadata2) {
            boolean bl = schemaFile != null || metadata2 != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "ApolloGraphQL: cannot find schema.[json | sdl]";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = schemaFile == null || metadata2 == null;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                File file = schemaFile;
                String string = "ApolloGraphQL: You can't define a schema in " + (file != null ? file.getAbsolutePath() : null) + " as one is already defined in a dependency. " + "Either remove the schema or the dependency";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (schemaFile != null) {
                String string;
                Schema schema = Intrinsics.areEqual(FilesKt.getExtension(schemaFile), "json") ? Introspection_to_schemaKt.toSchema(IntrospectionSchema.Companion.invoke(schemaFile)) : GraphQLParser.INSTANCE.parseSchema(schemaFile);
                try {
                    String string2 = schemaFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "schemaFile.absolutePath");
                    string = roots.filePackageName(string2);
                }
                catch (IllegalArgumentException e) {
                    string = "";
                }
                String packageName = string;
                String schemaPackageName = StringsKt.removeSuffix(StringsKt.removePrefix(rootPackageName + '.' + packageName, (CharSequence)"."), (CharSequence)".");
                return new SchemaInfo(schema, schemaPackageName);
            }
            if (metadata2 != null) {
                Schema schema = metadata2.getSchema();
                if (schema == null) {
                    Intrinsics.throwNpe();
                }
                String string = metadata2.getSchemaPackageName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return new SchemaInfo(schema, string);
            }
            throw (Throwable)new IllegalStateException("There should at least be metadata or schemaFile");
        }

        @NotNull
        public final Logger getNoOpLogger() {
            return NoOpLogger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/compiler/GraphQLCompiler$Companion$SchemaInfo;", "", "schema", "Lcom/apollographql/apollo3/compiler/frontend/Schema;", "schemaPackageName", "", "(Lcom/apollographql/apollo3/compiler/frontend/Schema;Ljava/lang/String;)V", "getSchema", "()Lcom/apollographql/apollo3/compiler/frontend/Schema;", "getSchemaPackageName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "apollo-compiler"})
        private static final class SchemaInfo {
            @NotNull
            private final Schema schema;
            @NotNull
            private final String schemaPackageName;

            @NotNull
            public final Schema getSchema() {
                return this.schema;
            }

            @NotNull
            public final String getSchemaPackageName() {
                return this.schemaPackageName;
            }

            public SchemaInfo(@NotNull Schema schema, @NotNull String schemaPackageName) {
                Intrinsics.checkParameterIsNotNull(schema, "schema");
                Intrinsics.checkParameterIsNotNull(schemaPackageName, "schemaPackageName");
                this.schema = schema;
                this.schemaPackageName = schemaPackageName;
            }

            @NotNull
            public final Schema component1() {
                return this.schema;
            }

            @NotNull
            public final String component2() {
                return this.schemaPackageName;
            }

            @NotNull
            public final SchemaInfo copy(@NotNull Schema schema, @NotNull String schemaPackageName) {
                Intrinsics.checkParameterIsNotNull(schema, "schema");
                Intrinsics.checkParameterIsNotNull(schemaPackageName, "schemaPackageName");
                return new SchemaInfo(schema, schemaPackageName);
            }

            public static /* synthetic */ SchemaInfo copy$default(SchemaInfo schemaInfo, Schema schema, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    schema = schemaInfo.schema;
                }
                if ((n & 2) != 0) {
                    string = schemaInfo.schemaPackageName;
                }
                return schemaInfo.copy(schema, string);
            }

            @NotNull
            public String toString() {
                return "SchemaInfo(schema=" + this.schema + ", schemaPackageName=" + this.schemaPackageName + ")";
            }

            public int hashCode() {
                Schema schema = this.schema;
                String string = this.schemaPackageName;
                return (schema != null ? schema.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SchemaInfo)) break block3;
                        SchemaInfo schemaInfo = (SchemaInfo)object;
                        if (!Intrinsics.areEqual(this.schema, schemaInfo.schema) || !Intrinsics.areEqual(this.schemaPackageName, schemaInfo.schemaPackageName)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

