/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.graphql.ast;

import com.apollographql.apollo3.graphql.ast.GQLBooleanValue;
import com.apollographql.apollo3.graphql.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.graphql.ast.GQLEnumValue;
import com.apollographql.apollo3.graphql.ast.GQLEnumValueDefinition;
import com.apollographql.apollo3.graphql.ast.GQLFloatValue;
import com.apollographql.apollo3.graphql.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.graphql.ast.GQLInputValueDefinition;
import com.apollographql.apollo3.graphql.ast.GQLIntValue;
import com.apollographql.apollo3.graphql.ast.GQLListType;
import com.apollographql.apollo3.graphql.ast.GQLListValue;
import com.apollographql.apollo3.graphql.ast.GQLNamedType;
import com.apollographql.apollo3.graphql.ast.GQLNonNullType;
import com.apollographql.apollo3.graphql.ast.GQLNullValue;
import com.apollographql.apollo3.graphql.ast.GQLObjectField;
import com.apollographql.apollo3.graphql.ast.GQLObjectValue;
import com.apollographql.apollo3.graphql.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.graphql.ast.GQLStringValue;
import com.apollographql.apollo3.graphql.ast.GQLType;
import com.apollographql.apollo3.graphql.ast.GQLTypeDefinition;
import com.apollographql.apollo3.graphql.ast.GQLValue;
import com.apollographql.apollo3.graphql.ast.GQLVariableValue;
import com.apollographql.apollo3.graphql.ast.GqlenumvaluedefinitionKt;
import com.apollographql.apollo3.graphql.ast.GqlnodeKt;
import com.apollographql.apollo3.graphql.ast.GqltypeKt;
import com.apollographql.apollo3.graphql.ast.InputValueValidationResult;
import com.apollographql.apollo3.graphql.ast.Issue;
import com.apollographql.apollo3.graphql.ast.Schema;
import com.apollographql.apollo3.graphql.ast.SourceLocation;
import com.apollographql.apollo3.graphql.ast.VariableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001cH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/apollographql/apollo3/graphql/ast/InputValueValidationScope;", "", "schema", "Lcom/apollographql/apollo3/graphql/ast/Schema;", "(Lcom/apollographql/apollo3/graphql/ast/Schema;)V", "issues", "", "Lcom/apollographql/apollo3/graphql/ast/Issue;", "getSchema", "()Lcom/apollographql/apollo3/graphql/ast/Schema;", "variableReferences", "Lcom/apollographql/apollo3/graphql/ast/VariableReference;", "registerIssue", "", "value", "Lcom/apollographql/apollo3/graphql/ast/GQLValue;", "expectedType", "Lcom/apollographql/apollo3/graphql/ast/GQLType;", "validateAndCoerce", "Lcom/apollographql/apollo3/graphql/ast/InputValueValidationResult;", "validateAndCoerceEnum", "enumTypeDefinition", "Lcom/apollographql/apollo3/graphql/ast/GQLEnumTypeDefinition;", "validateAndCoerceInputObject", "expectedTypeDefinition", "Lcom/apollographql/apollo3/graphql/ast/GQLInputObjectTypeDefinition;", "validateAndCoerceInternal", "validateAndCoerceScalar", "Lcom/apollographql/apollo3/graphql/ast/GQLNamedType;", "apollo-graphql-ast"})
public final class InputValueValidationScope {
    @NotNull
    private final Schema schema;
    @NotNull
    private final List<Issue> issues;
    @NotNull
    private final List<VariableReference> variableReferences;

    public InputValueValidationScope(@NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        this.schema = schema;
        boolean bl = false;
        this.issues = new ArrayList();
        bl = false;
        this.variableReferences = new ArrayList();
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final InputValueValidationResult validateAndCoerce(@NotNull GQLValue value, @NotNull GQLType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        return new InputValueValidationResult(this.validateAndCoerceInternal(value, expectedType), this.variableReferences, this.issues);
    }

    private final void registerIssue(GQLValue value, GQLType expectedType) {
        this.issues.add(new Issue.ValidationError("Value `" + GqlnodeKt.toUtf8$default(value, null, 1, null) + "` cannot be used in position expecting `" + GqltypeKt.pretty(expectedType) + '`', value.getSourceLocation()));
    }

    /*
     * WARNING - void declaration
     */
    private final GQLValue validateAndCoerceInputObject(GQLValue value, GQLInputObjectTypeDefinition expectedTypeDefinition) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        GQLNamedType expectedType = new GQLNamedType(null, expectedTypeDefinition.getName(), 1, null);
        if (!(value instanceof GQLObjectValue)) {
            this.registerIssue(value, expectedType);
            return value;
        }
        Iterable $this$forEach$iv = expectedTypeDefinition.getInputFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            GQLInputValueDefinition inputValueDefinition;
            block7: {
                inputValueDefinition = (GQLInputValueDefinition)element$iv;
                boolean bl = false;
                if (!(inputValueDefinition.getType() instanceof GQLNonNullType) || inputValueDefinition.getDefaultValue() != null) continue;
                Iterable $this$firstOrNull$iv = ((GQLObjectValue)value).getFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GQLObjectField it = (GQLObjectField)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)inputValueDefinition.getName())) continue;
                    v0 = element$iv2;
                    break block7;
                }
                v0 = null;
            }
            if (v0 != null) continue;
            this.issues.add(new Issue.ValidationError(Intrinsics.stringPlus((String)"No value passed for required inputField ", (Object)inputValueDefinition.getName()), value.getSourceLocation()));
        }
        $this$forEach$iv = ((GQLObjectValue)value).getFields();
        SourceLocation sourceLocation = null;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GQLObjectField gQLObjectField;
            Object v1;
            GQLObjectField field;
            block8: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                field = (GQLObjectField)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = expectedTypeDefinition.getInputFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GQLInputValueDefinition it = (GQLInputValueDefinition)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)field.getName())) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            GQLInputValueDefinition inputField = v1;
            if (inputField == null) {
                this.issues.add(new Issue.ValidationError("Field " + field.getName() + " is not defined by " + GqltypeKt.pretty(expectedType), field.getSourceLocation()));
                gQLObjectField = null;
            } else {
                gQLObjectField = new GQLObjectField(null, field.getName(), this.validateAndCoerceInternal(field.getValue(), inputField.getType()), 1, null);
            }
            if (gQLObjectField == null) continue;
            GQLObjectField gQLObjectField2 = gQLObjectField;
            boolean bl = false;
            boolean bl5 = false;
            GQLObjectField it$iv$iv = gQLObjectField2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1;
        List list2 = list;
        SourceLocation sourceLocation2 = sourceLocation;
        return new GQLObjectValue(sourceLocation2, list2, n, defaultConstructorMarker);
    }

    private final GQLValue validateAndCoerceEnum(GQLValue value, GQLEnumTypeDefinition enumTypeDefinition) {
        Object v0;
        block5: {
            GQLNamedType expectedType = new GQLNamedType(null, enumTypeDefinition.getName(), 1, null);
            if (!(value instanceof GQLEnumValue)) {
                this.registerIssue(value, expectedType);
                return value;
            }
            Iterable $this$firstOrNull$iv = enumTypeDefinition.getEnumValues();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLEnumValueDefinition it = (GQLEnumValueDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)((GQLEnumValue)value).getValue())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        GQLEnumValueDefinition enumValue = v0;
        if (enumValue == null) {
            this.issues.add(new Issue.ValidationError("Cannot find enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', value.getSourceLocation()));
        } else if (GqlenumvaluedefinitionKt.isDeprecated(enumValue)) {
            this.issues.add(new Issue.DeprecatedUsage("Use of deprecated enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', value.getSourceLocation()));
        }
        return value;
    }

    private final GQLValue validateAndCoerceScalar(GQLValue value, GQLNamedType expectedType) {
        GQLValue gQLValue;
        switch (expectedType.getName()) {
            case "Int": {
                if (!(value instanceof GQLIntValue)) {
                    this.registerIssue(value, expectedType);
                }
                gQLValue = value;
                break;
            }
            case "Float": {
                GQLValue gQLValue2 = value;
                if (gQLValue2 instanceof GQLFloatValue) {
                    gQLValue = value;
                    break;
                }
                if (gQLValue2 instanceof GQLIntValue) {
                    gQLValue = new GQLFloatValue(null, ((GQLIntValue)value).getValue(), 1, null);
                    break;
                }
                this.registerIssue(value, expectedType);
                gQLValue = value;
                break;
            }
            case "String": {
                if (!(value instanceof GQLStringValue)) {
                    this.registerIssue(value, expectedType);
                }
                gQLValue = value;
                break;
            }
            case "Boolean": {
                if (!(value instanceof GQLBooleanValue)) {
                    this.registerIssue(value, expectedType);
                }
                gQLValue = value;
                break;
            }
            case "ID": {
                if (!(value instanceof GQLStringValue) && !(value instanceof GQLIntValue)) {
                    this.registerIssue(value, expectedType);
                }
                gQLValue = value;
                break;
            }
            default: {
                this.registerIssue(value, expectedType);
                gQLValue = value;
            }
        }
        return gQLValue;
    }

    /*
     * WARNING - void declaration
     */
    private final GQLValue validateAndCoerceInternal(GQLValue value, GQLType expectedType) {
        if (value instanceof GQLVariableValue) {
            this.variableReferences.add(new VariableReference((GQLVariableValue)value, expectedType));
            return value;
        }
        if (value instanceof GQLNullValue) {
            if (expectedType instanceof GQLNonNullType) {
                this.registerIssue(value, expectedType);
                return value;
            }
            return value;
        }
        GQLType gQLType = expectedType;
        if (gQLType instanceof GQLNonNullType) {
            return this.validateAndCoerceInternal(value, ((GQLNonNullType)expectedType).getType());
        }
        if (gQLType instanceof GQLListType) {
            Collection<GQLValue> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!(value instanceof GQLListValue)) {
                this.registerIssue(value, expectedType);
                return value;
            }
            Iterable iterable = ((GQLListValue)value).getValues();
            SourceLocation sourceLocation = null;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GQLValue gQLValue = (GQLValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                GQLValue gQLValue2 = this.validateAndCoerceInternal((GQLValue)it, ((GQLListType)expectedType).getType());
                collection.add(gQLValue2);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 1;
            List list = collection;
            SourceLocation sourceLocation2 = sourceLocation;
            return new GQLListValue(sourceLocation2, list, n, defaultConstructorMarker);
        }
        if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition expectedTypeDefinition = this.schema.typeDefinition(((GQLNamedType)expectedType).getName());
            if (expectedTypeDefinition instanceof GQLInputObjectTypeDefinition) {
                return this.validateAndCoerceInputObject(value, (GQLInputObjectTypeDefinition)expectedTypeDefinition);
            }
            if (expectedTypeDefinition instanceof GQLScalarTypeDefinition) {
                if (!expectedTypeDefinition.isBuiltIn()) {
                    return value;
                }
                return this.validateAndCoerceScalar(value, (GQLNamedType)expectedType);
            }
            if (expectedTypeDefinition instanceof GQLEnumTypeDefinition) {
                return this.validateAndCoerceEnum(value, (GQLEnumTypeDefinition)expectedTypeDefinition);
            }
            this.issues.add(new Issue.ValidationError(Intrinsics.stringPlus((String)"Value cannot be of non-input type ", (Object)GqltypeKt.pretty(expectedType)), value.getSourceLocation()));
            return value;
        }
        throw new NoWhenBranchMatchedException();
    }
}

