/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.rx2.java;

import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.java.Assertions;
import com.apollographql.apollo.runtime.java.ApolloCall;
import com.apollographql.apollo.runtime.java.ApolloCallback;
import com.apollographql.apollo.runtime.java.ApolloDisposable;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.disposables.Disposable;
import org.jetbrains.annotations.NotNull;

public class Rx2Apollo {
    @CheckReturnValue
    @NotNull
    public static <T extends Operation.Data> Flowable<ApolloResponse<T>> flowable(@NotNull ApolloCall<T> call, @NotNull BackpressureStrategy backpressureStrategy) {
        Assertions.checkNotNull(call, (String)"originalCall == null");
        Assertions.checkNotNull((Object)backpressureStrategy, (String)"backpressureStrategy == null");
        return Flowable.create(emitter -> {
            final ApolloDisposable disposable = call.enqueue(new ApolloCallback<T>(){

                public void onResponse(@NotNull ApolloResponse<T> response) {
                    if (!emitter.isCancelled()) {
                        emitter.onNext(response);
                    }
                }
            });
            disposable.addListener(() -> {
                if (!emitter.isCancelled()) {
                    emitter.onComplete();
                }
            });
            emitter.setDisposable(new Disposable(){

                public void dispose() {
                    disposable.dispose();
                }

                public boolean isDisposed() {
                    return disposable.isDisposed();
                }
            });
        }, (BackpressureStrategy)backpressureStrategy);
    }

    @CheckReturnValue
    @NotNull
    public static <T extends Operation.Data> Flowable<ApolloResponse<T>> flowable(@NotNull ApolloCall<T> call) {
        return Rx2Apollo.flowable(call, BackpressureStrategy.BUFFER);
    }

    @CheckReturnValue
    @NotNull
    public static <T extends Operation.Data> Single<ApolloResponse<T>> single(@NotNull ApolloCall<T> call, @NotNull BackpressureStrategy backpressureStrategy) {
        return Rx2Apollo.flowable(call, backpressureStrategy).firstOrError();
    }

    @CheckReturnValue
    @NotNull
    public static <T extends Operation.Data> Single<ApolloResponse<T>> single(@NotNull ApolloCall<T> call) {
        return Rx2Apollo.single(call, BackpressureStrategy.BUFFER);
    }
}

