/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.FileUpload;
import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.InputType;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.InputFieldJsonWriter;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.request.RequestHeaders;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 @2\u00020\u0001:\u0002@AB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ2\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020(H\u0016J\u0016\u00102\u001a\u00020(2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J:\u00107\u001a\u00020\u001b2\u0012\u0010+\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tJ:\u0010:\u001a\u00020\u001b2\u0012\u0010+\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tJ(\u0010;\u001a\u00020(2\u0006\u00103\u001a\u0002042\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u00105\u001a\u000206H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006B"}, d2={"Lcom/apollographql/apollo/internal/interceptor/ApolloServerInterceptor;", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor;", "serverUrl", "Lokhttp3/HttpUrl;", "httpCallFactory", "Lokhttp3/Call$Factory;", "cachePolicy", "Lcom/apollographql/apollo/api/cache/http/HttpCachePolicy$Policy;", "prefetch", "", "scalarTypeAdapters", "Lcom/apollographql/apollo/api/ScalarTypeAdapters;", "logger", "Lcom/apollographql/apollo/api/internal/ApolloLogger;", "(Lokhttp3/HttpUrl;Lokhttp3/Call$Factory;Lcom/apollographql/apollo/api/cache/http/HttpCachePolicy$Policy;ZLcom/apollographql/apollo/api/ScalarTypeAdapters;Lcom/apollographql/apollo/api/internal/ApolloLogger;)V", "Lcom/apollographql/apollo/api/internal/Optional;", "getCachePolicy", "()Lcom/apollographql/apollo/api/internal/Optional;", "disposed", "getDisposed", "()Z", "setDisposed", "(Z)V", "getHttpCallFactory", "()Lokhttp3/Call$Factory;", "httpCallRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lokhttp3/Call;", "getHttpCallRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "setHttpCallRef", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "getLogger", "()Lcom/apollographql/apollo/api/internal/ApolloLogger;", "getPrefetch", "getScalarTypeAdapters", "()Lcom/apollographql/apollo/api/ScalarTypeAdapters;", "getServerUrl", "()Lokhttp3/HttpUrl;", "decorateRequest", "", "requestBuilder", "Lokhttp3/Request$Builder;", "operation", "Lcom/apollographql/apollo/api/Operation;", "cacheHeaders", "Lcom/apollographql/apollo/cache/CacheHeaders;", "requestHeaders", "Lcom/apollographql/apollo/request/RequestHeaders;", "dispose", "executeHttpCall", "request", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$InterceptorRequest;", "callBack", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor$CallBack;", "httpGetCall", "writeQueryDocument", "autoPersistQueries", "httpPostCall", "interceptAsync", "chain", "Lcom/apollographql/apollo/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "Companion", "FileUploadMeta", "apollo-runtime"})
public final class ApolloServerInterceptor
implements ApolloInterceptor {
    @NotNull
    private final HttpUrl serverUrl;
    @NotNull
    private final Call.Factory httpCallFactory;
    @NotNull
    private final Optional<HttpCachePolicy.Policy> cachePolicy;
    private final boolean prefetch;
    @NotNull
    private final ApolloLogger logger;
    @NotNull
    private final ScalarTypeAdapters scalarTypeAdapters;
    @NotNull
    private AtomicReference<Call> httpCallRef;
    private volatile boolean disposed;
    @NotNull
    public static final String HEADER_ACCEPT_TYPE = "Accept";
    @NotNull
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    @NotNull
    public static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    @NotNull
    public static final String ACCEPT_TYPE = "application/json";
    @NotNull
    public static final String CONTENT_TYPE = "application/json";
    @Nullable
    private static final MediaType MEDIA_TYPE;
    public static final Companion Companion;

    @NotNull
    public final HttpUrl getServerUrl() {
        return this.serverUrl;
    }

    @NotNull
    public final Call.Factory getHttpCallFactory() {
        return this.httpCallFactory;
    }

    @NotNull
    public final Optional<HttpCachePolicy.Policy> getCachePolicy() {
        return this.cachePolicy;
    }

    public final boolean getPrefetch() {
        return this.prefetch;
    }

    @NotNull
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final ScalarTypeAdapters getScalarTypeAdapters() {
        return this.scalarTypeAdapters;
    }

    @NotNull
    public final AtomicReference<Call> getHttpCallRef() {
        return this.httpCallRef;
    }

    public final void setHttpCallRef(@NotNull AtomicReference<Call> atomicReference) {
        Intrinsics.checkParameterIsNotNull(atomicReference, (String)"<set-?>");
        this.httpCallRef = atomicReference;
    }

    public final boolean getDisposed() {
        return this.disposed;
    }

    public final void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @Override
    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkParameterIsNotNull((Object)callBack, (String)"callBack");
        dispatcher.execute(new Runnable(this, request, callBack){
            final /* synthetic */ ApolloServerInterceptor this$0;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;

            public final void run() {
                this.this$0.executeHttpCall(this.$request, this.$callBack);
            }
            {
                this.this$0 = apolloServerInterceptor;
                this.$request = interceptorRequest;
                this.$callBack = callBack;
            }
        });
    }

    @Override
    public void dispose() {
        block0: {
            Call httpCall;
            this.disposed = true;
            Call call = httpCall = (Call)this.httpCallRef.getAndSet(null);
            if (call == null) break block0;
            call.cancel();
        }
    }

    public final void executeHttpCall(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptor.CallBack callBack) {
        Call previousCall;
        Call call;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)callBack, (String)"callBack");
        if (this.disposed) {
            return;
        }
        callBack.onFetch(ApolloInterceptor.FetchSourceType.NETWORK);
        Call httpCall = null;
        try {
            Call call2;
            if (request.useHttpGetMethodForQueries && request.operation instanceof Query) {
                Operation operation = request.operation;
                CacheHeaders cacheHeaders = request.cacheHeaders;
                Intrinsics.checkExpressionValueIsNotNull((Object)cacheHeaders, (String)"request.cacheHeaders");
                RequestHeaders requestHeaders = request.requestHeaders;
                Intrinsics.checkExpressionValueIsNotNull((Object)requestHeaders, (String)"request.requestHeaders");
                call2 = this.httpGetCall(operation, cacheHeaders, requestHeaders, request.sendQueryDocument, request.autoPersistQueries);
            } else {
                Operation operation = request.operation;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"request.operation");
                CacheHeaders cacheHeaders = request.cacheHeaders;
                Intrinsics.checkExpressionValueIsNotNull((Object)cacheHeaders, (String)"request.cacheHeaders");
                RequestHeaders requestHeaders = request.requestHeaders;
                Intrinsics.checkExpressionValueIsNotNull((Object)requestHeaders, (String)"request.requestHeaders");
                call2 = this.httpPostCall(operation, cacheHeaders, requestHeaders, request.sendQueryDocument, request.autoPersistQueries);
            }
            call = call2;
        }
        catch (IOException e) {
            this.logger.e((Throwable)e, "Failed to prepare http call for operation %s", new Object[]{request.operation.name().name()});
            callBack.onFailure(new ApolloNetworkException("Failed to prepare http call", e));
            return;
        }
        httpCall = call;
        Call call3 = previousCall = this.httpCallRef.getAndSet(httpCall);
        if (call3 != null) {
            call3.cancel();
        }
        if (httpCall.isCanceled() || this.disposed) {
            this.httpCallRef.compareAndSet(httpCall, null);
            return;
        }
        httpCall.enqueue(new Callback(this, httpCall, request, callBack){
            final /* synthetic */ ApolloServerInterceptor this$0;
            final /* synthetic */ Call $httpCall;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloInterceptor.CallBack $callBack;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (this.this$0.getDisposed()) {
                    return;
                }
                if (this.this$0.getHttpCallRef().compareAndSet(this.$httpCall, null)) {
                    this.this$0.getLogger().e((Throwable)e, "Failed to execute http call for operation %s", new Object[]{this.$request.operation.name().name()});
                    this.$callBack.onFailure(new ApolloNetworkException("Failed to execute http call", e));
                }
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (this.this$0.getDisposed()) {
                    return;
                }
                if (this.this$0.getHttpCallRef().compareAndSet(this.$httpCall, null)) {
                    this.$callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response));
                    this.$callBack.onCompleted();
                }
            }
            {
                this.this$0 = this$0;
                this.$httpCall = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
                this.$callBack = $captured_local_variable$3;
            }
        });
    }

    @NotNull
    public final Call httpGetCall(@NotNull Operation<?, ?, ?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        Request.Builder requestBuilder;
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkParameterIsNotNull((Object)requestHeaders, (String)"requestHeaders");
        Request.Builder builder = requestBuilder = new Request.Builder().url(Companion.httpGetUrl(this.serverUrl, operation, this.scalarTypeAdapters, writeQueryDocument, autoPersistQueries)).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"requestBuilder");
        this.decorateRequest(builder, operation, cacheHeaders, requestHeaders);
        Call call = this.httpCallFactory.newCall(requestBuilder.build());
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"httpCallFactory.newCall(requestBuilder.build())");
        return call;
    }

    @NotNull
    public final Call httpPostCall(@NotNull Operation<?, ?, ?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        Request.Builder requestBuilder;
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkParameterIsNotNull((Object)requestHeaders, (String)"requestHeaders");
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)Companion.httpPostRequestBody(operation, this.scalarTypeAdapters, writeQueryDocument, autoPersistQueries));
        requestBody = Companion.transformToMultiPartIfUploadExists(requestBody, operation);
        Request.Builder builder = requestBuilder = new Request.Builder().url(this.serverUrl).header(HEADER_CONTENT_TYPE, "application/json").post(requestBody);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"requestBuilder");
        this.decorateRequest(builder, operation, cacheHeaders, requestHeaders);
        Call call = this.httpCallFactory.newCall(requestBuilder.build());
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"httpCallFactory.newCall(requestBuilder.build())");
        return call;
    }

    public final void decorateRequest(@NotNull Request.Builder requestBuilder, @NotNull Operation<?, ?, ?> operation, @NotNull CacheHeaders cacheHeaders, @NotNull RequestHeaders requestHeaders) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkParameterIsNotNull((Object)requestHeaders, (String)"requestHeaders");
        requestBuilder.header(HEADER_ACCEPT_TYPE, "application/json").header(HEADER_APOLLO_OPERATION_ID, operation.operationId()).header(HEADER_APOLLO_OPERATION_NAME, operation.name().name()).tag((Object)operation.operationId());
        for (String header : requestHeaders.headers()) {
            String value = requestHeaders.headerValue(header);
            requestBuilder.header(header, value);
        }
        if (this.cachePolicy.isPresent()) {
            HttpCachePolicy.Policy cachePolicy = (HttpCachePolicy.Policy)this.cachePolicy.get();
            boolean skipCacheHttpResponse = StringsKt.equals((String)"true", (String)cacheHeaders.headerValue("do-not-store"), (boolean)true);
            String cacheKey = Companion.cacheKey(operation, this.scalarTypeAdapters);
            requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch)).header("X-APOLLO-CACHE-DO-NOT-STORE", Boolean.toString(skipCacheHttpResponse));
        }
    }

    public ApolloServerInterceptor(@NotNull HttpUrl serverUrl, @NotNull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @NotNull ScalarTypeAdapters scalarTypeAdapters, @NotNull ApolloLogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkParameterIsNotNull((Object)httpCallFactory, (String)"httpCallFactory");
        Intrinsics.checkParameterIsNotNull((Object)scalarTypeAdapters, (String)"scalarTypeAdapters");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.httpCallRef = new AtomicReference();
        this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null");
        this.httpCallFactory = (Call.Factory)Utils.checkNotNull((Object)httpCallFactory, (Object)"httpCallFactory == null");
        Optional optional = Optional.fromNullable((Object)cachePolicy);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"Optional.fromNullable(cachePolicy)");
        this.cachePolicy = optional;
        this.prefetch = prefetch;
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    static {
        Companion = new Companion(null);
        MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/apollographql/apollo/internal/interceptor/ApolloServerInterceptor$FileUploadMeta;", "", "key", "", "mimetype", "fileUpload", "Lcom/apollographql/apollo/api/FileUpload;", "(Ljava/lang/String;Ljava/lang/String;Lcom/apollographql/apollo/api/FileUpload;)V", "getFileUpload", "()Lcom/apollographql/apollo/api/FileUpload;", "getKey", "()Ljava/lang/String;", "getMimetype", "apollo-runtime"})
    public static final class FileUploadMeta {
        @NotNull
        private final String key;
        @NotNull
        private final String mimetype;
        @NotNull
        private final FileUpload fileUpload;

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getMimetype() {
            return this.mimetype;
        }

        @NotNull
        public final FileUpload getFileUpload() {
            return this.fileUpload;
        }

        public FileUploadMeta(@NotNull String key, @NotNull String mimetype, @NotNull FileUpload fileUpload) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)mimetype, (String)"mimetype");
            Intrinsics.checkParameterIsNotNull((Object)fileUpload, (String)"fileUpload");
            this.key = key;
            this.mimetype = mimetype;
            this.fileUpload = fileUpload;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013J,\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J$\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J<\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u0012\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u001e\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J4\u0010$\u001a\u00020%2\u0012\u0010\u0012\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ(\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J&\u0010*\u001a\u0004\u0018\u00010\u001f2\b\u0010+\u001a\u0004\u0018\u00010\u001f2\u0012\u0010\u0012\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lcom/apollographql/apollo/internal/interceptor/ApolloServerInterceptor$Companion;", "", "()V", "ACCEPT_TYPE", "", "CONTENT_TYPE", "HEADER_ACCEPT_TYPE", "HEADER_APOLLO_OPERATION_ID", "HEADER_APOLLO_OPERATION_NAME", "HEADER_CONTENT_TYPE", "MEDIA_TYPE", "Lokhttp3/MediaType;", "getMEDIA_TYPE", "()Lokhttp3/MediaType;", "addExtensionsUrlQueryParameter", "", "urlBuilder", "Lokhttp3/HttpUrl$Builder;", "operation", "Lcom/apollographql/apollo/api/Operation;", "addVariablesUrlQueryParameter", "scalarTypeAdapters", "Lcom/apollographql/apollo/api/ScalarTypeAdapters;", "cacheKey", "httpGetUrl", "Lokhttp3/HttpUrl;", "serverUrl", "writeQueryDocument", "", "autoPersistQueries", "httpMultipartRequestBody", "Lokhttp3/RequestBody;", "operations", "fileUploadMetaList", "Ljava/util/ArrayList;", "Lcom/apollographql/apollo/internal/interceptor/ApolloServerInterceptor$FileUploadMeta;", "httpPostRequestBody", "Lokio/ByteString;", "recursiveGetUploadData", "value", "variableName", "allUploads", "transformToMultiPartIfUploadExists", "originalBody", "apollo-runtime"})
    public static final class Companion {
        @Nullable
        public final MediaType getMEDIA_TYPE() {
            return MEDIA_TYPE;
        }

        @NotNull
        public final String cacheKey(@NotNull Operation<?, ?, ?> operation, @Nullable ScalarTypeAdapters scalarTypeAdapters) throws IOException {
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            return this.httpPostRequestBody(operation, scalarTypeAdapters, true, true).md5().hex();
        }

        @NotNull
        public final ByteString httpPostRequestBody(@NotNull Operation<?, ?, ?> operation, @Nullable ScalarTypeAdapters scalarTypeAdapters, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            ScalarTypeAdapters scalarTypeAdapters2 = scalarTypeAdapters;
            if (scalarTypeAdapters2 == null) {
                Intrinsics.throwNpe();
            }
            return operation.composeRequestBody(autoPersistQueries, writeQueryDocument, scalarTypeAdapters2);
        }

        @NotNull
        public final HttpUrl httpGetUrl(@NotNull HttpUrl serverUrl, @NotNull Operation<?, ?, ?> operation, @Nullable ScalarTypeAdapters scalarTypeAdapters, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)serverUrl, (String)"serverUrl");
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            HttpUrl.Builder urlBuilder = serverUrl.newBuilder();
            if (!autoPersistQueries || writeQueryDocument) {
                urlBuilder.addQueryParameter("query", operation.queryDocument());
            }
            if (operation.variables() != Operation.EMPTY_VARIABLES) {
                HttpUrl.Builder builder = urlBuilder;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"urlBuilder");
                this.addVariablesUrlQueryParameter(builder, operation, scalarTypeAdapters);
            }
            urlBuilder.addQueryParameter("operationName", operation.name().name());
            if (autoPersistQueries) {
                HttpUrl.Builder builder = urlBuilder;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"urlBuilder");
                this.addExtensionsUrlQueryParameter(builder, operation);
            }
            HttpUrl httpUrl = urlBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
            return httpUrl;
        }

        public final void addVariablesUrlQueryParameter(@NotNull HttpUrl.Builder urlBuilder, @NotNull Operation<?, ?, ?> operation, @Nullable ScalarTypeAdapters scalarTypeAdapters) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)urlBuilder, (String)"urlBuilder");
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            Buffer buffer = new Buffer();
            JsonWriter jsonWriter = JsonWriter.Companion.of((BufferedSink)buffer);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.beginObject();
            InputFieldMarshaller inputFieldMarshaller = operation.variables().marshaller();
            ScalarTypeAdapters scalarTypeAdapters2 = scalarTypeAdapters;
            if (scalarTypeAdapters2 == null) {
                Intrinsics.throwNpe();
            }
            inputFieldMarshaller.marshal((InputFieldWriter)new InputFieldJsonWriter(jsonWriter, scalarTypeAdapters2));
            jsonWriter.endObject();
            jsonWriter.close();
            urlBuilder.addQueryParameter("variables", buffer.readUtf8());
        }

        public final void addExtensionsUrlQueryParameter(@NotNull HttpUrl.Builder urlBuilder, @NotNull Operation<?, ?, ?> operation) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)urlBuilder, (String)"urlBuilder");
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            Buffer buffer = new Buffer();
            JsonWriter jsonWriter = JsonWriter.Companion.of((BufferedSink)buffer);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.beginObject();
            jsonWriter.name("persistedQuery").beginObject().name("version").value(1L).name("sha256Hash").value(operation.operationId()).endObject();
            jsonWriter.endObject();
            jsonWriter.close();
            urlBuilder.addQueryParameter("extensions", buffer.readUtf8());
        }

        /*
         * WARNING - void declaration
         */
        private final void recursiveGetUploadData(Object value, String variableName, ArrayList<FileUploadMeta> allUploads) {
            block8: {
                Object object;
                block11: {
                    void $this$filterIsInstanceTo$iv$iv;
                    block10: {
                        block9: {
                            block7: {
                                object = value;
                                if (!(object instanceof InputType)) break block7;
                                try {
                                    Field[] fields;
                                    Field[] fieldArray = fields = ((InputType)value).getClass().getDeclaredFields();
                                    int n = fieldArray.length;
                                    for (int i = 0; i < n; ++i) {
                                        Field field;
                                        Field field2 = field = fieldArray[i];
                                        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
                                        field2.setAccessible(true);
                                        Object subValue = field.get(value);
                                        String key = field.getName();
                                        this.recursiveGetUploadData(subValue, variableName + '.' + key, allUploads);
                                    }
                                }
                                catch (IllegalAccessException fields) {}
                                break block8;
                            }
                            if (!(object instanceof Input)) break block9;
                            Object unwrappedValue = ((Input)value).value;
                            this.recursiveGetUploadData(unwrappedValue, variableName, allUploads);
                            break block8;
                        }
                        if (!(object instanceof FileUpload)) break block10;
                        Object upload = value;
                        allUploads.add(new FileUploadMeta(variableName, ((FileUpload)upload).getMimetype(), (FileUpload)upload));
                        break block8;
                    }
                    if (!(object instanceof Object[])) break block11;
                    int varFileIndex = 0;
                    Object[] $this$filterIsInstance$iv = (Object[])value;
                    boolean $i$f$filterIsInstance = false;
                    Object[] objectArray = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof FileUpload)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FileUpload upload = (FileUpload)element$iv;
                        boolean bl = false;
                        String key = variableName + '.' + varFileIndex;
                        allUploads.add(new FileUploadMeta(key, upload.getMimetype(), upload));
                        int n = 0;
                        System.out.println((Object)key);
                        n = varFileIndex;
                        varFileIndex = n + 1;
                    }
                    break block8;
                }
                if (!(object instanceof Collection)) break block8;
                Iterable $this$forEachIndexed$iv = (Iterable)value;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void element;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object key = item$iv;
                    int index = n;
                    boolean bl2 = false;
                    Companion.recursiveGetUploadData(element, variableName + '.' + index, allUploads);
                }
            }
        }

        @Nullable
        public final RequestBody transformToMultiPartIfUploadExists(@Nullable RequestBody originalBody, @NotNull Operation<?, ?, ?> operation) throws IOException {
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            ArrayList<FileUploadMeta> allUploads = new ArrayList<FileUploadMeta>();
            for (String variableName : operation.variables().valueMap().keySet()) {
                Object value = operation.variables().valueMap().get(variableName);
                this.recursiveGetUploadData(value, "variables." + variableName, allUploads);
            }
            return allUploads.isEmpty() ? originalBody : this.httpMultipartRequestBody(originalBody, allUploads);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RequestBody httpMultipartRequestBody(@Nullable RequestBody operations, @NotNull ArrayList<FileUploadMeta> fileUploadMetaList) throws IOException {
            int n;
            Intrinsics.checkParameterIsNotNull(fileUploadMetaList, (String)"fileUploadMetaList");
            Buffer buffer = new Buffer();
            JsonWriter jsonWriter = JsonWriter.Companion.of((BufferedSink)buffer);
            jsonWriter.beginObject();
            Iterable $this$forEachIndexed$iv = fileUploadMetaList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void fileUploadMeta;
                int n2 = index$iv++;
                n = 0;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FileUploadMeta fileUploadMeta2 = (FileUploadMeta)item$iv;
                int i = n2;
                boolean bl = false;
                jsonWriter.name(String.valueOf(i)).beginArray();
                jsonWriter.value(fileUploadMeta.getKey());
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("operations", null, operations).addFormDataPart("map", null, RequestBody.create((MediaType)this.getMEDIA_TYPE(), (ByteString)buffer.readByteString()));
            Iterable $this$forEachIndexed$iv2 = fileUploadMetaList;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv : $this$forEachIndexed$iv2) {
                File file;
                void fileUploadMeta;
                n = index$iv2++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FileUploadMeta i = (FileUploadMeta)item$iv;
                int i2 = n;
                boolean bl2 = false;
                if (fileUploadMeta.getFileUpload().getFilePath() != null) {
                    String string;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String it = string;
                    boolean bl5 = false;
                    file = new File(it);
                } else {
                    file = null;
                }
                File file2 = file;
                MediaType mimetype = MediaType.parse((String)fileUploadMeta.getFileUpload().getMimetype());
                if (file2 != null) {
                    multipartBodyBuilder.addFormDataPart(String.valueOf(i2), file2.getName(), RequestBody.create((MediaType)mimetype, (File)file2));
                    continue;
                }
                multipartBodyBuilder.addFormDataPart(String.valueOf(i2), fileUploadMeta.getFileUpload().fileName(), new RequestBody(mimetype, (FileUploadMeta)fileUploadMeta){
                    final /* synthetic */ MediaType $mimetype;
                    final /* synthetic */ FileUploadMeta $fileUploadMeta;

                    @Nullable
                    public MediaType contentType() {
                        return this.$mimetype;
                    }

                    public long contentLength() {
                        return this.$fileUploadMeta.getFileUpload().contentLength();
                    }

                    public void writeTo(@NotNull BufferedSink sink) {
                        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                        this.$fileUploadMeta.getFileUpload().writeTo(sink);
                    }
                    {
                        this.$mimetype = $captured_local_variable$0;
                        this.$fileUploadMeta = $captured_local_variable$1;
                    }
                });
            }
            MultipartBody multipartBody = multipartBodyBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)multipartBody, (String)"multipartBodyBuilder.build()");
            return (RequestBody)multipartBody;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

