/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.FileUpload;
import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.InputType;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.api.internal.json.InputFieldJsonWriter;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.request.RequestHeaders;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApolloServerInterceptor
implements ApolloInterceptor {
    static final String HEADER_ACCEPT_TYPE = "Accept";
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    static final String ACCEPT_TYPE = "application/json";
    static final String CONTENT_TYPE = "application/json";
    static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final Optional<HttpCachePolicy.Policy> cachePolicy;
    final boolean prefetch;
    final ApolloLogger logger;
    final ScalarTypeAdapters scalarTypeAdapters;
    AtomicReference<Call> httpCallRef = new AtomicReference();
    volatile boolean disposed;

    public ApolloServerInterceptor(@NotNull HttpUrl serverUrl, @NotNull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @NotNull ScalarTypeAdapters scalarTypeAdapters, @NotNull ApolloLogger logger) {
        this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null");
        this.httpCallFactory = (Call.Factory)Utils.checkNotNull((Object)httpCallFactory, (Object)"httpCallFactory == null");
        this.cachePolicy = Optional.fromNullable((Object)cachePolicy);
        this.prefetch = prefetch;
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    @Override
    public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                ApolloServerInterceptor.this.executeHttpCall(request, callBack);
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
        Call httpCall = this.httpCallRef.getAndSet(null);
        if (httpCall != null) {
            httpCall.cancel();
        }
    }

    void executeHttpCall(final @NotNull ApolloInterceptor.InterceptorRequest request, final @NotNull ApolloInterceptor.CallBack callBack) {
        Call httpCall;
        if (this.disposed) {
            return;
        }
        callBack.onFetch(ApolloInterceptor.FetchSourceType.NETWORK);
        try {
            httpCall = request.useHttpGetMethodForQueries && request.operation instanceof Query ? this.httpGetCall(request.operation, request.cacheHeaders, request.requestHeaders, request.sendQueryDocument, request.autoPersistQueries) : this.httpPostCall(request.operation, request.cacheHeaders, request.requestHeaders, request.sendQueryDocument, request.autoPersistQueries);
        }
        catch (IOException e) {
            this.logger.e((Throwable)e, "Failed to prepare http call for operation %s", new Object[]{request.operation.name().name()});
            callBack.onFailure(new ApolloNetworkException("Failed to prepare http call", e));
            return;
        }
        Call previousCall = this.httpCallRef.getAndSet(httpCall);
        if (previousCall != null) {
            previousCall.cancel();
        }
        if (httpCall.isCanceled() || this.disposed) {
            this.httpCallRef.compareAndSet(httpCall, null);
            return;
        }
        httpCall.enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                if (ApolloServerInterceptor.this.disposed) {
                    return;
                }
                if (ApolloServerInterceptor.this.httpCallRef.compareAndSet(httpCall, null)) {
                    ApolloServerInterceptor.this.logger.e((Throwable)e, "Failed to execute http call for operation %s", new Object[]{request.operation.name().name()});
                    callBack.onFailure(new ApolloNetworkException("Failed to execute http call", e));
                }
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                if (ApolloServerInterceptor.this.disposed) {
                    return;
                }
                if (ApolloServerInterceptor.this.httpCallRef.compareAndSet(httpCall, null)) {
                    callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response));
                    callBack.onCompleted();
                }
            }
        });
    }

    Call httpGetCall(Operation operation, CacheHeaders cacheHeaders, RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(ApolloServerInterceptor.httpGetUrl(this.serverUrl, operation, this.scalarTypeAdapters, writeQueryDocument, autoPersistQueries)).get();
        this.decorateRequest(requestBuilder, operation, cacheHeaders, requestHeaders);
        return this.httpCallFactory.newCall(requestBuilder.build());
    }

    Call httpPostCall(Operation operation, CacheHeaders cacheHeaders, RequestHeaders requestHeaders, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)ApolloServerInterceptor.httpPostRequestBody(operation, this.scalarTypeAdapters, writeQueryDocument, autoPersistQueries));
        requestBody = ApolloServerInterceptor.transformToMultiPartIfUploadExists(requestBody, operation);
        Request.Builder requestBuilder = new Request.Builder().url(this.serverUrl).header(HEADER_CONTENT_TYPE, "application/json").post(requestBody);
        this.decorateRequest(requestBuilder, operation, cacheHeaders, requestHeaders);
        return this.httpCallFactory.newCall(requestBuilder.build());
    }

    void decorateRequest(Request.Builder requestBuilder, Operation operation, CacheHeaders cacheHeaders, RequestHeaders requestHeaders) throws IOException {
        requestBuilder.header(HEADER_ACCEPT_TYPE, "application/json").header(HEADER_APOLLO_OPERATION_ID, operation.operationId()).header(HEADER_APOLLO_OPERATION_NAME, operation.name().name()).tag((Object)operation.operationId());
        for (String header : requestHeaders.headers()) {
            String value = requestHeaders.headerValue(header);
            requestBuilder.header(header, value);
        }
        if (this.cachePolicy.isPresent()) {
            HttpCachePolicy.Policy cachePolicy = (HttpCachePolicy.Policy)this.cachePolicy.get();
            boolean skipCacheHttpResponse = "true".equalsIgnoreCase(cacheHeaders.headerValue("do-not-store"));
            String cacheKey = ApolloServerInterceptor.cacheKey(operation, this.scalarTypeAdapters);
            requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch)).header("X-APOLLO-CACHE-DO-NOT-STORE", Boolean.toString(skipCacheHttpResponse));
        }
    }

    static String cacheKey(Operation operation, ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return ApolloServerInterceptor.httpPostRequestBody(operation, scalarTypeAdapters, true, true).md5().hex();
    }

    static ByteString httpPostRequestBody(Operation operation, ScalarTypeAdapters scalarTypeAdapters, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        return operation.composeRequestBody(autoPersistQueries, writeQueryDocument, scalarTypeAdapters);
    }

    static HttpUrl httpGetUrl(HttpUrl serverUrl, Operation operation, ScalarTypeAdapters scalarTypeAdapters, boolean writeQueryDocument, boolean autoPersistQueries) throws IOException {
        HttpUrl.Builder urlBuilder = serverUrl.newBuilder();
        if (!autoPersistQueries || writeQueryDocument) {
            urlBuilder.addQueryParameter("query", operation.queryDocument());
        }
        if (operation.variables() != Operation.EMPTY_VARIABLES) {
            ApolloServerInterceptor.addVariablesUrlQueryParameter(urlBuilder, operation, scalarTypeAdapters);
        }
        urlBuilder.addQueryParameter("operationName", operation.name().name());
        if (autoPersistQueries) {
            ApolloServerInterceptor.addExtensionsUrlQueryParameter(urlBuilder, operation);
        }
        return urlBuilder.build();
    }

    static void addVariablesUrlQueryParameter(HttpUrl.Builder urlBuilder, Operation operation, ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.setSerializeNulls(true);
        jsonWriter.beginObject();
        operation.variables().marshaller().marshal((InputFieldWriter)new InputFieldJsonWriter(jsonWriter, scalarTypeAdapters));
        jsonWriter.endObject();
        jsonWriter.close();
        urlBuilder.addQueryParameter("variables", buffer.readUtf8());
    }

    static void addExtensionsUrlQueryParameter(HttpUrl.Builder urlBuilder, Operation operation) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.setSerializeNulls(true);
        jsonWriter.beginObject();
        jsonWriter.name("persistedQuery").beginObject().name("version").value(1L).name("sha256Hash").value(operation.operationId()).endObject();
        jsonWriter.endObject();
        jsonWriter.close();
        urlBuilder.addQueryParameter("extensions", buffer.readUtf8());
    }

    private static void recursiveGetUploadData(Object value, String variableName, ArrayList<FileUploadMeta> allUploads) {
        block6: {
            block9: {
                FileUpload[] uploads;
                block8: {
                    block7: {
                        block5: {
                            if (!(value instanceof InputType)) break block5;
                            try {
                                Field[] fields;
                                for (Field field : fields = value.getClass().getDeclaredFields()) {
                                    field.setAccessible(true);
                                    Object subValue = field.get(value);
                                    String key = field.getName();
                                    ApolloServerInterceptor.recursiveGetUploadData(subValue, variableName + "." + key, allUploads);
                                }
                            }
                            catch (IllegalAccessException fields) {}
                            break block6;
                        }
                        if (!(value instanceof Input)) break block7;
                        Object unwrappedValue = ((Input)value).value;
                        ApolloServerInterceptor.recursiveGetUploadData(unwrappedValue, variableName, allUploads);
                        break block6;
                    }
                    if (!(value instanceof FileUpload)) break block8;
                    FileUpload upload = (FileUpload)value;
                    String key = variableName;
                    allUploads.add(new FileUploadMeta(key, upload.getMimetype(), new File(upload.getFilePath())));
                    System.out.println(key);
                    break block6;
                }
                if (!(value instanceof FileUpload[])) break block9;
                int varFileIndex = 0;
                for (FileUpload upload : uploads = (FileUpload[])value) {
                    String key = variableName + "." + varFileIndex;
                    allUploads.add(new FileUploadMeta(key, upload.getMimetype(), new File(upload.getFilePath())));
                    System.out.println(key);
                    ++varFileIndex;
                }
                break block6;
            }
            if (!(value instanceof Collection)) break block6;
            Object[] listData = ((Collection)value).toArray();
            for (int i = 0; i < listData.length; ++i) {
                Object subValue = listData[i];
                ApolloServerInterceptor.recursiveGetUploadData(subValue, variableName + "." + i, allUploads);
            }
        }
    }

    static RequestBody transformToMultiPartIfUploadExists(RequestBody originalBody, Operation operation) throws IOException {
        ArrayList<FileUploadMeta> allUploads = new ArrayList<FileUploadMeta>();
        for (String variableName : operation.variables().valueMap().keySet()) {
            Object value = operation.variables().valueMap().get(variableName);
            ApolloServerInterceptor.recursiveGetUploadData(value, "variables." + variableName, allUploads);
        }
        if (allUploads.isEmpty()) {
            return originalBody;
        }
        return ApolloServerInterceptor.httpMultipartRequestBody(originalBody, allUploads);
    }

    static RequestBody httpMultipartRequestBody(RequestBody operations, ArrayList<FileUploadMeta> fileUploads) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.beginObject();
        for (int i = 0; i < fileUploads.size(); ++i) {
            jsonWriter.name(String.valueOf(i)).beginArray();
            jsonWriter.value(fileUploads.get((int)i).key);
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
        jsonWriter.close();
        MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("operations", null, operations).addFormDataPart("map", null, RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString()));
        for (int i = 0; i < fileUploads.size(); ++i) {
            FileUploadMeta fileMeta = fileUploads.get(i);
            multipartBodyBuilder.addFormDataPart(String.valueOf(i), fileMeta.file.getName(), RequestBody.create((MediaType)MediaType.parse((String)fileMeta.mimetype), (File)fileMeta.file));
        }
        return multipartBodyBuilder.build();
    }

    private static final class FileUploadMeta {
        public final String key;
        public final String mimetype;
        public final File file;

        FileUploadMeta(String key, String mimetype, File file) {
            this.key = key;
            this.mimetype = mimetype;
            this.file = file;
        }
    }
}

