/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.subscription;

import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.subscription.OperationClientMessage;
import com.apollographql.apollo.subscription.OperationServerMessage;
import com.apollographql.apollo.subscription.SubscriptionTransport;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;

public final class WebSocketSubscriptionTransport
implements SubscriptionTransport {
    private final Request webSocketRequest;
    private final WebSocket.Factory webSocketConnectionFactory;
    private final SubscriptionTransport.Callback callback;
    final AtomicReference<WebSocket> webSocket = new AtomicReference();
    final AtomicReference<WebSocketListener> webSocketListener = new AtomicReference();

    public WebSocketSubscriptionTransport(Request webSocketRequest, WebSocket.Factory webSocketConnectionFactory, SubscriptionTransport.Callback callback) {
        this.webSocketRequest = webSocketRequest;
        this.webSocketConnectionFactory = webSocketConnectionFactory;
        this.callback = callback;
    }

    @Override
    public void connect() {
        WebSocketListener webSocketListener = new WebSocketListener(this);
        if (!this.webSocketListener.compareAndSet(null, webSocketListener)) {
            throw new IllegalStateException("Already connected");
        }
        this.webSocket.set(this.webSocketConnectionFactory.newWebSocket(this.webSocketRequest, (okhttp3.WebSocketListener)webSocketListener));
    }

    @Override
    public void disconnect(OperationClientMessage message) {
        WebSocket socket = this.webSocket.getAndSet(null);
        if (socket != null) {
            socket.close(1001, message.toJsonString());
        }
        this.release();
    }

    @Override
    public void send(OperationClientMessage message) {
        WebSocket socket = this.webSocket.get();
        if (socket == null) {
            throw new IllegalStateException("Not connected");
        }
        socket.send(message.toJsonString());
    }

    void onOpen() {
        this.callback.onConnected();
    }

    void onMessage(OperationServerMessage message) {
        this.callback.onMessage(message);
    }

    void onFailure(Throwable t) {
        try {
            this.callback.onFailure(t);
        }
        finally {
            this.release();
        }
    }

    void onClosed() {
        try {
            this.callback.onClosed();
        }
        finally {
            this.release();
        }
    }

    void release() {
        WebSocketListener socketListener = this.webSocketListener.getAndSet(null);
        if (socketListener != null) {
            socketListener.release();
        }
        this.webSocket.set(null);
    }

    public static final class Factory
    implements SubscriptionTransport.Factory {
        private final Request webSocketRequest;
        private final WebSocket.Factory webSocketConnectionFactory;

        public Factory(@NotNull String webSocketUrl, @NotNull WebSocket.Factory webSocketConnectionFactory) {
            this.webSocketRequest = new Request.Builder().url((String)Utils.checkNotNull((Object)webSocketUrl, (Object)"webSocketUrl == null")).addHeader("Sec-WebSocket-Protocol", "graphql-ws").addHeader("Cookie", "").build();
            this.webSocketConnectionFactory = (WebSocket.Factory)Utils.checkNotNull((Object)webSocketConnectionFactory, (Object)"webSocketConnectionFactory == null");
        }

        @Override
        public SubscriptionTransport create(@NotNull SubscriptionTransport.Callback callback) {
            Utils.checkNotNull((Object)callback, (Object)"callback == null");
            return new WebSocketSubscriptionTransport(this.webSocketRequest, this.webSocketConnectionFactory, callback);
        }
    }

    static final class WebSocketListener
    extends okhttp3.WebSocketListener {
        final WeakReference<WebSocketSubscriptionTransport> delegateRef;

        WebSocketListener(WebSocketSubscriptionTransport delegate) {
            this.delegateRef = new WeakReference<WebSocketSubscriptionTransport>(delegate);
        }

        public void onOpen(WebSocket webSocket, Response response) {
            WebSocketSubscriptionTransport delegate = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (delegate != null) {
                delegate.onOpen();
            }
        }

        public void onMessage(WebSocket webSocket, String text) {
            WebSocketSubscriptionTransport delegate = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (delegate != null) {
                OperationServerMessage message = OperationServerMessage.fromJsonString(text);
                delegate.onMessage(message);
            }
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            WebSocketSubscriptionTransport delegate = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (delegate != null) {
                delegate.onFailure(t);
            }
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            WebSocketSubscriptionTransport delegate = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (delegate != null) {
                delegate.onClosed();
            }
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            WebSocketSubscriptionTransport delegate = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (delegate != null) {
                delegate.onClosed();
            }
        }

        void release() {
            this.delegateRef.clear();
        }
    }
}

