/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Utils;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class ResponseFieldMapperFactory {
    private final ConcurrentHashMap<Class, ResponseFieldMapper> pool = new ConcurrentHashMap();

    @NotNull
    public ResponseFieldMapper create(@NotNull Operation operation) {
        Utils.checkNotNull((Object)operation, (Object)"operation == null");
        Class<?> operationClass = operation.getClass();
        ResponseFieldMapper mapper = this.pool.get(operationClass);
        if (mapper != null) {
            return mapper;
        }
        this.pool.putIfAbsent(operationClass, operation.responseFieldMapper());
        return this.pool.get(operationClass);
    }
}

