/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortedInputFieldMapWriter
implements InputFieldWriter {
    final Comparator<String> fieldNameComparator;
    final Map<String, Object> buffer;

    public SortedInputFieldMapWriter(@NotNull Comparator<String> fieldNameComparator) {
        this.fieldNameComparator = (Comparator)Utils.checkNotNull(fieldNameComparator, (Object)"fieldNameComparator == null");
        this.buffer = new TreeMap<String, Object>(fieldNameComparator);
    }

    public Map<String, Object> map() {
        return Collections.unmodifiableMap(this.buffer);
    }

    public void writeString(@NotNull String fieldName, @Nullable String value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeInt(@NotNull String fieldName, @Nullable Integer value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeLong(@NotNull String fieldName, @Nullable Long value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeDouble(@NotNull String fieldName, @Nullable Double value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeNumber(@NotNull String fieldName, @Nullable Number value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeBoolean(@NotNull String fieldName, @Nullable Boolean value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    public void writeCustom(@NotNull String fieldName, @NotNull ScalarType scalarType, @Nullable Object value) {
        this.buffer.put(fieldName, value);
    }

    public void writeObject(@NotNull String fieldName, @Nullable InputFieldMarshaller marshaller) throws IOException {
        if (marshaller == null) {
            this.buffer.put(fieldName, null);
        } else {
            SortedInputFieldMapWriter nestedWriter = new SortedInputFieldMapWriter(this.fieldNameComparator);
            marshaller.marshal((InputFieldWriter)nestedWriter);
            this.buffer.put(fieldName, nestedWriter.buffer);
        }
    }

    public void writeList(@NotNull String fieldName, @Nullable InputFieldWriter.ListWriter listWriter) throws IOException {
        if (listWriter == null) {
            this.buffer.put(fieldName, null);
        } else {
            ListItemWriter listItemWriter = new ListItemWriter(this.fieldNameComparator);
            listWriter.write((InputFieldWriter.ListItemWriter)listItemWriter);
            this.buffer.put(fieldName, listItemWriter.list);
        }
    }

    public void writeMap(@NotNull String fieldName, @Nullable Map<String, Object> value) throws IOException {
        this.buffer.put(fieldName, value);
    }

    private static class ListItemWriter
    implements InputFieldWriter.ListItemWriter {
        final Comparator<String> fieldNameComparator;
        final List list = new ArrayList();

        ListItemWriter(Comparator<String> fieldNameComparator) {
            this.fieldNameComparator = fieldNameComparator;
        }

        public void writeString(@Nullable String value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeInt(@Nullable Integer value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeLong(@Nullable Long value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeDouble(@Nullable Double value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeNumber(@Nullable Number value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeBoolean(@Nullable Boolean value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeCustom(@NotNull ScalarType scalarType, @Nullable Object value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }

        public void writeObject(@Nullable InputFieldMarshaller marshaller) throws IOException {
            if (marshaller != null) {
                SortedInputFieldMapWriter nestedWriter = new SortedInputFieldMapWriter(this.fieldNameComparator);
                marshaller.marshal((InputFieldWriter)nestedWriter);
                this.list.add(nestedWriter.buffer);
            }
        }

        public void writeList(@Nullable InputFieldWriter.ListWriter listWriter) throws IOException {
            if (listWriter != null) {
                ListItemWriter nestedListItemWriter = new ListItemWriter(this.fieldNameComparator);
                listWriter.write((InputFieldWriter.ListItemWriter)nestedListItemWriter);
                this.list.add(nestedListItemWriter.list);
            }
        }

        public void writeMap(@Nullable Map<String, Object> value) throws IOException {
            if (value != null) {
                this.list.add(value);
            }
        }
    }
}

