/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.lru;

import com.apollographql.apollo.api.internal.Action;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.lru.EvictionPolicy;
import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.cache.Weigher;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LruNormalizedCache
extends NormalizedCache {
    private final Cache<String, Record> lruCache;

    LruNormalizedCache(EvictionPolicy evictionPolicy) {
        CacheBuilder lruCacheBuilder = CacheBuilder.newBuilder();
        if (evictionPolicy.maxSizeBytes().isPresent()) {
            lruCacheBuilder.maximumWeight(((Long)evictionPolicy.maxSizeBytes().get()).longValue()).weigher((Weigher)new Weigher<String, Record>(){

                public int weigh(String key, Record value) {
                    return key.getBytes(Charset.defaultCharset()).length + value.sizeEstimateBytes();
                }
            });
        }
        if (evictionPolicy.maxEntries().isPresent()) {
            lruCacheBuilder.maximumSize(((Long)evictionPolicy.maxEntries().get()).longValue());
        }
        if (evictionPolicy.expireAfterAccess().isPresent()) {
            lruCacheBuilder.expireAfterAccess(((Long)evictionPolicy.expireAfterAccess().get()).longValue(), (TimeUnit)((Object)evictionPolicy.expireAfterAccessTimeUnit().get()));
        }
        if (evictionPolicy.expireAfterWrite().isPresent()) {
            lruCacheBuilder.expireAfterWrite(((Long)evictionPolicy.expireAfterWrite().get()).longValue(), (TimeUnit)((Object)evictionPolicy.expireAfterWriteTimeUnit().get()));
        }
        this.lruCache = lruCacheBuilder.build();
    }

    @Override
    @Nullable
    public Record loadRecord(final @NotNull String key, final @NotNull CacheHeaders cacheHeaders) {
        Record record;
        try {
            record = (Record)this.lruCache.get((Object)key, (Callable)new Callable<Record>(){

                @Override
                public Record call() throws Exception {
                    return (Record)LruNormalizedCache.this.nextCache().flatMap((Function)new Function<NormalizedCache, Optional<Record>>(){

                        @NotNull
                        public Optional<Record> apply(@NotNull NormalizedCache cache) {
                            return Optional.fromNullable((Object)cache.loadRecord(key, cacheHeaders));
                        }
                    }).get();
                }
            });
        }
        catch (Exception ignore) {
            return null;
        }
        if (cacheHeaders.hasHeader("evict-after-read")) {
            this.lruCache.invalidate((Object)key);
        }
        return record;
    }

    @Override
    public void clearAll() {
        this.nextCache().apply((Action)new Action<NormalizedCache>(){

            public void apply(@NotNull NormalizedCache cache) {
                cache.clearAll();
            }
        });
        this.clearCurrentCache();
    }

    @Override
    public boolean remove(final @NotNull CacheKey cacheKey, final boolean cascade) {
        Utils.checkNotNull((Object)cacheKey, (Object)"cacheKey == null");
        boolean result = (Boolean)this.nextCache().map((Function)new Function<NormalizedCache, Boolean>(){

            @NotNull
            public Boolean apply(@NotNull NormalizedCache cache) {
                return cache.remove(cacheKey, cascade);
            }
        }).or((Object)Boolean.FALSE);
        Record record = (Record)this.lruCache.getIfPresent((Object)cacheKey.key());
        if (record != null) {
            this.lruCache.invalidate((Object)cacheKey.key());
            result = true;
            if (cascade) {
                for (CacheReference cacheReference : record.referencedFields()) {
                    result &= this.remove(CacheKey.from(cacheReference.key()), true);
                }
            }
        }
        return result;
    }

    void clearCurrentCache() {
        this.lruCache.invalidateAll();
    }

    @Override
    @NotNull
    protected Set<String> performMerge(@NotNull Record apolloRecord, @NotNull CacheHeaders cacheHeaders) {
        Record oldRecord = (Record)this.lruCache.getIfPresent((Object)apolloRecord.key());
        if (oldRecord == null) {
            this.lruCache.put((Object)apolloRecord.key(), (Object)apolloRecord);
            return apolloRecord.keys();
        }
        Set<String> changedKeys = oldRecord.mergeWith(apolloRecord);
        this.lruCache.put((Object)apolloRecord.key(), (Object)oldRecord);
        return changedKeys;
    }

    @Override
    public Map<Class, Map<String, Record>> dump() {
        LinkedHashMap<Class, Map<String, Record>> dump = new LinkedHashMap<Class, Map<String, Record>>();
        dump.put(this.getClass(), Collections.unmodifiableMap(new LinkedHashMap(this.lruCache.asMap())));
        if (this.nextCache().isPresent()) {
            dump.putAll(((NormalizedCache)this.nextCache().get()).dump());
        }
        return dump;
    }
}

