/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.response;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.field.MapFieldValueResolver;
import com.apollographql.apollo.internal.json.ApolloJsonReader;
import com.apollographql.apollo.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.internal.json.ResponseJsonStreamReader;
import com.apollographql.apollo.internal.response.RealResponseReader;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public final class OperationResponseParser<D extends Operation.Data, W> {
    final Operation<D, W, ?> operation;
    final ResponseFieldMapper responseFieldMapper;
    final ScalarTypeAdapters scalarTypeAdapters;
    final ResponseNormalizer<Map<String, Object>> responseNormalizer;

    public OperationResponseParser(Operation<D, W, ?> operation, ResponseFieldMapper responseFieldMapper, ScalarTypeAdapters scalarTypeAdapters) {
        this(operation, responseFieldMapper, scalarTypeAdapters, ResponseNormalizer.NO_OP_NORMALIZER);
    }

    public OperationResponseParser(Operation<D, W, ?> operation, ResponseFieldMapper responseFieldMapper, ScalarTypeAdapters scalarTypeAdapters, ResponseNormalizer<Map<String, Object>> responseNormalizer) {
        this.operation = operation;
        this.responseFieldMapper = responseFieldMapper;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.responseNormalizer = responseNormalizer;
    }

    public Response<W> parse(@NotNull Map<String, Object> payload) {
        List errorPayloads;
        Utils.checkNotNull(payload, (Object)"payload == null");
        Operation.Data data = null;
        Map buffer = (Map)payload.get("data");
        if (buffer != null) {
            RealResponseReader<Map<String, Object>> realResponseReader = new RealResponseReader<Map<String, Object>>(this.operation.variables(), buffer, new MapFieldValueResolver(), this.scalarTypeAdapters, this.responseNormalizer);
            data = (Operation.Data)this.responseFieldMapper.map(realResponseReader);
        }
        ArrayList<Error> errors = null;
        if (payload.containsKey("errors") && (errorPayloads = (List)payload.get("errors")) != null) {
            errors = new ArrayList<Error>();
            for (Map errorPayload : errorPayloads) {
                errors.add(this.readError(errorPayload));
            }
        }
        return Response.builder(this.operation).data(this.operation.wrapData(data)).errors(errors).dependentKeys(this.responseNormalizer.dependentKeys()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<W> parse(BufferedSource source) throws IOException {
        this.responseNormalizer.willResolveRootQuery(this.operation);
        try (BufferedSourceJsonReader jsonReader = null;){
            jsonReader = new BufferedSourceJsonReader(source);
            jsonReader.beginObject();
            Operation.Data data = null;
            List<Error> errors = null;
            ResponseJsonStreamReader responseStreamReader = ApolloJsonReader.responseJsonStreamReader(jsonReader);
            while (responseStreamReader.hasNext()) {
                String name = responseStreamReader.nextName();
                if ("data".equals(name)) {
                    data = (Operation.Data)responseStreamReader.nextObject(true, new ResponseJsonStreamReader.ObjectReader<Object>(){

                        @Override
                        public Object read(ResponseJsonStreamReader reader) throws IOException {
                            Map<String, Object> buffer = reader.toMap();
                            RealResponseReader<Map<String, Object>> realResponseReader = new RealResponseReader<Map<String, Object>>(OperationResponseParser.this.operation.variables(), buffer, new MapFieldValueResolver(), OperationResponseParser.this.scalarTypeAdapters, OperationResponseParser.this.responseNormalizer);
                            return OperationResponseParser.this.responseFieldMapper.map(realResponseReader);
                        }
                    });
                    continue;
                }
                if ("errors".equals(name)) {
                    errors = this.readResponseErrors(responseStreamReader);
                    continue;
                }
                responseStreamReader.skipNext();
            }
            jsonReader.endObject();
            Response response = Response.builder(this.operation).data(this.operation.wrapData(data)).errors(errors).dependentKeys(this.responseNormalizer.dependentKeys()).build();
            return response;
        }
    }

    private List<Error> readResponseErrors(ResponseJsonStreamReader reader) throws IOException {
        return reader.nextList(true, new ResponseJsonStreamReader.ListReader<Error>(){

            @Override
            public Error read(ResponseJsonStreamReader reader) throws IOException {
                return reader.nextObject(true, new ResponseJsonStreamReader.ObjectReader<Error>(){

                    @Override
                    public Error read(ResponseJsonStreamReader reader) throws IOException {
                        return OperationResponseParser.this.readError(reader.toMap());
                    }
                });
            }
        });
    }

    private Error readError(Map<String, Object> payload) {
        String message = null;
        ArrayList<Error.Location> locations = new ArrayList<Error.Location>();
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            if ("message".equals(entry.getKey())) {
                Object value = entry.getValue();
                message = value != null ? value.toString() : null;
                continue;
            }
            if ("locations".equals(entry.getKey())) {
                List locationItems = (List)entry.getValue();
                if (locationItems == null) continue;
                for (Map item : locationItems) {
                    locations.add(this.readErrorLocation(item));
                }
                continue;
            }
            if (entry.getValue() == null) continue;
            customAttributes.put(entry.getKey(), entry.getValue());
        }
        return new Error(message, locations, customAttributes);
    }

    private Error.Location readErrorLocation(Map<String, Object> data) {
        long line = -1L;
        long column = -1L;
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if ("line".equals(entry.getKey())) {
                    line = ((BigDecimal)entry.getValue()).longValue();
                    continue;
                }
                if (!"column".equals(entry.getKey())) continue;
                column = ((BigDecimal)entry.getValue()).longValue();
            }
        }
        return new Error.Location(line, column);
    }
}

