/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.response;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class ScalarTypeAdapters {
    private static final Map<Class, CustomTypeAdapter> DEFAULT_ADAPTERS = ScalarTypeAdapters.defaultAdapters();
    private final Map<ScalarType, CustomTypeAdapter> customAdapters;

    public ScalarTypeAdapters(@Nonnull Map<ScalarType, CustomTypeAdapter> customAdapters) {
        this.customAdapters = (Map)Utils.checkNotNull(customAdapters, (Object)"customAdapters == null");
    }

    @Nonnull
    public <T> CustomTypeAdapter<T> adapterFor(@Nonnull ScalarType scalarType) {
        Utils.checkNotNull((Object)scalarType, (Object)"scalarType == null");
        CustomTypeAdapter customTypeAdapter = this.customAdapters.get(scalarType);
        if (customTypeAdapter == null) {
            customTypeAdapter = DEFAULT_ADAPTERS.get(scalarType.javaType());
        }
        if (customTypeAdapter == null) {
            throw new IllegalArgumentException(String.format("Can't map GraphQL type: %s to: %s. Did you forget to add custom type adapter?", scalarType.typeName(), scalarType.javaType()));
        }
        return customTypeAdapter;
    }

    private static Map<Class, CustomTypeAdapter> defaultAdapters() {
        LinkedHashMap<Class, CustomTypeAdapter> adapters = new LinkedHashMap<Class, CustomTypeAdapter>();
        adapters.put(String.class, new DefaultCustomTypeAdapter<String>(){

            @Override
            @Nonnull
            public String decode(@Nonnull String value) {
                return value;
            }
        });
        adapters.put(Boolean.class, new DefaultCustomTypeAdapter<Boolean>(){

            @Override
            @Nonnull
            public Boolean decode(@Nonnull String value) {
                return Boolean.parseBoolean(value);
            }
        });
        adapters.put(Integer.class, new DefaultCustomTypeAdapter<Integer>(){

            @Override
            @Nonnull
            public Integer decode(@Nonnull String value) {
                return Integer.parseInt(value);
            }
        });
        adapters.put(Long.class, new DefaultCustomTypeAdapter<Long>(){

            @Override
            @Nonnull
            public Long decode(@Nonnull String value) {
                return Long.parseLong(value);
            }
        });
        adapters.put(Float.class, new DefaultCustomTypeAdapter<Float>(){

            @Override
            @Nonnull
            public Float decode(@Nonnull String value) {
                return Float.valueOf(Float.parseFloat(value));
            }
        });
        adapters.put(Double.class, new DefaultCustomTypeAdapter<Double>(){

            @Override
            @Nonnull
            public Double decode(@Nonnull String value) {
                return Double.parseDouble(value);
            }
        });
        return adapters;
    }

    private static abstract class DefaultCustomTypeAdapter<T>
    implements CustomTypeAdapter<T> {
        private DefaultCustomTypeAdapter() {
        }

        @Override
        @Nonnull
        public String encode(@Nonnull T value) {
            return value.toString();
        }
    }
}

