/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloQueryWatcher;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheControl;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.RealApolloCall;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RealApolloQueryWatcher<T>
implements ApolloQueryWatcher<T> {
    private RealApolloCall<T> activeCall;
    private ApolloCall.Callback<T> callback;
    private CacheControl refetchCacheControl = CacheControl.CACHE_FIRST;
    private volatile boolean canceled;
    private boolean executed = false;
    private final ApolloStore apolloStore;
    private Set<String> dependentKeys = Collections.emptySet();
    private final ApolloCallTracker tracker;
    private final ApolloStore.RecordChangeSubscriber recordChangeSubscriber = new ApolloStore.RecordChangeSubscriber(){

        @Override
        public void onCacheRecordsChanged(Set<String> changedRecordKeys) {
            if (!Utils.areDisjoint((Set)RealApolloQueryWatcher.this.dependentKeys, changedRecordKeys)) {
                RealApolloQueryWatcher.this.refetch();
            }
        }
    };

    RealApolloQueryWatcher(RealApolloCall<T> originalCall, ApolloStore apolloStore, ApolloCallTracker tracker) {
        this.activeCall = originalCall;
        this.apolloStore = apolloStore;
        this.tracker = tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApolloQueryWatcher<T> enqueueAndWatch(@Nullable ApolloCall.Callback<T> callback) {
        RealApolloQueryWatcher realApolloQueryWatcher = this;
        synchronized (realApolloQueryWatcher) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed.");
            }
            this.executed = true;
        }
        this.callback = callback;
        this.tracker.registerQueryWatcher(this);
        this.activeCall.enqueue(this.callbackProxy(this.callback));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RealApolloQueryWatcher<T> refetchCacheControl(@Nonnull CacheControl cacheControl) {
        RealApolloQueryWatcher realApolloQueryWatcher = this;
        synchronized (realApolloQueryWatcher) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
        }
        Utils.checkNotNull((Object)((Object)cacheControl), (Object)"httpCacheControl == null");
        this.refetchCacheControl = cacheControl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        RealApolloQueryWatcher realApolloQueryWatcher = this;
        synchronized (realApolloQueryWatcher) {
            this.canceled = true;
            try {
                this.activeCall.cancel();
                this.apolloStore.unsubscribe(this.recordChangeSubscriber);
            }
            finally {
                this.tracker.unregisterQueryWatcher(this);
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.activeCall.operation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refetch() {
        if (this.canceled) {
            return;
        }
        RealApolloQueryWatcher realApolloQueryWatcher = this;
        synchronized (realApolloQueryWatcher) {
            this.apolloStore.unsubscribe(this.recordChangeSubscriber);
            this.activeCall.cancel();
            if (!this.canceled) {
                this.activeCall = ((RealApolloCall)this.activeCall.clone()).cacheControl(this.refetchCacheControl);
                this.activeCall.enqueue(this.callbackProxy(this.callback));
            }
        }
    }

    private ApolloCall.Callback<T> callbackProxy(final ApolloCall.Callback<T> sourceCallback) {
        return new ApolloCall.Callback<T>(){

            @Override
            public void onResponse(@Nonnull Response<T> response) {
                if (RealApolloQueryWatcher.this.canceled) {
                    return;
                }
                RealApolloQueryWatcher.this.dependentKeys = response.dependentKeys();
                RealApolloQueryWatcher.this.apolloStore.subscribe(RealApolloQueryWatcher.this.recordChangeSubscriber);
                sourceCallback.onResponse(response);
            }

            @Override
            public void onHttpError(@Nonnull ApolloHttpException e) {
                if (RealApolloQueryWatcher.this.canceled) {
                    return;
                }
                sourceCallback.onHttpError(e);
            }

            @Override
            public void onNetworkError(@Nonnull ApolloNetworkException e) {
                if (RealApolloQueryWatcher.this.canceled) {
                    return;
                }
                sourceCallback.onNetworkError(e);
            }

            @Override
            public void onParseError(@Nonnull ApolloParseException e) {
                if (RealApolloQueryWatcher.this.canceled) {
                    return;
                }
                sourceCallback.onParseError(e);
            }

            @Override
            public void onCanceledError(@Nonnull ApolloCanceledException e) {
                if (RealApolloQueryWatcher.this.canceled) {
                    return;
                }
                sourceCallback.onCanceledError(e);
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (RealApolloQueryWatcher.this.canceled) {
                    return;
                }
                sourceCallback.onFailure(e);
            }
        };
    }
}

