/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.IdleResourceCallback;
import com.apollographql.apollo.Logger;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.cache.http.HttpCacheStore;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheControl;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.NormalizedCacheFactory;
import com.apollographql.apollo.cache.normalized.RecordFieldAdapter;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.RealApolloCall;
import com.apollographql.apollo.internal.RealApolloPrefetch;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.cache.http.HttpCache;
import com.apollographql.apollo.internal.cache.normalized.RealApolloStore;
import com.apollographql.apollo.internal.util.ApolloLogger;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public final class ApolloClient
implements ApolloQueryCall.Factory,
ApolloMutationCall.Factory,
ApolloPrefetch.Factory {
    private final HttpUrl serverUrl;
    private final Call.Factory httpCallFactory;
    private final HttpCache httpCache;
    private final ApolloStore apolloStore;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    private final Moshi moshi;
    private final ResponseFieldMapperFactory responseFieldMapperFactory = new ResponseFieldMapperFactory();
    private final ExecutorService dispatcher;
    private final HttpCachePolicy.Policy defaultHttpCachePolicy;
    private final CacheControl defaultCacheControl;
    private final CacheHeaders defaultCacheHeaders;
    private final ApolloLogger logger;
    private final ApolloCallTracker tracker = new ApolloCallTracker();
    private final List<ApolloInterceptor> applicationInterceptors;

    public static Builder builder() {
        return new Builder();
    }

    private ApolloClient(Builder builder) {
        this.serverUrl = builder.serverUrl;
        this.httpCallFactory = builder.okHttpClient;
        this.httpCache = builder.httpCache;
        this.apolloStore = builder.apolloStore;
        this.customTypeAdapters = builder.customTypeAdapters;
        this.moshi = builder.moshi;
        this.dispatcher = builder.dispatcher;
        this.defaultHttpCachePolicy = builder.defaultHttpCachePolicy;
        this.defaultCacheHeaders = builder.defaultCacheHeaders;
        this.defaultCacheControl = builder.defaultCacheControl;
        this.logger = builder.apolloLogger;
        this.applicationInterceptors = builder.applicationInterceptors;
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloMutationCall<T> mutate(@Nonnull Mutation<D, T, V> mutation) {
        return this.newCall((Operation<D, T, V>)mutation).cacheControl(CacheControl.NETWORK_ONLY);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloQueryCall<T> query(@Nonnull Query<D, T, V> query) {
        return this.newCall((Operation<D, T, V>)query);
    }

    @Override
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloPrefetch prefetch(@Nonnull Operation<D, T, V> operation) {
        return new RealApolloPrefetch(operation, this.serverUrl, this.httpCallFactory, this.httpCache, this.moshi, this.dispatcher, this.logger, this.tracker);
    }

    public CacheHeaders defaultCacheHeaders() {
        return this.defaultCacheHeaders;
    }

    void clearHttpCache() {
        if (this.httpCache != null) {
            this.httpCache.clear();
        }
    }

    public void clearNormalizedCache() {
        this.apolloStore.clearAll();
    }

    public ApolloStore apolloStore() {
        return this.apolloStore;
    }

    public void idleCallback(IdleResourceCallback idleResourceCallback) {
        this.tracker.setIdleResourceCallback(idleResourceCallback);
    }

    public int activeCallsCount() {
        return this.tracker.activeCallsCount();
    }

    Response cachedHttpResponse(String cacheKey) throws IOException {
        if (this.httpCache != null) {
            return this.httpCache.read(cacheKey);
        }
        return null;
    }

    private <D extends Operation.Data, T, V extends Operation.Variables> RealApolloCall<T> newCall(@Nonnull Operation<D, T, V> operation) {
        return RealApolloCall.builder().operation(operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.defaultHttpCachePolicy).moshi(this.moshi).responseFieldMapperFactory(this.responseFieldMapperFactory).customTypeAdapters(this.customTypeAdapters).apolloStore(this.apolloStore).cacheControl(this.defaultCacheControl).cacheHeaders(this.defaultCacheHeaders).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).tracker(this.tracker).refetchQueries(Collections.emptyList()).refetchQueryNames(Collections.emptyList()).build();
    }

    public static class Builder {
        OkHttpClient okHttpClient;
        HttpUrl serverUrl;
        HttpCacheStore httpCacheStore;
        ApolloStore apolloStore = ApolloStore.NO_APOLLO_STORE;
        Optional<NormalizedCacheFactory> cacheFactory = Optional.absent();
        Optional<CacheKeyResolver> cacheKeyResolver = Optional.absent();
        HttpCachePolicy.Policy defaultHttpCachePolicy = HttpCachePolicy.NETWORK_ONLY;
        CacheControl defaultCacheControl = CacheControl.CACHE_FIRST;
        CacheHeaders defaultCacheHeaders = CacheHeaders.NONE;
        final Map<ScalarType, CustomTypeAdapter> customTypeAdapters = new LinkedHashMap<ScalarType, CustomTypeAdapter>();
        private final Moshi.Builder moshiBuilder = new Moshi.Builder();
        Moshi moshi;
        ExecutorService dispatcher;
        Optional<Logger> logger = Optional.absent();
        HttpCache httpCache;
        ApolloLogger apolloLogger;
        final List<ApolloInterceptor> applicationInterceptors = new ArrayList<ApolloInterceptor>();

        private Builder() {
        }

        public Builder okHttpClient(@Nonnull OkHttpClient okHttpClient) {
            this.okHttpClient = (OkHttpClient)Utils.checkNotNull((Object)okHttpClient, (Object)"okHttpClient is null");
            return this;
        }

        public Builder serverUrl(@Nonnull HttpUrl serverUrl) {
            this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl is null");
            return this;
        }

        public Builder serverUrl(@Nonnull String serverUrl) {
            this.serverUrl = HttpUrl.parse((String)((String)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null")));
            return this;
        }

        public Builder httpCacheStore(@Nonnull HttpCacheStore cacheStore) {
            this.httpCacheStore = (HttpCacheStore)Utils.checkNotNull((Object)cacheStore, (Object)"cacheStore == null");
            return this;
        }

        public Builder normalizedCache(@Nonnull NormalizedCacheFactory normalizedCacheFactory) {
            return this.normalizedCache(normalizedCacheFactory, CacheKeyResolver.DEFAULT);
        }

        public Builder normalizedCache(@Nonnull NormalizedCacheFactory normalizedCacheFactory, @Nonnull CacheKeyResolver keyResolver) {
            this.cacheFactory = Optional.fromNullable((Object)Utils.checkNotNull((Object)normalizedCacheFactory, (Object)"normalizedCacheFactory == null"));
            this.cacheKeyResolver = Optional.fromNullable((Object)Utils.checkNotNull((Object)keyResolver, (Object)"cacheKeyResolver == null"));
            return this;
        }

        public <T> Builder addCustomTypeAdapter(@Nonnull ScalarType scalarType, final @Nonnull CustomTypeAdapter<T> customTypeAdapter) {
            this.customTypeAdapters.put(scalarType, customTypeAdapter);
            this.moshiBuilder.add((Type)scalarType.javaType(), new JsonAdapter<T>(){

                public T fromJson(JsonReader reader) throws IOException {
                    return customTypeAdapter.decode(reader.nextString());
                }

                public void toJson(JsonWriter writer, T value) throws IOException {
                    writer.value(customTypeAdapter.encode(value));
                }
            });
            return this;
        }

        public Builder dispatcher(@Nonnull ExecutorService dispatcher) {
            this.dispatcher = (ExecutorService)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
            return this;
        }

        public Builder defaultHttpCachePolicy(@Nonnull HttpCachePolicy.Policy cachePolicy) {
            this.defaultHttpCachePolicy = (HttpCachePolicy.Policy)Utils.checkNotNull((Object)cachePolicy, (Object)"cachePolicy == null");
            return this;
        }

        public Builder defaultCacheControl(@Nonnull CacheControl cacheControl) {
            this.defaultCacheControl = (CacheControl)((Object)Utils.checkNotNull((Object)((Object)cacheControl), (Object)"cacheControl == null"));
            return this;
        }

        public Builder defaultCacheHeaders(@Nonnull CacheHeaders cacheHeaders) {
            this.defaultCacheHeaders = (CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
            return this;
        }

        public Builder logger(@Nullable Logger logger) {
            this.logger = Optional.fromNullable((Object)logger);
            return this;
        }

        public Builder addApplicationInterceptor(@Nonnull ApolloInterceptor interceptor) {
            this.applicationInterceptors.add(interceptor);
            return this;
        }

        public ApolloClient build() {
            Utils.checkNotNull((Object)this.okHttpClient, (Object)"okHttpClient is null");
            Utils.checkNotNull((Object)this.serverUrl, (Object)"serverUrl is null");
            this.apolloLogger = new ApolloLogger(this.logger);
            this.moshi = this.moshiBuilder.build();
            if (this.httpCacheStore != null) {
                this.httpCache = new HttpCache(this.httpCacheStore, this.apolloLogger);
                this.okHttpClient = this.okHttpClient.newBuilder().addInterceptor(this.httpCache.interceptor()).build();
            }
            if (this.cacheFactory.isPresent() && this.cacheKeyResolver.isPresent()) {
                Object normalizedCache = ((NormalizedCacheFactory)this.cacheFactory.get()).createNormalizedCache(RecordFieldAdapter.create(this.moshi));
                this.apolloStore = new RealApolloStore((NormalizedCache)normalizedCache, (CacheKeyResolver)this.cacheKeyResolver.get(), this.customTypeAdapters);
            }
            if (this.dispatcher == null) {
                this.dispatcher = this.defaultDispatcher();
            }
            return new ApolloClient(this);
        }

        private ExecutorService defaultDispatcher() {
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, "Apollo Dispatcher");
                }
            });
        }
    }
}

