/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.field.MapFieldValueResolver;
import com.apollographql.apollo.internal.json.ApolloJsonReader;
import com.apollographql.apollo.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo.internal.json.ResponseJsonStreamReader;
import com.apollographql.apollo.internal.reader.RealResponseReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;

final class HttpResponseBodyParser<D extends Operation.Data, W> {
    private final Operation<D, W, ?> operation;
    private final ResponseFieldMapper responseFieldMapper;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;

    HttpResponseBodyParser(Operation<D, W, ?> operation, ResponseFieldMapper responseFieldMapper, Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
        this.operation = operation;
        this.responseFieldMapper = responseFieldMapper;
        this.customTypeAdapters = customTypeAdapters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<W> parse(ResponseBody responseBody, final ResponseNormalizer<Map<String, Object>> networkResponseNormalizer) throws IOException {
        networkResponseNormalizer.willResolveRootQuery(this.operation);
        try (BufferedSourceJsonReader jsonReader = null;){
            jsonReader = new BufferedSourceJsonReader(responseBody.source());
            jsonReader.beginObject();
            ResponseJsonStreamReader responseStreamReader = ApolloJsonReader.responseJsonStreamReader(jsonReader);
            Operation.Data data = null;
            List<Error> errors = null;
            while (responseStreamReader.hasNext()) {
                String name = responseStreamReader.nextName();
                if ("data".equals(name)) {
                    data = (Operation.Data)responseStreamReader.nextObject(true, new ResponseJsonStreamReader.ObjectReader<Object>(){

                        @Override
                        public Object read(ResponseJsonStreamReader reader) throws IOException {
                            Map<String, Object> buffer = reader.toMap();
                            RealResponseReader<Map<String, Object>> realResponseReader = new RealResponseReader<Map<String, Object>>(HttpResponseBodyParser.this.operation.variables(), buffer, new MapFieldValueResolver(), HttpResponseBodyParser.this.customTypeAdapters, networkResponseNormalizer);
                            return HttpResponseBodyParser.this.responseFieldMapper.map(realResponseReader);
                        }
                    });
                    continue;
                }
                if ("errors".equals(name)) {
                    errors = this.readResponseErrors(responseStreamReader);
                    continue;
                }
                responseStreamReader.skipNext();
            }
            jsonReader.endObject();
            Response response = Response.builder(this.operation).data(this.operation.wrapData(data)).errors(errors).dependentKeys(networkResponseNormalizer.dependentKeys()).build();
            return response;
        }
    }

    private List<Error> readResponseErrors(ResponseJsonStreamReader reader) throws IOException {
        return reader.nextList(true, new ResponseJsonStreamReader.ListReader<Error>(){

            @Override
            public Error read(ResponseJsonStreamReader reader) throws IOException {
                return reader.nextObject(true, new ResponseJsonStreamReader.ObjectReader<Error>(){

                    @Override
                    public Error read(ResponseJsonStreamReader reader) throws IOException {
                        return HttpResponseBodyParser.this.readError(reader);
                    }
                });
            }
        });
    }

    private Error readError(ResponseJsonStreamReader reader) throws IOException {
        String message = null;
        ArrayList<Error.Location> locations = new ArrayList<Error.Location>();
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : reader.toMap().entrySet()) {
            if ("message".equals(entry.getKey())) {
                message = entry.getValue().toString();
                continue;
            }
            if ("locations".equals(entry.getKey())) {
                List locationItems = (List)entry.getValue();
                if (locationItems == null) continue;
                for (Map item : locationItems) {
                    locations.add(this.readErrorLocation(item));
                }
                continue;
            }
            if (entry.getValue() == null) continue;
            customAttributes.put(entry.getKey(), entry.getValue());
        }
        return new Error(message, locations, customAttributes);
    }

    private Error.Location readErrorLocation(Map<String, Object> data) throws IOException {
        long line = -1L;
        long column = -1L;
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if ("line".equals(entry.getKey())) {
                    line = ((BigDecimal)entry.getValue()).longValue();
                    continue;
                }
                if (!"column".equals(entry.getKey())) continue;
                column = ((BigDecimal)entry.getValue()).longValue();
            }
        }
        return new Error.Location(line, column);
    }
}

