/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheControl;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.QueryReFetcher;
import com.apollographql.apollo.internal.RealApolloQueryWatcher;
import com.apollographql.apollo.internal.ResponseFieldMapperFactory;
import com.apollographql.apollo.internal.cache.http.HttpCache;
import com.apollographql.apollo.internal.interceptor.ApolloCacheInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloParseInterceptor;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import com.squareup.moshi.Moshi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;

public final class RealApolloCall<T>
implements ApolloQueryCall<T>,
ApolloMutationCall<T> {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final HttpCachePolicy.Policy httpCachePolicy;
    final Moshi moshi;
    final ResponseFieldMapperFactory responseFieldMapperFactory;
    final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    final ApolloStore apolloStore;
    final CacheControl cacheControl;
    final CacheHeaders cacheHeaders;
    final ApolloInterceptorChain interceptorChain;
    final ExecutorService dispatcher;
    final ApolloLogger logger;
    final ApolloCallTracker tracker;
    final List<ApolloInterceptor> applicationInterceptors;
    final List<OperationName> refetchQueryNames;
    final List<Query> refetchQueries;
    final Optional<QueryReFetcher> queryReFetcher;
    final AtomicBoolean executed = new AtomicBoolean();
    volatile boolean canceled;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private RealApolloCall(Builder<T> builder) {
        this.operation = builder.operation;
        this.serverUrl = builder.serverUrl;
        this.httpCallFactory = builder.httpCallFactory;
        this.httpCache = builder.httpCache;
        this.httpCachePolicy = builder.httpCachePolicy;
        this.moshi = builder.moshi;
        this.responseFieldMapperFactory = builder.responseFieldMapperFactory;
        this.customTypeAdapters = builder.customTypeAdapters;
        this.apolloStore = builder.apolloStore;
        this.cacheControl = builder.cacheControl;
        this.cacheHeaders = builder.cacheHeaders;
        this.dispatcher = builder.dispatcher;
        this.logger = builder.logger;
        this.applicationInterceptors = builder.applicationInterceptors;
        this.refetchQueryNames = builder.refetchQueryNames;
        this.refetchQueries = builder.refetchQueries;
        this.tracker = builder.tracker;
        this.queryReFetcher = this.refetchQueries.isEmpty() && this.refetchQueryNames.isEmpty() || builder.apolloStore == null ? Optional.absent() : Optional.of((Object)QueryReFetcher.builder().queries(builder.refetchQueries).queryWatchers(this.refetchQueryNames).serverUrl(builder.serverUrl).httpCallFactory(builder.httpCallFactory).moshi(builder.moshi).responseFieldMapperFactory(builder.responseFieldMapperFactory).customTypeAdapters(builder.customTypeAdapters).apolloStore(builder.apolloStore).dispatcher(builder.dispatcher).logger(builder.logger).applicationInterceptors(builder.applicationInterceptors).callTracker(builder.tracker).build());
        this.interceptorChain = this.prepareInterceptorChain(this.operation);
    }

    @Override
    @Nonnull
    public Response<T> execute() throws ApolloException {
        Response response;
        if (!this.executed.compareAndSet(false, true)) {
            throw new IllegalStateException("Already Executed");
        }
        if (this.canceled) {
            throw new ApolloCanceledException("Canceled");
        }
        try {
            this.tracker.registerCall(this);
            response = (Response)this.interceptorChain.proceed().parsedResponse.or((Object)Response.builder((Operation)this.operation).build());
        }
        catch (Exception e) {
            if (this.canceled) {
                throw new ApolloCanceledException("Canceled", e);
            }
            throw e;
        }
        finally {
            this.tracker.unregisterCall(this);
        }
        if (this.canceled) {
            throw new ApolloCanceledException("Canceled");
        }
        if (this.queryReFetcher.isPresent()) {
            ((QueryReFetcher)this.queryReFetcher.get()).refetch();
        }
        return response;
    }

    @Override
    public void enqueue(@Nullable ApolloCall.Callback<T> responseCallback) {
        if (!this.executed.compareAndSet(false, true)) {
            throw new IllegalStateException("Already Executed");
        }
        this.tracker.registerCall(this);
        this.interceptorChain.proceedAsync(this.dispatcher, this.interceptorCallbackProxy(responseCallback));
    }

    @Override
    @Nonnull
    public RealApolloQueryWatcher<T> watcher() {
        return new RealApolloQueryWatcher(this.clone(), this.apolloStore, this.tracker);
    }

    @Override
    @Nonnull
    public RealApolloCall<T> httpCachePolicy(@Nonnull HttpCachePolicy.Policy httpCachePolicy) {
        if (this.executed.get()) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().httpCachePolicy((HttpCachePolicy.Policy)Utils.checkNotNull((Object)httpCachePolicy, (Object)"httpCachePolicy == null")).build();
    }

    @Override
    @Nonnull
    public RealApolloCall<T> cacheControl(@Nonnull CacheControl cacheControl) {
        if (this.executed.get()) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().cacheControl((CacheControl)((Object)Utils.checkNotNull((Object)((Object)cacheControl), (Object)"cacheControl == null"))).build();
    }

    @Override
    @Nonnull
    public RealApolloCall<T> cacheHeaders(@Nonnull CacheHeaders cacheHeaders) {
        if (this.executed.get()) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().cacheHeaders((CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null")).build();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.interceptorChain.dispose();
        if (this.queryReFetcher.isPresent()) {
            ((QueryReFetcher)this.queryReFetcher.get()).cancel();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    @Nonnull
    public RealApolloCall<T> clone() {
        return this.toBuilder().build();
    }

    @Override
    @Nonnull
    public ApolloMutationCall<T> refetchQueries(OperationName ... operationNames) {
        if (this.executed.get()) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().refetchQueryNames(Arrays.asList((Object[])Utils.checkNotNull((Object)operationNames, (Object)"operationNames == null"))).build();
    }

    @Override
    @Nonnull
    public ApolloMutationCall<T> refetchQueries(Query ... queries) {
        if (this.executed.get()) {
            throw new IllegalStateException("Already Executed");
        }
        return this.toBuilder().refetchQueries(Arrays.asList((Object[])Utils.checkNotNull((Object)queries, (Object)"queries == null"))).build();
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.operation;
    }

    private ApolloInterceptor.CallBack interceptorCallbackProxy(final ApolloCall.Callback<T> originalCallback) {
        return new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                if (originalCallback == null) {
                    return;
                }
                try {
                    if (RealApolloCall.this.canceled) {
                        originalCallback.onCanceledError(new ApolloCanceledException("Canceled"));
                        return;
                    }
                    if (RealApolloCall.this.queryReFetcher.isPresent()) {
                        ((QueryReFetcher)RealApolloCall.this.queryReFetcher.get()).refetch();
                    }
                    originalCallback.onResponse((Response)response.parsedResponse.get());
                }
                finally {
                    RealApolloCall.this.tracker.unregisterCall(RealApolloCall.this);
                }
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (originalCallback == null) {
                    return;
                }
                try {
                    if (RealApolloCall.this.canceled) {
                        originalCallback.onCanceledError(new ApolloCanceledException("Canceled", e));
                    } else if (e instanceof ApolloHttpException) {
                        originalCallback.onHttpError((ApolloHttpException)e);
                    } else if (e instanceof ApolloParseException) {
                        originalCallback.onParseError((ApolloParseException)e);
                    } else if (e instanceof ApolloNetworkException) {
                        originalCallback.onNetworkError((ApolloNetworkException)e);
                    } else {
                        originalCallback.onFailure(e);
                    }
                }
                finally {
                    RealApolloCall.this.tracker.unregisterCall(RealApolloCall.this);
                }
            }
        };
    }

    public Builder<T> toBuilder() {
        return RealApolloCall.builder().operation(this.operation).serverUrl(this.serverUrl).httpCallFactory(this.httpCallFactory).httpCache(this.httpCache).httpCachePolicy(this.httpCachePolicy).moshi(this.moshi).responseFieldMapperFactory(this.responseFieldMapperFactory).customTypeAdapters(this.customTypeAdapters).apolloStore(this.apolloStore).cacheControl(this.cacheControl).cacheHeaders(this.cacheHeaders).dispatcher(this.dispatcher).logger(this.logger).applicationInterceptors(this.applicationInterceptors).tracker(this.tracker).refetchQueryNames(this.refetchQueryNames).refetchQueries(this.refetchQueries);
    }

    private ApolloInterceptorChain prepareInterceptorChain(Operation operation) {
        ArrayList<ApolloInterceptor> interceptors = new ArrayList<ApolloInterceptor>();
        HttpCachePolicy.Policy httpCachePolicy = operation instanceof Query ? this.httpCachePolicy : null;
        ResponseFieldMapper responseFieldMapper = this.responseFieldMapperFactory.create(operation);
        interceptors.addAll(this.applicationInterceptors);
        interceptors.add(new ApolloCacheInterceptor(this.apolloStore, this.cacheControl, this.cacheHeaders, responseFieldMapper, this.customTypeAdapters, this.dispatcher, this.logger));
        interceptors.add(new ApolloParseInterceptor(this.httpCache, this.apolloStore.networkResponseNormalizer(), responseFieldMapper, this.customTypeAdapters, this.logger));
        interceptors.add(new ApolloServerInterceptor(this.serverUrl, this.httpCallFactory, httpCachePolicy, false, this.moshi, this.logger));
        return new RealApolloInterceptorChain(operation, interceptors);
    }

    public static final class Builder<T> {
        Operation operation;
        HttpUrl serverUrl;
        Call.Factory httpCallFactory;
        HttpCache httpCache;
        HttpCachePolicy.Policy httpCachePolicy;
        Moshi moshi;
        ResponseFieldMapperFactory responseFieldMapperFactory;
        Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
        ApolloStore apolloStore;
        CacheControl cacheControl;
        CacheHeaders cacheHeaders;
        ApolloInterceptorChain interceptorChain;
        ExecutorService dispatcher;
        ApolloLogger logger;
        List<ApolloInterceptor> applicationInterceptors;
        List<OperationName> refetchQueryNames = Collections.emptyList();
        List<Query> refetchQueries = Collections.emptyList();
        ApolloCallTracker tracker;

        public Builder<T> operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder<T> serverUrl(HttpUrl serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder<T> httpCallFactory(Call.Factory httpCallFactory) {
            this.httpCallFactory = httpCallFactory;
            return this;
        }

        public Builder<T> httpCache(HttpCache httpCache) {
            this.httpCache = httpCache;
            return this;
        }

        public Builder<T> httpCachePolicy(HttpCachePolicy.Policy httpCachePolicy) {
            this.httpCachePolicy = httpCachePolicy;
            return this;
        }

        public Builder<T> moshi(Moshi moshi) {
            this.moshi = moshi;
            return this;
        }

        public Builder<T> responseFieldMapperFactory(ResponseFieldMapperFactory responseFieldMapperFactory) {
            this.responseFieldMapperFactory = responseFieldMapperFactory;
            return this;
        }

        public Builder<T> customTypeAdapters(Map<ScalarType, CustomTypeAdapter> customTypeAdapters) {
            this.customTypeAdapters = customTypeAdapters;
            return this;
        }

        public Builder<T> apolloStore(ApolloStore apolloStore) {
            this.apolloStore = apolloStore;
            return this;
        }

        public Builder<T> cacheControl(CacheControl cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder<T> cacheHeaders(CacheHeaders cacheHeaders) {
            this.cacheHeaders = cacheHeaders;
            return this;
        }

        public Builder<T> interceptorChain(ApolloInterceptorChain interceptorChain) {
            this.interceptorChain = interceptorChain;
            return this;
        }

        public Builder<T> dispatcher(ExecutorService dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public Builder<T> logger(ApolloLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder<T> tracker(ApolloCallTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        public Builder<T> applicationInterceptors(List<ApolloInterceptor> applicationInterceptors) {
            this.applicationInterceptors = applicationInterceptors;
            return this;
        }

        public Builder<T> refetchQueryNames(List<OperationName> refetchQueryNames) {
            this.refetchQueryNames = refetchQueryNames != null ? new ArrayList<OperationName>(refetchQueryNames) : Collections.emptyList();
            return this;
        }

        public Builder<T> refetchQueries(List<Query> refetchQueries) {
            this.refetchQueries = refetchQueries != null ? new ArrayList<Query>(refetchQueries) : Collections.emptyList();
            return this;
        }

        Builder() {
        }

        public RealApolloCall<T> build() {
            return new RealApolloCall(this);
        }
    }
}

