/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network;

import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import androidx.annotation.RequiresApi;
import com.apollographql.apollo.network.NetworkObserver;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/network/AndroidNetworkObserver;", "Lcom/apollographql/apollo/network/NetworkObserver;", "connectivityManager", "Landroid/net/ConnectivityManager;", "<init>", "(Landroid/net/ConnectivityManager;)V", "listener", "Ljava/lang/ref/WeakReference;", "Lcom/apollographql/apollo/network/NetworkObserver$Listener;", "onlineNetworks", "", "", "networkCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "onConnectivityChange", "", "isOnline", "", "setListener", "close", "apollo-runtime_debug"})
@RequiresApi(value=23)
@SuppressLint(value={"MissingPermission"})
public final class AndroidNetworkObserver
implements NetworkObserver {
    @NotNull
    private final ConnectivityManager connectivityManager;
    @Nullable
    private WeakReference<NetworkObserver.Listener> listener;
    @NotNull
    private Set<Long> onlineNetworks;
    @NotNull
    private final ConnectivityManager.NetworkCallback networkCallback;

    public AndroidNetworkObserver(@NotNull ConnectivityManager connectivityManager) {
        Intrinsics.checkNotNullParameter((Object)connectivityManager, (String)"connectivityManager");
        this.connectivityManager = connectivityManager;
        this.onlineNetworks = new LinkedHashSet();
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ AndroidNetworkObserver this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                AndroidNetworkObserver.access$getOnlineNetworks$p(this.this$0).add(network.getNetworkHandle());
                AndroidNetworkObserver.access$onConnectivityChange(this.this$0, !((Collection)AndroidNetworkObserver.access$getOnlineNetworks$p(this.this$0)).isEmpty());
            }

            public void onLost(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                AndroidNetworkObserver.access$getOnlineNetworks$p(this.this$0).remove(network.getNetworkHandle());
                AndroidNetworkObserver.access$onConnectivityChange(this.this$0, !((Collection)AndroidNetworkObserver.access$getOnlineNetworks$p(this.this$0)).isEmpty());
            }
        };
    }

    private final void onConnectivityChange(boolean isOnline) {
        WeakReference<NetworkObserver.Listener> weakReference = this.listener;
        Intrinsics.checkNotNull(weakReference);
        NetworkObserver.Listener listener2 = (NetworkObserver.Listener)weakReference.get();
        if (listener2 == null) {
            this.close();
        } else {
            listener2.networkChanged(isOnline);
        }
    }

    @Override
    public void setListener(@NotNull NetworkObserver.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (!(this.listener == null)) {
            boolean bl = false;
            String string = "There can be only one listener";
            throw new IllegalStateException(string.toString());
        }
        NetworkRequest request = new NetworkRequest.Builder().addCapability(12).build();
        this.listener = new WeakReference<NetworkObserver.Listener>(listener2);
        this.connectivityManager.registerNetworkCallback(request, this.networkCallback);
    }

    @Override
    public void close() {
        this.connectivityManager.unregisterNetworkCallback(this.networkCallback);
        this.listener = null;
    }

    public static final /* synthetic */ Set access$getOnlineNetworks$p(AndroidNetworkObserver $this) {
        return $this.onlineNetworks;
    }

    public static final /* synthetic */ void access$onConnectivityChange(AndroidNetworkObserver $this, boolean isOnline) {
        $this.onConnectivityChange(isOnline);
    }
}

