/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.sql;

import com.apollographql.apollo.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo.cache.normalized.api.CacheKey;
import com.apollographql.apollo.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo.cache.normalized.api.Record;
import com.apollographql.apollo.cache.normalized.sql.internal.RecordDatabase;
import com.apollographql.apollo.exception.ApolloExceptionHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u001f\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070 0 H\u0016J(\u0010\"\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00122\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$H\u0002J+\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\u00020\u0007*\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010(J%\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001e\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010*J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/apollographql/apollo/cache/normalized/sql/SqlNormalizedCache;", "Lcom/apollographql/apollo/cache/normalized/api/NormalizedCache;", "recordDatabase", "Lcom/apollographql/apollo/cache/normalized/sql/internal/RecordDatabase;", "<init>", "(Lcom/apollographql/apollo/cache/normalized/sql/internal/RecordDatabase;)V", "loadRecord", "Lcom/apollographql/apollo/cache/normalized/api/Record;", "key", "", "cacheHeaders", "Lcom/apollographql/apollo/cache/normalized/api/CacheHeaders;", "loadRecords", "", "keys", "clearAll", "", "remove", "", "cacheKey", "Lcom/apollographql/apollo/cache/normalized/api/CacheKey;", "cascade", "", "pattern", "merge", "", "records", "date", "", "(Lcom/apollographql/apollo/cache/normalized/api/CacheHeaders;)Ljava/lang/Long;", "record", "dump", "", "Lkotlin/reflect/KClass;", "internalDeleteRecord", "visited", "", "internalUpdateRecords", "(Ljava/util/Collection;Ljava/lang/Long;)Ljava/util/Set;", "withDate", "(Lcom/apollographql/apollo/cache/normalized/api/Record;Ljava/lang/Long;)Lcom/apollographql/apollo/cache/normalized/api/Record;", "internalUpdateRecord", "(Lcom/apollographql/apollo/cache/normalized/api/Record;Ljava/lang/Long;)Ljava/util/Set;", "internalGetRecords", "", "apollo-normalized-cache-sqlite"})
@SourceDebugExtension(value={"SMAP\nSqlNormalizedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlNormalizedCache.kt\ncom/apollographql/apollo/cache/normalized/sql/SqlNormalizedCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,216:1\n1863#2,2:217\n1557#2:219\n1628#2,3:220\n1202#2,2:224\n1230#2,4:226\n1863#2,2:230\n1246#2,4:234\n1368#2:238\n1454#2,5:239\n1557#2:244\n1628#2,3:245\n1202#2,2:248\n1230#2,4:250\n1368#2:254\n1454#2,5:255\n1#3:223\n462#4:232\n412#4:233\n*S KotlinDebug\n*F\n+ 1 SqlNormalizedCache.kt\ncom/apollographql/apollo/cache/normalized/sql/SqlNormalizedCache\n*L\n49#1:217,2\n53#1:219\n53#1:220,3\n117#1:224,2\n117#1:226,4\n132#1:230,2\n181#1:234,4\n211#1:238\n211#1:239,5\n153#1:244\n153#1:245,3\n154#1:248,2\n154#1:250,4\n156#1:254\n156#1:255,5\n181#1:232\n181#1:233\n*E\n"})
public final class SqlNormalizedCache
extends NormalizedCache {
    @NotNull
    private final RecordDatabase recordDatabase;

    public SqlNormalizedCache(@NotNull RecordDatabase recordDatabase) {
        Intrinsics.checkNotNullParameter((Object)recordDatabase, (String)"recordDatabase");
        this.recordDatabase = recordDatabase;
    }

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Record record;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("memory-cache-only")) {
            return null;
        }
        try {
            record = this.recordDatabase.select(key);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read a record from the database", e));
            record = null;
        }
        Record record2 = record;
        if (record2 != null) {
            if (cacheHeaders.hasHeader("evict-after-read")) {
                this.recordDatabase.delete(key);
            }
            return record2;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        return normalizedCache != null ? normalizedCache.loadRecord(key, cacheHeaders) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Collection collection;
        Collection collection2;
        Collection collection3;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        List list;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("memory-cache-only")) {
            return CollectionsKt.emptyList();
        }
        try {
            list = this.internalGetRecords(keys);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read records from the database", e));
            list = CollectionsKt.emptyList();
        }
        List records = list;
        if (cacheHeaders.hasHeader("evict-after-read")) {
            Iterable $this$forEach$iv = records;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Record record = (Record)element$iv2;
                boolean bl = false;
                this.recordDatabase.delete(record.getKey());
            }
        }
        Iterable $i$f$forEach = records;
        Iterable iterable = keys;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Record record = (Record)item$iv$iv;
            Collection collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(it.getKey());
        }
        List missRecordKeys = CollectionsKt.minus((Iterable)iterable, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Collection collection5 = missRecordKeys;
        if (collection5.isEmpty()) {
            boolean bl = false;
            collection3 = null;
        } else {
            collection3 = collection5;
        }
        List list2 = (List)collection3;
        if (list2 != null) {
            List it = list2;
            boolean bl = false;
            NormalizedCache normalizedCache = this.getNextCache();
            collection2 = normalizedCache != null ? normalizedCache.loadRecords((Collection)it, cacheHeaders) : null;
        } else {
            collection2 = collection = null;
        }
        if (collection2 == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection missRecords = collection;
        return CollectionsKt.plus((Collection)records, (Iterable)missRecords);
    }

    public void clearAll() {
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache != null) {
            normalizedCache.clearAll();
        }
        this.recordDatabase.deleteAll();
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        boolean selfRemoved = (Boolean)RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.remove$lambda$4(this, cacheKey, cascade), 1, null);
        NormalizedCache normalizedCache = this.getNextCache();
        boolean chainRemoved = normalizedCache != null ? normalizedCache.remove(cacheKey, cascade) : false;
        return selfRemoved || chainRemoved;
    }

    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Ref.IntRef selfRemoved = new Ref.IntRef();
        RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.remove$lambda$5(this, pattern, selfRemoved), 1, null);
        NormalizedCache normalizedCache = this.getNextCache();
        int chainRemoved = normalizedCache != null ? normalizedCache.remove(pattern) : 0;
        return selfRemoved.element + chainRemoved;
    }

    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        Set set;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store") || cacheHeaders.hasHeader("memory-cache-only")) {
            return SetsKt.emptySet();
        }
        try {
            Set<String> set2 = this.internalUpdateRecords(records, this.date(cacheHeaders));
            NormalizedCache normalizedCache = this.getNextCache();
            Set set3 = normalizedCache != null ? normalizedCache.merge(records, cacheHeaders) : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus(set2, (Iterable)set3);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge records from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Long date(CacheHeaders $this$date) {
        String string = $this$date.headerValue("apollo-date");
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store") || cacheHeaders.hasHeader("memory-cache-only")) {
            return SetsKt.emptySet();
        }
        try {
            Set<String> set2 = this.internalUpdateRecord(record, this.date(cacheHeaders));
            NormalizedCache normalizedCache = this.getNextCache();
            Set set3 = normalizedCache != null ? normalizedCache.merge(record, cacheHeaders) : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus(set2, (Iterable)set3);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge a record from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = this.recordDatabase.selectAll();
        KClass kClass = Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass());
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record record = (Record)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getKey(), element$iv$iv);
        }
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
        NormalizedCache normalizedCache = this.getNextCache();
        Map map2 = normalizedCache != null ? normalizedCache.dump() : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map, (Map)map2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean internalDeleteRecord(String key, boolean cascade, Set<String> visited) {
        if (cascade) {
            List list;
            if (visited.contains(key)) {
                return false;
            }
            visited.add(key);
            Record record = this.recordDatabase.select(key);
            if (record != null && (list = record.referencedFields()) != null) {
                void $this$forEach$iv;
                Iterable iterable = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CacheKey it = (CacheKey)element$iv;
                    boolean bl = false;
                    this.internalDeleteRecord(it.getKey(), true, visited);
                }
            }
        }
        this.recordDatabase.delete(key);
        return this.recordDatabase.changes() > 0L;
    }

    static /* synthetic */ boolean internalDeleteRecord$default(SqlNormalizedCache sqlNormalizedCache, String string, boolean bl, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        return sqlNormalizedCache.internalDeleteRecord(string, bl, set);
    }

    private final Set<String> internalUpdateRecords(Collection<Record> records, Long date) {
        Ref.ObjectRef updatedRecordKeys = new Ref.ObjectRef();
        updatedRecordKeys.element = SetsKt.emptySet();
        RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.internalUpdateRecords$lambda$11(this, records, updatedRecordKeys, date), 1, null);
        return (Set)updatedRecordKeys.element;
    }

    /*
     * WARNING - void declaration
     */
    private final Record withDate(Record $this$withDate, Long date) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        if (date == null) {
            return $this$withDate;
        }
        Map map2 = $this$withDate.getFields();
        UUID uUID = $this$withDate.getMutationId();
        Map map3 = $this$withDate.getFields();
        String string = $this$withDate.getKey();
        boolean $i$f$mapValues = false;
        void var5_8 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl2 = false;
            Long l = (long)date;
            map.put(k, l);
        }
        Map map5 = map = destination$iv$iv;
        UUID uUID2 = uUID;
        Map map6 = map3;
        String string2 = string;
        return new Record(string2, map6, uUID2, map5);
    }

    private final Set<String> internalUpdateRecord(Record record, Long date) {
        return (Set)RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.internalUpdateRecord$lambda$13(this, record, date), 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Record> internalGetRecords(Collection<String> keys) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)keys, (int)999);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List chunkedKeys = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.recordDatabase.select(chunkedKeys);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean remove$lambda$4(SqlNormalizedCache this$0, CacheKey $cacheKey, boolean $cascade) {
        return SqlNormalizedCache.internalDeleteRecord$default(this$0, $cacheKey.getKey(), $cascade, null, 4, null);
    }

    private static final Unit remove$lambda$5(SqlNormalizedCache this$0, String $pattern, Ref.IntRef $selfRemoved) {
        this$0.recordDatabase.deleteMatching($pattern);
        $selfRemoved.element = (int)this$0.recordDatabase.changes();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit internalUpdateRecords$lambda$11(SqlNormalizedCache this$0, Collection $records, Ref.ObjectRef $updatedRecordKeys, Long $date) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = $records;
        Object object = this$0;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Record record = (Record)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        $this$map$iv = ((SqlNormalizedCache)((Object)object)).internalGetRecords((List)destination$iv$iv);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record bl = (Record)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getKey(), element$iv$iv);
        }
        Map oldRecords = destination$iv$iv2;
        $this$associateBy$iv = $records;
        object = $updatedRecordKeys;
        boolean $i$f$flatMap = false;
        void capacity$iv22 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Set set;
            Record record = (Record)element$iv$iv;
            boolean bl = false;
            Record oldRecord = (Record)oldRecords.get(record.getKey());
            if (oldRecord == null) {
                this$0.recordDatabase.insert(this$0.withDate(record, $date));
                set = record.fieldKeys();
            } else {
                Pair pair = oldRecord.mergeWith(record, $date);
                Record mergedRecord = (Record)pair.component1();
                Set changedKeys = (Set)pair.component2();
                if (!((Map)mergedRecord).isEmpty()) {
                    this$0.recordDatabase.update(mergedRecord);
                }
                set = changedKeys;
            }
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        ((Ref.ObjectRef)object).element = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return Unit.INSTANCE;
    }

    private static final Set internalUpdateRecord$lambda$13(SqlNormalizedCache this$0, Record $record, Long $date) {
        Set set;
        Record oldRecord = this$0.recordDatabase.select($record.getKey());
        if (oldRecord == null) {
            this$0.recordDatabase.insert(this$0.withDate($record, $date));
            set = $record.fieldKeys();
        } else {
            Pair pair = oldRecord.mergeWith($record, $date);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            if (!((Map)mergedRecord).isEmpty()) {
                this$0.recordDatabase.update(mergedRecord);
            }
            set = changedKeys;
        }
        return set;
    }
}

