/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.internal;

import com.apollographql.apollo.api.InputType;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.api.internal.json.Utils;
import com.apollographql.apollo.cache.normalized.internal.CacheKeyBuilder;
import com.apollographql.apollo.cache.normalized.internal.SortedInputFieldMapWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo/cache/normalized/internal/RealCacheKeyBuilder;", "Lcom/apollographql/apollo/cache/normalized/internal/CacheKeyBuilder;", "()V", "build", "", "field", "Lcom/apollographql/apollo/api/ResponseField;", "variables", "Lcom/apollographql/apollo/api/Operation$Variables;", "resolveArguments", "", "", "objectMap", "resolveVariableArgument", "apollo-normalized-cache"})
public final class RealCacheKeyBuilder
implements CacheKeyBuilder {
    @NotNull
    public String build(@NotNull ResponseField field, @NotNull Operation.Variables variables) {
        String string;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        if (field.getArguments().isEmpty()) {
            return field.getFieldName();
        }
        Map<String, Object> resolvedArguments = this.resolveArguments(field.getArguments(), variables);
        try {
            Buffer buffer = new Buffer();
            JsonWriter jsonWriter = JsonWriter.Companion.of((BufferedSink)buffer);
            jsonWriter.setSerializeNulls(true);
            Utils.writeToJson(resolvedArguments, (JsonWriter)jsonWriter);
            jsonWriter.close();
            string = field.getFieldName() + '(' + buffer.readUtf8() + ')';
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> resolveArguments(Map<String, ? extends Object> objectMap, Operation.Variables variables) {
        void $this$mapValuesTo$iv$iv;
        Map<String, ? extends Object> $this$mapValues$iv = objectMap;
        boolean $i$f$mapValues = false;
        Map<String, ? extends Object> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map nestedObjectMap;
            void $dstr$_u24__u24$value;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            void var18_19 = $dstr$_u24__u24$value;
            boolean bl3 = false;
            Object value = var18_19.getValue();
            Object v = value instanceof Map ? (ResponseField.Companion.isArgumentValueVariableType(nestedObjectMap = (Map)value) ? this.resolveVariableArgument(nestedObjectMap, variables) : this.resolveArguments(nestedObjectMap, variables)) : value;
            map3.put(k2, v);
        }
        Iterable $this$sortedBy$iv = MapsKt.toList((Map)destination$iv$iv);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return MapsKt.toMap((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = (String)it.getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        }));
    }

    private final Object resolveVariableArgument(Map<String, ? extends Object> objectMap, Operation.Variables variables) {
        Map<String, Object> map;
        Object variable = objectMap.get("variableName");
        Map map2 = variables.valueMap();
        boolean bl = false;
        Object resolvedVariable = map2.get(variable);
        if (resolvedVariable == null) {
            map = null;
        } else if (resolvedVariable instanceof Map) {
            map = this.resolveArguments((Map)resolvedVariable, variables);
        } else if (resolvedVariable instanceof InputType) {
            SortedInputFieldMapWriter inputFieldMapWriter = new SortedInputFieldMapWriter();
            ((InputType)resolvedVariable).marshaller().marshal((InputFieldWriter)inputFieldMapWriter);
            map = this.resolveArguments(inputFieldMapWriter.map(), variables);
        } else {
            map = (Map<String, Object>)resolvedVariable;
        }
        return map;
    }
}

