/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.debugserver.internal.server;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.debugserver.internal.graphql.GraphQL;
import com.apollographql.apollo.debugserver.internal.server.Server;
import com.apollographql.apollo.debugserver.internal.server.Server_jvmCommonKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo/debugserver/internal/server/JvmServer;", "Lcom/apollographql/apollo/debugserver/internal/server/Server;", "apolloClients", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/apollographql/apollo/ApolloClient;", "", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "dispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "graphQL", "Lcom/apollographql/apollo/debugserver/internal/graphql/GraphQL;", "serverSocket", "Ljava/net/ServerSocket;", "start", "", "stop", "apollo-debug-server"})
@SourceDebugExtension(value={"SMAP\nServer.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.jvm.kt\ncom/apollographql/apollo/debugserver/internal/server/JvmServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
final class JvmServer
implements Server {
    @Nullable
    private ServerSocket serverSocket;
    @NotNull
    private final ExecutorCoroutineDispatcher dispatcher;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final GraphQL graphQL;

    public JvmServer(@NotNull AtomicReference<Map<ApolloClient, String>> apolloClients) {
        Intrinsics.checkNotNullParameter(apolloClients, (String)"apolloClients");
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.dispatcher = ExecutorsKt.from((ExecutorService)executorService);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)this.dispatcher));
        this.graphQL = new GraphQL(apolloClients);
    }

    @Override
    public void start() {
        if (this.serverSocket != null) {
            throw new IllegalStateException("Already started".toString());
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JvmServer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        ServerSocket localServerSocket = new ServerSocket(8081);
                        JvmServer.access$setServerSocket$p(this.this$0, localServerSocket);
                        while (true) {
                            Socket socket;
                            try {
                                socket = localServerSocket.accept();
                            }
                            catch (Exception exception) {
                                break;
                            }
                            Socket clientSocket = socket;
                            BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, clientSocket, null){
                                int label;
                                final /* synthetic */ JvmServer this$0;
                                final /* synthetic */ Socket $clientSocket;
                                {
                                    this.this$0 = $receiver;
                                    this.$clientSocket = $clientSocket;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            GraphQL graphQL = JvmServer.access$getGraphQL$p(this.this$0);
                                            Socket socket = this.$clientSocket;
                                            Intrinsics.checkNotNull((Object)socket);
                                            Closeable closeable = socket;
                                            InputStream inputStream = this.$clientSocket.getInputStream();
                                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                                            OutputStream outputStream = this.$clientSocket.getOutputStream();
                                            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                                            Server_jvmCommonKt.handleClient(graphQL, closeable, inputStream, outputStream);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void stop() {
        JvmServer jvmServer = this;
        try {
            Unit unit;
            JvmServer $this$stop_u24lambda_u240 = jvmServer;
            boolean bl = false;
            ServerSocket serverSocket = $this$stop_u24lambda_u240.serverSocket;
            if (serverSocket != null) {
                serverSocket.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.dispatcher.close();
    }

    public static final /* synthetic */ void access$setServerSocket$p(JvmServer $this, ServerSocket serverSocket) {
        $this.serverSocket = serverSocket;
    }

    public static final /* synthetic */ GraphQL access$getGraphQL$p(JvmServer $this) {
        return $this.graphQL;
    }
}

