/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.json.InputFieldJsonWriter;
import com.apollographql.apollo.api.internal.json.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public interface Operation<D extends Data, T, V extends Variables> {
    public static final Variables EMPTY_VARIABLES = new Variables();

    public String queryDocument();

    public V variables();

    public ResponseFieldMapper<D> responseFieldMapper();

    public T wrapData(D var1);

    @NotNull
    public OperationName name();

    @NotNull
    public String operationId();

    @NotNull
    public Response<T> parse(@NotNull BufferedSource var1, @NotNull ScalarTypeAdapters var2) throws IOException;

    @NotNull
    public Response<T> parse(@NotNull BufferedSource var1) throws IOException;

    public static class Variables {
        protected Variables() {
        }

        @NotNull
        public Map<String, Object> valueMap() {
            return Collections.emptyMap();
        }

        @NotNull
        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                @Override
                public void marshal(InputFieldWriter writer) {
                }
            };
        }

        public final String marshal() throws IOException {
            return this.marshal(ScalarTypeAdapters.DEFAULT);
        }

        public final String marshal(@NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
            Buffer buffer = new Buffer();
            JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.beginObject();
            this.marshaller().marshal(new InputFieldJsonWriter(jsonWriter, scalarTypeAdapters));
            jsonWriter.endObject();
            jsonWriter.close();
            return buffer.readUtf8();
        }
    }

    public static interface Data {
        public ResponseFieldMarshaller marshaller();
    }
}

