/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.response.CustomTypeAdapter;
import com.apollographql.apollo.response.CustomTypeValue;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class SimpleResponseReader
implements ResponseReader {
    private final Map<String, Object> recordSet;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final Map<String, Object> variableValues;

    public SimpleResponseReader(@NotNull Map<String, Object> recordSet, Operation.Variables variables, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        this(recordSet, variables.valueMap(), scalarTypeAdapters);
    }

    private SimpleResponseReader(@NotNull Map<String, Object> recordSet, @NotNull Map<String, Object> variableValues, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        this.recordSet = Utils.checkNotNull(recordSet, "recordSet == null");
        this.variableValues = Utils.checkNotNull(variableValues, "variableValues == null");
        this.scalarTypeAdapters = Utils.checkNotNull(scalarTypeAdapters, "scalarTypeAdapters == null");
    }

    @Override
    public String readString(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        String value = (String)this.valueFor(this.recordSet, field);
        return this.checkValue(field, value);
    }

    @Override
    public Integer readInt(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    @Override
    public Long readLong(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    @Override
    public Double readDouble(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    @Override
    public Boolean readBoolean(ResponseField field) {
        if (this.shouldSkip(field)) {
            return null;
        }
        Boolean value = (Boolean)this.valueFor(this.recordSet, field);
        return this.checkValue(field, value);
    }

    @Override
    public <T> T readObject(ResponseField field, ResponseReader.ObjectReader<T> objectReader) {
        if (this.shouldSkip(field)) {
            return null;
        }
        Map value = (Map)this.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        return value != null ? (T)objectReader.read(new SimpleResponseReader((Map<String, Object>)value, this.variableValues, this.scalarTypeAdapters)) : null;
    }

    @Override
    public <T> List<T> readList(ResponseField field, ResponseReader.ListReader<T> listReader) {
        ArrayList<T> result;
        if (this.shouldSkip(field)) {
            return null;
        }
        List values = (List)this.valueFor(this.recordSet, field);
        this.checkValue(field, values);
        if (values == null) {
            result = null;
        } else {
            result = new ArrayList<T>();
            for (Object value : values) {
                if (value == null) {
                    result.add(null);
                    continue;
                }
                T item = listReader.read(new ListItemReader(field, value));
                result.add(item);
            }
        }
        return result != null ? Collections.unmodifiableList(result) : null;
    }

    @Override
    public <T> T readCustomType(ResponseField.CustomTypeField field) {
        Object result;
        if (this.shouldSkip(field)) {
            return null;
        }
        T value = this.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            result = null;
        } else {
            CustomTypeAdapter typeAdapter = this.scalarTypeAdapters.adapterFor(field.scalarType());
            result = typeAdapter.decode(CustomTypeValue.fromRawValue(value));
        }
        return this.checkValue(field, result);
    }

    @Override
    public <T> T readFragment(ResponseField field, ResponseReader.ObjectReader<T> objectReader) {
        if (this.shouldSkip(field)) {
            return null;
        }
        String value = (String)this.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        if (value == null) {
            return null;
        }
        for (ResponseField.Condition condition : field.conditions()) {
            if (!(condition instanceof ResponseField.TypeNameCondition) || !((ResponseField.TypeNameCondition)condition).typeNames().contains(value)) continue;
            return objectReader.read(this);
        }
        return null;
    }

    private boolean shouldSkip(ResponseField field) {
        for (ResponseField.Condition condition : field.conditions()) {
            if (!(condition instanceof ResponseField.BooleanCondition)) continue;
            ResponseField.BooleanCondition booleanCondition = (ResponseField.BooleanCondition)condition;
            Boolean conditionValue = (Boolean)this.variableValues.get(booleanCondition.variableName());
            if (!(booleanCondition.inverted() ? Boolean.TRUE.equals(conditionValue) : Boolean.FALSE.equals(conditionValue))) continue;
            return true;
        }
        return false;
    }

    private <V> V checkValue(ResponseField field, V value) {
        if (!field.optional() && value == null) {
            throw new NullPointerException("corrupted response reader, expected non null value for " + field.fieldName());
        }
        return value;
    }

    private <T> T valueFor(Map<String, Object> map, ResponseField field) {
        return (T)map.get(field.responseName());
    }

    private class ListItemReader
    implements ResponseReader.ListItemReader {
        private final ResponseField field;
        private final Object value;

        ListItemReader(ResponseField field, Object value) {
            this.field = field;
            this.value = value;
        }

        @Override
        public String readString() {
            return (String)this.value;
        }

        @Override
        public Integer readInt() {
            return ((BigDecimal)this.value).intValue();
        }

        @Override
        public Long readLong() {
            return ((BigDecimal)this.value).longValue();
        }

        @Override
        public Double readDouble() {
            return ((BigDecimal)this.value).doubleValue();
        }

        @Override
        public Boolean readBoolean() {
            return (Boolean)this.value;
        }

        @Override
        public <T> T readCustomType(ScalarType scalarType) {
            CustomTypeAdapter typeAdapter = SimpleResponseReader.this.scalarTypeAdapters.adapterFor(scalarType);
            return typeAdapter.decode(CustomTypeValue.fromRawValue(this.value));
        }

        @Override
        public <T> T readObject(ResponseReader.ObjectReader<T> objectReader) {
            Map value = (Map)this.value;
            return objectReader.read(new SimpleResponseReader(value, SimpleResponseReader.this.variableValues, SimpleResponseReader.this.scalarTypeAdapters));
        }

        @Override
        public <T> List<T> readList(ResponseReader.ListReader<T> listReader) {
            List values = (List)this.value;
            if (values == null) {
                return null;
            }
            ArrayList<T> result = new ArrayList<T>();
            for (Object value : values) {
                if (value == null) {
                    result.add(null);
                    continue;
                }
                T item = listReader.read(new ListItemReader(this.field, value));
                result.add(item);
            }
            return Collections.unmodifiableList(result);
        }
    }
}

