/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.SimpleResponseWriter;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class OperationDataJsonSerializer {
    private OperationDataJsonSerializer() {
    }

    public static String serialize(@NotNull Operation.Data data, @NotNull String indent) {
        return OperationDataJsonSerializer.serialize(data, indent, ScalarTypeAdapters.DEFAULT);
    }

    public static String serialize(@NotNull Operation.Data data, @NotNull String indent, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        Utils.checkNotNull(data, "data == null");
        Utils.checkNotNull(indent, "intent == null");
        Utils.checkNotNull(scalarTypeAdapters, "scalarTypeAdapters == null");
        try {
            SimpleResponseWriter responseWriter = new SimpleResponseWriter(scalarTypeAdapters);
            data.marshaller().marshal(responseWriter);
            return responseWriter.toJson(indent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

