/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Response<T> {
    private final Operation operation;
    private final T data;
    private final List<Error> errors;
    private Set<String> dependentKeys;
    private final boolean fromCache;

    public static <T> Builder<T> builder(@Nonnull Operation operation) {
        return new Builder(operation);
    }

    Response(Builder<T> builder) {
        this.operation = Utils.checkNotNull(builder.operation, "operation == null");
        this.data = builder.data;
        this.errors = builder.errors != null ? Collections.unmodifiableList(builder.errors) : Collections.emptyList();
        this.dependentKeys = builder.dependentKeys != null ? Collections.unmodifiableSet(builder.dependentKeys) : Collections.emptySet();
        this.fromCache = builder.fromCache;
    }

    public Operation operation() {
        return this.operation;
    }

    @Nullable
    public T data() {
        return this.data;
    }

    @Nonnull
    public List<Error> errors() {
        return this.errors;
    }

    @Nonnull
    public Set<String> dependentKeys() {
        return this.dependentKeys;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean fromCache() {
        return this.fromCache;
    }

    public Builder<T> toBuilder() {
        return new Builder<T>(this.operation).data(this.data).errors(this.errors).dependentKeys(this.dependentKeys).fromCache(this.fromCache);
    }

    public static final class Builder<T> {
        final Operation operation;
        T data;
        List<Error> errors;
        Set<String> dependentKeys;
        boolean fromCache;

        Builder(@Nonnull Operation operation) {
            this.operation = Utils.checkNotNull(operation, "operation == null");
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Builder<T> errors(@Nullable List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder<T> dependentKeys(@Nullable Set<String> dependentKeys) {
            this.dependentKeys = dependentKeys;
            return this;
        }

        public Builder<T> fromCache(boolean fromCache) {
            this.fromCache = fromCache;
            return this;
        }

        public Response<T> build() {
            return new Response(this);
        }
    }
}

