/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Response<T> {
    private final Operation operation;
    private final T data;
    private final List<Error> errors;
    private Set<String> dependentKeys;

    public static <T> Builder<T> builder(@Nonnull Operation operation) {
        return new Builder(operation);
    }

    Response(Builder<T> builder) {
        this.operation = Utils.checkNotNull(((Builder)builder).operation, "operation == null");
        this.data = ((Builder)builder).data;
        this.errors = ((Builder)builder).errors != null ? Collections.unmodifiableList(((Builder)builder).errors) : Collections.emptyList();
        this.dependentKeys = ((Builder)builder).dependentKeys != null ? Collections.unmodifiableSet(((Builder)builder).dependentKeys) : Collections.emptySet();
    }

    public Operation operation() {
        return this.operation;
    }

    @Nullable
    public T data() {
        return this.data;
    }

    @Nonnull
    public List<Error> errors() {
        return this.errors;
    }

    @Nonnull
    public Set<String> dependentKeys() {
        return this.dependentKeys;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public static final class Builder<T> {
        private final Operation operation;
        private T data;
        private List<Error> errors;
        private Set<String> dependentKeys;

        Builder(@Nonnull Operation operation) {
            this.operation = Utils.checkNotNull(operation, "operation == null");
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Builder<T> errors(@Nullable List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder<T> dependentKeys(@Nullable Set<String> dependentKeys) {
            this.dependentKeys = dependentKeys;
            return this;
        }

        public Response<T> build() {
            return new Response(this);
        }
    }
}

